/**************************************************************************/
/* test7 - critical sections                                              */
/*       - preemtive is turned on, so critical sections are what prevents */
/*         cprintfs from being interrupted in the middle of their output  */
/**************************************************************************/

#include "rtos.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

void *peer = NULL;
crit_x *cs = NULL;

void switcher1(DWORD arg)
{
    int x;

    do {
        cs_enter( cs );
        cprintf("in thread %lu\n\r", arg );
        cs_exit( cs );
        rt_sleep(10);
    } while( 1 );
}

main()
{
    kpreemptive = 1;
    kdebug = 1;
    rt_init(100);
    cs = cs_alloc();
    cputs("starting...\r\n");
    rt_newthread( switcher1, 1,4096, 0, "worker 1" );
    rt_newthread( switcher1, 2,4096, 0, "worker 2" );
    rt_sleep( 10000 );
    cprintf ("cs = %08lx\r\n", cs);
    cs_free( cs );
}


