
/*
 * tftp_c.c - sample tftp client
 */

#include <rtos.h>
#include <net.h>
#include <process.h>
#include <string.h>
#include <tftp.h>

main(int argc, char **argv)
{
    DWORD host;
    int put;
    char *filename;
    char *hostname;
    int result;

    kdebug = 1;
    rt_init( 100 );
    sock_init();

    if ( argc < 4 ) {
        cprintf("%s GET|PUT  hostname  filename\r\n", argv[0]);
        exit( 3 );
    }


    put = !stricmp( argv[1], "put");
    hostname = argv[2];
    host = resolve( hostname );
    filename = argv[3];

    if ( host == 0 ) {
        cprintf("ERROR: unable to resolve %s\r\n", hostname );
        exit( 3 );
    }

    if ( put ) {
        cprintf("\r\nUploading %s to %s...", filename, hostname );
        result = tftp( host, TFTP_PUT, filename );
    } else {
        cprintf("\r\nDownloading %s from %s...", filename, hostname );
        result = tftp( host, TFTP_GET, filename );
    }
    cprintf( "%s\r\n", result ? "failed" : "success");
    return( result ? 2 : 0 );
}

