; E100PKT, packet driver for DOS
; Copyright (C) 2018, Seth Simon (sethsimon@sdf.org)
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see
; <https://www.gnu.org/licenses/>.

;=========================
;=======           =======
;       F_TERMINATE
;=======           =======
;=========================
f_terminate:
    ; BX = handle
    push    ax
    mov     ax, word [bp]    
    call    verify_handle
    mov     bl, ERROR_BAD_HANDLE
    jc      .done_popax

    call    more_than_one_handle_open
    mov     bl, ERROR_CANT_TERMINATE
    jc      .done_popax

    push    ds
    push    es
    push    dx
    push    si

    push    cs
    pop     ds

    ; Make sure no one else hooked the hw vector
    mov     si, cs
    mov     ah, 0x35
    mov     al, byte [irq_int]
    int     0x21                ; ES:BX := vector

    mov     ax, es
    sub     ax, si      ; Segment difference
    sub     bx, hw_int  ; Offset difference
    or      ax, bx
    mov     bl, ERROR_CANT_TERMINATE
    stc
    jnz     .done

    ; Disable the hardware
    call    toggle_irq_mask
    mov     bl, 4           ; BH already 0, RUC=RU Abort
    call    scb_command

    mov     ah, 0x25
    mov     al, byte [irq_int]
    lds     dx, [prev_hw_int]
    int     0x21

    mov     al, byte [cs:pkt_int]
    cwd             ; DX = 0
    mov     ds, dx
    int     0x21

    ; ES is already the same as CS
    mov     ah, 0x49
    int     0x21        ; Free memory (returns CF=0)
.done:
    pop     si
    pop     dx
    pop     es
    pop     ds
.done_popax:
    pop     ax
    ret
