Program Print2PS;

{
                         Print2PS, version 1.0

                Copyright (C) 2006 by Francesco Zamblera
                  under the GNU General Public License

                           vilnergoy@yahoo.it


    This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

    This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
}

USES    dos;

Type     _byte = string[2];

Const    HexDigit : String[16] = '0123456789ABCDEF';
         ASCII128file : String[12] = 'lower128.dat';
         MaxLines = 61;
         LineLength = 65;

Var      ConvTable: Array [#0..#255] of _byte;
         FontFile: File Of Char;
         InputTxt, OutputPS, Template: text;
         Data: Array [0..2047] of Char;
         FontName, Path, FileName: String;

Procedure InitTable;
var k: char;
begin
 for k := #0 to #255 do
     ConvTable [k] :=
               HexDigit [ord(k) div 16 + 1] +
               HexDigit [ord(k) mod 16 + 1]
end;

Procedure WriteTable;
var k: char;
begin
 for k := #220 to #255 do writeln(k,'     ',ConvTable[k])
end;

Procedure ReadFile (fn: string);
var i: integer;
begin
 assign(FontFile,fn);
 reset(FontFile);
 i := 0;
 while not eof (FontFile) do begin
                              read(FontFile,Data[i]);
                              inc(i)
                             end;
 close(FontFile)
end;

Procedure convert (IsUpper128: boolean; fn: string);
var i,Glyph,displ: byte;
begin
 ReadFile(fn);
 if IsUpper128 then displ := 128 else displ := 0;
 for Glyph := 0 to 127 do
     begin
      write(OutputPS,'   /c',Glyph + displ,' <');
      for i := 0 to 15 do
          write(OutputPS,ConvTable [Data [Glyph*16+i]]);
      writeln(OutputPS,'> def')
     end;
end;

Procedure WriteEncoding;
var i: byte;
begin
 writeln(OutputPS,       '  /Encoding 256 array def');
 writeln(OutputPS,       '  0 1 255 {Encoding exch /.notdef put} for');
 writeln(OutputPS,       '  Encoding');
 for i := 32 to 254 do
     writeln(OutputPS,   '    dup ',i , ' /c', i, ' put');
 writeln(OutputPS,       '    255 /c255 put')
end;

Procedure WriteData (fn: string);
begin
 writeln(OutputPS);
 writeln(OutputPS,   '  /Bitmaps 256 dict def');
 writeln(OutputPS,   '  Bitmaps begin');
 writeln(OutputPS,   '    /.notdef <FFFF800180018001800180018001FFFF> def');
 InitTable;
 Convert (false,path + 'fonts\' + ASCII128File);
 Convert(true,path + 'fonts\' +fn+'.dat');
 writeln(OutputPS,   '  end')
end;

Procedure MakeFont (FontName: string);
var InsertData: boolean;
    Line: String;
begin
 InsertData := false;
 while (not InsertData) and (not eof (Template))
       do begin
           readln(Template,Line);
           InsertData := Line = '%%ENCODING BITMAPS';
           if not InsertData then writeln(OutputPS,Line)
          end;
 if InsertData then begin
                     WriteEncoding;
                     WriteData (FontName)
                    end
               else begin
                     writeln('Error in file TEMPLATE.PS:');
                     writeln('Line "%%ENCODING BITMAPS" not found');
                     halt(1)
                    end;
 while not eof(Template) do begin
                             readln(Template,Line);
                             writeln(OutputPS,Line)
                            end
end;

function Ascii2hex(s: string): string;
var res: string; i: byte;
begin
 res := '';
 for i := 1 to length(s) do
     res := res + convtable[s[i]];
 Ascii2hex := res
end;


Procedure WriteText;
var line: String;
    i,LineNumber: byte; PageNumber: integer;
begin
 LineNumber := 0; PageNumber := 1;
 writeln(OutputPS); Writeln(OutputPS,'%PAGE',PageNumber);
 line := '';
 while not eof (InputTxt)
       do begin
           inc(LineNumber);
           ReadLn (InputTxt,line);
           for i := 1 to length (line)
               do if line [i]= #8 then line[i] := #32;
           writeln(OutputPS, '<' + Ascii2hex(line) +
                             '> show nl   %',LineNumber);
           if linenumber = maxlines
              then begin
                    writeln(OutputPS, 'showpage np');
                    inc(PageNumber);
                    LineNumber := 0 ;
                    writeln(OutputPS);
                    writeln(OutputPS, '%PAGE ', PageNumber);
                   end
          end;
 if linenumber <> 0 then writeln(OutputPS,'showpage');
 writeln(OutputPS,'%%EOF')
end;

begin
 FontName := ParamStr (1);
 Path := ParamStr (2);
 FileName := ParamStr (3);
 assign(Template, Path + 'template.ps');
 if FileName = '' then FileName := 'print';
 assign(OutputPS, FileName + '.ps');
 assign(InputTxt, Path + 'print.tmp');
 reset(Template); reset(InputTxt); rewrite(OutputPS);
 MakeFont (FontName);
 WriteText;
 close(Template); close (OutputPS)
end.
