{**********************************************************************
Copyright (C) 2009 by Salvatore Licciardi

Web http://www.webalice.it/turylicciardi    eMail turylicciardi@tiscali.it

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, version 3 of the License.
 This program is distributed in the hope  that it will be useful , but WITHOUT
 ANY WARRANTY without even the implied warranty  of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details. You should have received
 a copy of the GNU General Public License along with this program. If not, see
 http://www.gnu.org/licenses/

 **********************************************************************}

{ this unit is for FreePascal / BP7 .
  Target OS: Go32v2 , Win32 , OS/2 and similar .
  with Printers unit you can use your printer as LPT 1..9, COM 1..4 .

  written by: Salvatore Licciardi
  WWW page  : web.tiscali.it/licciardi
  E-Mail    : turylicciardi@tiscali.it
  this file : web.tiscali.it/licciardi/prog/printers.zip
  version   : 1.0.1  2004/02/28

}

unit printers;
{$MODE ObjFpc}
interface

{$ifdef FPC}
uses SysUtils;
{$endif}

function     Set_Printer(s:string):longint;        { 0=open , 1=not open , 2=isn't valid }
function     Get_Printer:string;
function     Get_Status_Printer(s:string):longint; { 0=open , 1=not open , 2=isn't valid }
function     Close_Printer:boolean;

var          lst: text;

implementation

const default_printer:string='';

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifndef FPC}
function UpCase(s:string):string;
var i:longint;
begin
for i:=1 to length(s) do
    if s[i] in ['a'..'z'] then s[i]:=char( ord(s[i])-32 );
UpCase:=s;
end;
{$endif}

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifndef FPC}
function Trim(s:string):string;
begin
while copy(s,1,1)=' ' do s:=copy(s,2,length(s)-1);
while copy(s,length(s),1)=' ' do s:=copy(s,1,length(s)-1);
Trim:=s;
end;
{$endif}

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  Get_Status_Printer(s:string):longint;  { 0=open , 1=not open , 2=isn't valid }
begin
s:=upcase(trim(s));
Get_Status_Printer:=0;
if (s=default_printer)and(s<>'') then Exit;
Get_Status_Printer:=1;
if length(s)<>4 then
                begin
                Get_Status_Printer:=2;
                Exit;
                end;
if ( (copy(s,1,3)='LPT') and (s[4] in ['1'..'9']) ) or
   ( (copy(s,1,3)='COM') and (s[4] in ['1'..'4']) ) then { valid name }
                                                    else
                                                     begin
                                                     Get_Status_Printer:=2;
                                                     Exit;
                                                     end;
end;

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  Get_Printer:string;
begin
Get_Printer:=default_printer;
end;

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  Close_Printer:boolean;
begin
{$i-}
close(lst);
{$i+}
if ioresult<>0 then Close_Printer:=false
               else
                begin
                close_printer:=true;
                default_printer:='';
                end;
end;

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  Set_Printer(s:string):longint;
begin
Set_Printer:=2;
default_printer:='';
s:=trim(upcase(s));
if length(s)<>4 then Exit;
if ( (copy(s,1,3)='LPT') and (s[4] in ['1'..'9']) ) or
   ( (copy(s,1,3)='COM') and (s[4] in ['1'..'4']) ) then { valid name }
                                                    else Exit;
default_printer:=s;
assign(lst,s);
{$i-}
rewrite(lst);
{$i+}
if ioresult=0 then set_printer:=0
              else set_printer:=1;
end;

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

end.
