/* keydefgr.h */



/*
 * history
 * 25 aug 02: tom ehlert - creation
 */


#define NAME(x) x##_FR


#include <dos.h>
#include "mkeyb.h"



/********************************************************
 * GERMAN keyboard mappings                             *
 ********************************************************/

uchar NAME(scancodetable)[] = {

 /* 1 */ ALPHA           (0x02, '&', '1'         )
 /* 2 */ ALPHA_ALTGR     (0x03, '', '2',     '~')
 /* 3 */ ALPHA_ALTGR     (0x04, '"', '3',     '#')
 /* 4 */ ALPHA_ALTGR     (0x05, '\'','4',     '{')
 /* 5 */ ALPHA_ALTGR     (0x06, '(', '5',     '[')
 /* 6 */ ALPHA_CTRL_ALTGR(0x07, '-', '6',0x1e,'|')
 /* 7 */ ALPHA_ALTGR     (0x08, '', '7',     '`')
 /* 8 */ ALPHA_CTRL_ALTGR(0x09, '_', '8',0x1c,'\\')
 /* 9 */ ALPHA_ALTGR     (0x0A, '', '9',     '^')
 /* 0 */ ALPHA_ALTGR     (0x0B, '', '0',     '@')
 /* 0 */ ALPHA_ALTGR     (0x0c, ')', '',     ']')
 /* 0 */ ALPHA_CTRL_ALTGR(0x0d, '=', '+',0x1f,'}')


 /* Q */ REPLACE        (0x10, 0x1e             )	// Q-->A
 /* W */ REPLACE        (0x11, 0x2c             )   // W-->Z
 /* A */ REPLACE        (0x1e, 0x10             )	// A-->Q
 /* Z */ REPLACE        (0x2c, 0x11             )   // Z-->W

 /* ] */ ALPHA          (0x1a, '^',''          )
 /* ] */ ALPHA          (0x1b, '$',''          )

 /* ; */ REPLACE        (0x27, 0x32             )   // ;-->M     
 

 /*   */ ALPHA          (0x28,'','%'           )
 /*   */ ALPHA          (0x29,'',0             )
 /*   */ ALPHA          (0x2b,'*',''           )

 /*   */ ALPHA          (50,',','?'             ) 
 /*   */ ALPHA          (51,';','.'             )
 /*   */ ALPHA          (52,':','/'             )
 /*   */ ALPHA          (53,'!',0x15            )
 /*   */ ALPHA          ( 86,'<','>'            )

        0
};



struct KeyboardDefinition NAME(Keyboard) = {
        "FR",                                          //char LanguageShort[4];                 // "GR",                    
        "FRENCH - claviature francais (by tom-untested)",  //char *Description;                         // created by, "with combis"
        DRIVER_FUNCTION_NORMAL,                        //char DriverFunctionRequired;                                  
        NAME(scancodetable),                           //char *ScancodeTable;                                          
#ifdef COMBI
        {       NAME(combi1table),NAME(combi2table),NAME(combi3table),
                NAME(combi4table),NAME(combi5table),NAME(combi6table) },
#else
        { 0 },
#endif                  
        0,// ',',                                           //char DezimalDingsbums;                                        
        0,                                             //char DefaultLayoutUS;                  // TRUE for russian             
        } ;
