/* keydefNL.H */

//
// history
// 20 apr 02: tom ehlert - creation
//


// I don't think german DOS keyboard driver needs combies
// #define COMBI

#define LANGUAGE "dutch"
#define STATUS   "first try"



#define EURO 0x00	/* unknown so far */

/********************************************************
* DUTCH  keyboard mappings                             *
********************************************************/


unsigned char scancodetable[] =
	{
/* 1 */  0x02, NORMAL|ALTGREY,  '1','!',0xff,0xfb,  /*  */
/* 2 */  0x03, NORMAL|ALTGREY,  '2','"',0xff,0xfd, /*  */
/* 3 */  0x04, NORMAL|ALTGREY,  '3','#',0xff,0xfc,/*  */
/* 4 */  0x05, NORMAL|ALTGREY,  '4','$',0xff, 0xac,/*  */
/* 5 */  0x06, NORMAL|ALTGREY,	'5','%',0xff,0xab, /*  */
/* 6 */  0x07, NORMAL|ALTGREY,  '6','&',0xff,0xf3, /*  */
/* 7 */  0x08, NORMAL|ALTGREY,  '7','/',0xff,0x9c, /*  */
/* 8 */  0x09, NORMAL|ALTGREY,  '8','(',0xff,'{',
/* 9 */  0x0a, NORMAL|ALTGREY,  '9',')',0xff,'}',
/* 0 */  0x0b, NORMAL        ,  '0','\'',0,

/* - */  0x0c, NORMAL|ALTGREY,  '/','?',0,'\\',
#ifdef COMBI
/* = */  0x0d, NORMAL,			COMBI1,COMBI2,0xff,		/* COMBI ' and ` + aeiou*/
#else
/* = */  0x0d, NORMAL|ALTGREY,	0xf8,'~',0,0xf7,				/*   */
#endif
/* r */  0x13, ALTGREY,			0x14,
/* [ */  0x1a, NORMAL,			0xf9,'^',0,				/*   */
/* ] */  0x1b, NORMAL,		'*', 0xb3,0,			/*   */

/* s */  0x1f, ALTGREY,			0xe1,					/*  */

/* ; */  0x27, NORMAL,  		'+',0xf1,0, 			/*  */
/* ' */  0x28, NORMAL,  		'\'','`',0,
#ifdef COMBI
/* ` */  0x29, NORMAL,		     COMBI3,0xf8,0xff,			/* COMBI ^ + aeiou */
#else
/* ` */  0x29, NORMAL|ALTGREY,	'@',0x15,0,0xaa,		/*   */
#endif
/* \ */  0x2b, NORMAL,		     '<','>',0,
/* z */  0x2c, ALTGREY,		     0xae, /*  */
/* c */  0x2e, ALTGREY,		     0x9b, /*  */

/* M */  0x32, ALTGREY,  		 0xe6,	/* greek mue */
/* , */  0x33, NORMAL,		     ',',';', 0xff,
/* . */  0x34, NORMAL|ALTGREY,	 '.',':', 0x1f,0xfa, /*  */
/* / */  0x35, NORMAL,		     '-','=', 0x1f,

/*   */  0x56, NORMAL|ALTGREY,	 ']','[', IGNORE, '|',
	0
	};


/*
	these keys are generated on a COMBI+character base,
	don't know if that is correct.
	I also don't know what keys to generate, as the
	standard character set (DOS/BIOS) doesn't have
	norwegian/swedish/spanish characters

*/
#ifdef COMBI
unsigned char combi1table[] = 		/* ' a e i o u E #32' */
	{/*scancode lower upper */
/* A */  0x1e, 0xa0,0x00,
/* E */  0x12, 0x82,0x90,
/* I */  0x17, 0xa1,0x00,
/* O */  0x18, 0xa2,0x00,
/* U */  0x16, 0xa3,0x00,
/*blank*/0x39, '\'','\'',		/* and additional generated character */
	0};

unsigned char combi2table[] = 		/* ` a e i o u #32` */
	{/*scancode lower upper */
/* A */  0x1e, 0x85,0x00,
/* E */  0x12, 0x8a,0x00,
/* I */  0x17, 0x8d,0x00,
/* O */  0x18, 0x95,0x00,
/* U */  0x16, 0x97,0x00,
/*blank*/0x39, '`','`',		/* and additional generated character */
	0};

unsigned char combi3table[] = 		/* ^ a e i o u #32^ */
	{/*scancode lower upper */
/* A */  0x1e, 0x83,0x00,
/* E */  0x12, 0x88,0x00,
/* I */  0x17, 0x8c,0x00,
/* O */  0x18, 0x93,0x00,
/* U */  0x16, 0x96,0x00,
/*blank*/0x39, '^','^',		/* and additional generated character */
	0};
unsigned char combi4table[] = 		/* something missing yet ?? */
	{/*scancode lower upper */
/*blank*/0x39, ' ',' ',		/* and additional generated character */
	0};
unsigned char combi5table[] = 		/* something missing yet ?? */
	{/*scancode lower upper */
/*blank*/0x39, ' ',' ',		/* and additional generated character */
	0};

#endif

