; COMTEST - Find COMs port type and associated IRQ line
; Copyright (c) 2000-2002 Arkady Belousov <ark@mos.ru>
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;

WARN
%NOINCL
LOCALS
.model tiny

INCLUDE asm.mac
INCLUDE macro.mac
INCLUDE convert/digit.mac
INCLUDE DOS/io.mac


; DATA SEGMENT 

.data

S_header	db	'COMTEST v2.5 Copyright (c) 2000-2002 by Arkady V.Belousov',0dh,0ah
		db	0dh,0ah
		db	'COM# Addr IRQ# Type                      Attached',0dh,0ah
		db	'---- ---- ---- ------------------------- ----------------------------'
CRLF		db	0dh,0ah,'$'
S_port		db	'  '
S_COMno		db	  '   '
S_IOaddr	db	     '      '
S_IRQno		db		   '    $'

S_noUART	db			'not found$'
S_8250		db			'8250 (no FIFO)            $'
S_8250A		db			'8250A/16450 (no FIFO)     $'
S_16550noSCR	db			'16550 (buggy FIFO/no SCR) $'
S_16550		db			'16550 (buggy FIFO)        $'
S_16550AnoSCR	db			'16550A (with FIFO/no SCR) $'
S_16550A	db			'16550A (with FIFO)        $'

S_MS		db	'Microsoft mode mouse$'
S_WM		db	'Mouse with wheel$'
S_LT		db	'Logitech 3-button mode mouse$'

S_note		db	'$',0ah,'* multiple IRQ detected',0dh,0ah,'$'

UARTtype	dw	DGROUP:S_8250
		dw	DGROUP:S_8250A
		dw	DGROUP:S_16550noSCR
		dw	DGROUP:S_16550
		dw	DGROUP:S_16550AnoSCR
		dw	DGROUP:S_16550A

micetype	dw	DGROUP:S_MS
		dw	DGROUP:S_WM
		dw	DGROUP:S_LT


; CODE SEGMENT 

.code
		org	100h
start:		cld
		mov	ax,1Fh			; disable mouse
		call	mousedrv

		DOSWriteS ,DGROUP:S_header
		mov	bx,'1'
@@comloop:	push	bx

;---------- get IO address for COM port
		mov	[S_COMno],bl
		MOVSEG	es,0,ax,nothing
		shl	bx,1
		mov	si,es:400h[bx-'1'-'1']
;----------
		call	testaddr
		pop	bx
		inc	bx
		cmp	bx,'4'
		jbe	@@comloop

		DOSWriteS ,DGROUP:S_note	; final note

;---------- reset mouse and exit
		xor	ax,ax
		call	mousedrv
		int	20h

;
; In:	SI			(I/O address)
; Modf:	AX, CX, DX, BX, DI, ES
; Call:	detectUART, detectmouse
;
testaddr	proc
;---------- convert IO address into string
		MOVSEG	es,ds,,DGROUP
		mov	di,offset DGROUP:S_IOaddr
		mov	cl,12
@@loophexw:	mov	ax,si
		shr	ax,cl
		and	al,0Fh
		digit2x
		stosb
		sub	cl,4
		jae	@@loophexw

;---------- detect UART type and IRQ line
		call	detectUART
		 mov	dl,' '
		 mov	ax,'  '
		 mov	di,offset DGROUP:S_noUART
		 jc	@@printUART

		shl	bx,1
		mov	di,UARTtype[bx]
		call	detectIRQ
		 mov	al,'?'
		 or	bx,bx
		 jz	@@printUART		; jump if no IRQ detected

		mov	ax,bx
		dec	ax
		and	ax,bx			; =0 if only one bit set in BX
		jz	@@mask2str
		 mov	byte ptr [S_note],0dh	; turn on final note
		 mov	dl,'*'
		 xor	bx,ax			; remain lowest set bit

@@mask2str:	xor	cx,cx
@@mask2no:	shr	bx,1
		 loopnz	@@mask2no

		mov	ax,'10'-11		; ='1x'
		 sub	ax,cx
		cmp	al,'0'
		 jae	@@printUART
		add	ax,(' '-'1') SHL 8 + 10	; =' x'

;---------- print UART info
@@printUART:	xchg	al,ah
		mov	word ptr S_IRQno[0],ax
		mov	byte ptr S_IRQno[2],dl
		DOSWriteS ,DGROUP:S_port
		DOSWriteS ,di

;---------- check attached devices
		cmp	cx,offset DGROUP:S_noUART
		 je	@@testret
		call	detectmouse
		jc	@@testret
		shl	bx,1
		DOSWriteS ,micetype[bx]

@@testret:	DOSWriteS ,DGROUP:CRLF
		ret
testaddr	endp

;

mousedrv	proc
		push	ax bx es
		mov	ax,3533h
		int	21h			; get INT in ES:BX
		mov	ax,es
		test	ax,ax
		pop	es bx ax
		jz	@@mouseret
		int	33h
@@mouseret:	ret
mousedrv	endp

;
;			Detect UART presence and type
;
;
; In:	SI			(I/O address)
; Out:	Carry flag		(no UART detected)
;	BX			(UART type: 0=8250, 1=8250A/16450,
;				 2=16550/no SCR, 3=16550,
;				 4=16550A/no SCR, 5=16550A)
; Use:	none
; Modf:	AX, DX
; Call:	none
;
detectUART	proc
		cli
		test	si,si
		jz	@@noUART

;---------- check UART registers for dummy bits
		lea	dx,[si+4]		; {3FCh} MCR (modem ctrl reg)
		 in	ax,dx			; {3FDh} LSR (line status reg)
		test	al,11100000b		; =0E0h; reserved bits
		 jnz	@@noUART
		inc	dx
		 in	al,dx			; {3FDh} LSR (line status reg)
		inc	ax
		 jz	@@noUART		; jump if AX was 0FFFFh

;---------- check loopback mode
		dec	dx
		in	al,dx			; {3FCh} MCR (modem ctrl reg)
		 xchg	bx,ax			; OPTIMIZE: instead MOV BL,AL
		mov	al,00010000b		; =10h
		 out	dx,al			; {3FCh} MCR: enable loopback
		inc	dx
		 inc	dx
		 in	al,dx			; {3FEh} MSR (modem stat reg)
		 mov	ah,al			; MSR.4-7=MCR.1,0,2,3
		dec	dx
		 dec	dx
		 mov	al,00011111b		; =1Fh
		 out	dx,al			; {3FCh} MCR: enable loopback
		inc	dx
		 inc	dx
		 in	al,dx			; {3FEh} MSR (modem stat reg)
		dec	dx
		 dec	dx
		not	al
		test	ax,1111000011110000b	; =0F0F0h
		xchg	ax,bx			; OPTIMIZE: instead MOV AL,BL
		 out	dx,al			; {3FCh} MCR: restore contents
		jnz	@@noUART

;---------- check LCR function
		dec	dx
		in	al,dx			; {3FBh} LCR (line ctrl reg)
		 xchg	bx,ax			; OPTIMIZE: instead MOV BL,AL
		mov	al,10111111b		; =0BFh
		 out	dx,al			; {3FBh} LCR: DLAB on, space
		in	al,dx			;  parity, stop=2, length=8
		 mov	ah,al
		mov	al,00000010b		; =2
		 out	dx,al			; {3FBh} LCR: DLAB off, no
		 in	al,dx			;  parity, stop=1, length=7
		cmp	ax,1011111100000010b	; =0BF02h
		 jne	@@noLCR
;----------
		dec	dx
		 dec	dx
		 in	al,dx			; {3F9h} IER (int enable reg)
		inc	dx
		 inc	dx
		test	al,11110000b		; =0F0h; reserved bits
		 jz	@@checkUART

@@noLCR:	xchg	ax,bx			; OPTIMIZE: instead MOV AL,BL
		 out	dx,al			; {3FBh} LCR: restore contents
@@noUART:	sti
		stc
		ret

;---------- check if SCRatch register present
@@checkUART:	xchg	ax,bx			; OPTIMIZE: instead MOV AL,BL
		 out	dx,al			; {3FBh} LCR: restore contents
		lea	dx,[si+7]
		 in	al,dx			; {3FFh} SCR (scratch reg)
		 xchg	bx,ax			; OPTIMIZE: instead MOV BL,AL
		mov	al,055h
		 out	dx,al			; {3FFh} SCR (scratch reg)
		 in	al,dx			; 1: check if present
		 mov	ah,al
		mov	al,0AAh
		 out	dx,al			; {3FFh} SCR (scratch reg)
		 in	al,dx			; 2: check if present
		sub	ax,055AAh
		 neg	ax			; nonzero makes carry flag
		 sbb	ax,ax			; UART=8250 (no SCR)
		 inc	ax			;  or 16450 (with SCR)
		xchg	ax,bx			; OPTIMIZE: instead MOV AL,BL
		 out	dx,al			; {3FFh} SCR: restore contents

;---------- check FIFO
		lea	dx,[si+2]
		 mov	al,11000111b		; =0C7h
		 out	dx,al			; {3FAh} FCR: enable FIFO
		 in	al,dx			; {3FAh} IIR (intr id reg)
		test	al,10000000b		; =80h
		 jz	@@FIFOoff
		inc	bx
		 inc	bx			; UART=16550
		test	al,01000000b		; =40h
		 jz	@@FIFOoff
		inc	bx
		 inc	bx			; UART=16550A
@@FIFOoff:	mov	al,0
		 out	dx,al			; {3FAh} FCR: disable FIFO
		sti
		;clc
		ret
detectUART	endp

;
;			Detect IRQ assigned to UART
;
;
; In:	SI			(I/O address)
; Out:	BX			(mask of detected IRQs)
; Use:	none
; Modf:	none
; Call:	UARTreset
;
detectIRQ	proc	C uses ax cx dx
		cli
		mov	al,00001010b		; =0Ah
		 out	0A0h,al			; {A0h} PIC2/OCW3: IRR read mode
		 out	020h,al			; {20h} PIC1/OCW3: IRR read mode

;---------- clear UART interrupts
		mov	ax,0000110000000011b	; =0C03h
						; {3FBh} LCR: DLAB off
		call	UARTreset		; {3FCh} MCR: loopback off, OUT1/OUT2 on
		push	bx			; keep old LCR and MCR values

;---------- test THRE interrupt generation
		mov	cx,3
@@shotloop:	push	cx
		in	al,0A0h			; {A0h} get IRR
		 mov	ah,al			; keep current IRR state
		in	al,020h			; {20h} get IRR
		xchg	bx,ax			; OPTIMIZE: instead MOV BX,AX
		mov	al,2
		 out	dx,al			; {3F9h} IER: enable THRE intr

		mov	cx,100h
@@waitIRQon:	in	al,0A0h			; {A0h} get IRR
		 mov	ah,al
		in	al,020h			; {20h} get IRR
		xor	ax,bx			; check if IRQ appeared
		and	ax,not 1		; mask out timer IRQ
		loopz	@@waitIRQon
		xchg	bx,ax

		mov	al,0
		 out	dx,al			; {3F9h} IER: interrupts off
		in	ax,dx			; {3FAh} IIR: clear THRE event
		lea	dx,[si+5]		; {3FDh} LSR: clear error bits
		 in	ax,dx			; {3FEh} MSR: clear state bits
		mov	dx,si
		 in	al,dx			; {3F8h} flush receive buffer
		inc	dx

		mov	cx,100h
@@waitIRQoff:	in	al,0A0h			; {A0h} get IRR
		 mov	ah,al
		in	al,020h			; {20h} get IRR
		xor	ax,bx			; check if IRQ disappeared
		and	ax,bx
		loopz	@@waitIRQoff

		pop	cx
		loopz	@@shotloop
		xchg	bx,ax			; OPTIMIZE: instead MOV BX,AX

;---------- restore LCR and MCR state
		lea	dx,[si+3]
		pop	ax			; {3FBh} LCR: restore contents
		out	dx,ax			; {3FCh} MCR: restore contents
		sti
		ret
detectIRQ	endp

;
; In:	SI			(I/O address)
;	AL			(LCR value)
;	AH			(MCR value)
; Out:	BL			(old LCR value)
;	BH			(old MCR value)
;	DX = SI+1
; Modf:	AX, DX
;
UARTreset	proc
		xchg	bx,ax			; OPTIMIZE: instead MOV BX,AX
		lea	dx,[si+3]
		 in	ax,dx			; {3FBh} LCR (line ctrl reg)
		 xchg	ax,bx			; {3FCh} MCR (modem ctrl reg)
		 out	dx,ax
		inc	dx
		 inc	dx			; {3FDh} LSR: clear error bits
		 in	ax,dx			; {3FEh} MSR: clear state bits
		mov	dx,si
		 in	al,dx			; {3F8h} flush receive buffer
		inc	dx
		 in	ax,dx			; {3FAh} IIR: clear THRE event
		 xor	ax,ax			; {3F9h} IER: interrupts off
		 out	dx,ax			; {3FAh} FCR: disable FIFO
		ret
UARTreset	endp

;
;			Detect mouse type if present
;
;
; In:	SI			(I/O address)
; Out:	Carry flag		(no mouse found)
;	BX			(mouse type: 0=MS, 1=Wheel, 2=Logitech)
; Use:	0:46Ch
; Modf:	none
; Call:	UARTreset, readUART
;
detectmouse	proc	C uses ax cx dx es
;---------- save current LCR/MCR, drop RTS line and reset UART
		mov	ax,0000000000000010b	; =0002h
						; {3FBh} LCR: DLAB off
		call	UARTreset		; {3FCh} MCR: DTR/RTS/OUT2 off
		push	bx			; keep old LCR and MCR values

;---------- wait current+next timer tick
		MOVSEG	es,0,ax,nothing
@@RTSloop:	mov	ah,es:[46Ch]
@@RTSwait:	cmp	ah,es:[46Ch]
		 je	@@RTSwait		; loop until next timer tick
		xor	al,1
		 jnz	@@RTSloop		; loop until end of 2nd tick

;---------- set 1200 baud rate and raise RTS line
		lea	dx,[si+3]
		 mov	al,10000000b		; =80h
		 out	dx,al			; {3FBh} LCR: DLAB on
		xchg	dx,si
		 mov	ax,96			; 1200 baud rate
		 out	dx,ax			; {3F8h},{3F9h} divisor latch
		xchg	dx,si
		 mov	ax,0000001100000010b	; =0302h
		 out	dx,ax			; {3FBh} LCR: DLAB off, no
						;  parity, stop=1, length=7
						; {3FCh} MCR: DTR/RTS on, OUT2 off

;---------- detect if Microsoft or Logitech mouse present
		mov	bx,0100h		; bl=mouse type, bh=no `M'
		mov	cx,4			; scan 4 first bytes
@@detmloop:	call	readUART
		jc	@@detmdone
		cmp	al,8
		 je	@@skipPNP		; jump if PNP data starts
		cmp	al,'M'
		 jne	@@checkWM
		 mov	bh,0			; MS compatible mouse found...
@@checkWM:	cmp	al,'Z'
		 jne	@@checkLT
		 mov	bl,1			; ...wheel mouse found
@@checkLT:	cmp	al,'3'
		 jne	@@detmnext
		 mov	bl,2			; ...Logitech mouse found
@@detmnext:	loop	@@detmloop

@@skipPNP:	mov	cx,91			; =5*18.2 ticks, ~5 seconds
@@PNPloop:	mov	ah,es:[46Ch]		; current timer value
@@PNPwait:	call	readUART
		 jc	@@detmdone		; jump if no more data
		cmp	ah,es:[46Ch]
		 je	@@PNPwait		; loop until next timer tick
		loop	@@PNPloop		; loop until timeout

@@detmdone:	lea	dx,[si+3]
		pop	ax			; {3FBh} LCR: restore contents
		out	dx,ax			; {3FCh} MCR: restore contents

		shr	bh,1			; 1 makes carry flag
		ret
detectmouse	endp

;
; In:	SI			(I/O address)
;	ES = 0
; Out:	Carry flag		(set if timeout)
;	AL			(received data when no timeout)
; Use:	0:46Ch
; Modf:	DX
;
readUART	proc
		assume	es:nothing
		mov	dh,2+1			; length of silence in ticks
						; (include rest of curr tick)
@@readloop:	mov	dl,es:[46Ch]
@@readwait:	push	dx
		lea	dx,[si+5]
		 in	al,dx			; {3FDh} LSR (line status reg)
		pop	dx
		test	al,1
		 jnz	@@readret		; jump if data ready
		cmp	dl,es:[46Ch]
		 je	@@readwait		; loop until next timer tick
		dec	dh
		 jnz	@@readloop		; loop until end of 2nd tick
		stc				; indicate timeout
		ret

@@readret:	mov	dx,si
		 in	al,dx			; {3F8h} receive byte
		;clc
		ret
readUART	endp


;

		end	start
