; LBAcache - a hard disk cache based on XMS, 386 only,
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001

; Check out the CHS version as well (limited to 8 GB,
; uses less DOS memory, and wimps out on LBA write)...

; this is a silly UN-loader:
; It scans through the memory for instances of HDCACHE$ device
; headers, and if they have an XMS handle, it closes the handle
; after disabling the driver.
; If in addition the link to a COMCACHE signature is found, the
; MCB size is reduced to save some RAM.
; If - third case - even int 0x13 is found to be still pointing
; to the device, the oldint vector is restored and the RAM is
; completely freed.
; if an I option rather than an U option is given, will only
; show information and not unload the instances.

; new 01/2002: the F flush option to flush drives A..F ("eject media").
; new 01/2002: uncache is now part of the cache binary :-)
; new 08/2002: no waiting inside the status display, dec/percent display

%ifdef STANDALONE
bits 16
segment .text

 	org 0x100	; it is a .com file!

alabel:		; because .8086 and .386 wants to "be inside code"
.8086

entry:		; guess: the entry point
	xor ax,ax
	cld
	mov si,0x81
parse:
	lodsb
	cmp al,13	; cr -> eof
	jz parsed
	or al,al	; 0 -> eof
	jz parsed
	and al,0x0df	; not 0x20 (to upcase)
	cmp al,'U'
	jnz parse2	; U -> unload
	or ah,3		; always causes info as well
parse2:	cmp al,'I'	; I -> info
	jnz parse3
	or ah,2

	jmp short parsed
parse3:	cmp al,'F'
	jnz parse
	or ah,4
parsed:
	cmp ah,0	; did we find an U or an I or an F ?
	jnz confirmed

showhelp:
	push cs
	pop ds
	mov dx,yesmsg	; *offset*
showwimp:
	mov ah,9
		int 0x21
	mov al,1
leavethis:
	push cs
	pop es
	push cs
	pop ds
	mov ah,0x4c
		int 0x21	; exit with errorlevel al
%else

; -------------------------------------------------------------

showwimp:
	mov si,dx	; show a message before leaving
	call pmessage	; see below :-)
leavethis:
	pop ds
	pop es
	pop eax
	popa
	ret
uncache:		; always called from the cache
	pusha
	push eax
	push es
	push ds
	mov ah,[cs:args]
	test ah,7	; only continue if anything to do
	jz leavethis	; bits: 1 stop (remove all caches with
	mov bx,cs	; the signature and a nonzero XMS handle)
	mov ds,bx	; 2 info (stop should also set bit 1 !)
	mov es,bx	; 4 sync (flush/empty) all caches
%endif

; -------------------------------------------------------------

.386				; I know, no 386 presence check. pah.

confirmed:			; ok, so we have a mission now!
	mov [cs:unflag],ah	; store the type of our mission

	test ah,4
	jz confnorm
	mov si,flushmsg
		call pmessage	; message only, no AL AX EAX shown
	mov ax,0x4600		; eject media (int 13 extensions)
	mov dl,0		; A
		int 0x13	; no error checking: we only care for
	mov ax,0x4600		; the side effect of flushing the cache
	mov dl,0		; B
		int 0x13
	mov ax,0x4600
	mov dl,0x80		; C
		int 0x13
	mov ax,0x4600
	mov dl,0x81		; D
		int 0x13
	mov ax,0x4600
	mov dl,0x82		; E
		int 0x13
	mov ax,0x4600
	mov dl,0x83		; F
		int 0x13
	mov al,0
	mov dx,flushedmsg
		jmp showwimp	; we flushed (and maybe ejected) A..F 

; -------------------------------------------------------------

confnorm:
	mov ax,0x4300
	int 0x2f	; XMS install check
	cmp al,0x80
	jz xmsfound
	mov dx,noxmsmsg
	jmp showwimp	; no XMS - no cache to be found

xmsfound:
	push es
	mov ax,0x4310
	int 0x2f	; get the pointer to the xms far call
	mov [cs:xmsptr],bx
	mov ax,es
	mov [cs:xmsptr+2],ax
	shl eax,16
	mov ax,bx
	pop es
	mov si,yesxmsmsg+0x8000	; show message and EAX
		call pmessage	; XMS found, scanning may begin

	push word 0
	pop es			; ES will change soon anyway
	mov eax,[es:0x4c]	; current int 0x13 vector
	mov [cs:currint13],eax	; store for later
	mov si,curri13msg+0x8000	; show message and EAX
		call pmessage

; -------------------------------------------------------------

	mov bp,0x70	; assume no success before this...

findme:
	mov es,bp	; assume driver to be aligned!
	cmp dword [es:0x0a],'HDCA'
	jnz findon
	cmp dword [es:0x0e],'CHE$'
	jnz findon
	mov ax, [es:0x12]	; XMS handle
	or ax,ax
	jz findon		; no XMS handle - must be already off
	push eax
	mov eax,[es:0x18]	; XMS pointer for this one
	cmp eax,[cs:xmsptr]
	pop eax
	jz down1	; XMS pointers match
findon:
	jmp nope	; go on scanning

down1:
	test byte [cs:unflag],1	; UNLOAD requested?
	jz noshutdown
	mov word [es:0x3e],2	; SHUT DOWN driver
noshutdown:

	push ax
	mov si,foundmsg+0x4000	; *offset* - show message and AX
	mov ax,bp
		call pmessage	; show segment
	pop ax

; ----------------------

	mov si,xmsmsg+0x4000	; *offset* - show message and AX
		call pmessage	; show handle

	mov dx,ax	; handle
	  push dx	; **save
	mov ah,0x0e	; INFO handle
		call doxmscall
	jnc xmsok1
	  pop dx	; **restore1
xmswimp:
	jmp instancedone	; wimp out

xmsok1:
	mov ax,dx	; size in kb
	mov si,xmsinfomsg+0x4000	; *offset*, show message and AX
		call pmessage
	  pop dx	; **restore2

	test byte [cs:unflag],1	; do we UNLOAD ?
	jz nofreexms
	mov ah,0x0a	; FREE handle
		call doxmscall
	jc xmswimp
xmsfreeok:
	mov word [es:0x12],0	; remove XMS handle ID -> marks the
				; driver as uninteresting for UNCACHE
nofreexms:

; ----------------------

	mov bx,infolist		; a list of what we want to show
infoloop:
	mov si,[cs:bx]		; where to read
	or si,si
	jz infodone
	mov eax,[es:si]		; read a value from driver
	inc bx
	inc bx
	mov si,[cs:bx]		; select a message
		call pmessage	; show the message and AL/AX/EAX
	inc bx
	inc bx
	jmp short infoloop	; go on with next info

infodone:

; ----------------------

; *** 8/02: added human readable display
		push edx

humanreadable:
	mov eax,[es:0x24]	; read hits
		push eax	; save for percent
	xor edx,edx
	add eax,[es:0x28]	; read misses added
	adc edx,edx
		push eax	; save (low part) for percent
	mov ebx,1000
	div ebx			; transform to k
	xor edx,edx
		call hex2dec	; transform to packed BCD
	mov si,hrdmsg+0x4000	; human readable read message, 16bit
	test eax,0xffff0000	; need 32bit?
	jz hrd16
hrd32:	xor si,0xc000		; 16->32bit display size
hrd16:		call pmessage
		pop eax		; total
	mov ebx,eax
		pop eax		; hits
	xor edx,edx
	mov edx,100		; for percent
	mul edx
	xor edx,edx		; brute overflow blocking
	ror ebx,1		; rounding (no overflow check)
	add eax,ebx
	stc
	rcl ebx,1		; undo above, plus "or 1"
				; now ebx is an access count > 0
	div ebx			; calculate percent
	cmp eax,100		; clip to 99%
	jb hrd99
hrd100:	mov eax,99
hrd99:		aam		; AAM: ah=al div 10, al=al mod 10
		shl ah,4
		or al,ah	; now we have packed BCD
	mov si,hhitmsg+0x2000	; percentage message, 8bit
		call pmessage

; ----------------------

humanreadable2:
	mov eax,[es:0x2c]	; write hits
		push eax	; save for percent
	xor edx,edx
	add eax,[es:0x30]	; read misses added
	adc edx,edx
		push eax	; save (low part) for percent
	mov ebx,1000
	div ebx			; transform to k
	xor edx,edx
		call hex2dec	; transform to packed BCD
	mov si,hwrmsg+0x4000	; human readable write message, 16bit
	test eax,0xffff0000	; need 32bit?
	jz hwr16
hwr32:	xor si,0xc000		; 16->32bit display size
hwr16:		call pmessage
		pop eax		; total
	mov ebx,eax
		pop eax		; hits
	xor edx,edx
	mov edx,100		; for percent
	mul edx
	xor edx,edx		; brute overflow blocking
	ror ebx,1		; rounding (no overflow check)
	add eax,ebx
	stc
	rcl ebx,1		; undo above, plus "or 1"
				; now ebx is an access count > 0
	div ebx			; calculate percent
	cmp eax,100		; clip to 99%
	jb hwr99
hwr100:	mov eax,99
hwr99:		aam		; AAM: ah=al div 10, al=al mod 10
		shl ah,4
		or al,ah	; now we have packed BCD
	mov si,hhitmsg+0x2000	; percentage message, 8bit
		call pmessage

		pop edx

; ----------------------

	test byte [cs:unflag],1	; do we UNLOAD ?
	jz near instancedone	; if not, we are done with the instance

shrinkit:
	mov ax,es		; driver segment
	cmp ax,[cs:currint13+2]	; current int 13 vector segment
	jz fullremove		; int 13 still in driver
	mov eax,[es:0x3a]	; old int 13 vector...
	cmp eax,[cs:currint13]
	jnz partremove		; IF Z: int 13 same as oldint stored
				; in driver, so it was not even hooked

; ----------------------

fullremove:
	mov eax,[es:0x3a]	; int 13 vector before driver took it
	push es
	  push word 0
	  pop es
	mov [es:0x4c],eax	; un-hook the int 13 vector !!
	pop es
	mov [cs:currint13],eax	; update our notion of int 13

	mov si,unhookmsg+0x8000	; message and EAX
		call pmessage	; tell that we have unhooked

	xchg bx,bx
	xchg bx,bx
	xchg bx,bx

	mov ax,0		; now we can FREE the used memory,
	jmp comremove		; unless the driver was loaded as sys.

; ----------------------

				; we cannot unhook int 0x13, but
partremove:			; we can still reduce the used size,
				; unless the driver was loaded as sys.
	mov ax,[es:0x40]	; where to end the TSR
	add ax,15
	shr ax,4		; paragraphs - NEEDED BELOW
comremove:
	push es	; **save
	les bx,[es:0x00]	; device link pointer, because we are
				; looking for the magic that tells us
	cmp dword [es:bx+3],'COMC'	; if the driver is in com mode.
	jnz itsasys		; no removal possible for sys
	cmp dword [es:bx+7],'ACHE'
	jz itsacom
itsasys:
	pop es	; **restore1
	mov si,nocommsg
		call pmessage	; tell about the sys-ness...
	jmp instancedone	; we cannot free the RAM of a SYS !

; ----------------------

itsacom:			; Instance found to be .com version, so
				; we can un-alloc the memory it uses!
	mov bx,es		; where the com code segment is
	pop es	; **restore2

	push ax
	mov ax,bx		; segment of com
		mov si,comsegmsg+0x4000	; show message and AX
		call pmessage
	pop ax

	or ax,ax
	jz vanishing
	push bx 	; *** WARNING: should depend on distance MCB
	mov bx,es	; *** (BX) to the SYS SEG (ES) in some
	add ax,bx	; *** better/saner way than now probably!
	pop bx		; *** for now: size + (SYS-COM) + 1
	sub ax,bx	; *** is the size to which we reduce
	inc ax
vanishing:

		mov si,reducemsg+0x4000	; show message and AX
		call pmessage	; tell that we are reducing

	mov cx,0x1149	; start by assuming FREE (seg bx)
			; CH is the XMS function, CL the DOS one
	or ax,ax
	jz mcbme	; shrink/remove seg bx to ax paragraphs
	mov cx,0x124a	; resize, do not free

mcbme:	push es
	mov es,bx		; segment
	push bx
	mov bx,ax		; new size (if resize)
	push ax
	mov ah,cl		; the function to do
		int 0x21	; resize/free this MCB
	pop ax
	pop bx
	pop es

	jnc instancedone	; if it has worked, done with this!

	mov si,mcbfailmsg	; Only reason: this was no MCB
		call pmessage	; MCB operation failed

	; trying UMB mechanism as a second possibility
	; still, segment is BX and new size is AX
	; if DOS=UMB is active, DOS is supposed to have
	; converted all UMB to MCB, but we will see...

	mov dx,bx	; segment
	mov bx,ax	; new size (if resize)
	mov ah,ch	; the XMS function we figured out above
		call doxmscall	; XMS UMB free/resize
	; jc umbfailed... - the user already knows from the XMS error

; -------------------------------------------------------------

; *** Wait removed 8/02
instancedone:
	mov si,keymsg		; only show message
		call pmessage	; tell that we are done ; *** waiting
; ***	mov ah,0
; ***		int 0x16	; wait for a keypress
	
nope:	inc bp			; signature not found
	cmp bp,0xa000	; skip seg 0xa000 ... 0xc1ff in search
	jnz nskip
	mov bp,0xc200	; no VGABIOS would be < 16k, but Xdosemu
			; has an 8k VGABIOS ... http://www.dosemu.org/
nskip:	cmp bp,0xf000	; no we will not check the ROM and HMA area!
	jnz near findme	; go on searching

leavethis0:
	mov si,donemsg		; only show message
		call pmessage	; say goodbye...
	mov al,0		; errorlevel 0
	jmp leavethis

; -------------------------------------------------------------


pmessage:		; show message at (si and 0x1fff) and 
	push dx		; value of N lsby of eax, N being
	push eax	; si shr 13... and then CRLF.
	push ds
	  push cs
	  pop ds
	  push ax

	mov dx,si
	and dx,0x1fff	; mask out our flags (offset is max 8k !!!)
	mov ah,9
		int 0x21

	  pop ax
	test si,0xe000	; any bytes to show?
	jz pmdone	; if none, done
	  push ax
	mov ax,si
	shr ax,12	; how many nibbles to show
	and al,14	; only 2/4/6/8/10/12/14, which is
			; AL AX ? EAX ? ? ? (1..7 bytes)
	mov dh,al	; as a counter
	  mov dl,cl	; save
	mov cl,8	; max 8 nibbles
	sub cl,dh	; how many nibbles not to show
	shl cl,2	; nibbles -> bits
	  pop ax
	shl eax,cl	; make EAX "left-bound"
	  mov cl,dl	; restore

showeaxlp:
	rol eax,4	; move digit to show in lowest pos
	  push ax
	and al,0x0f
	add al,'0'	; hex -> ascii
	cmp al,'9'
	jbe nothex
	add al,7	; 'A'-('9'+1)
nothex:	mov dl,al
	mov ah,2
		int 0x21	; show a char
	  pop ax
	dec dh
	jnz showeaxlp	; on to the next digit

pmdone:	mov dx,crlfmsg21	; *offset*
	mov ah,9
		int 0x21

	pop ds
	pop eax
	pop dx
	ret

; -------------------------------------------------------------

hex2dec:		; take a longint eax and convert to packed BCD
	push ebx	; overflow handled (0xffffffff has 10 digits)
	push ecx
	push edx
	push edi
	xor edx,edx
	xor ecx,ecx	; shift counter
	xor edi,edi	; result
	mov ebx,10
h2dlp:	div ebx		; remainder in edx, 0..9
	shl edx,cl	; move to position
	or edi,edx	; store digit
	xor edx,edx	; make edx:eax a proper 64bit value again
	or eax,eax	; done?
	jz h2dend
	add cl,4	; next digit
	cmp cl,32	; digit possible?
	jae h2doverflow	; otherwise overflow
	jmp short h2dlp
		
h2dend:	mov eax,edi	; return packed BCD
	pop edi
	pop edx
	pop ecx
	pop ebx
	ret

h2doverflow:
	mov edi,0x99999999
	jmp short h2dend

; -------------------------------------------------------------

doxmscall:		; do an XMS call, with error handling
	mov [cs:xmswhat],ah	; for the error message
	call far [cs:xmsptr]
	or ax,ax
	jz xmserror		; ax=1 if ok
	clc			; ok
xmsdone:
	ret
xmserror:			; ax was 0, error code in BL
	push ax
	push si
	mov al,bl		; error code
	mov ah,[cs:xmswhat]	; verbose :-)
		mov si,xmserrmsg+0x2000	; *offset*, show message and AL
		call pmessage
	pop si
	pop ax
	stc		; error
	jmp short xmsdone

; -------------------------------------------------------------

%ifdef STANDALONE
yesmsg	db "LBAcache unloader by Eric Auer: 2001-2002",13,10
	db "If you give me an U(nload) on the command line",13,10
	db "I will unload any HDCACHE driver I can find",13,10
	db "And if you give me an I(nfo), I will only show info",13,10

	db "To flush drives A..F, give me an F(lush) command.",13,10

	db "This will only work on a 386, as *cache does."
%endif

crlfmsg21	db 13,10,"$",0

flushmsg	db "Flush mode - all other options ignored",13,10,"$",0
flushedmsg	db 13,10
		db "If there was a lbacache, it is now flushed",13,10
		db "for drives A..F (also tried to eject media)",13,10,"$"

noxmsmsg	db "XMS driver not found, not searching for caches. $"
yesxmsmsg	db "Starting to scan for HDCACHE - XMS pointer is $"
curri13msg	db "Int 0x13 vector found to be $"

keymsg		db "Scanning for further instances...$"
donemsg		db "Scan for cache instances completed, exiting.$"

foundmsg	db "Found signature at segment   $"
xmsmsg		db "Driver XMS handle is number  $"
xmsinfomsg	db "XMS handle has hex size (kB) $"

infolist	dw 0x24,rhitmsg+0x8000,0x28,rmissmsg+0x8000
		dw 0x2c,whitmsg+0x8000,0x30,wmissmsg+0x8000
		dw 0x34,tabinf1+0x4000,0x36,tabinf2+0x4000
		dw 0x38,sectmsg+0x4000,0x3a,oldi13msg+0x8000
		dw 0,0
		
rhitmsg		db "read  hits:   $"
rmissmsg	db "read  misses: $"
whitmsg		db "write hits:   $"
wmissmsg	db "write misses: $"
tabinf2 	db "table shr.sz: $"
tabinf1 	db "table offset: $"
sectmsg		db "number of sectors cached: $"
oldi13msg	db "stored  int 0x13  vector: $"

hrdmsg		db "***** reads  (decimal, in 1000s): $"
hwrmsg		db "***** writes (decimal, in 1000s): $"
hhitmsg		db "***** percentage of hits  (dec.): $"


unhookmsg	db "Int 0x13 vector is now again $"
nocommsg	db "LBAcache.SYS: cannot free DOS memory.$"
comsegmsg	db "LBAcache.COM: com PSP at segment $"
reducemsg	db "Reducing MCB to size (in paragraphs) $"
mcbfailmsg	db "MCB operation failed, trying UMB variant$"

xmserrmsg	db "XMS problem, function.error: $"
xmsptr		dd 0	; pointer to the XMS handler
xmswhat		db 0	; function code

unflag		db 0	; what to do:   1:unload 2:info 4:flush
currint13	dd 0	; current value of int 0x13 vector

