{===========================================================================
||  FreeDOS Keyb  2.0                                                     ||
||  (Prototype 1 - 3.January.2003)                                        ||
|| ---------------------------------------------------------------------- ||
||  Open Source keyboard driver for DOS                                   ||
||  License:       GNU-GPL 2.0  (see copying.txt)                         ||
||  Platform:      DOS v.1.0 or later                                     ||
||                 PC XT/AT with keyboard interface at int9h/int15h       ||
||  Compiler:      Borland Turbo Pascal 7.0                               ||
|| ---------------------------------------------------------------------- ||
|| (C) Aitor SANTAMARIA MERINO                                            ||
|| (aitor.sm@wanadoo.es)                                                  ||
|| ---------------------------------------------------------------------- ||
|| Contributions:                                                         ||
||   - Dietmar  HOEHMANN   (Xkeyb API and some basic code)                ||
||   - Matthias PAUL       (reboot and flush cache code, general help)    ||
||   - Axel     FRINKE     (header of int15h, general help and ideas)     ||
===========================================================================}


{------------------------------------------------------------------------
---- BEGIN FreeDOS xKEYB 1.x CODE (by A. Santamaria, D. Hhmann)    -----
------------------------------------------------------------------------}


{$A-,B-,D-,E-,F-,I-,L-,N-,O-,R-,S-,V-}
{$G+ enable 286 opcodes}
{$M $2000,0,0}

PROGRAM Keyb;

Uses Dos, ints;



Const   VerS        = '2.0 (Prototype1)';
        Version     = $0100 + 91;

        E0Prefixed  = 2;

        { keyboard commands }
        DisableKeyboard = $AD;
        EnableKeyboard  = $AE;

        { keyboard signals }
        AckSignal    = $FA;
        NakSignal    = $FE;


Procedure Data; Forward;

Type   BuffEntTyp  = Record                 { Type of the entries in key buffer. }
                     Case Byte of
                        0:(Ascii,Scan : Byte);
                        1:(Entire : Word);
                     End;
       XBufferTyp  = Array[0..63] of BuffEntTyp;
       ActionTyp   = (Install,Uninstall,OverLoad,GetInfo,WrongVers,OtherDrv,FastHlp);
       PtrTyp      = Record Ofs,Seg:Word End;
       TransTabTyp = Array[1..256,0..5] of Byte;  {127 scancodes, E0+127 scancodes}
       PtrRec = Record
                    Ofs,Seg : Word;
                End;
       XFuncTyp    = Record
                        Stat : Byte;
                        Case Byte of
                           0 : (Adr : Pointer);
                           1 : (Proc : Procedure(W : Word));
                     End;

{ ========== Following constants are building the fast access DS ========== }
Const  ScanCode    : Byte = 0;
       NCS         : Boolean = False;
       Loop        : Byte = 0;
{ The 5 following variables are eventually be read from the 2nd copy of XKeyb and modified. }
       ShiftKeys   : Array[0..7] of Byte = (0,0,0,0,0,0,0,0);   { ScanCodes of Shift keys. }
       LastXStr    : Byte = 0;              { Number of the last defined XString. }
       TransTable  : ^TransTabTyp = Nil;    { Pointer to translation table. }
{$IFNDEF KBDRES}
       Inactive    : Boolean = False;       { Tells whether keyboard input is processed by XKeyb or by the BIOS. }
{$ELSE}
       Inactive    : Boolean = True;        { See above. }
{$ENDIF}
       FileLoaded  : Boolean = False;       { File was loaded? }
       XBuffer     : ^XBufferTyp = Nil;     { Pointer to second level buffer. }
       OldInt2Fh   : Pointer = Nil;         { Chain for multiplexer interrupt. }
       OldInt9h    : pointer = NIL;         { Chain for int9h. }
       OldInt16h   : Pointer = Nil;         { Chain for Int 16h. }
       OldInt15h   : Pointer = Nil;         { Chain for Int 15h. }

       XString     : ^String = Nil;         { Actual XString. }
       XStrPos     : Byte = 0;              { Position in XString. }
       PutXStr     : Boolean = False;       { Is XString currently being processed ? }
       Row         : Byte = 0;              { Pointer in translation table. }
       LoopRunning : Boolean = False;       { End of pause mode is already waited for. }
       XBufferHead : Word = 0;              { Pointer to next char and next }
       XBufferTail : Word = 0;              { free entry in second level key buffer. }
       AltInput    : Byte = 0;              { Char entered by Alt and numberkeys. }
       SnapKey     : Boolean = False;       { MultiplexHandler waits for key. }
       SnapedKey   : Byte = 0;              { Ascii-Value of key. }
       FuncPtr     : Byte = 0;              { Number of waiting fuction calls. }
       CombStat    : Word = 0;              { Status of char combination. 0=No combination signs in work. }
                                            { Else pointer to combination table. }
       XKeyb       : boolean = true;        { are XKeyb extensions loaded ? }
       EoDS        : Byte = 0;

Procedure FastDS;                           { Memory for fast access DS. }
Begin
   ASM
   DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0
   End;
End;


{------------------------------------------------------------------------
---- BEGIN BIOS variable segment                                    -----
------------------------------------------------------------------------}

Var    KStatusFlags1     : Byte absolute 0:$417;  { Listing active keys }
                                            { 0 : Right SHIFT pressed}
                                            { 1 : Left SHIFT  pressed}
                                            { 2 : CTRL  pressed}
                                            { 3 : ALT  pressed}
                                            { 4 : SCROLL LOCK active }
                                            { 5 : NUM LOCK active }
                                            { 6 : CAPS LOCK  active}
                                            { 7 : INSERT active}
       KStatusFlags2     : Byte absolute 0:$418;  { Currently pressed modifier keys. }
       KStatusByte1      : Byte absolute 0:$496;  { Status of right ALT and Control. }
       KStatusByte2      : Byte absolute 0:$497;  { Status of LEDs. }
       BufferStart : Word absolute 0:$480;  { Start address of key buffer. }
       BufferEnd   : Word absolute 0:$482;  { End address of key buffer. }
       BufferHead  : Word absolute 0:$41C;  { Next free char in buffer. }
       BufferTail  : Word absolute 0:$41A;  { Next char to read. }
       NoMemCheck  : Word absolute 0:$472;



{------------------------------------------------------------------------
---- BEGIN FreeDOS xKEYB 1.x CODE (by A. Santamaria, D. Hhmann)    -----
------------------------------------------------------------------------}


{ -----------------------------------------------------------------------
  Definition of a record which contains data staying resident.
  This builds the slow access DS.
  -----------------------------------------------------------------------}
Type
DR = Record                                 { All data needed after installation. }
       TransTable  : TransTabTyp;           { Maximally 128 keys + 128 extended keys }
                                            { 5 key levels (0-4): normal, shift, ctrl, alt, ctrl+alt (alt gr). }
                                            { Level 5 contains administration information for every key: }
                                            { Bits 0-2 tell, whether the key is influenced by Num, Caps or Scroll. }
                                            { Bits 3-7 tell for every level whether it's mapped to an XStr. }
       ConfigFile  : String[64];            { Name of Config file. }
       DoFuncs     : Array[1..10] of        { Functions having to be done at next INT 16. }
                     Record
                        FuncNum : Byte;
                        Case Byte of
                           0:(Stat,Scan:Byte);
                           1:(Entire:Word);
                     End;
       XStrBufSize : Word;                  { Size of buffer for xstrings. }
       XFunc       : Array[201..235] of XFuncTyp;
       CombTab     : Array[0..191] of Byte; { Table for combinated chars. }
       XStrings    : Array[0..$C8C8] of Byte;{ Up to 50K of Kbdextensions.
                                               Aitor's note: reduced from 63Kb}
End;




{ ==========================================================
  Routines for key buffer:
     Procedure StoreKey(Ascii,Scan : Byte);
     Function  BufferSpace : Word;

     + Processing of BIOS calls.
  ==========================================================}


Procedure FindXStr(XStrNum : Byte);         { Search XString and "open" for reading. }
                                            { Will be called by GetKey, }
Label Ende;                                 { if the Scancode read from the 2nd buffer was 128. }
Begin
   If XStrNum<=LastXStr Then                { Number of searched XStr may not be greater than last XStr. }
   Begin
      ASM                                   { base address of XString Table to ES:DI. }
         Mov DI,Offset Data+Offset DR.XStrings
         Push CS
         Pop ES
      End;
      While XStrNum>1 Do                    { Skip n-1 XStrs. }
      Begin
         ASM                      { Address of next XStr. }
            Mov Al,ES:[DI]
            Xor Ah,Ah
            Inc AX
            Add DI,Ax
         End;
         Dec(XStrNum);
      End;
      ASM                         { Store address in XString. }
         Mov Word Ptr XString,DI
         Mov Word Ptr XString+2,ES
         CMP Byte Ptr ES:[DI],0   { length of string = 0 ? }
         JZ  Ende                 { Then end. }
      End;
      XStrPos:=1;                           { Set actual position in XStr to 1. }
      PutXStr:=True;                        { Set flag for processing of XStr. }
                                            { All chars read from now on are from this XStr. }
   End;                                     { If number of XStr is greater than the last one, ignore it. }
Ende:
End;

Function GetKey : Word;                     { Get key from XBuffer. Lo = Ascii, Hi = Scancode. }
Label Skp1,Skp2,Skp3,Skp4;
Begin
   GetKey:=0;

   If not PutXStr Then                      { If no XStr in work, }
   ASM                            { get key from XBuffer. }
      Mov AX,XBufferTail
      Shl Ax,1
      Les DI,XBuffer
      Add Di,Ax                   { Address of next key. }
      Mov Ax,ES:[DI]              { Read key. }
      Cmp Ah,$FF
      Jne Skp1
      Push Ax
      Call FindXStr               { Scancode 128 -> Key mapped to XString -> Search and "open" XStr. }
      Jmp Skp2
Skp1: pop dx
      Mov [BP-2],Ax
Skp2:
      Mov AX,XBufferTail
      Inc Ax
      And Ax,63
      Mov XBufferTail,Ax          { Pointer to next entry. }
   End;

   If PutXStr Then                          { XStr in process. !No ELSE to the IF above, }
   Begin                                    { as PutXStr possibly was set only above! }
      ASM
         Mov Al,XStrPos
         Xor Ah,AH
         Mov Di,Ax
         Add Di,Word Ptr XString
         Mov Ax,[DI]              { Next 2 Bytes from XString. }
         Inc XStrPos
         Cmp AL,0
         JZ  Skp3                 { 1st char >0 ? }
         Xor AH,AH                { -> ASCII only, no Scancode. }
         Jmp Skp4

Skp3:    Inc XStrPos              { Else return Scancode, increase pointer by 2. }
Skp4:    Mov [BP-2],AX
      End;
      PutXStr:=XStrPos<=Length(XString^);   { End of XString ? -> PutXStr = False. }
   End;
End;



{------------------------------------------------------------------------
---- BEGIN Cache Flush code (by M. Paul)                            -----
------------------------------------------------------------------------}

(* Last edit: 2001-06-18 MPAUL
;
; - Taken from Axel C. Frinkes & Matthias Pauls FreeKEYB sources
;   with some modifications to possibly work as a drop-in replacement
;   in 4DOS.
; - While the implied actions are different for SMARTDRV 4.0+
;   and NWCACHE 1.00+, the result is the same for both of
;   them - the cache will be flushed unconditionally.
; - Works around a problem with DBLSPACE loaded, where DBLSPACE
;   may terminate the current process with an error message, that
;   it would not be compatible with SMARTDRV before 4.10+.
; - Works around a problem, where the cache would not be flushed
;   with NWCACHE 1.00+, if the CX register accidently happened
;   to be 0EDCh.
; - Is enabled to continue to work with future issues of NWCACHE,
;   which might no longer flush the cache just on calling
;   SMARTDRV's install check...
; - Supports NetWare Lite's NLCACHE and Personal NetWare's
;   NWCACHE sideband API to asynchronously flush the cache.
;   This ensures system integrity even when the NetWare Lite or
;   Personal NetWare SERVER is loaded on the machine.
; - Furthermore, under some conditions on pre-386 machines
;   NWCACHE cannot intercept a reboot broadcast by itself, and
;   hence it must be called explicitely before a possible reboot.  *)

procedure FlushCache; assembler;
label FlushNLCACHE, NLCACHE_callf, NLCACHE_farentry, NLCACHE_reentry,
      FlushSMARTDRV, FlushCacheForce, FlushCacheExit;
asm
FlushNLCACHE:
        mov     ax,0D8C0h       { NLCACHE/NWCACHE install check  }
        mov     cl,ah           { (sanity check: preset CL >= 10h) }
        push    cs              { (preset to ourselves for safety) }
        pop     es              
        mov     di,offset NLCACHE_farentry
        int     2Fh             { (NLCACHE/NWCACHE modify AL,CL,DX,DI,ES)}

        cmp     ax,0D8FFh       { cache installed? (AL = FFh)             }
         jne    FlushSMARTDRV   

        cmp     cl,al           { CL=FFh? (workaround for NWCACHE before  }
         je     NLCACHE_callf   { BETA 17 1993-09-28, CL=FFh,00h,01h)     }
        cmp     cl,10h          { (sanity check: CL < 10h on return,      }
         jae    FlushSMARTDRV   { only CL=01h,02h,03h are defined so far) }

NLCACHE_callf:
        xor     bx,bx           { BX=0: asynch. flush request from server }
        push    cs              { push return address on stack            }
        mov     ax,offset NLCACHE_reentry
        push    ax              
        push    es              { push ES:DI -> entry point into far API  }
        push    di              
        clc                     { assume pure cache                       }
NLCACHE_farentry:               { (dummy entry point)                     }
        retf                    { simulate a CALLF into sideband function }

NLCACHE_reentry:                { return from sideband (AX/flags modified)}
         jc     FlushNLCACHE    { if error retry because still dirty cache}
        test    ax,ax           { CF clear and AX=0000h?                  }
         jnz    FlushNLCACHE    { if not, retry until everything is OK    }

(*NLCACHE/NWCACHE is pure now, so it would be safe to exit here.
; However, it doesn't harm to play it extra safe and
; just fall through into the normal SMARTDRV flush sequence...
; Who knows, multiple caches might be loaded at the same time...  *)

FlushSMARTDRV:
        mov     ax,4A10h        { SMARTDRV 4.00+ API                      }
        xor     bx,bx           { install check (BX=0)                    }
        mov     cx,0EBABh       { mimic SMARTDRV 4.10+ (CX=EBABh)         }
                                { to workaround DBLSPACE problem.         }
                                { CX<>0EDCh to avoid NWCACHE's /FLUSH:OFF }
                                { special case! Flush regardless          }
                                { of NWCACHE's configuration setting.     }
        int     2Fh             { (modifies AX,BX,CX,DX,DI,SI,BP,DS;ES?)  }
                                { NWCACHE 1.xx has flushed its buffers    }
                                { now, but we should not rely on this.    }
        cmp     ax,6756h        { NWCACHE 1.00+ magic return?             }
         je     FlushCacheForce {  (extra-safe for future NWCACHE 2.00+)  }
        cmp     ax,0BABEh       { SMARTDRV 4.0+ magic return?             }
         jne    FlushCacheExit  {  nothing we can do                      }
         jcxz   FlushCacheExit  { any dirty cache elements?               }
FlushCacheForce:
        mov     cx,ax           { CX<>0EDCh to avoid NWCACHE special case,}
                                { hence we preset with magic return for   }
                                { possible future broadcast expansion.    }
        mov     ax,4A10h        { SMARTDRV 4.00+ API                      }
        mov     bx,0001h        { force synchronous cache flush           }
        push    cx              
        int     2Fh             { (modifies BP???)                        }
        pop     cx              { (safety only, not necessary)            }
        cmp     cx,6756h        { retry for any cache but NWCACHE         }
        jne    FlushSMARTDRV    { probably obsolete, but safer            }
                                { at the risk of a possible deadlock in   }
                                { case some hyphothetical SMARTDRV        }
                                { clone would not support the CX return   }
FlushCacheExit:
end;

{------------------------------------------------------------------------
---- BEGIN Suspend / ShutDown functions (A. Santamaria_Merino)      -----
------------------------------------------------------------------------}


procedure ForceAPM1_1; assembler;
label ende;
asm
     MOV AX, $5301      {Real Mode interface connect}
     XOR BX, BX
     INT $15

     MOV AX, $530F      {Engage power management}
     MOV BX, 1
     MOV CX, BX
     INT $15

     MOV AX, $5308      {Enable APM for all devices}
     MOV BX, 1
     MOV CX, BX
     INT $15

     MOV AX, $530E      {force version 1.1}
     XOR BX, BX
     MOV CX, $0101
     INT $15
end;



procedure SwitchOff; assembler;
asm
     CALL ForceAPM1_1

     MOV AX, $5307              {First attempt: switch all off}
     MOV BX, 1
     MOV CX, 3
     INT $15

     MOV AX, $5307              {Second attempt: system bios}
     XOR BX, BX
     MOV CX, 3
     INT $15
end;



procedure suspend; assembler;
asm
     CALL ForceAPM1_1

     MOV AX, $5307
     MOV BX, 1
     MOV CX, 2
     INT 15
end;


{------------------------------------------------------------------------
---- BEGIN FreeDOS xKEYB 1.x CODE (by A. Santamaria, D. Hhmann)    -----
------------------------------------------------------------------------}


Procedure EfStoreKey(A,S : Byte); assembler;  { effectively store key in XBuffer. }
label
     Skp1;
asm
            Mov Ax,XBufferHead
            Shl Ax,1
            LES DI,XBuffer
            Add DI,Ax             { Address of next free space in buffer. }
            Mov Ah,S              { Scancode. }
            Mov Al,A              { ASCII-Value. }
            Mov ES:[DI],Ax        { Enter in buffer. }

            Mov Ax,XBufferHead    { Move pointer to buffer end. }
            Inc Ax
            And Ax,63

            Cmp Ax,XBufferTail    { Buffer overflow ? }
            JE  Skp1              { Then discard key and do not change XBufferHead. }
            Mov XBufferHead,Ax
Skp1:
end;


procedure DefXFunction (XFN: byte);   { default X function }
begin
    case XFN of
               {246: RESERVED}
               247 : Inline($CD/$19);          { OS/2: Close DOS Box. (int 19h) }
               {248: RESERVED}
{TESTING ONLY   248:  EfStoreKey (ord('A'),0);}
               249 : begin
                         XBufferTail := XBufferHead;
                         BufferTail  := BufferHead;
                         Inline($CD/$1B);          { Break.  (int 1Bh)}
                     end;
(*               250 : Inactive:=True;           { XKeyb off. BIOS takes over. } *)
               251 : Begin                     { Suspend}
                         FlushCache;
                         Suspend
                      end;
               252 : Begin                     { Switch the PC off }
                         FlushCache;
                         SwitchOff
                     end;
               253 : Begin                     { Cold Reboot }
                         FlushCache;
                         NoMemCheck := 0;
                         Inline($ea/0/0/$FF/$FF);  { JMP FFFF:0000 -> Reset. }
                     end;
               254 : Inline($CD/5);            { Print Screen (INT 5h) }
               255 : Begin                     { XF255: Warm Reboot }
                         FlushCache;                
                         NoMemCheck:=$1234;
                         Inline($ea/0/0/$FF/$FF);  { JMP FFFF:0000 -> Reset. }
                     End;
    end;
end;


procedure XFunction (XFN: byte);
begin
Case XFN of
201..235: {*** USER DEFINED XFunctions ****}
   With DR(@Data^) Do                       { Function call. }
   Begin
      Case XFunc[XFN].Stat of
         $80 : If FuncPtr<10 Then
               Begin
                  Inc(FuncPtr);
                  Asm
                     Xor Ax,Ax
                     Mov Es,Ax
                     Mov BL,ES:KStatusFlags1      { Get key status. }
                     Push CS
                     Pop ES
                     Mov DI,Offset Data+Offset DR.DoFuncs
                     Mov Al,FuncPtr
                     Dec Al
                     Mov Ah,3
                     Mul Ah
                     Add DI,Ax              { Address of entry in DoFuncs. }
                     Mov Al,XFN
                     Mov ES:[DI],Al         { Function number. }
                     Mov ES:[DI+1],Bl       { key status. }
                     Mov Al,Scancode
                     Mov ES:[DI+2],Al       { ScanCode. }
                  End;
               End;
         $81 : XFunc[XFN].Proc(ScanCode*256+KStatusFlags1);
         $82 : Word(XFunc[XFN].Adr^):=ScanCode*256+KStatusFlags1;
      End;
   End;
246..255: DefXFunction (XFN)
end; {case}
end;

{------------------------------------------------------------------------
---- BEGIN FreeDOS KEYB 2 CODE (by A. Santamaria)                   -----
------------------------------------------------------------------------}


function TranslateScanCode (s: byte): byte;
begin
     case s of
              2..13 :  if (KStatusFlags1 AND 8)>0 { upper numeric keys, with Alt changes s }
                         then s := s+118;
              55    :  if (KStatusFlags1 AND 4)>0 { ^Print }
                         then s := 114;
              59..68:  { F1..F10 }
                       if (KStatusFlags1 and 8)>0 then S:=s+45           {Lalt or Ralt}
                       else if (KStatusFlags1 and 4)>0 then S:=s+35      {ctrl}
                       else if (KStatusFlags1 and 3)>0 then S:=s+25;     {Lshift and RShift}
              71..83:  { ^NumericPAD }
                       If ((KStatusFlags1 and $C) = 4) then
                       Case S of
                                71 : S:=119;         { ^Home. }
                                72 : S:=141;         { ^Cursor Up }
                                73 : S:=132;         { ^Pg Up. }
                                75 : S:=115;         { ^Cursor left. }
                                76 : S:=143;         { ^numericPad 5 }
                                77 : S:=116;         { ^Cursor right. }
                                79 : S:=117;         { ^End. }
                                80 : S:=145;         { ^Cursor Down }
                                81 : S:=118;         { ^Pg Down. }
                                82 : S:=146;         { ^Ins      }
                                83 : S:=147;         { ^Del }
                       End;
              87..88:  { F11, F12 }
                       if (KStatusFlags1 and 8)>0 then S:=s+52           {Lalt or Ralt}
                       else if (KStatusFlags1 and 4)>0 then S:=s+50      {ctrl}
                       else if (KStatusFlags1 and 3)>0 then S:=s+48      {Lshift and RShift}
                       else s:=s+46;
     end;
     TranslateScancode := s
end;


{------------------------------------------------------------------------
---- BEGIN FreeDOS xKEYB 1.x CODE (by A. Santamaria, D. Hhmann)    -----
------------------------------------------------------------------------}


Procedure StoreKey(A,S : Byte);             { General processing of ASCII,Scancode }
Begin

      s := TranslateScanCode (s);

{ ********** E0-prefixed keys ********** }
   if (KStatusByte1 AND E0Prefixed)>0 then begin
       if A=0 then A := $E0
              else S := $E0
   end;

{============== Continue with Scancode/ASCII processing ============= }

   If SnapKey Then                          { Does Program interface wait for a key? }
   Begin
      SnapKey:=False;                       { Key goes to PI. }
      SnapedKey:=A;
   End
   Else
   If (KStatusFlags2 and 8)=8 Then               { Pause ? }
   ASM                                      { Then end Pause. }
      Mov AL,ES:[Offset KStatusFlags2]           { ES still remains from the check for 0000! }
      And AL,$F7
      Mov ES:[Offset KStatusFlags2],AL
   End
   Else                                     { Else store pressed key. }
       EfStoreKey (A,S);
End;


Function BufferSpace : Byte;                { Calculate free space in buffer. (first level) }
Label Skp1;
Begin
   ASM
      Xor Ax,Ax
      Mov Es,Ax
      Mov AX,ES:BufferEnd
      Sub AX,ES:BufferStart                 { Buffer size in Byte. }
      Mov BX,ES:BufferHead
      Sub Bx,ES:BufferTail                  { Number of Bytes in buffer. }
      JNC Skp1                              { If BX negative, -BX is the free space! }
      Xor Ax,Ax
Skp1: Sub Ax,Bx                             { AX = Free Bytes. }
      Shr Ax,1                              { AX = Free Entrys. }
      Dec AX                                { One entry stays emptys for administration. }
      Mov [BP-1],AL
   End;
End;

Procedure MoveKeys;
{ This routine fills the BIOS key buffer }
{ from the second level buffer. Other ones are fetching them. }
Label Lop1,EoL1,Skp1;
Begin
   ASM
      CLI
      Call BufferSpace
Lop1:    Or Al,Al
         JZ EoL1                  { Loop maximally until AL=0. }
         Mov Bx,XBufferHead
         Cmp Bx,XBufferTail       { If XBuffer empty }
         JNE Skp1
         CMP PutXStr,0            { and no XStr in process }
         JZ  EoL1                 { then end of loop. }
Skp1:
         Push Ax                  { Store counter in AL. }
         Call GetKey              { Get key. }
         Xor Si,Si
         Mov Es,Si
         Mov DI,ES:BufferHead     { Pointer to end of buffer. }
         Mov ES:[DI+$400],AX      { Key in [40:BufferHead]. }
         Pop Ax
         Dec Al                   { Free Space -1. }

         Add Di,2                 { Pointer to next entry. }
         Cmp DI,ES:BufferEnd      { Reached end of buffer ? }
         Mov ES:BufferHead,DI
         Jne Lop1                 { No -> Proceed in Text. }

         Mov DI,ES:BufferStart    { Pointer back to start. }
         Mov ES:BufferHead,DI
         Jmp Lop1                 { Next loop iteration. }

EoL1:
   End;
End;


Procedure Int16Handler;
Label Skp1,Lop1,EoL1;
Begin
   ASM
      PushA
      Push DS
      Push CS
      Pop  DS
      Push ES
      STI
   End;
   For Loop:=1 To FuncPtr Do
      With DR(@Data^),DoFuncs[Loop] Do
         XFunc[FuncNum].Proc(Entire);
   FuncPtr:=0;
   MoveKeys;
   ASM
      Pop  ES
      Pop  DS
      PopA
      Leave
      JMP CS:OldInt16h
   End;
End;


{------------------------------------------------------------------------
---- BEGIN FreeDOS KEYB 2 CODE (by A. Santamaria)                   -----
------------------------------------------------------------------------}


procedure MultiplexHandler; assembler;
label our;
asm
      CMP  AX, $AD80
      JE   Our
      JMP  CS:[OldInt2Fh]
Our:
      Mov AL,$FF                  { -> Keyboard driver installed. }
      Mov CX,$584B                { Mark for Xkeyb. }
      Mov BX,Version              { Version number. }
      Mov DX,Seg Data             { Address of the data block. }
      Mov ES,DX
      Mov DI,Offset Data
      Mov DX,$4448                { Mark for Xkeyb. }
      Mov SI,$5053                { Mark for Xkeyb. }
      IRET
end;


{------------------------------------------------------------------------
---- BEGIN FreeDOS xKEYB 1.x CODE (by A. Santamaria, D. Hhmann)    -----
------------------------------------------------------------------------}

(****
Procedure MultiplexHandler;
{ Handler for multiplexer interrupt. Hereby we get the state of installation. }

Label InsCheck,SetKeyTrans,GetKeyTrans,WaitForKeyHit,PutKey,
      SetX,GetX,SetFunc,ClearFunc,SetMap,SetTable,GetTable,
      GetCombTab,GetShiftTab,
      Distr,Ende,Next,Skp1,Skp2,Skp3,Skp4,Skp5,Skp6,Skp7,Skp8,
      Lop1,Lop2,Lop3,Lop4,Lop5,EoL1,EoL2,EoL3,EoL4;
Begin
   ASM
      Push BP
      Push DS                     { Store DS and set to CS. }
      Push CS
      Pop  DS

      CMP AX,$AD80                { Is XKeyb called? }
      JB  Next                    { (XKeyb occupies the function region AD80 - AD9C.) }
      CMP AX,$AD9B
      JA  Next                    { No -> Proceed in chain. }
      CMP AX,$AD92                { functions 92 and 93 not implemented! }
      JE  Next
      CMP AX,$AD93
      JE  Next
      CMP AX,$AD83                { functions 83..8F not implemented! }
      JB  Distr
      CMP AX,$AD90
      JB  Next

{ XKEYB Distributor }
Distr:
      CMP AL,$80                  { AD80 -> Installation Check. }
      JE InsCheck
      CMP AL,$81                  { AD81 -> Set Code Page (Dummy). }
      JNE Skp1
      Mov Ax,0
      CLC
      Jmp Ende
Skp1: CMP AL,$82                  { AD82 -> Set keyboard mapping. }
      JE  SetMap
      CMP AL,$90
      JE  SetKeyTrans             { AD90 -> Set key translation. }
      CMP AL,$91
      JE  GetKeyTrans             { AD91 -> Read key translation. }
      CMP AL,$94
      JE  WaitForKeyHit           { AD94 -> Wait for key hit and return key data. }
      CMP AL,$95
      JE  PutKey                  { AD95 -> Store key into second level buffer. }
      CMP AL,$96
      JE  SetX                    { AD96 -> Set expansion string. }
      CMP AL,$97
      JE  GetX                    { AD97 -> Read expansion string. }
      CMP AL,$98
      JE  SetFunc                 { AD98 -> Assign function. }
      CMP AL,$99
      JE  ClearFunc               { AD99 -> Cancel function assignment. }
      CMP AL,$9A
      JE  SetTable                { AD9A -> Set address of keyboard translation table. }
      CMP AL,$9B
      JE  GetTable                { AD9B -> Read address of keyboard translation table. }
      CMP AL,$9C
      JNE Skp2
      Mov Ax,0                    { AD9C -> Get number of last defined expansion string. }
      Mov BL,LastXStr
      JMP Ende
Skp2: CMP AL,9Dh
      JE  GetCombTab              { Read address of the combination table. }
      CMP Al,9Eh
      JE  GetShiftTab             { Read address of the Shift-List. }
      Mov Ax,10                   { Error 10 -> unknown function. }
      JMP Ende

InsCheck:
      Mov AL,$FF                  { -> Keyboard driver installed. }
      Mov CX,$584B                { Mark for Xkeyb. }
      Mov BX,Version              { Version number. }
      Mov DX,Seg Data             { Address of the data block. }
      Mov ES,DX
      Mov DI,Offset Data
      Mov DX,$4448                { Mark for Xkeyb. }
      Mov SI,$5053                { Mark for Xkeyb. }
      Jmp Ende

SetMap:                           { BL=0 -> BIOS.  BL=FF -> XKeyb. }
      Mov Ax,9
      STC
      INC BL                      { Result has to be 0 or 1! }
      CMP BL,1
      JA  Ende                    { Else error 9 -> Illegal mapping code. }
      Mov Inactive,BL             { 0 (False) -> XKeyb, 1 (True) -> BIOS. }
      Mov Ax,0
      CLC
      JMP Ende

SetKeyTrans:
      Mov Ax,4
      Dec DI                      { Result needs to be smaller than 255}
      CMP DI,255
      JA  Ende                    { Else error 4 -> Illegal key number}
      Shl DI,1
      Mov Ax,Di
      Shl Di,1
      Add Ax,Di                   { (Key number-1)*6 -> Offset for translation table! }
      LES DI,TransTable           { Base of translation table. }
      Add DI,Ax                   { Address of the entry to modify. }
      Mov ES:[DI],BL              { Normal mapping. }
      Inc DI
      Mov ES:[DI],CH              { With Shift. }
      Inc DI
      Mov ES:[DI],CL              { With Control. }
      Inc DI
      Mov ES:[DI],DH              { With Alt. }
      Inc DI
      Mov ES:[DI],DL              { With Alt Gr. }
      Inc DI
      Mov ES:[DI],BH              { Status byte. }
      Mov Ax,0
      Jmp Ende

GetKeyTrans:
      Mov Ax,4
      Dec DI
      CMP DI,255
      JA  Ende                    { Error if key number 0 or >255. }
      Shl DI,1
      Mov Ax,Di
      Shl Di,1
      Add Ax,Di
      LES DI,TransTable
      Add DI,Ax                   { Address of entry in the table. }     
      Mov BL,ES:[DI]              { Read all entries. }
      Inc DI
      Mov CH,ES:[DI]
      Inc DI
      Mov CL,ES:[DI]
      Inc DI
      Mov DH,ES:[DI]
      Inc DI
      Mov DL,ES:[DI]
      Inc DI
      Mov BH,ES:[DI]
      Mov Ax,0
      Jmp Ende

WaitForKeyHit:
      Mov SnapKey,True            { -> Program interface is waiting for a key. }
      STI                         { Enable interrupts. }
Lop1: CMP SnapKey,True            { Wait until key press.}
      JE  Lop1
      CLI                         { Please do not disturb.}
      Mov Ah,ScanCode             { Read virtual scancode. }
      Mov Al,SnapedKey            { ASCII Value of key. }
      Mov Bh,ScanCode             { Physical Scancode. }
      Xor Cx,Cx
      Mov Es,CX
      Mov Bl,ES:[Offset KStatusFlags1]  { Keyboard status. }
      Mov Dh,Row                  { Key level -> 0=Normal, 1=Shift, 2=Control, 3=Alt, 4=Alt Gr. }
      Mov Cx,Version              { Version number. }
      Jmp Ende

PutKey:
      Mov CX,XBufferHead          { Remember BufferHead. }
      Push CX
      Push BX                     { BL=ASCII Value. }
      Mov  BL,BH                  { BH=Scancode (virtual). }
      Push BX
      Call StoreKey               { store it. }
      Xor Ax,Ax
      Pop CX
      Cmp Cx,XBufferHead          { Did BufferHead change? }
      Jne Ende                    { Yes -> ok. }
      Mov Ax,5                    { No -> Error 5: Buffer full. }
      Jmp Ende

SetX:
      Mov Ax,1
      Dec Bl
      Cmp Bl,199
      JA  Ende                    { XStr number has to be between 1 and 200! }

      Inc Bl                      { Restore XStr Number. }
      Mov Bp,Offset Data
      Xor Si,Si
      Cmp Bl,LastXStr             { Is XStr Number greater than that of last one? }
      JBE Skp3

         Mov BH,1                 { Yes -> We need to create some empty strings. }
Lop2:       Cmp BH,LastXStr       { Calculate pointer BEHIND last XStr. }
            JA  EoL3
            Mov Al,Byte Ptr CS:[SI+BP+Offset DR.XStrings] { Length of XStr. }
            Xor AH,AH
            Add Si,Ax             { Add length to SI. }
            Inc SI                { SI+1 -> because of length byte! }
            Inc BH
            Jmp Lop2
EoL3:
         Xor Ch,Ch
         Mov CL,BL
         Sub Cl,LastXStr          { CX = Number of empty strings to create. }
         Mov Ax,2
         Push Cx                  { Save. }
         Add Cx,Si                { SI = Pointer behind LastXStr. }
         Cmp Cx,Word Ptr CS:[BP+ Offset DR.XStrBufSize]  { Do the empty strings still fit into the buffer? }
         Pop CX
         JA  Ende                 { No -> Error 2: Buffer full. }

         Xor Ax,Ax
         CLD                      { Direction: forward (inc). }
         Push Di                  { Store ES:DI. }
         Push ES
         Push CX                  { Store CX. }
         Push CS
         Pop ES                   { ES = Segment address of buffer. }
         Mov Di,Si                { DI = Address behind LastXStr relatively to start of buffer. }
         Add Di,BP                { + Offset address of  Data region. }
         Add Di,Offset DR.XStrings{ + Offset address of buffer in the record. }
         Rep Stosb                { Create CX empty strings. }
         Pop CX                   { Restore CX and ES:DI. }
         Pop ES
         Pop DI

         Push Cx
         Add CL,LastXStr
         Mov LastXStr,CL          { Correct LastXStr. }
         Pop Cx

         Add Si,Cx                { SI contains Address of XString to define. }
         Mov Cx,Si                { CX points behind LastXStr. Both relates to the start of the buffer! }
         Dec Si
         Jmp Skp4

{ The ELSE-branch, if XStr number <= LastXStr. }
Skp3:
         Mov BH,1
         Mov AX,SI                { SI points to first XStr. (contains 0.) }
Lop3:       CMP BH,LastXStr       { Calculate pointer behind last XStr and pointer to the searched XStr. }
            JA  EoL4
            CMP BL,BH
            DB  $75,2             { If BL<>BH skip next command. }
            Mov Ax,SI             { Else store address of searched XStr. }
            Mov Dl,CS:[SI+BP+Offset DR.XStrings]
            Xor Dh,Dh
            Add Si,Dx
            Inc SI
            Inc BH
            Jmp Lop3

EoL4:    Mov CX,SI                { As above! CX points behind everything, Si to the searched string.}
         Mov Si,AX

Skp4:                             { We continue with the values calculated by one of the IF branches. }
      Mov DL,ES:[DI]              { Length of XStr to enter. }
      Xor Dh,Dh
      Mov Al,CS:[SI+BP+Offset DR.XStrings] { Length of present XStr. }
      Xor Ah,Ah
      Sub Dx,Ax                   { DX: needed shifting BACKWARDS in Bytes. May be negative. }
      JZ Skp5                     { Same string length? Then skip shifting. }

         Push CX
         Add Cx,Dx                { Is the shifting possible? }
         Mov Ax,2
         Dec Cx
         Cmp CX,CS:[BP+Offset DR.XStrBufSize]
         Pop CX
         JA  Ende                 { Sorry. Not enough buffer space. }

         Mov AX,SI
         Add Al,CS:[BP+SI+Offset DR.XStrings]
         Adc AH,0
         Inc Ax                   { Pointer behind the string to insert. }
         Mov Bx,Cx
         Sub Bx,Ax                { Number of Bytes to copy. }
         Jz  Skp5                 { None? Bye... }

         Push Dx
         SHL DX,1                 { Test upper bit -> is DX positive or negative? }
         Pop DX
         CLD
         JC Skp6                  { If negative copy from front to back. }

         STD                      { Else from back to front. }
         Add Ax,Bx                { Correct pointer: From first byte to copy to the last. }
         Dec Ax                   { UPON the last, not behind! }

Skp6:    Push Es                  { Save ES:DI, will still be needed! }
         Push Di
         Push Si                  { As well as the start address of the string to set. }
         Push CS
         Pop Es                   { ES to segment address of buffer. }
         Mov DI,Ax                { ES:DI = target. }
         Add DI,DX                { target = source + shifting }
         Mov Si,Ax                { DS:SI = source }
         Mov Cx,Bx                { Number of Bytes. }
         Mov AX,Offset DR.XStrings{ Offset address of Buffer relatively to start of record }
         Add Ax,BP                { + Base address of data region }
         Add SI,AX                { add to source and target. }
         Add DI,AX
         Rep Movsb                { Just put it! }
         Pop Si                   { Restore Si,Di,Es. }
         Pop Di
         Pop Es

Skp5: Mov Cl,ES:[DI]              { Length of string to enter. }
      Xor Ch,Ch
      Mov BX,DI
      Mov DI,SI                   { DI = target offset. }
      Mov SI,BX                   { SI = source offset. }
      Add DI,BP                   { target offset + base of buffer. }
      Add DI,Offset DR.XStrings
      Mov Bx,Es
      Mov DS,Bx                   { DS = source segment. }
      Push CS
      Pop ES                      { ES = target segment. }
      CLD                         { Go ahead! }
      Inc CX                      { And don't forget the length byte! }
      Rep Movsb                   { There it goes ... }

      Xor Ax,Ax                   { Ahh. Did it :-) }
      Mov BL,LastXStr
      JMP Ende

GetX:
      Mov AX,1
      Dec Bl
      Cmp Bl,199
      JA  Ende                    { Invalid number. }

      Mov Ax,3
      Inc Bl
      Cmp Bl,LastXStr
      Ja  Ende                    { XStr is not defined. }

      Mov Si,Offset Data+Offset DR.XStrings { Offset address of buffer relatively to Segment start. }
Lop4:    Cmp BL,1                 { Search desired XStr. }
         JE  EoL1
         Mov Al,CS:[SI]
         Xor Ah,Ah
         Add Si,Ax
         Inc Si
         Dec Bl
         Jmp Lop4
EoL1:
      CLD
      Mov CL,CS:[SI]              { String length to CX. }
      Xor Ch,Ch
      Inc CX                      { + length byte. }
      Rep Movsb                   { and shovel ... }

      Xor Ax,Ax
      Mov Bl,LastXStr
      Jmp Ende

SetFunc:
      Mov BP,Offset Data+Offset DR.XFunc { Offset address of XFunction table. }
      Cmp Bl,0                    { BL=0 -> Search empty XStr. }
      JNE Skp7                    { Else use given number. }

         Mov SI,0
         Mov Ax,6
Lop5:    Cmp DS:[BP+SI+Offset XFuncTyp.Stat],Ah { Unused ? }
         JE  EoL2                 { Then end. }
         Add SI,5                 { Else next one. }
         Inc BL
         Cmp BL,40                { No more left? }
         Je  Ende                 { Oh oh. Error 4: No free XStr for functions. }
         JMP Lop5                 { Don't be tired! Go on searching! }

EoL2:    Add BL,201               { Adapt BL for caller. }
         JMP Skp8                 { SI cointains pointer into the table. }

{ Else-branch. Test if desired XStr is legal. }
Skp7:
         Mov Ax,1
         Sub BL,201
         JC  Ende                 { XStr number < 201? No way. }
         Cmp BL,34
         JA  Ende                 { After subtraction still > 34? Not possible either. }
                                  { If the XFunc is already in use, that's the user's own problem! }
         Mov Al,Bl
         Mov Ah,5
         Mul Ah                   { Every entry contains 5 Bytes. }
         Add BL,201               { Correct value. }
         Mov Si,Ax                { SI contains pointer into the table. }

Skp8:
      Mov Ax,7
      CMP BH,2                    { BH>2? That's an error. }
      JA  Ende                    { Error 2 -> Illegal calling convention. }

      Add BH,$80
      Mov DS:[BP+SI+Offset XFuncTyp.Stat],BH   { Insert all the stuff into the table. }
      Mov DS:[BP+SI+Offset XFuncTyp.Adr],Di
      Mov DS:[BP+SI+Offset XFuncTyp.Adr+2],ES
      Xor Ax,AX
      Jmp Ende

ClearFunc:
      Mov BP,Offset Data+Offset DR.XFunc
      Mov Ax,1
      Sub Bl,201
      Jc  Ende
      Cmp Bl,34
      Ja  Ende                    { Error if illegal XFunc number. }

      Mov Al,Bl
      Mov Ah,5
      Mul Ah
      Mov Si,Ax
      Mov AX,8
      Cmp DS:[BP+SI+Offset XFuncTyp.Stat],AH
      Je  Ende                    { Error if XFunc not mapped. }

      Mov DS:[BP+Si+Offset XFuncTyp.Stat],AH { Status = 0. }

      Xor Ax,AX
      Jmp Ende

SetTable:
      Mov Word Ptr TransTable,DI  { Set address of translation table. }
      Mov Word Ptr TransTable+2,ES

GetTable:
      LES DI,TransTable           { Read address of translation table. }
      Xor Ax,Ax
      Jmp Ende

GetCombTab:
      Push Cs
      Pop  Es
      Mov  Di,Offset Data+Offset DR.CombTab
      Xor  Ax,Ax
      Jmp  Ende

GetShiftTab:
      Push Cs
      Pop  Es
      Mov  Di,Offset ShiftKeys
      Xor  Ax,Ax

Ende:
      Pop DS                      { Restore DS and end of interrupt. }
      Pop BP
      IRET

Next:
      Pop DS                      { Restore DS and go to next interrupt handler. }
      Pop BP
      JMP CS:[OldInt2Fh]
   End;
End;
***)




Procedure KBDOut(B:Byte);
Label Lop1,Lop2,Ok,Err;
Begin
   ASM
Lop1: IN  AL,$64                  { Wait for readiness. }
      And AL,2
      JNZ Lop1

      Mov AL,B                    { Output byte. }
      Out $60,AL

      Xor Ax,Ax
      Mov Es,Ax
      Mov CX,$2000

Lop2: Mov Al,ES:KStatusByte2              { Wait for answer. }
      Test Al,$10
      Jnz Ok
      Test Al,$20
      Jnz Err
      Loop Lop2

Err:  Or ES:KStatusByte2,$80              { Error flag. }

Ok:   And ES:KStatusByte2,$CF             { Clear Ack & Nak. }
   End;
End;

{***********************************************************
 Translation routines.
 ***********************************************************}


{NON-WORKING PROCEDURE, CHECK IT}
procedure AltNumPadInput (scancode: byte);
var
   flag: word;
begin
   If ((KStatusFlags1 and $F) = 8 ) and ((KStatusByte1 AND E0Prefixed)=0) and           { ALT pressed? }
      (ScanCode>=$47) and (ScanCode<=$52) and
      (Scancode<>$4A) and (scancode<>$4E)   { Is key influenced by NUM? }
      Then
      Begin
        If (KStatusFlags2 and 8)=8 Then               { Pause ? }
           ASM                                        { Then end Pause. }
             Mov AL,ES:[Offset KStatusFlags2]         { ES still remains from the check for 0000! }
             And AL,$F7
             Mov ES:[Offset KStatusFlags2],AL
           End
        else begin
          {translate scancode->number}
         case Scancode of $47..$49 : Scancode := Scancode - $40;
                          $4B..$4D : Scancode := Scancode - $47;
                          $4F..$51 : Scancode := Scancode - $4E;
                          Else       Scancode := 0;
         end;
         AltInput:=AltInput*10 + ScanCode; { -> append pressed number to the existing value. }
        end;
        flag := $FFFF;
      End else
        flag := 0;

   ASM
      PUSH flag
   END;
end;



procedure PreInt15Hand;
label Ende, Skp1, Skp1_2, Skp1_4, Skp1_5, Lop2, Skp5, NoCombine, X, DefaultX,
      StartCombi, Lop3, Skp7, Store, Done, Reject, IsMakeCode;

var
   a: byte;
begin
     ASM
        PUSH BX
        PUSH CX
        PUSH DX
        PUSH DI
        PUSH SI
        PUSH DS
        PUSH ES


        {**** CS -> DS }
        PUSH CS
        POP  DS

        CMP AL, 128         { process only MakeCodes }
        JB  IsMakeCode
        CMP AL, $E0         { and E0h, extended prefix }
        JNE Reject

        { it's E0, so update LED }
        MOV CL, ES:[Offset KStatusByte1]      { CL := KStatusByte1 }
        OR  CL, E0Prefixed   { Put E0Prefixed flag }
        MOV ES:[Offset KStatusByte1], CL
        JMP Reject           { even though, let it continue processing }

IsMakeCode:       
        Mov scancode, AL

{        PUSH AX
        CALL AltNumPadInput
        POP  BX
        TEST BL, $FF
        JNZ  Done}
     END;


{The following piece is for the Alt+nnn inputs, could be rejected in some
special circumstances}

   If ((KStatusFlags1 and $F) = 8 ) and ((KStatusByte1 AND E0Prefixed)=0) and           { ALT pressed? }
      (ScanCode>=$47) and (ScanCode<=$52) and
      (Scancode<>$4A) and (scancode<>$4E)   { Is key influenced by NUM? }
      Then
      Begin
        If (KStatusFlags2 and 8)=8 Then               { Pause ? }
           ASM                                        { Then end Pause. }
             Mov AL,ES:[Offset KStatusFlags2]         { ES still remains from the check for 0000! }
             And AL,$F7
             Mov ES:[Offset KStatusFlags2],AL
           End
        else begin
          {translate scancode->number}
         case Scancode of $47..$49 : Scancode := Scancode - $40;
                          $4B..$4D : Scancode := Scancode - $47;
                          $4F..$51 : Scancode := Scancode - $4E;
                          Else       Scancode := 0;
         end;
         AltInput:=AltInput*10 + ScanCode; { -> append pressed number to the existing value. }
        end;
        goto done;
      End;


{ ********** Compute the row ********** }

   scancode := scancode + ((KStatusByte1 AND E0Prefixed) SHL 6);
        { if E0-prefixed, then scancode adds 128}

   NCS:=(( TransTable^[ScanCode,5] and      { Check, whether Num, Caps or Scroll are on }
          (KStatusFlags1 shr 4) and               { and whether the pressed key is influenced by them. }
          $7
        ) > 0);                { Extended Shift key clears NCS! }


  if (KStatusFlags1 AND $0C)=4 then row := 2   {ctrl}
  else if (KStatusFlags1 and $03)>0 then row := byte(NCS) xor 1  {shift}
  else if (KStatusFlags1 and $08)>0 then row := 3 + ord((KStatusByte1 AND $08)>0)  {alt or AltGr}
  else row := byte (NCS);
 

   
   ASM
      Mov Al,ScanCode             { ScanCode. }
      Dec Al                      { Array starts at 1. Correcting that. }
      Xor AH,AH
      SHL AX,1
      Mov BX,Ax
      Shl Ax,1
      Add Ax,Bx                   { 6 times value -> pointer in TransTable. }
      LES Di,TransTable           { Start address of table. }
      Add Di,Ax                   { Address of table entry. }
      Mov Al,ES:[DI+5]            { Read status byte. }
      Mov Bl,ScanCode
      AND BL,$7F          { disable the effect of +128 for E0-prefixed ones}

      Mov Cl,Row                  { Line. }
      Inc Cl
      Shl Al,Cl                   { The XStr-Bit corresponding to row gets shifted to Carry. }
      JNC Skp1                    { Jump if not occupied by XStr. }
      Mov BL,$FF                  { Replace scancode by signature FFh }

Skp1: Mov Cl,Row
      Xor Ch,Ch
      Add Di,CX
      Mov Al,ES:[DI]              { ASCII value or XStr number from Transtable. }

      TEST AL,AL                  { if not found, }
      JNZ  Skp1_2
      MOV  AL, BL                 { return scancode to AL }
      JMP  Reject                 { and reject it }


{------------------------------------------------------------------------
---- BEGIN FreeDOS KEYB 2.0 CODE (by Aitor Santamaria_Merino)       -----
------------------------------------------------------------------------}

{====================== WE HAVE Scan, ASCII ===========}

Skp1_2:
      CMP BL,$FF      { XOperation: XFunction, XString, COMBI or predefined}
      JE  X

{====================== PART 1: non-XOperation ========}

      CMP AL,$E0          { if ASCII=$E0k,$F0, then ScanCode=0 }
      JE  Skp1_4
      CMP AL, $F0
      JNE Skp1_5
Skp1_4:
      XOR BL,BL

Skp1_5:
      CMP CombStat, 0     { pending COMBI operation? }
      JZ  Store           { NO, store the ASCII,SCANCODE }

    {===== PART 1-1: COMBINE ==} 

      Mov Di,CombStat
      Mov CombStat,0

      Mov Si,Di
      Mov CL,DS:[DI]              { Number of chars to check. }
      Xor Ch,Ch
      Inc Di
Lop2: Cmp Al,DS:[DI]              { Found 2nd char of combination? }
      JNZ Skp5                    { No. }

      Inc Di
      Mov Al,DS:[Di]              { Replacement char. }
      XOR BX,BX                   { ScanCode should be 0 with COMBI!}
      Jmp Store

Skp5: Inc Di                      { Next entry. }
      Inc Di
      Dec Cx                      { Another candidate? }
      JNZ Lop2                    { Then go on. }

NoCombine:
      Push Ax                     { All that was a failure. }
      Push BX                     { Now throw both chars into the key buffer seperately. }
      Mov Al,DS:[Si-1]            { First char. }
      Xor Bl,Bl                   { Scancode forgotten. So we put 0. }
      Push Ax
      Push Bx
      Call StoreKey               { Store first char. }
      Call StoreKey               { Store 2nd char. }
      Jmp Done

{====================== PART 2: XOperation ========}

X:    CMP AL, 235    { >235: COMBI or predefined XFunction, always present }
      JA  DefaultX

      TEST XKeyb, $FF      { have been X extensions loaded ? }
      JZ   Done            { no, then goto end }

      {===== PART 2-1: XString or XFunction ==}

      CMP AL,201           { is AL<=200 ? }
      JB Store             { yes, it's XString, so store it! }

      PUSH AX              { XFunction }
      Call XFunction
      Jmp Done

      {===== PART 2-2: COMBI or predefined-XFunction ==}

DefaultX:
      CMP Al,246
      JB  StartCombi       { if <246, starts a COMBI sequence}

      PUSH AX              { otherwise, predefined-XFunction }
      Call DefXFunction
      Jmp Done

    {===== PART 2-1: START COMBI ==}

StartCombi:
      Mov DI,Offset Data+Offset DR.CombTab  { Test, whether char is first char of a combination. }
Lop3: Cmp Byte Ptr DS:[Di],0      { End of list? }
      Jz  Store                   { Yes. }
      Cmp Al,236                  { Is this the char? }
      JE  Skp7                    { Yes. }
      Inc Di
      Mov Cl,DS:[Di]
      Xor Ch,Ch
      Shl Cx,1
      Add Di,Cx
      Inc Di                      { Next char. }
      Dec Al
      Jmp Lop3

Skp7: Inc Di
      Mov CombStat,Di
      Jmp Done

{==================== FINAL: Store the key in AX, BX ========}

Store:
      PUSH Ax
      Push Bx
      Call StoreKey


Done:                   { final if everything was right! }
      Mov  AL, Scancode
      CLC
      JMP  Ende

Reject:                 { reject scancode, so that it continues processing }
      STC

Ende:

        POP ES
        POP DS
        POP SI
        POP DI
        POP DX
        POP CX
        POP BX



End; {ASM}
end;


{header for the new int15 handler; thanks to Axel Frinke}
procedure Int15h; assembler;
label IsFunc4F, KeyboardHandler;
asm

    PUSHF             { preserve flags! }

    CMP   AH, $4F     { is it function 4Fh? }
    JE    IsFunc4F    { check functions }
    POPF
    JMP   DWORD PTR CS:[OldInt15h]

IsFunc4F:
    CALL  DWORD PTR CS:[OldInt15h] { the old one first! }
    JC    KeyboardHandler          { if Carry clear, }
    RETF  2                        { return and preserve flags! }

KeyboardHandler:
    CALL  PreInt15Hand;            { call the old one:
                                     it will be pasted here, once all of it
                                     is turned into assembler }
    RETF  2

end;



procedure extInt9h (shiftkey: byte; isbreak: boolean);  {0..7}
var
   shiftedbit, v1, v2 : byte;
begin
    shiftedbit := 1 SHL shiftkey;
    case shiftkey of
                    0..1: {shift}
                          if isBreak then KStatusFlags1 := KStatusFlags1 XOR shiftedbit
                                     else KStatusFlags1 := KStatusFlags1 OR shiftedbit;
                    2..3: begin {ctrl,alt}
                            if (KStatusByte1 AND E0Prefixed)>0 then begin
                                if isBreak then KStatusByte1 := KStatusByte1 XOR shiftedbit
                                           else KStatusByte1 := KStatusByte1 OR shiftedbit
                            end else begin
                                shiftedbit := shiftedbit SHR 2;
                                if isBreak then KStatusFlags2 := KStatusFlags2 XOR shiftedbit
                                           else KStatusFlags2 := KStatusFlags2 OR shiftedbit
                            end;
                            v1 := (KStatusByte1 OR (KStatusFlags2 SHL 2)) AND $0C;
                            v2 := KStatusFlags1 AND $F3;
                            KStatusFlags1 := v1 OR v2;

                            if (shiftkey=3) AND isBreak AND (AltInput<>0)
                               then begin
                                 StoreKey (AltInput,0);
                                 AltInput := 0
                               end;

                          end;
                    4..6: begin  {caps, num, scroll }
                              if isBreak then KStatusFlags2 := KStatusFlags2 XOR shiftedbit
                                         else KStatusFlags2 := KStatusFlags2 OR shiftedbit;
                              if not isBreak then KStatusFlags1 := KStatusFlags1 XOR shiftedbit
                          end;
                    7   : if (KStatusFlags2 AND $0C)=0 then begin  {no ctrl, alt}
                               v1 := ord ( (KStatusFlags2 AND $03)>0 );
                               v2 := (KStatusFlags2 AND $20) SHR 5;
                               if (v1 xor v2)=0 then begin  {no shifted!}
                                  if isBreak then KStatusFlags2 := KStatusFlags2 XOR shiftedbit
                                             else KStatusFlags2 := KStatusFlags2 OR shiftedbit;
                                  if not isBreak then begin
                                      KStatusFlags1 := KStatusFlags1 XOR shiftedbit;
                                      storekey (0, 82)
                                  end;
                               end;
                          end
    end;
end;



{  DEBUG METHOD!! 
procedure StrOut (b: byte);
var s: string;
begin
asm
  PUSH AX
  PUSH BX
  PUSH CX
  PUSH DX
  PUSH DI
end;
    StoreKey (ord('='),0);
    str (b, s);
    while length(s)>0 do begin
      StoreKey (ord(s[1]),0);
      delete (s,1,1)
    end;
    StoreKey (ord('='),0);
asm
  POP DI
  POP DX
  POP CX
  POP BX
  POP AX
end
end;



{------------------------------------------------------------------------
---- BEGIN FreeDOS xKEYB 1.x CODE (by A. Santamaria, D. Hhmann)    -----
------------------------------------------------------------------------}


{$F+}
procedure Int9H; assembler;
Label
xx1,xx2,
         Start, WaitReady1, NoBreak, ShiftFound, NoPause, Ende,
         WaitReady2, LeaveInt, BIOS, BIOSEnd, WaitReady3, EndeNoE0,
         Lop1, Lop2,
         Jmp1, Jmp2, Jmp3, Jmp4, Jmp5, Jmp6;
{===================================
 Convenctions that will be tried
    AL: byte:    scancode
 ------ for the extended int9 handling only
    ES=0         segment for the BIOS variables
    BL: byte:    number of pressed shift key ( as in KStatusFlags1 )
    CL: boolean: breakcode?
===================================}
asm

        {**** Workaround for the byte 03h problem with APL }
        JMP Start
        DW 0                 { reserved for IsActive, modified by APL software}

Start:
 
        {**** save the registers }
        PUSH AX
        PUSH BX
        PUSH CX
        PUSH DX
        PUSH DI
        PUSH SI
        PUSH DS
        PUSH ES


        {**** CS -> DS }
        PUSH CS
        POP  DS

        {**** check if the driver should be active }

(*        TEST Inactive, $FF   { If Inactive GOTO BIOS}
        JNZ  BIOS *)
        CLI                  { we process it, we disable hardware ints }



        {**** Disable the keyboard }

        XOR    CX, CX       { counter to 65535! }
        MOV    ES, CX       { we annihilate ES, for the extended handling }
WaitReady1:
        IN     AL, $64      { read status register }
        TEST   AL, 2        { bit 1 set: input buffer full? }
        LOOPNZ WaitReady1   { loop until timeout or bit 1 clear }

        MOV AL, DisableKeyboard 
        OUT $64, AL         { send the disable command }


        {**** Get Scancode }

        IN AL, $60          { get scancode to AL }

        {**** Authenticate scancode}

        Mov Ah,$4F
        STC
        INT 15h             { -> Possibly external scancode translation by INT 15! }
        JNC Ende            { No further processing of pressed keys if CARRY cleared! }


{==== Extended handling============================================}
{ On Entry: AL: Scancode
            ES=0          }

        {**** Test for Ack, Nak, XKey }

        CMP AL, $E0          { E0? then jump to Ende, and there E0prefixed will be updated }
        JE  Ende
        CMP AL, AckSignal    { Acknowledge signal? }
        JNE Jmp1             
        MOV CL, $10
        JMP Jmp2
Jmp1:   CMP AL, NakSignal    { No-acknowledge signal? }
        JNE Jmp3
        MOV CL, $20
Jmp2:   OR  ES:KStatusByte2, CL   { Ack or Nak signals:  }
        JMP Ende                  { update extended keyboard state }


        {**** Determine if it's break or make code }
        { Fill CX: BreakCode? }

Jmp3:
        XOR  CX, CX          { this will store BreakCode }
        TEST AL, $80         { break or make? }
        JZ   Jmp4            { if zero -> make }
        MOV  CL,1            { breakcode}
        AND  AL, $7F         { disable the break bit}

        { ********** Test for Break ********** }

Jmp4:
        TEST CL,$FF         { if NOT breakcode }
        JNZ  NoBreak
        MOV  BL, ES:[Offset KStatusByte1]
        TEST BL, E0Prefixed { and it is Extended }
        JZ   NoBreak
        CMP  AL, 70         { scancode 70 (break) }
        JNE  NoBreak

        MOV BX, XBufferHead
        MOV XBufferTail, BX
        MOV BX, ES:[Offset BufferHead]
        MOV ES:BufferTail, BX
        INT $1B
        JMP Ende

        { ********** Scan the shifting keys ********** }


NoBreak:
        XOR BX, BX
        MOV DI, offset ShiftKeys    {scan ShiftKeys array}
Lop2:   MOV DL, DS:[DI]
        CMP DL, AL
        JE  ShiftFound
        INC DI
        INC BL
        CMP BL, 8
        JB  Lop2
        JMP Jmp5
ShiftFound:
        PUSH BX         { FOUND: call extInt9 with appropriate params }
        PUSH CX
        CALL extInt9h
        JMP  Ende

        { ********** BreakCodes are no longer processed ********** }


Jmp5:   TEST CL, $FF    { no more breakcodes processed }
        JNZ  Ende 


        { ********** Test for Pause (=Ctrl+NumLock) ********** }

        CMP BL, 5                   { IF NumLock }
        JNE NoPause
        XOR AX, AX
        MOV ES, AX
        TEST ES:KStatusFlags1, 4    { AND Control... }
        JZ  NoPause                   { then PAUSE!! }
        OR  ES:KStatusFlags2,8                  { Set pause bit. }
        JMP Ende                           { Goto final waiting loop. }


         { ********** If we reached this point, simply store with ASCII=0 ********** }

NoPause:
         XOR   BL, BL         { otherwise, StoreKey ( 0, AL) }
         PUSH  BX
         PUSH  AX
         Call  StoreKey



{ ********** ENDE: Interrupt ENDs here ********** }


Ende:

        {===== A) update the E0 flag in KStatusByte1 (0040h:0096h) ==}
        XOR CX,CX
        MOV ES,CX
        MOV CL, ES:[Offset KStatusByte1]      { CL := KStatusByte1 }
        AND CL, $FD          { Clear E0Prefixed flag }
        CMP AL, $E0          { AL=Scancode = E0h ? }
        JNE Jmp6
        OR  CL, E0Prefixed   { Put E0Prefixed flag }
Jmp6:   MOV ES:[Offset KStatusByte1], CL


        {===== B) update the BIOS buffer and run Xfunctions ==}

EndeNoE0:
        Call MoveKeys;

        {===== C) totally reenable interrupts ==}

        MOV AL, $20            { report End of Interrupt to interrupt controller }
        OUT $20, AL
        STI                    { restore interrupts }

        {===== D) Enable the keyboard ==}

        XOR    CX, CX       { counter to 65535! }
WaitReady2:
        IN     AL, $64      { read status register }
        TEST   AL, 2        { bit 1 set: input buffer full? }
        LOOPNZ WaitReady2   { loop until timeout or bit 1 clear }

        MOV AL, EnableKeyboard
        OUT $64, AL         { send the enable command }


        {===== E) Wait state if pause was pressed ==}

        MOV AL, LoopRunning        { is Pause loop running?}
        TEST AL, $FF
        JNZ LeaveInt               { yes: leave interrupt! }

        { process pause }
        MOV AL, 1                  { lock this region }
        MOV LoopRunning, AL
        XOR AX, AX                 { see Pause bit in KStatusFlags2}
        MOV ES, AX
Lop1:   TEST ES:KStatusFlags2, 8   { in Pause? then continue loop }
        JNZ Lop1
        XOR AX, AX
        MOV LoopRunning, AL        { exit locked region }


LeaveInt:
        {===== F) Leave interrupt routine ==}


        { recover registers }
        POP ES
        POP DS
        POP SI
        POP DI
        POP DX
        POP CX
        POP BX
        POP AX
   
        { exit interrupt }
        IRET

(*   EXPERIMENTAL
     NOT WORTH enabling this, as the system will change a lot
BIOS:                                  { Keyb is inactive. Key translation is done by BIOS. }

      PUSH AX
      PUSH ES

      MOV  AL, FileLoaded              { File Loaded? }
      TEST AL, $FF
      JZ   BIOSEnd

      XOR  AX, AX
      MOV  ES, AX
      MOV  AL, ES:KStatusFlags1
      CMP  AL, $0C                      { Ctrl+Alt ? }
      JNE  BIOSEnd

      {**** CHECK F2: }

      PUSH  CX

      XOR    CX, CX       { counter to 65535! }
      MOV    ES, CX       { we annihilate ES, for the extended handling }
WaitReady3:
      IN     AL, $64      { read status register }
      TEST   AL, 2        { bit 1 set: input buffer full? }
      LOOPNZ WaitReady3   { loop until timeout or bit 1 clear }

      POP    CX

      MOV AL, DisableKeyboard 
      OUT $64, AL         { send the disable command }


      {**** Get Scancode }

      IN  AL, $60          { get scancode to AL }
      CMP AL,  60          { is F2? }
      JNZ BIOSEnd
      XOR AL, AL           { YES, so ACTIVATE the driver }
      MOV Inactive, AL
      JMP EndeNoE0         { exit interrupt, no need to check E0-flag }

BIOSEnd:

      POP ES
      POP AX

      JMP OldInt9h
*)

(*
   If ((KStatusFlags1 and 12) = 12) and           { Ctrl+Alt and }
      (Port[$60]=60) and                    { F2 pressed? }
      FileLoaded Then                       { already file loaded? }
   Begin                                    { XKeyb takes over again. }
      Inactive:=False;
      asm
         MOV AL,$20
         OUT $20,AL
      end;
      Goto LeaveInt
   End;
*)
end;
{$F-}


{------------------------------------------------------------------------
---- END FreeDOS KEYB 2.0 CODE (by Aitor Santamaria_Merino)         -----
------------------------------------------------------------------------}


{***********************************************************
 The following procedure is a dummy.
 Here we store the data section during runtime.
 ( For slow access DS.)
 The final size depends on size of XStr buffer.
 ***********************************************************}

Procedure Data;                               {  about 2'75K free memory. }
Begin ASM
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
End; End;

Var    DatSeg      : ^DR;                   { Variables only needed during installation. }
       Regs        : Registers;

Procedure Keep(Ende : Pointer; Code : Byte);     { Terminate program but stay resident in memory. }
Var    Laenge      : Word;                       { !The program will stay in memory only until the given address! }
       PSPPtr      : ^Word;
Begin
   {free the environment block}
   PSPPtr := Ptr( PrefixSeg, $2C );
   asm
      MOV AX, WORD PTR PSPPtr
      MOV ES, AX
      MOV AX, $4900
      INT $21
   end;

   {callculate size and exit}
   Laenge:=ptrrec(Ende).Seg-PrefixSeg +     { Calculate program length. }
           (ptrrec(Ende).Ofs+15) Div 16;
   ASM
      MOV AH, 49
      MOV AL, Code
      MOV DX, Laenge
      INT $21
   END;
End;


{$IFNDEF KBDRES}   {Piece of code which is not neccessary for KBDRES}


Procedure Error(B : Byte);
Begin
   Case B of
      1 : Writeln('Different Version of Keyb installed.');
      2 : Writeln('Incompatible keyboard driver installed.');
      3 : Writeln('Resident part of keyb was NOT installed.');
      4 : Writeln('Specified file could not be opened.');
      5 : Writeln('The resident part of Keyb could not be removed.');
      6 : Writeln('Internal failure: Memory for fast access DS too small.');
      7 : Writeln('Keyb requires (still!) an AT/286 or better');
      8 : Writeln('Required configuration file PC437.KEY not found');
   End;
   Halt(b);
End;


{***********************************************************
 Load translation table.
 ***********************************************************}

{ +++++++++++ Special keys for XStrings +++++++++++ }

Const  KeyNames    : Array[1..18] of String[5] =
                     ('HOME','END','PU','PD','CL','CR','CU','CD','DEL','INS',
                      'CHOME' ,'CEND','CPU','CPD','CCL','CCR','F11','F12');
       KeyCodes    : Array[1..18] of Byte =
                     (71,79,73,81,75,77,72,80,83,82,119,117,132,118,115,116,87,88);

{$S+,I+,R+}

Var    XStrEnd     : Word;
       XStrs       : Array[1..200] of String; { The XStrs will first be deposited here and only later }
                                              { be copied to their data region. So we don't have to move }
                                              { all the following XStrs if we insert one. If XStrs exist already, }
                                              { they will be copied here first! }

Function ProgramName:String;                { Finds out name and path of the current program. }
Var    EnvSeg,                              { Replaces ParamStr(0) as that won't work if environment is empty. }
       EnvOfs      : Word;
       S           : String;
Begin
   EnvSeg:=MemW[PrefixSeg:$2C];             { Environment Adress. }
   EnvOfs:=0;
   While MemW[EnvSeg:EnvOfs]>0 Do           { Seek end of environment. }
      Inc(EnvOfs);
   Inc(EnvOfs,4);
   S:='';
   While Mem[EnvSeg:EnvOfs]>0 Do            { Program name. Terminated by zero. }
   Begin
      S:=S+Char(Mem[EnvSeg:EnvOfs]);
      Inc(EnvOfs);
   End;
   ProgramName:=S;                          { Let's give it back ... }
End;



{keeps trailing \}
Function ProgramPath: string;
var
   s: string;
begin
     s := ProgramName;
     while s[length(s)]<>'\' do
        delete (s,length(s),1);
{     delete (s,length(s),1);}
     ProgramPath := s
End; {ProgramPath}



Function GetNumber(Var Line:String; Var LinePtr:Byte):Byte; { Read byte from line. }
Var    S           : String[8];
       Num         : Byte;
       err         : Integer;
Begin
   S:='0';
   err := 0;

   While Line[LinePtr]=' ' Do               { Skip eventual spaces. }
      Inc(LinePtr);

   {regular case}
   While (Line[LinePtr]>='0') and           { until no more numbers follow or end of line reached. }
         (Line[LinePtr]<='9') and
         (LinePtr<=Length(Line)) Do
   Begin
      S:=S+Line[LinePtr];
      Inc(LinePtr);
   End;
   Val(S,Num,err);                          { Calculate value. }

   {Send result}
   if err=0 then GetNumber:=Num
            else GetNumber:=0
End;


Procedure SetKey(Var Line:String);          { Read sections with the name KEYS. }
Var    KeyNum      : Byte;
       LinePtr     : Byte;
       C           : Char;
       B           : Byte;
       flag       : boolean;
Begin
   LinePtr:=1;

   While Line[LinePtr]=' ' Do               { Skip eventual spaces. }
      Inc(LinePtr);

   {Add Aitor 1.10: Exx to read the extended scancodes}
   flag := upcase(line[lineptr])='E';
   if flag then inc(LinePtr);

   KeyNum:=GetNumber(Line,LinePtr)+128*ord(flag);      { Read keynumber. }

   If (KeyNum=0) or (KeyNum>256) Then    { Keynumber legal? }
   Begin
      Writeln('Illegal key number:');
      Writeln(Line);
   End;

   TransTable^[KeyNum,5]:=0;             { Key attribute = 0. }

   C:=Line[LinePtr];
   While C<>' ' Do                       { After key number, NCS follows optionally, then space. }
   Begin
      Case UpCase(C) Of
         'N' : Inc(TransTable^[KeyNum,5],2);   { Set Num Lock Bit. }
         'C' : Inc(TransTable^[KeyNum,5],4);   { Caps. }
         'S' : Inc(TransTable^[KeyNum,5],1);   { Scroll. }
      End;
      Inc(LinePtr);                      { Next char. }
      C:=Line[LinePtr];
   End;

   For B:=0 To 4 Do                      { Mappings for 5 levels. }
   Begin
      While Line[LinePtr]=' ' Do
         Inc(LinePtr);                   { Skip space. }
      Case Line[LinePtr] of
         '#' : Begin                     { #+ASCII-Value of char. }
                  Inc(LinePtr);
                  TransTable^[KeyNum,B]:=GetNumber(Line,LinePtr);
               End;
         '!' : Begin                     { Key mapped to XStr. }
                  Inc(LinePtr);
                    flag := upcase(line[lineptr])='C';  {!C means 235+ (for COMBI)}
                    if flag then inc(LinePtr);
                  TransTable^[KeyNum,B]:=GetNumber(Line,LinePtr)+235*ord(flag);
                  Inc(TransTable^[KeyNum,5],$80 shr B);  { Set XStr Bit for actual level. }
               End;
         Else  Begin                     { Normal mapping with chars. }
                  TransTable^[KeyNum,B]:=Byte(Line[LinePtr]);
                  Inc(LinePtr);
               End;
      End;
   End;
End;

Procedure SetShifts(Var Line:String);       { Read scancodes of shift keys from config file. }
Var    B           : Byte;
       LinePtr     : Byte;
Begin
   LinePtr:=1;
   B:=0;
   While (LinePtr<=Length(Line)) and (B<=7) Do     { All scancodes need to be in one row! }
   Begin
      ShiftKeys[B]:=GetNumber(Line,LinePtr);       { And it needs to contain at least 8 scancodes! }
      Inc(B);
   End;

   If B<=7 Then                          { Less than 8 scancodes found? }
   Begin
      Writeln('Warning:');
      Writeln('Some shift keys remain undefined!');
      Writeln(Line);
   End;
End;


Function GetKeyByName(Var Line:String; Var LinePtr:Byte):String;
Var    KeyName     : String[10];            { For processing XStr definitions. }
       ShiftOffset : Byte;                  { Gets the scancode of a key by its name. }
       B           : Byte;                  { Names of keys are in KeyNames. }
       I           : Integer;               { The corresponding scancodes are in KeyCodes. }
Begin
   GetKeyByName:='';
   KeyName:='';

   While (LinePtr<Length(Line)) and         { Read name of key. }
         (Line[LinePtr]<>']') and
         (Length(KeyName)<7) Do
   Begin                                    { Copy char until ']', end of line or 7 chars read. }
      KeyName:=KeyName+UpCase(Line[LinePtr]);
      Inc(LinePtr);
   End;

   If Line[LinePtr]<>']' Then               { Key not terminated by ']' ? }
   Begin
      Writeln;
      Writeln('"]" missing in xstring definition:');
      Writeln(Line);
      Exit;
   End
   Else Inc(LinePtr);

   B:=0;
   Repeat                                   { Search key in list specified at the top of this program section. }
      Inc(B);
   Until (B=17) or (KeyName=KeyNames[B]);
   If B<17 Then                             { Key found => return its scancode. }
   Begin
      GetKeyByName:=#0+Char(KeyCodes[B]);   { We return a zero-Byte + the scancode. }
                                            { Returning string may be appended directly to the XStr. }
   End
   Else
   Begin                                    { Key not found. May be function key. }
      ShiftOffset:=0;
      Case KeyName[1] of                    { Scancodes of function keys (F) are number + an offset. }
         'S' : ShiftOffset:=83;             { Offset for Shift. }
         'C' : ShiftOffset:=93;             { Control. }
         'A' : ShiftOffset:=103;            { Alt. }
         'F' : ShiftOffset:=58;             { No modifying key. }
      End;
      If (ShiftOffset=0) or
         (
            (ShiftOffset>58) and
            (KeyName[2]<>'F')
         ) Then
      Begin                                 { Name of key is invalid. }
         Writeln;
         Writeln('Invalid keyname ',KeyName,' in xstring definition:');
         Writeln(Line);
         Exit;
      End;

      If ShiftOffset>58 Then Delete(KeyName,1,2) { Isolate function key number. }
                        Else Delete(KeyName,1,1);

      Val(KeyName,B,I);                     { and turn into value. }
      If (B<1) or (B>10) Then               { Only values 1-10 are allowed. }
      Begin
         Writeln;
         Writeln('Invalid function key F',B,' in xstring definition:');
         Writeln(Line);
         Exit;
      End;

      GetKeyByName:=#0+Char(B+ShiftOffset); { The scancode is key number + the level independent offset. }
   End;
End;

Function GetSpecKey(Var Line:String; Var LinePtr : Byte):String;
Var    Len         : Byte;                  { This function manages if a '\' appears in the XStr definition. }
       Number      : Byte;                  { If needed it calls the function GetKeyByName. }
       Select      : Char;
Begin
   Len:=Length(Line);
   GetSpecKey:='';

   If LinePtr>Len Then                      { Was '\' the last char in the XStr? }
   Begin
      Writeln;                              { Yes -> Error. }
      Writeln('Unexpected end of xstring definition:');
      Writeln(Line);
      Exit;
   End;

   Select:=UpCase(Line[LinePtr]);           { Evaluate char after \ . }
   Case Select of
      'N' : Begin
               GetSpecKey:=#13;             { \n = CR. }
               Inc(LinePtr);
            End;
      '\' : Begin
               GetSpecKey:='\';             { \\ = \. }
               Inc(LinePtr);
            End;
      'A',
      'S' : Begin                           { \Axxx = Chr(xxx) ; \Sxxx = Key(xxx). }
               If Lineptr+3<Len Then        { The number has got max. 3 digits. }
                  Byte(Line[0]):=           { Shorten length of line }
                  LinePtr+3;                { to ignore digits following eventually upon the number! }
               Inc(LinePtr);
               Number:=GetNumber(Line,LinePtr);
               Byte(Line[0]):=Len;          { Restore original line length. }

               If Select='A'
                  Then GetSpecKey:=Char(Number)
                  Else GetSpecKey:=#0+Char(Number);
            End;
      '[' : Begin                           { In [] we have the name of a key. }
               Inc(LinePtr);                { GetKeyByName calculates the corresponding code. }
               GetSpecKey:=GetKeyByName(Line,LinePtr);
            End;
      Else Begin                            { Illegal char after \ -> Error. }
              Writeln;
              Writeln('Syntax error in xstring definition:');
              Writeln(Line);
           End;
   End;
End;

Procedure ParseXStr(Var Line:String; Var LinePtr:Byte; Var Dest:String);
Begin                                       { This routine translates an XStr. }
   Dest:='';
   While LinePtr<=Length(Line) Do           { Process all chars until end of line. }
   Begin
      If Line[LinePtr]='\' Then             { Is char a backslash ? }
      Begin
         Inc(LinePtr);                      { Yes -> special char. }
         Dest:=Dest+GetSpecKey(Line,LinePtr);    { Meaning will be calculated by GetSpecKey. }
      End
      Else
      Begin                                 { No -> Take char unmodified. }
         Dest:=Dest+Line[LinePtr];
         Inc(LinePtr);
      End;
   End;
End;


Procedure SetXStr(Var Line : String);       { Process sections with label [XSTRINGS] }
Var    LinePtr     : Byte;
       XStrNum     : Byte;
Begin
   LinePtr:=1;
   XStrNum:=GetNumber(Line,LinePtr);     { Line starts with number of the XStr. }

   If (XStrNum=0) or (XStrNum>200) Then  { Number valid ? }
   Begin
      Writeln;
      Writeln('illegal xstring number:');
      Writeln(Line);
      Writeln('legal xstring numbers: 1-200.')
   End
   Else
   Begin
      If XStrNum>LastXStr Then LastXStr:=XStrNum;  { Number greater than LastXStr? -> Set new LastXStr. }
      Inc(LinePtr);                      { Exactly ONE space follows. Skip that. }

      XStrs[XStrNum]:='';
      ParseXStr(Line,LinePtr,XStrs[XStrNum]); { Let XStr translate by ParseXStr. }
   End;
End;

Procedure ReadCombis(Var S : String);
{ S[1]=First char of combinations of this list. }
{ S[2]=Number of combinations in this list. Needs to be 0 at the calling of this routine. }
Var    Loop        : Byte;
Begin
   With DatSeg^ Do
   Begin
      Loop:=0;
      While (CombTab[Loop]<>0) and (CombTab[Loop]<>Byte(S[1])) Do
      Begin                                 { Search combination char. }
         Loop:=Loop+2*CombTab[Loop+1]+2;
      End;

      If CombTab[Loop]>0 Then               { Found combinations with this char. }
      Begin
         Byte(S[0]):=CombTab[Loop+1]*2+2;
         Move(CombTab[Loop],S[1],Byte(S[0])); { Copy existing combinations. }

         Move(CombTab[Loop+Byte(S[0])],CombTab[Loop],192-Loop);
                                            { The read combinations will be erased! }
                                            { Eventually reentered later in other form. }
      End;
   End;
End;

Procedure WriteCombis(Var S : String);
Var    Loop        : Byte;
Begin
   Loop:=0;
   With DatSeg^ Do
   Begin
      While CombTab[Loop]>0 Do
         Loop:=Loop+2*CombTab[Loop+1]+2;

      If Loop+Length(S)>191 Then
      Begin
         Writeln(#10'Warning: Overflow of combination char table. ');
         Writeln('combinations with char ',S[1],' inactive.');
      End
      Else
      Begin
         Move(S[1],CombTab[Loop],Length(S)); { Insert the crap. }
         CombTab[Loop+Length(S)]:=0;
      End;
   End;
End;


Procedure SetCombi(Var Line : String);
Var    CombiChars  : String;
       LinePtr     : Byte;
Begin
   LinePtr:=1;
   While (Line[LinePtr]=' ') and (LinePtr<=Length(Line)) Do
      Inc(LinePtr);                         { Skip blanks. }
   If LinePtr>Length(Line) Then Exit;       { Nothing in the row? }

   CombiChars:=Line[LinePtr]+#0;            { First char of the combination after CombiChars. }
   ReadCombis(CombiChars);                  { Read eventually existing combinations with this char. }

   Inc(LinePtr);
   While LinePtr<=Length(Line) Do           { Process line. }
   Begin
      If Line[LinePtr]<>' ' Then            { Blank ? *shiver* }
      Begin
         If Line[LinePtr]='#' Then          { ASCII-Value for char after #. }
         Begin
            Inc(LinePtr);                   { Get ASCII-Value and translate into char. }
            CombiChars:=CombiChars+Char(GetNumber(Line,LinePtr));
         End
         Else
         If Line[LinePtr]='!' Then          { ! erases an existing definition. }
         Begin
            CombiChars[0]:=#2;
            CombiChars[2]:=#0;
         End
         Else
         Begin
            CombiChars:=CombiChars+Line[LinePtr];
            Inc(LinePtr);                   { Else copy chars directly. }
         End;
      End
      Else
         Inc(LinePtr);                      { Skip blanks. }
   End;

   If Odd(Length(CombiChars)) Then
   Begin                                    { Here we have just a halve pair of chars -> nonsense. }
      Writeln(#10'Warning: Halve pair of chars at combination char:');
      Writeln(#10,Line);
      Writeln(#10'Line was shortened to full pairs of chars!');
      Dec(CombiChars[0]);
   End;

   CombiChars[2]:=
      Char(Length(CombiChars) Shr 1 -1);    { Half length of list minus 1 is number of combinations. }
   If CombiChars[2]>#0 Then
      WriteCombis(CombiChars);              { Save combinations. }
End;



Procedure CopyXStrs(BufSize:Word);           { Shorten XStrings and save to buffer. }
Var    B           : Byte;
       BufferFull  : Boolean;
Begin
   XStrEnd:=0;
   BufferFull:=False;

   With DatSeg^ Do
   Begin
      B:=1;
      While (B<=LastXStr) and not BufferFull Do  { Until all XStrs are inserted or buffer is full. }
      Begin
         If XStrEnd+Length(XStrs[B])>=BufSize Then    { Will the string still fit into the buffer ? }
         Begin
            Writeln;                                  { No. }
            Writeln('Not enough buffer space for xstring declaration:');
            Writeln(XStrs[B]);
            XStrs[B]:='';                             { Erase XString. }
            BufferFull:=(BufSize-XStrEnd)=0;          { Buffer completely full ? => Exit loop. }
         End
         Else
         Begin
            Move(XStrs[B],XStrings[XStrEnd],Byte(XStrs[B][0])+1); { Copy XStr into the buffer and }
            XStrEnd:=XStrEnd+Byte(XStrs[B][0])+1;     { recalculate end of occupied memory. }
            Inc(B);
         End;
      End;
      LastXStr:=B-1;                        { If not all strings could be inserted. }

      If XStrBufSize=0 Then
         XStrBufSize:=XStrEnd;              { Buffer size not declared => minimize. }
   End;
End;

Procedure GetOldXStrs;                      { Read XStrings from resident copy of Keyb. }
Var    B           : Byte;
       W           : Word;
Begin
   With DatSeg^ Do                          { The data region of the resident copy will be used! }
   Begin
      W:=0;
      For B:=1 To LastXStr Do               { Go through all XStrs. }
      Begin
         Move(XStrings[W],XStrs[B],XStrings[W]+1);    { Copy XStr to other data region. }
         W:=W+XStrings[W]+1;                { Calculate address of next XStr. }
      End;
   End;
End;




Procedure ExpandFileName(Var Name : String);{ If needed, extend name of config file. }
Begin
  { first, we are loading a .KEY file }
   If Pos('.',Name)=0 Then    { filename has no extension -> add .KEY }
      Name:=Name+'.Key';

   If (Pos('\',Name)=0) and
      (Pos(':',Name)=0) Then  { filename contains no path -> add program path }
   Begin
      Name := FSearch (Name, ProgramPath+';'+GetEnv('PATH'));  {RQ 1.6-1.7}
      Name := FExpand (Name);            
   End;
End;
(*begin
   if Pos('.',Name)=0 Then    { filename has no extension -> add .KEY }
      Name:=Name+'.KEY';

   If (Pos('\',Name)=0) and
      (Pos(':',Name)=0) Then  { filename contains no path -> add program path }
      Name := ProgramPath+name
end;
*)



Type   SectionTyp  = (Keys,Shifts,XStrings,Comment,List,Continue,Combi);

Function GetSection(Var Line : String):SectionTyp;    { Evaluate section name. }
Var    B           : Byte;
Begin
   B:=2;
   While (B<Length(Line)) and               { Make line uppercase. }
         (Line[B]<>']') Do                  { Ignore all chars after ']'. }
   Begin
      Line[B]:=UpCase(Line[B]);
      Inc(B);
   End;
   Line[0]:=Char(B);                        { Ignore chars after ] . }

   If Line='[KEYS]' Then GetSection:=Keys
   Else If Line='[SHIFTS]' Then GetSection:=Shifts
   Else If Line='[XSTRINGS]' Then GetSection:=XStrings
   Else If Line='[COMMENT]' Then GetSection:=Comment
   Else If Line='[LIST]' Then GetSection:=List
   Else If Line='[CONTINUE]' Then GetSection:=Continue
   Else If Line='[COMBI]' Then GetSection:=Combi
   Else
   Begin
      Writeln('Warning:');
      Writeln('Unknown section ',Line,' found.');
      Writeln('Skipping section.');
      GetSection:=Comment;
   End;
End;

Procedure ReadConfigFile(Name:String; BufSize : Word);   { Read config file. }
Var    B           : Byte;
       S           : String;
       Section     : SectionTyp;
       Line        : String;
       ConfigFile  : Text;
       FileN       : byte;    {number of file being parsed}
       SingleName  : string;
       TrueFile    : boolean;
Label  Cont;
Begin
   For B:=1 To 200 Do                       { Clear XString workspace. }
      XStrs[B]:='';

   If BufSize=$FFFF Then GetOldXStrs;       { Read old xstrings. BufSize=FFFFh -> XKeyb resident installiert. }

   TrueFile := FALSE;
   SingleName := 'PC437';

Cont:
   ExpandFileName(SingleName);
   Assign(ConfigFile,SingleName);
{$I-}
   Reset(ConfigFile);
{$I+}
   If IOResult<>0 Then Error(8-4*ord(TrueFile)); { Opening of file failed. }

   If TrueFile then DatSeg^.ConfigFile:=SingleName;
   Section:=Comment;

   While not Eof(ConfigFile) Do             { Read whole file. }
   Begin
      Readln(ConfigFile,Line);

      If (Length(Line)>0) and (Line[1]<>';') Then                { Ignore empty lines. }
         If Line[1]='[' Then Section:=GetSection(Line)
         Else
            Case Section of
               Keys     : SetKey(Line);
               Shifts   : SetShifts(Line);
               XStrings : SetXStr(Line);
               List     : Writeln(Line);
               Combi    : SetCombi(Line);   { Define combination chars. }
               Continue : Begin             { Proceed with next file. }
                             Close(ConfigFile);
                             SingleName:=Line;
                             Goto Cont;
                          End;   {en FIleN>1}
            End
      Else If Section=List Then Writeln;
   End;
   Close(ConfigFile);
   if trueFile then begin
       FileLoaded := TRUE;
       WriteLn ('Installed ',SingleName);
   end else begin
       truefile   := TRUE;
       SingleName := Name;
       goto cont
   end;

   With DatSeg^ Do
      If BufSize<$FFFF Then                 { No resident installation yet. }
      Begin
         XStrBufSize:=BufSize;
         If BufSize>1024 Then BufSize:=1024;{ For installation max. 1K buffer, else we overwrite our code! }
         If BufSize=0 Then BufSize:=1024;   { No size given? -> minimal, up to 1K. }
      End
      Else BufSize:=XStrBufSize;            { If installed already, resident copy declares buffer size. }

   CopyXStrs(BufSize);                      { Put XStrs to their data region. }

End;


{***********************************************************
 Main program & Check for already installed driver.
 ***********************************************************}

Type   BCDString   = String[2];

Function BCD(B : Byte) : BCDString;         { Translate BCD number into string. }
Begin
   If B>15 Then BCD:=Char(B shr 4 + 48)+Char(B and 15 + 48)
           Else BCD:=Char(B+48);
End;

Function VS(W : Word) : String;             { Returns version number as string. }
Var    S           : String;
Begin
   S:=BCD(LO(W));                           { Turn second value into string. }
   If Length(S)<2 Then S:='0'+S;            { Eventually add leading zero. }
   VS:=BCD(Hi(W))+'.'+S;                    { Add first value and point. }
End;

Function TestInstallation : Byte;
{ Check whether a copy of XKeyb is already installed. }
{ Result:   0 -> No keyboard driver installed. }
{           1 -> Identical version of XKeyb installed. }
{                >> DatSeg will be set to data region of resident copy. }
{           2 -> Different version of XKeyb installed. }
{           3 -> Different keyboard driver installed. }
Begin
   TestInstallation:=0;
   With Regs Do                             { Already installed ? }
   Begin
      AX:=$AD80;                            { Check state of installation. }
      BX:=0;                                { AL=0 -> No keyboard driver installed. }
      ES:=0;                                { AL=FFh -> Already a keyboard driver installed. }
      DI:=0;
      Intr($2F,Regs);

      If AL=$FF Then                        { Already installed? }
      Begin                                 { YES! }

         If (SI=$5053) and                  { Is it XKeyb ? }
            (DX=$4448) and
            (CX=$584B) Then
         Begin                              { YES! }
            If BX=Version Then              { Same version? }
            Begin                           { YES! -> Tables can be overloaded [taken over?]. }
               DatSeg:=Ptr(ES,DI);          { Set pointer to data segment of resident driver copy. }
               TestInstallation:=1;
            End
            Else TestInstallation:=2;       { Different version of XKeyb. }
         End
         Else TestInstallation:=3;          { Other keyboard driver (KEYB.COM ?) installed. }
      End;
   End;
End;

Procedure Remove;                           { Remove XKeyb from memory. }
Var    Removeable  : Boolean;
       IntVec      : Array[Byte] of Pointer absolute 0:0;
       Regs        : Registers;
       MultiHand   : Pointer;
       Int16Hand   : Pointer;
       Int9Hand    : Pointer;
       Int15Hand   : Pointer;
Begin
{ Check whether removing is possible. }

   MultiHand:=DatSeg;
   ptrrec(MultiHand).Ofs:=Ofs(MultiplexHandler);
   Int16Hand:=DatSeg;
   ptrrec(Int16Hand).Ofs:=Ofs(Int16Handler);
   Int9Hand :=DatSeg;
   ptrrec(Int9Hand).Ofs :=Ofs(Int9h);
   Int15Hand :=DatSeg;
   ptrrec(Int15Hand).Ofs :=Ofs(Int15h);
   With DatSeg^ Do
   Begin
      Removeable:=
         (IntVec[$09]=Int9Hand) and
         (IntVec[$16]=Int16Hand) and
         (IntVec[$2F]=MultiHand) and
         (IntVec[$15]=Int15Hand);

      If not Removeable Then Error(5);      { Removing impossible. Interrupt vectors were changed by another program. }

{ Uninstall it. }
      SetIntVec ($9,  OldInt9h);
      SetIntVec ($16, OldInt16h);
      SetIntVec ($15, OldInt15h);
      SetIntVec ($2F, OldInt2Fh);


      With Regs Do
      Begin
         AH:=$49;                           { Free memory. }
         ES:=MemW[Seg(XBuffer^):$2C];       { Environment segment. }
         Intr($21,Regs);
         AH:=$49;
         ES:=Seg(XBuffer^);                 { Program segment. }
         Intr($21,Regs);
      End;
   End;

   Writeln('Resident part of Keyb removed.');
End;

Procedure ShowInfo;
Begin
   With DatSeg^ Do
   Begin
      Writeln('Active definition file     : ',ConfigFile);
      Writeln('Number of XStrings defined : ',Byte( Ptr(Seg(DatSeg^) , Ofs(LastXStr))^ ));
      Writeln('XString buffer size        : ',XStrBufSize,' Bytes');
   End;
End;

Function PerformParam:ActionTyp;            { Evaluate parameters. }
Var    B           : Byte;
       I           : Integer;
       S           : String;
       Regs        : Registers;
       ConFileName : String;
       Action      : ActionTyp;
       Installed   : Byte;
       XStrBufSize : Word;
       FastDatSeg  : Word;
       T           : text;
Begin
   FastDatSeg:=CSeg;
   ConFileName:='';
   XStrBufSize:=0;
   Action:=GetInfo;
   Installed:=TestInstallation;

   If Installed=1 Then                      { If already installed get certain values from resident FastDS. }
      Move(Ptr(ptrrec(DatSeg).Seg , Ofs(ShiftKeys))^,
           ShiftKeys,39); 

   With Regs Do
   Begin
      AX:=$3700;                            { Evaluate SwitchChar. (Normally '/') }
      Intr($21,Regs);
   End;

   For B:=1 To ParamCount Do                { Process all parameters. }
   Begin
      S:=ParamStr(B);
      If Byte(S[1])=Regs.DL Then            { parameter starts with switch char. }
      Begin
         Case Upcase(S[2]) of
            'X' : Begin                     { Set buffersize for xstring buffer. }
                     Delete(S,1,2);
                     Val(S,XStrBufSize,I);
                  End;
            'U' : Begin                     { Uninstall.}
                     Action:=Uninstall;
                  End;
            'Q' : Begin                     { Quit. Ignore LIST sections. }
                     Close(OutPut);
                     Assign(OutPut,'Nul');
                     Rewrite(OutPut);
                  End;
            'I' : Begin                     { Install. Ignore other driver. }
                     Installed:=0;
                     Action:=Install;
                  End;
            '?' : begin
                        Action := FastHlp;        { Show the fast help }
                  end;
            Else
            Begin                           { Unknown option required -> Error. }
               Writeln;
               Writeln('Invalid modifier -  ',S);  {Aitor 1.7}
            End;
         End;
      End
      Else
      Begin
         ConFileName:=S;      { a parameter without / is the .KEY file name }
         Case Installed of
            0:Action:=Install;
            1:Action:=OverLoad;
         End;
      End;
   End;

   if action<>FastHlp then
   Case Installed of
      2:Action:=WrongVers;
      3:Action:=OtherDrv;
   End;

   if action=OverLoad then begin   {when file not found, abort! }
       ExpandFileName(S);
       Assign(t,S);
       {$I-}
       Reset(t);
       {$I+}
       If IOResult<>0
          then error(4)
          else close (t);
   end;


{ Geforderte Aktion ausfhren. }

   Case Action of
      Install          : ReadConfigFile(ConFileName,XStrBufSize);
      OverLoad         : ReadConfigFile(ConFileName,$FFFF);
      GetInfo          : If Installed=1 Then ShowInfo Else Error(3);
      Uninstall        : If Installed=1 Then Remove Else Error(3);
      WrongVers        : Error(1);
      OtherDrv         : Error(2);
   End;

   If Installed=1 Then                      { If already installed, write certain values into resident FastDS. }
   Begin
      If Action=OverLoad Then Inactive:=False;   { Activate driver if table was loaded. }
      Move(ShiftKeys,                            { (also includes ReadConfigFile, updated to TRUE }
           Ptr(ptrrec(DatSeg).Seg , Ofs(ShiftKeys))^, 15);
   End;

   PerformParam:=Action;
End;

procedure ShowFastHelp;
begin
    Writeln ('("Taurus") Second generation keyboard driver for FreeDOS');
    WriteLn ('License:  GNU-GPL 2.0 or later');
    WriteLn ('(c) Aitor Santamara  - 2003');
    WriteLn;
    WriteLn ('KEYB  layoutFile [/Q] [/Xsize] [/I]');
    WriteLn ('KEYB  /U');
    WriteLn ('KEYB  /?');
    WriteLn;
    WriteLn ('LayoutFile  File containing the information for your keyboard');
    WriteLn ('/Q          (Quiet) Avoid Listing information on the layout file');
    WriteLn ('/I          (force Install) Install keyb unconditionally');
    WriteLn ('/Xsize      (xkeyb compatibility) maximum size for Xstrings');
    WriteLn ('/U          (uninstall) unloads the driver from memory');
    WriteLn ('/?          shows this help');
    WriteLn;
    WriteLn ('More information: NOTES.TXT')
end;


{$ENDIF}{KBDRES}

function Is286p: boolean;
var
   vax: word;
begin
     asm
        xor  ax,ax              
        push ax                 
        popf                    
        pushf                   
        pop  ax                 
        mov  vax, ax
     end;
     Is286p := (vax AND $F000)<>$F000
end;


Var    B           : Byte;
       Action      : ActionTyp;

Begin

   If Ofs(EoDS)>Ofs(FindXStr) Then begin
      Writeln('Internal failure: Memory for fast access DS too small.');
      halt (6)
   end;       {This is Error(6), but needs to do this with KBDRES}


   if (mem[$F000:$FFFE]=$FF) or (mem[$F000:$FFFE]=$FE) or (not Is286p) then begin
       Writeln('Keyb still requires an AT/286 or better');
       halt (7)
   end;       {This is Error(7), but needs to do this with KBDRES}

   WriteLn ('KEYB ',VerS,': keyboard driver for FreeDOS (/?: more info)');


                                            { Initialize resident data segment. }
                                            { These values are only valid if the driver is made
                                              resident newly [the first time?]. }
   XBuffer:=Ptr(PrefixSeg,128);
   TransTable:=@DR(@Data^).TransTable;
   DatSeg:=@Data;                           { Initialize pointer to resident data segment to the procedure data. }
                                            { If necessary, this setting will be changed by TestInstallation. }

{$IFNDEF KBDRES}
   Action:=PerformParam;                    { Evaluate command line parameters. }

   If Action=FastHlp Then
      ShowFastHelp
   Else
   If Action=Install Then
{$ENDIF}
   With DatSeg^ Do
   Begin
{$IFNDEF KBDRES}
      XStrBufSize:=                         { Round up end of buffer to segment border. }
         XStrBufSize
           +(
               16
              -Ofs(XStrings[XStrBufSize]) and $F
            )
            and $F;
{$ELSE}
      XStrBufSize:=Ofs(Keep)-Ofs(XStrings);                         { Round up end of buffer to segment border. }
{$ENDIF}

      GetIntVec($2F,OldInt2Fh);
      GetIntVec($16,OldInt16h);
      GetIntVec($15,OldInt15h);
      GetIntVec($9 ,OldInt9h);

      Move(Ptr(DSeg,0)^,Ptr(CSeg,0)^,Ofs(EoDS)); { Copy data into resident FastDS. }

      For Loop:=201 To 235 Do
         XFunc[Loop].Stat:=0;

      SetIntVec($9, @Int9H);
      SetIntVec($2F,@MultiPlexHandler);
      SetIntVec($16,@Int16Handler);
      SetIntVec($15,@Int15h);

{      SwapVectors;}
 {$IFNDEF KBDRES}
      Keep(@XStrings[XStrBufSize],0);
 {$ELSE}
      Keep(@Keep,0);
 {$ENDIF}
 
      FastDS;                              { Avoids removal of FastDS by the linker. }
   End;
END.

        
