/*
// Program:  Format
// Written By:  Brian E. Reifsnyder
// Version:  removed from main format.h since version 0.91g
// (0.90b ... 0.90f and 0.91b ... 0.91e are updates by Eric Auer 2003)
// Copyright:  2002 under the terms of the GNU GPL, Version 2.
// Module Name:  DPB.H
// Module Description:  DPB header file for format.
*/

/*
/////////////////////////////////////////////////////////////////////////////
//  SPECIAL
/////////////////////////////////////////////////////////////////////////////
*/

/* Is this really correct??? RBIL 61 table 01787 looks VERY different */
/* for the FAT32 case! */
typedef struct DPB_Structure {
  /* Standard DPB */
  unsigned char drive_number;			/* 00 */
  unsigned char device_driver_unit_number;	/* 01 */
  unsigned int  bytes_per_sector;		/* 02 */
  unsigned char sectors_per_cluster_minus_one;	/* 04 */
  unsigned char sectors_per_cluster_power_two;	/* 05 */
  unsigned int  beginning_fat_sector;		/* 06 */
  unsigned char number_fat_copies;		/* 08 */
  unsigned int  number_root_directory_entries;	/* 09 */ /* 0 for FAT32? */
  unsigned int  first_data_cluster;		/* 0b */
  unsigned int  number_clusters_plus_one;	/* 0d */
  unsigned int  sectors_per_fat;		/* 0f */ /* 0 for FAT32 */
  unsigned int  first_root_directory_sector;	/* 11 */
  unsigned long device_driver_address;		/* 13 */
  unsigned char media_descriptor;		/* 17 */

  unsigned char dpb_access_flag;		/* 18 */
  unsigned long next_dpb_pointer;		/* 19 */
  unsigned int  last_cluster_allocated;		/* 1d */
  unsigned int  number_free_clusters;		/* 1f */
  /* FAT32 DPB */
  unsigned int  number_free_clusters_high;	/* 21 */
  unsigned int  mirroring_flags;		/* 23 */ /* WORD! */
    /* bits 15..8 reserved 7 donotmirrorfat 6..4 reserved 3..0 activefat */
  unsigned int  info_sector_number;		/* 25 */ /* -1 for none */
  unsigned int  backup_boot_sector_number;	/* 27 */ /* -1 for none */
  unsigned long first_sector_number_first_clust; /* 29 */ /* dword */
  unsigned long max_clust_number;		/* 2d */  /* dword */
  unsigned long number_sectors_per_fat;		/* 31 */  /* dword */
  unsigned long root_dir_start_cluster;		/* 35 */  /* dword */
  unsigned long free_space_start_cluster;	/* 39 */  /* dword */
  } DPB;

EXTERN DPB far *dpb;

typedef struct Get_ExtDPB_Data_Buffer
{
  unsigned int buffer_length;
  DPB          ext_dpb;
} GE_DPD_DB;

EXTERN GE_DPD_DB ext_parameter_block;

