/*
// Program:  Format
// Version:  0.91g
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  btstrct.h
// Module Description:  Boot sector structures header file.
*/

#ifndef BTSTRCT_H
#define BTSTRCT_H 1

#ifdef MAIN
#define BTEXTERN    /* */
#else
#define BTEXTERN    extern
#endif


typedef struct Standard_Boot_Sector_Fields
{
  unsigned char jmp[3];                      /* 0x00     0   */
  unsigned char oem_id[8];                   /* 0x03     3   */
} STD_BS;


typedef struct Standard_BPB
{
  unsigned bytes_per_sector          : 16;   /* 0x0b    11   */
  unsigned sectors_per_cluster       :  8;   /* 0x0d    13   */
  unsigned reserved_sectors          : 16;   /* 0x0e    14   */
  unsigned number_of_fats            :  8;   /* 0x10    16   */
  unsigned root_directory_entries    : 16;   /* 0x11    17   */
  unsigned total_sectors             : 16;   /* 0x13    19   */
  unsigned media_descriptor          :  8;   /* 0x15    21   */
  unsigned sectors_per_fat           : 16;   /* 0x16    22   */
  unsigned sectors_per_cylinder      : 16;   /* 0x18    24   */
  unsigned number_of_heads           : 16;   /* 0x1a    26   */
  unsigned hidden_sectors_low        : 16;   /* 0x1c    28   */
  unsigned hidden_sectors_high       : 16;   /* 0x1e         */
  unsigned large_sector_count_low    : 16;   /* 0x20    32   */
  unsigned large_sector_count_high   : 16;   /* 0x22         */
} STD_BPB;

typedef struct FAT32_BPB_Extension
{
  unsigned fat_size_low              : 16;   /*         36   */
  unsigned fat_size_high             : 16;   /*         38   */
  unsigned ext_flags                 : 16;   /*         40   */
  unsigned file_system_version       : 16;   /*         42   */
  unsigned root_dir_start_low        : 16;   /*         44   */
  unsigned root_dir_start_high       : 16;   /*         46   */
  unsigned info_sector_number        : 16;   /*         48   */
  unsigned backup_boot_sector        : 16;   /*         50   */
  char     reserved_1[12]                ;   /*         52   */
} FAT32_BPB;

typedef struct Extended_Boot_Sector
{
  unsigned drive_number              :  8;   /*         36 || 64 */
  unsigned reserved                  :  8;   /*         37 || 65 */
  unsigned signature_byte            :  8;   /*         38 || 66 */
  char     serial_number[4]              ;   /*         39 || 67 */
  char     volume_label[11]              ;   /*         43 || 71 */
  char     file_system_type[8]           ;   /*         54 || 82 */
} EXT_BS;


BTEXTERN STD_BS     bs_start;
BTEXTERN EXT_BS     bs_ext;

#endif
