/*
// Program:  Format
// Written By:  Brian E. Reifsnyder
// Version:  0.91e
// (0.90b ... 0.90f and 0.91b ... 0.91e are updates by Eric Auer 2003)
// Copyright:  2002 under the terms of the GNU GPL, Version 2.
// Module Name:  FORMAT.H
// Module Description:  Main header file for format.
*/

/*
/////////////////////////////////////////////////////////////////////////////
//  SPECIAL
/////////////////////////////////////////////////////////////////////////////
*/

#define NAME "Format"
#define VERSION "0.91e"


#ifdef MAIN
#define EXTERN /**/
int debug_prog=0; /* now controlled by the /D command line argument */
#else
#define EXTERN extern
extern int debug_prog;
#endif



#include <dos.h>
#include <stdio.h>  /* printf */
#include <stdlib.h> /* exit */
#include <mem.h>    /* memset memcpy */

/*
/////////////////////////////////////////////////////////////////////////////
//  DEFINES
/////////////////////////////////////////////////////////////////////////////
*/


#define MEG 1048576

#define PRIMARY 1
#define EXTENDED 2
#define LOGICAL 3
#define SPECIAL 4

#define LAST 99

#define TRUE  1
#define FALSE 0

#define HARD   0
#define FLOPPY 1

#define FAT12 1
#define FAT16 2
#define FAT32 3

#define MAX_BAD_SECTORS 1024


#define UNUSED     99

#define READ       25
#define WRITE      26

#define UNKNOWN 99

#define BIOS 1
#define DOS  2

/*
/////////////////////////////////////////////////////////////////////////////
//  GLOBAL VARIABLES
/////////////////////////////////////////////////////////////////////////////
*/

EXTERN char ascii_cd_number[15];
EXTERN char partition_label[16];

/* Buffers */
EXTERN unsigned long bad_sector_map[(MAX_BAD_SECTORS+1)];
EXTERN unsigned int bad_sector_map_pointer;

EXTERN unsigned char fat12_fat[6145];

EXTERN unsigned char mirror_map[8192];

/* Ending Mapping Variables */
EXTERN long computed_ending_cylinder;
EXTERN unsigned long computed_partition_size;

/* Integers converted from long numbers */
EXTERN int integer3;
EXTERN int integer4;

EXTERN union  REGS  regs;
EXTERN struct SREGS sregs;

/*
/////////////////////////////////////////////////////////////////////////////
//  GLOBAL STRUCTURES
/////////////////////////////////////////////////////////////////////////////
*/

typedef struct Access_Flags
  {
  unsigned char special_function;      /* Set to 0.                        */
  unsigned char disk_access;           /* Set to non-zero to allow access. */
  } AF;

typedef struct Drive_Statistics
  {
  unsigned long bytes_total_disk_space;
  unsigned long bytes_in_bad_sectors;
  unsigned long bytes_available_on_disk;

  unsigned long bytes_in_each_allocation_unit;
  unsigned long allocation_units_available_on_disk;
  unsigned long allocation_units_with_bad_sectors; /* 0.91c */

  unsigned int serial_number_low;
  unsigned int serial_number_high;
  } DS;

typedef struct Formatting_Parameters
  {
  char drive_letter[2];
  char volume_label[12];

  char existing_format;           /* TRUE or FALSE */

  int drive_type;                 /* FLOPPY or HARD */
  int drive_number;
  int physical_drive_number;
  int partition_number;
  int fat_type;
  int media_type;                 /* FD#### or HD */

  int force_yes;
  int verify;

  unsigned long first_data_sector;

  int v;
  int q;
  int u;
  int f;
  int b;
  int s;
  int t;
  int n;
  int one;
  int four;
  int eight;

  unsigned long size;
  unsigned long cylinders;
  unsigned long sectors;
  unsigned long sides; /* for /1 processing -ea */

  } FP;

typedef struct DDPT_Structure /* see floppy.c for understanding this */
{
  unsigned step_rate : 4 ;       /* 0, HI4 */
  unsigned head_unload_time : 4; /* 0, LO4 */
  unsigned head_load_time : 7;   /* 1, HI7 */
  unsigned dma_flag : 1;         /* 1, LO1 */
  unsigned post_rt_of_disk_motor : 8; /* 2 */
  unsigned sector_size : 8;           /* 3 */
  unsigned sectors_per_cylinder : 8;  /* 4 */
  unsigned gap3_length_rw : 8;   /* !!!  5 */
  unsigned dtl : 8;              /* !!!  6 */
  unsigned gap3_length_xmat : 8; /* !!!  7 */
  unsigned fill_char_xmat : 8;        /* 8 */
  unsigned head_settle_time : 8;      /* 9 */
  unsigned run_up_time : 8;           /* a */
} DDPT;

/* Is this really correct??? RBIL 61 table 01787 looks VERY different */
/* for the FAT32 case! */
typedef struct DPB_Structure {
  /* Standard DPB */
  unsigned char drive_number;			/* 00 */
  unsigned char device_driver_unit_number;	/* 01 */
  unsigned int  bytes_per_sector;		/* 02 */
  unsigned char sectors_per_cluster_minus_one;	/* 04 */
  unsigned char sectors_per_cluster_power_two;	/* 05 */
  unsigned int  beginning_fat_sector;		/* 06 */
  unsigned char number_fat_copies;		/* 08 */
  unsigned int  number_root_directory_entries;	/* 09 */ /* 0 for FAT32? */
  unsigned int  first_data_cluster;		/* 0b */
  unsigned int  number_clusters_plus_one;	/* 0d */
  unsigned int  sectors_per_fat;		/* 0f */ /* 0 for FAT32 */
  unsigned int  first_root_directory_sector;	/* 11 */
  unsigned long device_driver_address;		/* 13 */
  unsigned char media_descriptor;		/* 17 */

  unsigned char dpb_access_flag;		/* 18 */
  unsigned long next_dpb_pointer;		/* 19 */
  unsigned int  last_cluster_allocated;		/* 1d */
  unsigned int  number_free_clusters;		/* 1f */
  /* FAT32 DPB */
  unsigned int  number_free_clusters_high;	/* 21 */
  unsigned int  mirroring_flags;		/* 23 */ /* WORD! */
    /* bits 15..8 reserved 7 donotmirrorfat 6..4 reserved 3..0 activefat */
  unsigned int  info_sector_number;		/* 25 */ /* -1 for none */
  unsigned int  backup_boot_sector_number;	/* 27 */ /* -1 for none */
  unsigned long first_sector_number_first_clust; /* 29 */ /* dword */
  unsigned long max_clust_number;		/* 2d */  /* dword */
  unsigned long number_sectors_per_fat;		/* 31 */  /* dword */
  unsigned long root_dir_start_cluster;		/* 35 */  /* dword */
  unsigned long free_space_start_cluster;	/* 39 */  /* dword */
  } DPB;

typedef struct Track_Address_Field_Structure
{
  unsigned cylinder : 8;
  unsigned head : 8;
  unsigned sector : 8;
  unsigned size_code : 8; /* 2 for 512 bytes */
} TAF;

typedef struct Low_Level_Format_Values_Structure
{
  int interleave_factor;
  int interleave_index;
  int interleave_map[64];
} LLFVS;

typedef struct Parameter_Block_Structure
{
  unsigned use_current_bpb           :  1;
  unsigned use_track_layout_fields   :  1;
  unsigned all_sectors_same_size     :  1;
  unsigned reserved                  :  5;

  unsigned device_type               :  8;
  unsigned device_attributes         : 16;
  unsigned number_of_cylinders       : 16;
  unsigned media_type                :  8;
  /* BPB Follows */
  unsigned bytes_per_sector          : 16;	/* 00 */ /* BPB offset */
  unsigned sectors_per_cluster       :  8;	/* 02 */
  unsigned reserved_sectors          : 16;	/* 03 */
  unsigned number_of_fats            :  8;	/* 05 */
  unsigned root_directory_entries    : 16;	/* 06 */
  unsigned total_sectors             : 16;	/* 08 */ /* 0 if > 32 MB */
  unsigned media_descriptor          :  8;	/* 0a */
  unsigned sectors_per_fat           : 16;	/* 0b */ /* 0 for FAT32 */
  unsigned sectors_per_cylinder      : 16;	/* 0d */
  unsigned number_of_heads           : 16;	/* 0f */
  unsigned hidden_sectors_low        : 16;	/* 11 */
  unsigned hidden_sectors_high       : 16;	/* 13 */ /* if DOS 3+ */
  unsigned large_sector_count_low    : 16;	/* 15 */ /* if > 32 MB */
  unsigned large_sector_count_high   : 16;	/* 17 */ /* same. DOS 4+ */
	/* DOS 4 actually uses a word at 1f for number of cylinders */
	/* and a byte after that for the type, then a word for flags */
	/* DOS 5+ no longer has those fields, though */

  /* FAT32 BPB Follows */
  unsigned sectors_per_fat_low       : 16;	/* 19 */ /* FAT < 16 MBy, so */
  unsigned sectors_per_fat_high      : 16;	/* 1b */ /* not really used  */
  unsigned ext_flags                 : 16;	/* 1d */ /* WORD! */
    /* bit 15..8 reserved, 7 donotmirrorfats 6..4 reserved 3..0 activefat */
  unsigned file_sys_ver_minor        :  8;	/* 1f */
  unsigned file_sys_ver_major        :  8;	/* 20 */
  unsigned root_dir_start_clus_low   : 16;	/* 21 */
  unsigned root_dir_start_clus_high  : 16;	/* 23 */
  unsigned file_sys_info_sec         : 16;	/* 25 */ /* or -1 */
  unsigned backup_boot_sec_num       : 16;	/* 27 */ /* or -1 */
  unsigned char fat32_bpb_reserved   [12];	/* 29 */

  /* Ending of parameter block */
  unsigned char reserved_2           [32];
  unsigned char reserved_3           [64];  /* Slack...shouldn't be used. */
  /* do not use // style comments for Turbo C 2.01 ! -ea */
} PB;


EXTERN AF access_flags; /* removed far keyword -ea */
EXTERN DPB far *dpb;
EXTERN DS drive_statistics;
EXTERN FP param;
EXTERN PB parameter_block;
EXTERN DDPT far *ddpt;
EXTERN LLFVS low_level;

typedef struct Get_ExtDPB_Data_Buffer
{
  unsigned int buffer_length;
  DPB          ext_dpb;
}GE_DPD_DB;

EXTERN GE_DPD_DB ext_parameter_block;


