/*
// Program:  Format
// Version:  0.91d
// (0.90b/c/d fixing compiler warnings - Eric Auer 2003)
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  uformat.c
// Module Description:  Unconditional Format Functions
*/

#define UFORMAT

#include "format.h"
#include "uformat.h"
#include "floppy.h"
#include "driveio.h"
#include "userint.h"

void Unconditional_Floppy_Format(void);
void Unconditional_Hard_Disk_Format(void);
void Compute_Sector_Skew(void);

/* Unconditionally Format the Drive */
void Unconditional_Format()
{
  bad_sector_map_pointer=0;

  if (param.drive_type==FLOPPY) {
    Unconditional_Floppy_Format();
  } else {
    Unconditional_Hard_Disk_Format();
  }
}

void Unconditional_Floppy_Format()
{
  int index;
  int buggy;
  unsigned long percentage;
  int drive_number;

  index = 0;
  buggy = 0;

  /* Reset the floppy disk controller */
  drive_number = param.drive_number;
  regs.h.ah = 0x00;
  regs.h.dl = drive_number;
  int86( 0x13, &regs, &regs);


  /* Set huge_sector_buffer to all 0xf6's. */
  memset(huge_sector_buffer_0, 0xf6, sizeof(huge_sector_buffer_0));
  memset(huge_sector_buffer_1, 0xf6, sizeof(huge_sector_buffer_1));
  /* both! 0.91d */

  do
    {
    buggy += Format_Floppy_Cylinder(index,0);
    if (drive_specs[param.media_type].number_of_heads==2)
      buggy += Format_Floppy_Cylinder(index,1);
    /* old version only used 2nd head if heads != 2        */
    /* now using only 1st head if heads != 2, correct? -ea */

    if ((index==0) && (buggy>0)) /* -ea */
      {
      printf("Format error in track 0, giving up.\n");
      exit(23);
      }

    percentage =
      ((100*index)/(drive_specs[param.media_type].cylinders));

    Display_Percentage_Formatted(percentage);

    Compute_Sector_Skew();

    index++;
    } while (index < drive_specs[param.media_type].cylinders);
    /* must be < not <= (formatted one track too much in 0.91 ! */

    if (buggy>0)
      printf("Found %d bad sectors during formatting.\n", buggy);
}

void Unconditional_Hard_Disk_Format()
{
  /* int error_code; */
  int number_of_sectors;

  int percentage_refresh_rate=10;
  int percentage_refresh_counter=10;

  unsigned index=0;

  unsigned long last_bad_sector;
  unsigned long sector_number;
  unsigned long percentage;

  unsigned long max_logical_sector
   = drive_specs[param.media_type].total_logical_sectors;
  long int badsec1 = 0; /* -ea */
  long int badsec2 = 0; /* -ea */

  number_of_sectors = sizeof(huge_sector_buffer_0)>>9; /* -ea */
  if (number_of_sectors < 1) {
    printf("huge_sector_buffer not available???\n");
    number_of_sectors = 1; /* use small sector_buffer */
  }

  bad_sector_map_pointer = 0;
  last_bad_sector = 0xffffffffUL;
  sector_number = 1; /* start after boot sector */

  for (index = 0; index < MAX_BAD_SECTORS; index++)
    bad_sector_map[index] = 0;

  /* Clear and check for bad sectors (maximum of 1 buffer full at a time) */
  printf(" Zapping / checking %ld sectors\n", max_logical_sector); /* -ea */
  do
    {

#if 0 /* to be removed in 0.91d ? */
    /* Set huge_sector_buffer to all 0xf6's. */
    memset(huge_sector_buffer_0, 0xf6, sizeof(huge_sector_buffer_0));
    memset(huge_sector_buffer_1, 0xf6, sizeof(huge_sector_buffer_1));
    /* both! 0.91d */
    if (number_of_sectors == 1) {
      memset(sector_buffer_0, 0xf6, sizeof(sector_buffer_0));
      memset(sector_buffer_1, 0xf6, sizeof(sector_buffer_1));
    } /* even those 2! 0.91d */
#else /* 0.91d version */

    /* clear small buffer (used if number_of_sectors == 1) */
    for (index=0; index < (number_of_sectors<<9); index++) {
      sector_buffer[index] = 0xf6;
    }
    
    /* also clear big buffer (used in all other cases) */
    for (index=0; index < (number_of_sectors<<9); index++) {
      huge_sector_buffer[index] = 0xf6;
    }
    
#endif

    if ((sector_number + number_of_sectors) > max_logical_sector) {
      /* clip last chunk -ea */
      if ( (max_logical_sector - sector_number) > 32767L ) {
        printf("Hu??? Last chunk size > 32767 sectors??? Please report!\n");
      }
      Drive_IO(WRITE, sector_number, (int)(max_logical_sector - sector_number));
      Drive_IO(READ,  sector_number, (int)(max_logical_sector - sector_number));
    } else {
      Drive_IO(WRITE, sector_number, number_of_sectors);
      Drive_IO(READ,  sector_number, number_of_sectors);
    }

    /* Check for bad sectors by comparing the results of the sector read. */
    index=0;
    do
      {
      if (  ( (number_of_sectors>1)  && (huge_sector_buffer[index] != 0xf6) )
         || ( (number_of_sectors==1) && (sector_buffer[index] != 0xf6) ) )
	{

        if ( ( sector_number + (index >> 9) ) < 5 ) /* new 0.91d */
          {
          printf("One of the first 5 sectors is broken. FORMAT not possible.\n");
          exit(47);
          }

	if ( last_bad_sector != ( sector_number + (index >> 9) ) )
	  {
	  bad_sector_map[bad_sector_map_pointer]
	    = sector_number + (index >> 9); /* not (index+1)! 0.91d */

	  bad_sector_map_pointer++; /* fixed in 0.91c */
	  if (bad_sector_map_pointer >= MAX_BAD_SECTORS) /* new in 0.91c */
	    {
	    printf("Too many bad sectors! FAT bad sector map will be incomplete!\n");
	    bad_sector_map_pointer--;
	    } /* too many bad sectors */

	  badsec1++; /* -ea */
	  } /* new bad sector */

	} /* any bad sector */

      index++;
      } while (index < (number_of_sectors<<9) ); /* one buffer full */
      /* size of buffer was assumed to be 32*512 (wrong!) 0.91d */

    if (percentage_refresh_counter==0)
      {
      percentage=(100*sector_number)/max_logical_sector;
      Display_Percentage_Formatted(percentage);
      if (badsec1 != 0) { /* added better output -ea */
        printf("\n [errors found]\n");
        badsec2 += badsec1;
        badsec1 = 0;
      }
      }
    if (percentage_refresh_counter==percentage_refresh_rate)
      percentage_refresh_counter=-1;
    percentage_refresh_counter++;

    sector_number += 32;
    
    } while (sector_number<max_logical_sector);
    
    badsec2 += badsec1;
    if (badsec2>0) {
      printf("\n %lu errors found.\n", badsec2);
    } else {
      printf("\n No errors found.\n");
    }

}
