/*
// Program:  Free FDISK
// Module:  CMD.CPP
// Module Description:  Command Line Switch Code Module
//                      All functions that process command line entry are
//                      here.
// Written By:  Brian E. Reifsnyder
// Version:  0.98 (Pre 2)
// Copyright:  1998-2000 under the terms of the GNU GPL
*/

/*
/////////////////////////////////////////////////////////////////////////////
//  INCLUDES
/////////////////////////////////////////////////////////////////////////////
*/

//#include <dir.h>
#include <conio.h>
#include <ctype.h>
//#include <bios.h>
//#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fdisk.h"

/*
/////////////////////////////////////////////////////////////////////////////
//  PROTOTYPES
/////////////////////////////////////////////////////////////////////////////
*/

/* External Prototype Declarations */
/* ******************************* */
//extern int Create_Logical_Drive(int numeric_type, long size_in_MB);
extern int Create_Primary_Partition(int numeric_type,long size_in_MB);
//extern int Determine_Drive_Letters();
extern int Partition_Type_To_Create(unsigned long size_in_mb);
extern int Read_Partition_Tables();
extern int Write_Partition_Tables();

//extern long double far Translate_CHS_To_LBA(unsigned long cylinder
// ,unsigned long head,unsigned long sector,unsigned long total_heads
// ,unsigned long total_sectors);

extern void Ask_User_About_FAT32_Support();
extern void Clear_Screen(int type);
extern void Display_All_Drives();
extern void Display_CL_Partition_Table();
extern void Interactive_User_Interface();
extern void Modify_Partition_Type(int partition_number,int type_number);

//extern void Clear_Extended_Partition_Table(int drive);
//extern void Convert_Long_To_Integer(long number);
extern void Determine_Free_Space();
//extern void Pause();
extern void Print_Centered(int y,char *text,int style);
//extern void Position_Cursor(int row,int column);
extern void Set_Active_Partition(int partition_number);

/* Module Prototype Declarations */
/* ***************************** */
int Get_Options(char *arguments[],int number_of_arguments);

void Command_Line_Create_Primary_Partition();
void Command_Line_Info();
void Command_Line_Status();
void Command_Line_X();

/*  Rem'd out...Left because some prototypes may still be needed when all
    the command line functions have been re-added.

int Get_Hard_Drive_Parameters(int physical_drive);
int Read_Physical_Sector(int drive, long cylinder, long head, long sector);
int Read_Physical_Sector_CHS(int drive,long cylinder, long head, long sector);
int Read_Physical_Sector_LBA(int drive,long cylinder, long head, long sector);
int Write_Physical_Sector(int drive, long cylinder, long head, long sector);
int Write_Physical_Sector_CHS(int drive, long cylinder, long head, long sector);
int Write_Physical_Sector_LBA(int drive, long cylinder, long head, long sector);

long double Translate_CHS_To_LBA(unsigned long cylinder,unsigned long head
 ,unsigned long sector,unsigned long total_heads,unsigned long total_sectors);

unsigned long Decimal_Number(unsigned long hex1, unsigned long hex2, unsigned long hex3, unsigned long hex4);

void Automatically_Partition_Hard_Drive();
void Clear_Boot_Sector(int drive,long cylinder,long head,long sector);
void Clear_Flag(int flag_number);
void Clear_Partition_Table();
void Clear_Partition_Table_Area_Of_Sector_Buffer();
void Clear_Sector_Buffer();
void Check_For_INT13_Extensions();
void Create_Alternate_MBR();
void Create_BootEasy_MBR();
void Create_MBR();
void Create_MBR_If_Not_Present();
void Get_Partition_Information();
void Remove_MBR();
void Save_MBR();

/*
/////////////////////////////////////////////////////////////////////////////
//  FUNCTIONS
/////////////////////////////////////////////////////////////////////////////
*/

/* /PRI and /PRIO command line options */
void Command_Line_Create_Primary_Partition()
{
  Determine_Free_Space();
  Set_Active_Partition(
   Create_Primary_Partition(
   Partition_Type_To_Create(arg[0].value),arg[0].value));

  Write_Partition_Tables();
  exit(0);
}

/* /INFO command line option */
void Command_Line_Info(int number_of_options)
{
  if( (number_of_options==2) && (0==strcmp(arg[1].choice,"TECH")) )
   flags.extended_options_flag=TRUE;
  if( (number_of_options==2) && (0!=strcmp(arg[1].choice,"TECH")) )
    {
    printf("\nSyntax Error...Operation Terminated.\n");
    exit(1);
    }

  Display_CL_Partition_Table();
  exit(0);
}

/* /MODIFY command line option */
void Command_Line_Modify()
{
  if((arg[0].value<1) || (arg[0].value>4))
    {
    printf("\nPrimary partition number is out of range...Operation Terminated.\n");
    exit(9);
    }

  if((arg[0].extra_value<=0) || (arg[0].extra_value>255))
    {
    printf("\nNew partition type is out of range...Operation Terminated.\n");
    exit(9);
    }

  Modify_Partition_Type((arg[0].value-1),arg[0].extra_value);

  Write_Partition_Tables();
  exit(0);
}

/* /STATUS command line option */
void Command_Line_Status()
{
  flags.monochrome=TRUE;
  textcolor(7);
  Clear_Screen(NULL);
  Print_Centered(1,"Fixed Disk Drive Status",0);
  Display_All_Drives();
}

/* /X command line option */
void Command_Line_X()
{
  int index;

  /* Ask the user if FAT32 is desired. */
  if( (flags.version==W95B) || (flags.version==W98) )
   Ask_User_About_FAT32_Support();

  flags.use_extended_int_13=FALSE;
  index=0;
  do
    {
    part_table[index].ext_int_13=FALSE;
    index++;
    }while(index<8);

  Read_Partition_Tables();
  Interactive_User_Interface();
  exit(0);
}

/* Get the command line options */
int Get_Options(char *arguments[],int number_of_arguments)
{
  char value[6];
  char extra_value[3];

  int clearing_loop;
  int line_index;
  int loop;
  int option_index=0;
  int number_of_options=number_of_arguments-1;
  int variable;
  int variable_index;

  int CHOICE=1;
  int VALUE=2;
  int EXTRA_VALUE=3;

  flags.drive_number=0x80;
  if(number_of_options==0) return(number_of_options);

  /* Limit the possible number of options to 10 to prevent an overflow of */
  /* the arg[] structure.                                                 */
  if(number_of_options>10) number_of_options=10;

  loop=1;
  do
    {
    /* Clear value[6] and extra_value[3] */
    clearing_loop=0;
    do
      {
      value[clearing_loop]=0;
      if(clearing_loop<3) extra_value[clearing_loop]=0;
      clearing_loop++;
      }while(clearing_loop<6);

    if(loop==2)
      {
      /* Get the drive number */
      flags.drive_number=((arguments[loop] [0])-48)+127;
      option_index--;
      }

    if(loop!=2)
      {
      line_index=1;
      variable=CHOICE;
      variable_index=0;
      do
	{
	if( (variable==CHOICE) && (arguments[loop][line_index]!=':')
	 && (variable_index<10) )
	  {
	  arg[option_index].choice[variable_index]=arguments[loop][line_index];
	  arg[option_index].choice[variable_index]
	   =toupper(arg[option_index].choice[variable_index]);
	  }

	if( (variable==CHOICE) && (arguments[loop][line_index]==':') )
	  {
	  variable=VALUE;
	  variable_index=0;
	  line_index++;
	  }

	if( (variable==VALUE) && (arguments[loop][line_index]!=',') )
	  {
	  if( (variable_index<6) && ( (arguments[loop][line_index]>='0')
	   && (arguments[loop][line_index]<='9') ) )
	    {
	    value[variable_index]=arguments[loop][line_index];
	    }
	  }

	if( (variable==VALUE) && (arguments[loop][line_index]==',') )
	  {
	  variable=EXTRA_VALUE;
	  variable_index=0;
	  line_index++;
	  }

	if(variable==EXTRA_VALUE)
	  {
	  if( (variable_index<3) && ( (arguments[loop][line_index]>='0')
	   && (arguments[loop][line_index]<='9') ) )
	    {
	    extra_value[variable_index]=arguments[loop][line_index];
	    }
	  }

	variable_index++;
	line_index++;
	}while(line_index<strlen(arguments[loop]));
      }

    if( (value!=NULL) && (loop!=2) )arg[option_index].value=atol(value);

    if( (extra_value!=NULL) && (loop!=2) )
     arg[option_index].extra_value=atoi(extra_value);

    option_index++;
    loop++;
    }while(loop<=number_of_options);

  if(number_of_options>=2) number_of_options--;

  /* check to make sure the drive is a legitimate number */
  if( (flags.drive_number<0x80) || (flags.drive_number>flags.maximum_drive_number) )
    {
    printf("\nInvalid drive designation...Operation Terminated.\n");
    exit(5);
    }

  return(number_of_options);
}

