program FDISK; {my version of the Fixed DISK utility}
{$M 20800,0,655300}
{$E+}{$N+}{$G-}
{$DEFINE EXPERT}

uses DOS,
     PCstuff,
     MsaTools,
     FDiskUnit,
     CRT;

const
  ProgramName   = 'FDISK';
  CommandSyntax = '[command]';
  ValidOptions  = '/@:commandfile/Fix/MBR/Status';
  WhatItDoes    = 'Fixed disk partition table control and diagnostics utility.';
  WizardMode    : boolean = false;
const
  FatTypes = [1,4,6,$81,$84,$86,$C1,$C4,$C6];
const MainOptions : OptionsType = (
                   'New partition',
                   'Boot from... (select active partition)',
                   'Delete a partition (and all its data!)',
                   'List all primary & logical partitions',
                   'Pick physical disk',
                   'Find and fix faults in partitions',
{$IFDEF EXPERT}
                   'eXtra for experts (resize, type-change, etc) ',
{$ELSE}
                   '',
{$ENDIF}
                   '');

procedure ExplainWhatItDoes;
var i,j,k : byte;
begin
outputline(ProgramName+' version '+Version+' '+CopyrightNotice);
outputline(^J'Usage: '^M^J' '+ProgramName+' [options] '+CommandSyntax);
outputline(^J'Options:'^M^J' /?'+ValidOptions);
writeln(^J'Purpose:'^M^J,WhatItDoes);
writeln('This program is normally used in interactive mode, but you can use these');
writeln('interactive commands:');
for i:=1 to 6 do if i<>5 then
    begin
    st:=MainOptions[i]; j:=pos(' ',st); k:=pos('(',st);
    if st[j-1]=',' then dec(j);
    writeln(ProgramName,' ',capitals(copy(st,1,j)),' [parameters] ',copy(st,k,70):59-j);
    end;
writeln(ProgramName,' SAVE filename [MBR|driveletter:|startcyl endcyl]');
writeln(ProgramName,' LOAD filename [MBR|driveletter:|startcyl [endcyl]]');
end;

{$F+}
procedure MyInterrupt13(Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP: Word); interrupt;
begin
Flags:=0;
PhysicalStart:=hi(DX)*65536+CX;
PhysicalDrive:=lo(DX);
end;
{$F-}

procedure DoCommand(command : string); forward;

function hex2(w : word) : string;
const
   digit : array[0..$F] of char = ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
var b : byte;
   st : string[4];
begin
st:='0000';
for b:=1 to 4 do st[b]:=digit[(w shr (16-4*b)) and $0F];
hex2:=st;
end;

function ok(PartitionNumber : integer) : char;
var i,parent,n : word;
begin
ok:=' '; error:=0;
{$R+}
with PartitionsOn[Drive and 31]^[PartitionNumber],RawEntry do
     begin
     if not ((StartSide and 63) in [0..PhysicalHeads-1]) then error:=error or 1;
     if not ((StartSector and 63) in [0..MaxPhysicalSector]) then error:=error or 2;
	  if (StartCyl<0) or ((StartCyl+256*((StartSector shr 6)+4*(StartSide shr 6)))>PhysicalCyl) then error:=error or 4;
     if Parent>0
        then if RelSect<>AbsoluteSector(StartCyl,StartSide,StartSector)-PartitionsOn[Drive and 15]^[parent].FirstSector
                then begin if System<>5 then error:=error+$10; end;
     if NumberOfSectors<>1+AbsoluteSector(EndCyl,EndSide,EndSector)-AbsoluteSector(StartCyl,StartSide,StartSector)
        then begin error:=error+$20; end;
     end;
if error<>0 then
   begin
   ok:='*'; {TextAttr:=Red;}
   FaultyPartitions:=FaultyPartitions+chr(PartitionNumber);
   end;
end;

procedure StoreDriveSpecs(drive : integer);
const four = 4;
var bar,st,p: string[80];
    i : integer;
    n,
    total,
    SectorsPerUnit,
    BytesPerSector : real;
    reg            : registers;
    AX2,BX2,CX2,DX2: word;
    RealDrive      : integer;
    FreeSpace      : real;
    S2             : SearchRec;
    Dir  : DirStr;
    Name : NameStr; Ext : ExtStr;
begin
BadClusters:=-1; Contiguous:=0;
CanonicalForm:=Canonical(chr(64+drive)+':\');
RealDrive:=(ord(CanonicalForm[1])and 31);
with reg do begin
            AX:=$3600;
            DX:=drive;
            freespace:=DiskFree(Drive);
            n:=freespace;
            MsDos(reg);
            GetIntVec($13,OldInterrupt13);
            SetIntVec($13,@MyInterrupt13);
            PhysicalDrive:=$FF;
            fillchar(Bootsector,sizeof(bootsector),0);
            if (not Dos_ReadSector(drive-1,0,1,BootSector)) or (BootSector.SystemID=#0#0#0#0#0#0#0#0)
               then if not Dos_ReadSector(RealDrive-1,0,1,BootSector) then;
            SetIntVec($13,OldInterrupt13);
            with DriveDetails[char(64 + drive)] do
                 begin
                 CX:=word(PhysicalStart);
                 DH:=byte(PhysicalStart shr 16);
                 DL:=PhysicalDrive;
                 end;
            if Bootsector.SystemID='ADDSTOR'
               then Message('Compressed partition; estimates used.');
            end;
end;

procedure DisplayPartition(i : integer; Scroll : byte);
const ScrollBar : char = '';
begin
if Scroll=0 then ScrollBar:=' '
            else begin
                 ScrollBar:='';
                 end;
with PartitionsOn[Drive and 15]^[i],RawEntry do
     begin
     if (WhereY+hi(WindMin)>13)
        then if (i>Part) then exit
                         else begin
                              gotoXY(1,6); DelLine; gotoXY(1,14);
                              RowPart:=copy(RowPart,2,99)+#0;
                              end;
     RowPart[whereY+hi(WindMin)]:=chr(i);
     if TabMode and (i=part)
        then TextAttr:=$70
        else TextAttr:=3;
     write(i); if i<10 then write(' ');
     TextAttr:=7; write(' ');
     TextAttr:=3;
	  st:=CurrentDosName;
     if st<>NewDosName then;
     if st='' then st:=ThisLinuxName;
     start:='('+decimal((StartSector and $C0)*4+StartCyl);
     finish:='('+decimal((EndSector and $C0)*4+EndCyl);
     if System=0
        then begin
             write(ThisLinuxName); TextAttr:=7;
             if StartSector=0
							 then st:=' is not used'
							 else begin
                                  st:=' Deleted; was:';
                                  if Bootable<>0 then st:=st+' type '+hex(Bootable);
                                  st:=st+' ('+fmt((StartSector and $C0)*4+StartCyl,4)+'/'+fmt(StartSide,2)+'/'+
										 fmt(StartSector and $3F,2)+') -> ('+fmt((EndSector and $C0)*4+EndCyl,4)+'/'+fmt(EndSide,2)+'/'+
										 fmt(EndSector and $3F,2)+')';
                                  end;
				 write(st,'':79-whereX-length(st));
             if ScrollBar>' '
                then begin TextAttr:=$70; writeln(ScrollBar); TextAttr:=7; end
                else writeln;
             end
        else begin
             if Description=''
                     then begin
                          Description:=PartitionTypeName(System,StartCyl,StartSide,StartSector);
                          end;
             write(st:4,start:7,'/',StartSide:2,'/',(StartSector and $3F):2,') ->',finish:5,
             '/',(EndSide):2,'/',(EndSector and $3F):2,')');
             write(NumberOfSectors*512.0/1048576:7:1,' Mb');
             write(ok(i)+BootableStatus(Bootable));
             write(' '+hex(System)+' '+copy(Description,1,21));
             if ScrollBar<>' '
                then begin gotoXY(79,whereY); TextAttr:=$70; writeln(scrollbar); TextAttr:=5 end
                else writeln;
             end;
     TextAttr:=LightCyan;
     if (System in [1,4,6,$81,$84,$86,$C1,$C4,$C6]) then PrimaryDosExists:=true;
     end;
end;

function LogicalPartitionsExist : boolean;
var k : integer;
begin
LogicalPartitionsExist:=false;
for k:=1 to MaxPartition do with PartitionsOn[Drive]^[k] do
    if not (RawEntry.system in [0,5])
		 then begin LogicalPartitionsExist:=true; exit; end;
end;

function DescribeContents(SystemID,FirstSector : longint) : string;
var Buffer : Dos_BootSector;
begin
ReadLong(FirstSector,Buffer);
with Buffer,BPB do
	  if FormatID=$F8
		  then begin
				 DescribeContents:=' a '+TryToString(FatWhatever)+' partition; label: '+TryToString(VolumeLabel)
				 end
		  else DescribeContents:='some stuff I don''t understand';
end;

procedure DisplayPartitionTable;
var i,j,n : integer;
	 ThisDriveLetter : char;
begin
window(1,2,80,15);
TextAttr:=LightCyan;
CRT.ClrScr;
fillchar(RowPart[1],length(RowPart),0);
window(1,1,80,25);
gotoXY(1,3); TextAttr:=11;
write('    Partitions on the ');
TextAttr:=15; write(nth(drive+1));
TextAttr:=11; write(' hard disk (');
if NeedToRead then
	begin
	GetDriveParameters($80+drive);
	FaultyPartitions:='';
	ReadPartitionTable;
	end;
ClrEOL;
if pos('SCSI',st)>0
	then LinuxName:='sd'+chr(97+max(0,drive-FirstScsiDrive))
	else LinuxName:='hd'+chr(97+drive);
TextAttr:=White; write(LinuxName);
TextAttr:=11; write('):',' ':5-length(LinuxName));
{PartitionNumberList:=#1#2#3#4;}
ScrollOffset:=0;
st:=DiskDescription;
if st[1]=' ' then delete(st,1,1);
if st='no disk'
	then begin TextAttr:=TextAttr+$80; write(st); TextAttr:=TextAttr and $7f; writeln(' (try the '#27' key!)') end
	else writeln(st,' (',(PhysicalCyl):3,'x',(PhysicalHeads),'x',MaxPhysicalSector:2,'= ',
			  TotalPhysicalSectors*512.0/1048576:4:0,' Mb)');
TextAttr:=3;ClrEOL;
CRT.gotoXY(1,4); write('# '); TextAttr:=7; write('');
TextAttr:=3; write(' Name  (cyl/hd/sct) -> (cyl/hd/sct)  Size  Boot Type  {system} ');
TextAttr:=11; writeln('');
TextAttr:=7; write('');
if ListLogical in ListAllMode then
   begin TextAttr:=$70; writeln(#30); end
   else writeln(' ');
ThisDriveLetter:=LinuxName[3];
inc(ThisDriveLetter,2);
TextAttr:=white;
for i:=1 to 9 do
    begin
    gotoXY(1,i+5);
    ClrEOL;
    end;
window(1,6,80,15);
CRT.gotoXY(1,1);
if (ListLogical in ListAllMode) and (ScrollOffset=0) then
   begin
   ScrollOffset:=max(1,Part-7);
   end;
for i:=1 to 4 do with PartitionTable,Partition[i] do
    begin
    TextAttr:=Cyan;
    ClrEOL; {$R-}
    if Not (ListLogical in ListAllMode)
       then DisplayPartition(i,0)
       else if (System<>0)
               then DisplayPartition(i,ScrollOffset);
    end;
TextAttr:=LightRed;
{ReadPartitionTable; {!!!?}
if (ListLogical in ListAllMode)
   then begin
        {PartitionNumberList:='';}
        for i:=1 to MaxPartition do with PartitionsOn[Drive and 15]^[i],RawEntry do
            if (System<>0) or (ListEmpty in ListAllMode) or (i=Part)
               then if (i<=4) or not (System in ExtendedTypes)
                       then begin
                            {PartitionNumberList:=PartitionNumberList+chr(i);}
                            end;
        for i:=5 to MaxPartition do with PartitionsOn[Drive and 15]^[i],RawEntry do
            begin
            ClrEOL; {$R-}
            TextAttr:=LightCyan;
            if (System in FatTypes) then PrimaryDosExists:=true;
            if System in ExtendedTypes
               then begin
                    if (ListExtended in ListAllMode) then DisplayPartition(i,ScrollOffset);
                    end
               else if System=0 then
                    begin
                    if (ListEmpty in ListAllMode) or (i=Part)
                       then DisplayPartition(i,ScrollOffset);
                    end
               else DisplayPartition(i,ScrollOffset);
            end;
        write('':78);
        TextAttr:=$70; write(#31);
        end;
window(1,1,80,25);
gotoXY(1,16);
TextAttr:=LightRed;
(*if FaultyPartitions<>'' then writeln(' * There are faults in the partition table; use F6 to fix them')
                        else writeln;
*)
end;

function NextWord : string;
var st : string;
begin
if (ThisParameter<ParametersInList)
   then begin
        st:=Parameter[ThisParameter]^;
        if st[length(st)]=';'
           then begin dec(st[0]); if st<>'' then delete(Parameter[ThisParameter]^,1,length(st)-1); end
           else inc(ThisParameter);
        NextWord:=st;
        end
   else NextWord:='';
end;

function LookupDriveLetter(c : char) : integer;
var p : integer;
begin
for p:=1 to MaxPartition do
    with PartitionsOn[Drive and 15]^[p] do
         if c=CurrentDosName[1]
            then begin LookupDriveLetter:=p; exit; end;
LookupDriveLetter:=0;
end;

function LookupLinuxName(st : string) : integer;
var p : integer;
begin
st:=capitals(st);
if copy(st,1,4)='/DEV' then delete(st,1,4);
if st[1]='/' then delete(st,1,1);
for p:=1 to MaxPartition do
    with PartitionsOn[Drive and 15]^[p] do
         if st=capitals(ThisLinuxName)
            then begin LookupLinuxName:=p; exit; end;
LookupLinuxName:=0;
end;

function AskPartition(Prompt : string) : string;
const
    Doodle : byte = 1;
var k,row,col : byte;
    st,st2,sd : string[22];
begin
TurnOnMouseCursor;
TextAttr:=Yellow;
CRT.gotoXY(1,18);
write(Prompt);
ClrEOL;
col:=whereX; row:=whereY;
TextAttr:=White;
Highlight(Part);
st:='';
repeat cursoroff;
       window(1,1,80,25);
       if Part=0 then sd:='hard disk '+decimal(Drive)+' info '
                 else sd:='accept partition '+decimal(Part)+' ';
       StatusLine(' '#25#24' select partition  '#26#27' select disk  ENTER='+sd+' ESC=quit');
       TextAttr:=White;
       while not keypressed do
             begin
             if LastMode=CO80
                then begin
                     mem[$B800:(15*80+Doodle)*2-1]:=LightBlue;
                     mem[$B800:(15*80+Doodle)*2+1]:=LightCyan;
                     mem[$B800:(15*80+Doodle)*2+3]:=15;
                     mem[$B800:(15*80+Doodle)*2+5]:=LightCyan;
                     Doodle:=byte(TimerTicks) and 127;
                     end;
             st2:=ProcessMouseButton;
             if st2<=' ' then idle
                         else begin
                              Highlight(Part);
                              AskPartition:=st2; exit;
                              end;
             end;
       cursoron;
       st:=st+upcase(ReadKey);
       case st[length(st)] of
            ^M : begin
                 if Part<=0 then AskPartition:=''
                            else AskPartition:=decimal(Part);
                 exit;
                 end;
            ' ' : begin
                  str(Part:2,st); write(st);
                  Highlight(Part);
                  end;
            '+' : begin inc(Part); st:=''; end;
            '-' : begin dec(Part); st:=''; end;
            #127,^H : begin
                      dec(st[0],min(2,length(st)));
                      val(st,part,i);
                      end;
            #27,^C,^I,'?' : begin AskPartition:=st[length(st)]; exit;
                            end;
            #0: begin
                k:=ord(Readkey);
                case k of
                    75 : begin
                         if Drive>0 then dec(Drive);
                         NeedToRead:=true;
                         end;
                    77 : begin
                         inc(Drive);
                         NeedToRead:=true;
                         end;
                    80 : begin
                         if Part<MaxPartition then inc(Part);
                         end;
                    72 : begin
                         if Part>0 then dec(Part) else Part:=1;
                         end;
                    {else write(k:3);}
                    end;
                st:='';
                end;
            end;
       if st<>'' then
          begin
          val(st,part,i);
          if Part=0 then Part:=LookupLinuxName(st);
          if Part=0 then Part:=LookupDriveLetter(st[1]);
          end;
       DisplayPartitionTable;
       Highlight(Part);
       CRT.gotoXY(1,18);
       TextAttr:=Yellow;
       write(Prompt+' [');
       ClrEOL;
       TextAttr:=$70; 
       if st='' then if part=0 then write('  ')
                               else write(part:2)
                else if (pos(capitals(st[1]+st[2]),'HDSD')>0)
                        then write(st:5)
                        else write(st:2);
       TextAttr:=Yellow; write(']');
       until false;
end;

function FindPartition(SystemType : byte) : byte;
var i : byte;
begin
FindPartition:=0;
for i:=1 to 4 do with PartitionTable.Partition[i] do
    if System=SystemType then begin FindPartition:=i+1; exit; end;
end;

function SpaceLeft : string;
var i       : byte;
    cyl     : integer;
begin
st:='';
fillchar(UsedCyl,sizeof(UsedCyl),0);
for i:=1 to 4 do with PartitionTable.Partition[i] do
    if System>0 then
       for cyl:=(StartCyl+256*((StartSector shr 6)+4*(StartSide shr 6))) to
           (EndCyl+256*((EndSector shr 6)+4*(EndSide shr 6))) do UsedCyl[cyl]:=i;
for cyl:=0 to PhysicalCyl do
    if (UsedCyl[cyl]=0) and ((cyl=0) or (UsedCyl[cyl-1]>0))
       then st:=st+decimal(cyl)+' ';
SpaceLeft:=st;
end;

function AskType : string;
begin
AskType:='dunno';
end;

procedure ListSubPartitions(param : string);
begin
if param='' then case (ListLogical in ListAllMode) of
                      true:  ListAllMode:=[ListEmpty,ListExtended];
                      false: ListAllMode:=[ListLogical];
                      end
            else case upcase(param[1]) of
                      '1','Y','L' : ListAllMode:=[ListLogical];
                      'P','N' : ListAllMode:=[ListEmpty,ListExtended];
                      else move(param[1],ListAllMode,1);
                      end;
if RedirectedOutput
   then begin
        ListAllMode:=ListAllMode+[ListLogical];
        ReadPartitionTable;
        for i:=1 to MaxPartition do
        end;
if not (ListLogical in ListAllMode)
   then MainOptions[4]:='List all primary & logical partitions'
   else MainOptions[4]:='List without logical drives ("L" toggles)'
end;

procedure RewriteMBR(param : string);
begin
unimplemented
end;

procedure RepairPartitions(param : string);
begin
unimplemented;
end;

procedure SecurityOptions;
begin
unimplemented;
end;

procedure SetBootablePartition(n : byte);
var i,j : integer;
begin
Drive:=0;
with reg do begin
            AX:=$0201; CX:=1; DX:=$80+Drive;
            ES:=seg(PartitionTable); BX:=ofs(PartitionTable);
            fillchar(PartitionTable,sizeof(PartitionTable),0);
            intr($13,reg);
            if odd(flags) and (Drive<>0)
               then begin Drive:=0; exit; end;
            end;
for i:=1 to 4 do with PartitionTable.Partition[i] do
    begin
    Bootable:=Bootable and $7F;
    end;
inc(PartitionTable.Partition[n].Bootable,$80);
WriteSector($0001,$80,PartitionTable); {write MBR sector}
end;

var Section : array[0..99] of record size: integer;
                                     x,y : integer;
                                     Contents : string[64];
                                     end;
const ThisQ : integer = 0;
var   LastQ : integer absolute Section;
      PreviousQ : integer;
 
procedure wr(st : string);           {$R+}
var i,SaveAttr : byte;
begin
SaveAttr:=TextAttr;
for i:=1 to length(st) do
    case st[i] of
         '[' : begin
               TextAttr:=$79; write(' ');
               inc(LastQ);
               with Section[LastQ] do
                    begin X:=whereX; Y:=whereY; end;
               end;
         ']' : begin
               TextAttr:=SaveAttr; write(' ');
               with Section[LastQ] do
                    size:=whereX-X;
               end;
         else write(st[i]);
         end;
writeln;

end;

procedure BeginSection;
begin
fillchar(Section,sizeof(section),0);
LastQ:=0;
ThisQ:=0;
end;

procedure EndSection;
begin
 SetBorderColour(Black);
end;

function DetermineSlackFat(StartOfPartition : longint) : longint;
{find the last used sector in a (FAT) partition}
var j,k : word; lastused,n : longint;
  PhysicalSize,
  UsedClusters,
  BadClusters            : longint;
  OffsetToData           : longint;
  Contiguous             : word;
  Buffer    : array[0..512*4-1] of byte;
  Buffer2   : array[0..1023] of char;
  BootSector: Dos_BootSector absolute Buffer2;
var SectorsPerFat,SectorsPerCluster,BytesPerSector : word;
    FormatID  : byte;
    Fragmentation,
    FreeClusters, ContiguousClusters, TotalClusters,
    TotalSectors : longint;
    StateC    : boolean;
    BufferWord: array[0..((3*512) div 2)-1] of word absolute Buffer;
    TwelveBitFat : boolean;
    Nblocks,
    C,t0,
    entry     : word;
    w         : ^word;
    i         : longint;
    EBPB      : record spare : array[1..8] of byte;
	             BytesPerSector   : word; {normally 512; sometimes 128, 256, 1024}
	             SectorsPerCluster: byte; {or "sectors per allocation unit" - 1 for small diskettes}
	             ReservedSectors  : word; {normally 1, for the Boot sector; more if small sector size}
	             NumberOfFATs     : byte; {normally 2, DOS assumes 2 no matter what it says, except in VDISK}
	             RootEntries      : word; {size of root directory (32 bytes/entry)}
	             TotalSectors     : word; {DOS subtracts ReservedSectors & FAT space}
	             FormatID         : byte; {see Dos_360K etc}
	             SectorsPerFAT    : word; {2 for 360Kb, 7 for 1.2Mb}
	             SectorsPerTrack  : word; {e.g. 8, 9, 15, 26}
	             NumberOfSides    : word; {1 or 2 for diskettes}
	             SpecialReserved  : longint;
	             morejunk         : string[180];
	             end;
const
    Dos_360K     = $FD; {5.25" normal PC/XT: 9 sect/track, 40 tracks/side, 2 sides}
    Dos_320K     = $FF; {5.25" old (DOS 1) : 8 sect/track, 40 tracks/side, 2 sides}
    Dos_180K     = $FD; {5.25" old (DOS 1) : 9 sect/track, 40 tracks/side, 1 side}
    Dos_160K     = $FE; {5.25" old (DOS 1) : 8 sect/track, 40 tracks/side, 1 side}
    Dos_250K     = $FD; {8" old: 26 sect/track, 77 tracks/side, 1 side, 128 bytes/sect, 4sect/cluster}
    Dos_246K     = $FE; {a version of Dos_250K with 4 reserved sectors}
    Dos_616K     = $FE; {8" old: 8 sect/track, 77 tracks/side, 2 sides, 1024 bytes/sect, 4sect/cluster}
    Dos_Quad     = $F9; {Quad density: 9 or 15 sect/track, 80 tracks/side, 2 sides}
    Dos_720K     = $F9; {Quad density: 9 or 15 sect/track, 80 tracks/side, 2 sides}
    Dos_Hard     = $F8; {Fixed (hard) disk}
begin
FreeClusters:=0; ContiguousClusters:=0; TotalClusters:=0;
DosError:=0;
DetermineSlackFat:=-1;
fillchar(Bootsector,sizeof(bootsector),0);
LongBlockRead(StartOfPartition+0,@BootSector);
if false then with reg do
 	begin
 	fillchar(EBPB,sizeof(EBPB),0);
 	CX:=$0860;
 	DS:=seg(EBPB); DI:=ofs(EBPB)+1; DX:=DI;
 	AX:=$440D; BX:=drive+1; MsDos(reg);
 	if odd(flags) and (EBPB.BytesPerSector=0)
	   then begin ah:=$FF; exit; end
	   else if EBPB.SectorsPerCluster<>BootSector.BPB.SectorsPerCluster
	           then move(EBPB.BytesPerSector,BootSector.BPB.BytesPerSector,sizeof(BiosParameterBlock));
 	end;
with BootSector do
     begin
     with BPB do if BytesPerSector=0 then BytesPerSector:=512;
     with BPB do if SectorsPerCluster=0 then SectorsPerCluster:=1;
     with BPB do if TotalSectors=0
	  then TotalClusters:=BigTotalSectors div SectorsPerCluster
	  else TotalClusters:=TotalSectors div SectorsPerCluster;
     if (BPB.BytesPerSector<=0)
 	then begin WarningMessage('Invalid format'); exit; end
 	else BytesPerSector:=BPB.BytesPerSector;
     if not (BytesPerSector div 128 in [1,2,4,8])
 	then BytesPerSector:=512;
     SectorsPerCluster:=BPB.SectorsPerCluster;
     SectorsPerFAT:=BPB.SectorsPerFAT;
     with BPB do
	  begin
	  OffsetToData:=(ReservedSectors)
	               +(SectorsPerFat*NumberOfFats)
	               +((RootEntries+pred(BytesPerSector div 32)) div (BytesPerSector div 32));
	  Nblocks:=round(3*512/BytesPerSector);
	  end;
     dec(TotalClusters,OffsetToData);
     end;
LastUsed:=TotalClusters;
FormatID:=BootSector.BPB.FormatID;
C:=0; Fragmentation:=0; StateC:=false;
UsedClusters:=0;
BadClusters:=0;
for j:=1 to 4 do LongBlockRead(StartOfPartition+j,@Buffer[(j-1)*512]);
if false then begin {* !!!! *}
 	reg.flags:=1;
 	exit;
 	end;
if (FormatID=Buffer[0]) and ((Bootsector.BPB.BytesPerSector and 127)=0) and ((BytesPerSector div 128) in [1,2,4,8])
   then TwelveBitFat:=(TotalClusters<4096)
   else begin
 	BytesPerSector:=512;
 	case Buffer[0] of
	     $FD,$FE,$FF : SectorsPerCluster:=1;
	     $F8 : SectorsPerCluster:=8; (* *)
	     else SectorsPerCluster:=2;
	     end;
 	TwelveBitFAT:=Buffer[0]<>$F8;
 	end;
if TwelveBitFAT
   then begin
 	w:=@buffer[3];
 	for i:=2 to TotalClusters+1 do
	    begin
	    j:=word(i) and 1023;
	    if j=0 then
	       if not Dos_ReadSector(drive,(i div 1024)*Nblocks+1,Nblocks,Buffer)
	          then begin reg.flags:=1; exit; end
	          else w:=@Buffer[0];
	    w:=@Buffer[j+j div 2];
	    if odd(i)
	       then entry:=(w^ shr 4)
	       else entry:=(w^ and 4095);
	    case entry of
	         0 : begin
	             inc(FreeClusters);
	             if StateC then inc(C)
	                       else begin C:=1; StateC:=true; end;
	             end;
	      $FF7 : begin
	             if StateC then begin ContiguousClusters:=max(ContiguousClusters,C); StateC:=false; end;
	             inc(BadClusters);
	             end;
	        else begin
	             if StateC then begin ContiguousClusters:=max(ContiguousClusters,C); StateC:=false; end;
	             inc(UsedClusters);
	             if (entry<>i+1) and (entry<$FF7)
	                then inc(Fragmentation);
	             end;
	        end;
	    end
 	end
   else begin
 	Nblocks:=512 div BytesPerSector;
 	t0:=word(TimerTicks);
 	for i:=2 to TotalClusters+1 do
	    begin
	    j:=i and 255;
	    if j=0 then
 	       begin
 	       if i=3072 then
 	          begin
 	          t0:=byte(65536+TimerTicks-t0);
 	          if t0*hi(TotalClusters)>2000 then WarningMessage('Sorry, this might take some time!');
 	          end;
	       LongBlockRead(StartOfPartition+(i div 256)*Nblocks+1,@Buffer);
	       if false then begin reg.flags:=1; exit; end;
 	       end;
	    entry:=BufferWord[j];
	    if entry=0
	       then begin
	            inc(FreeClusters); LastUsed:=i;
	            if StateC then inc(C)
	                      else begin C:=1; StateC:=true; end;
	            end
	     else if Entry=$FFF7 then
	             begin
	             if StateC then begin ContiguousClusters:=max(ContiguousClusters,C); StateC:=false; end;
	             inc(BadClusters);
	             end
	        else begin
	             if StateC then begin ContiguousClusters:=max(ContiguousClusters,C); StateC:=false; end;
	             inc(UsedClusters);
	             if entry<$FFF7 then if entry<>i+1
	                then inc(Fragmentation);
	             end;
	    end;
 	end;
ContiguousClusters:=max(C,ContiguousClusters);
with Bootsector.BPB do
     DetermineSlackFat:=StartOfPartition+SectorsPerFat*NumberOfFats+(LastUsed*SectorsPerCluster);
reg.flags:=0;
end;

procedure DrawDiagram(Drive : byte);
const Border : byte = 7;
var map : string[99];
    PrimaryUsed, BootManager : integer;
    width,i,j,k : byte;
    FreeSpaceStart,FreeSpaceSize : longint;
    GotFreespace,GotPartitionTable,
    GotShrinkable : boolean;

 function Scale(sector : longint) : integer;
 begin
 scale:=trunc(sector*pred(width)/PhysicalSize)+1;
 end;

begin
Drive:=(Drive and 15);
GetDriveParameters(Drive+$80);
ReadPartitionTable;
BootManager:=-1;
FreeSpaceStart:=1; FreeSpaceSize:=0;
PrimaryUsed:=0;
GotFreespace:=false; GotShrinkable:=false;  GotPartitionTable:=MaxPartition>4;
width:=round(36+22*ln(PhysicalSize/20480)/ln(9999/10.240));
fillchar(map,sizeof(map),0);
map[0]:=chr(width);
writeln;
for p:=1 to MaxPartition do
    with PartitionsOn[Drive]^[p],RawEntry do
         begin
         if p<=4 then if System<>0 then inc(PrimaryUsed);
{         if System<>0 then writeln(P:2,' ',CurrentDosName:4,' ',hex(System),' ',ThisLinuxName:8);}
         case System of
              0 : {ignore};
              5 : begin
                  GotPartitionTable:=true;
                  for i:=Scale(FirstSector) to Scale(LastSector) do
                      map[i]:=chr($80+p);
                  end;
              $A: begin
                  BootManager:=p;
                  for i:=Scale(FirstSector) to Scale(LastSector) do
                      map[i]:=#$3A;
                  end;
              else begin
                   i:=Scale(FirstSector); j:=Scale(LastSector);
                   for i:=i to j do
                         map[i]:=chr((ord(map[i]) and $80)+ ord(p and $7F));
                   end;
              end;
         end;
for p:=1 to MaxPartition do
    with PartitionsOn[Drive]^[p],RawEntry do
         if System in ExtendedTypes
            then begin
                 Map[Scale(FirstSector)]:=chr($B5);
                 StartOfSlack:=LastSector;
                 end
            else if System in FatTypes then
                    begin
                    StartOfSlack:=DetermineSlackFAT(FirstSector);
                    i:=Scale(FirstSector);
                    j:=Scale(LastSector);
                    if j>width
                       then write(^G);
                    if StartOfSlack<LastSector
                       then for k:=succ(Scale(StartOfSlack+1)) to j do
                        inc(Map[i],$40);
                    if i=Scale(LastSector)
                       then Map[i]:=chr((ord(Map[i]) and $80)+p);
                    end;
if Map[1]=#0 then Map[1]:=#$3F
             else Map[1]:=#$40;
if true
   then Map[1]:=#$40;
if BootManager>0 then with PartitionsOn[Drive]^[BootManager] do
   begin
   i:=Scale(FirstSector);
   if Map[i]<>#$3A
      then begin; inc(Width); insert(#$3A,Map,i+1); end;
   end;
TextAttr:=Border*16;
fillchar(st[1],width+2,'');
st:='DISK SPACE MAP FOR DRIVE 0x8'+chr(48+(Drive and 31));
st[0]:=chr(width);
write('',st,''^M^J':');
TextAttr:=LightMagenta*16;
fillchar(st,sizeof(st),''); st:='-EXTENDED-PARTITION';
j:=0;
for i:=1 to width do
    case ord (map[i]) of
         0 : begin
             TextAttr:=Yellow; write('');
             end;
       1..4: begin TextAttr:=succ(ord(Map[i])); write(chr(ord(Map[i])+48)); end;
     5..$30: begin TextAttr:=LightBlue; write('!'); end;
        $3A: begin
             TextAttr:=$60+succ(BootManager);
             if BootManager in [1..9] then write(BootManager) else write('M');
             end;
        $35: begin GotPartitionTable:=true; TextAttr:=1; write(''); end;
        $3F: begin TextAttr:=Yellow; write(''); end;
        $40: begin TextAttr:=8; write(''); end;
   $41..$7F: begin TextAttr:=cyan; write(''); end;
   $81..$FF: begin inc(j); TextAttr:=$18; write(st[j]); end;
        else begin TextAttr:=LightCyan; write('?'); end;
        end;
TextAttr:=Border*16; write(':'^M^J':');
TextAttr:=LightMagenta*16;
j:=255;
for i:=1 to width do
    case ord(map[i]) of
         0 : begin
             if not GotFreespace then GotFreespace:=true;
             TextAttr:=Yellow; write('');
             end;
        $3A: begin TextAttr:=$60+succ(BootManager); write('M'); end;
    $F5,
    $B5,$35: begin TextAttr:=1; write(''); end;
        $3F: begin TextAttr:=Yellow; write(''); end;
        $40: begin TextAttr:=8; write(''); end;
   $41..$7F: begin
             GotShrinkable:=true;
             TextAttr:=cyan; write('');
             end;
        else begin
             TextAttr:=LightCyan;
             if map[i]<>map[i-1]
                then begin
                     j:=1;
                     fillchar(st,sizeof(st),' ');
                     with PartitionsOn[Drive]^[ord(Map[i]) and $3F],RawEntry do
                          if CurrentDosName<>''
                             then st:=CurrentDosName
                             else if (Map[i+1]=Map[i]) and (Map[i+length(LinuxName)]=Map[i])
                                     then st:=ThisLinuxName
                                     else st:=ThisLinuxname[length(ThisLinuxName)];
                     end
                else inc(j);
             write(st[j]);
             end;
        end;
TextAttr:=Border*16; writeln(':');
fillchar(st[1],width+2,''); st[0]:=chr(width+2);
write(st[1]); textAttr:=Border*16+8; write(''); TextAttr:=Border*16;
writeln(copy(st,3,99));
TextAttr:=8; write(' '#24);
writeln;
write('MBR ');
TextAttr:=7;
write('(',PrimaryUsed,' primary partitions out of a possible 4 used)'^M^J'Key: ');
if GotPartitionTable
   then begin TextAttr:=1; write(''); TextAttr:=Cyan; write('=Partition table, '); end;
if GotFreespace
   then begin TextAttr:=Yellow; write(''); TextAttr:=Cyan; write('=Free space, '); end;
if GotShrinkable
   then begin TextAttr:=cyan; write('=Shrinkable, '); end;
if BootManager>0
   then begin
        TextAttr:=$60+succ(BootManager);
        if BootManager in [1..9] then write(BootManager) else write('M');
        TextAttr:=cyan; writeln('=BootManager');
        end;
writeln;
end;

const NewPartitionOptions : OptionsType = (
       'Primary DOS (FAT) partition',
       'Linux (ext2fs) primary',
		 'Boot manager (has to be primary)',
		 'Other primary partition',
		 'Extended partition (to hold logical partitions)',
		 'Dos secondary ("logical") FAT partition',
		 'Hpfs (OS/2) secondary partition',
		 'Some other secondary partition (swap,ext2fs,etc)');

function PartitionOverlap(var S : SpaceArray; FirstSector,LastSector : longint) : byte;
{returns 0 if no overlap with any existing partition, else the entry in S}
var i : byte; Count : integer absolute S;
begin
PartitionOverlap:=0;
for i:=1 to count do
	 with S[i] do if (StartAt<=LastSector) and (EndAt>=FirstSector)
		 then PartitionOverlap:=i;
end;

const BootOptions : OptionsType = (
		 'First partition (unassigned; don''t use)',
		 'Second partition (extended; not a good idea to select!)',
		 'Third partition (non-bootable; don''t use)',
		 'Fourth partition (enable OS/2-compatible boot manager)',
		 #0'Other (diskette, logical partition, other disk, CDROM)',
		 #0'Menu installation/configuration',
		 #0'Password control',
		 '');

{$I FDISKNEW.PAS}
{$I FDISKBOO.PAS}
{$I FDISKFIX.PAS}

 function ListAllSubpartitionsOf(n : integer) : string;
 var  i  : integer;
     st  : string;
 begin
 st:='';
 for i:=5 to MaxPartition do
     with PartitionsOn[Drive and 15]^[i] do
          if (Parent=n) and (RawEntry.System>0)
             then if RawEntry.System in Extendedtypes
                     then st:=st+decimal(i)+','+ListAllSubpartitionsOf(i)
                     else st:=st+decimal(i)+',';
 ListAllSubpartitionsOf:=st;
 end;
(*
  function ProcessMouseButton : string;
  var row : integer; st : string[80];
  begin
  ProcessMouseButton:='';
  row:=succ((MouseY+7) div 8);
  if (MouseButton<>0)
    then begin
         case row of
             3 : begin
                 Part:=0; Highlight(0);
                 PopupPartitionInfo(0)
                 end;
             4 : if (ListLogical in ListAllMode) and (ScrollOffset>0)
                            then dec(ScrollOffset)
                            else write(^G);
             14: if (ListLogical in ListAllMode) and (ScrollOffset<MaxPartition-4)
                    then inc(ScrollOffset)
                    else write(^G);
             6..14 : begin
                     Part:=ord(RowPart[row]);
                     st:=decimal(Part);
                     if st<>#0 then PopupPartitionInfo(ord(st[1]));
                     ProcessMouseButton:=' ';
                     end;
             16..23: ProcessMouseButton:=chr(48+row-15);
              else if row=24 then ProcessMouseButton:='0';
              end;
         while (MouseButton<>0) and not keypressed
           do idle;
         end
    else case row of
            5,6..14: begin
                     st:=decimal(ord(RowPart[row]));
                     if st<>'0'
                        then begin part:=ord(RowPart[row]); Highlight(Part); end;
                     ProcessMouseButton:='';
                     end;
              end;
  end;
  *)

 procedure DeletePrimary(PartitionNumber : integer);
 begin
 with PartitionsOn[Drive and 31]^[PartitionNumber],RawEntry do
      begin
      if (System<$80)
         then Bootable:=0
         else if Bootable=$80
                 then begin
                      Bootable:=0;
                      WarningMessage('Remember to set the active partition');
                      end;
      System:=0;
      ReadLong(0,PartitionTable);
      move(RawEntry,PartitionTable.Partition[PartitionNumber],sizeof(RawEntry));
      WriteSector(1,$80+(Drive and $7F),PartitionTable);
      end;
 end;

 procedure DeleteLogical(PartitionNumber : integer);
 var PartitionTable : MbrType;
 begin
 with PartitionsOn[Drive and 31]^[PartitionNumber],RawEntry do
      begin
      Bootable:=System;
      System:=0;
      if (Parent>0) and false
         then begin
              ReadLong(Parent,PartitionTable);
              move(RawEntry,PartitionTable.Partition[succ(pred(PartitionNumber) mod 4)],sizeof(RawEntry));
              WriteSector(reg.cx,reg.dx,PartitionTable);
              end
         else Unimplemented;
      end;
 end;

 procedure DeletePartition(Command : string);
 var i,j,k : integer;
     PartitionNumber : integer;
     Answer,st : string;

 begin
 ListAllMode:=ListAllMode+[ListEmpty,ListLogical,ListExtended];
 PartitionNumber:=0;
 for i:=1 to max(4,MaxPartition) do
     with PartitionsOn[Drive and 15]^[i],RawEntry do
          if System >0
             then if (System<>5) or (PartitionNumber=0) then PartitionNumber:=i;
 if PartitionNumber=0
    then PartitionNumber:=1;
 Part:=0; Answer:='';
 Window(1,14,80,24);
 CRT.ClrScr;
 CRT.gotoXY(1,24);
 ClrEOL;
 Answer:='';
 repeat idle;
        TabMode:=true;
        DisplayPartitionTable;
        CRT.gotoXY(1,14);
        TextAttr:=ABlink+red;
        writeln(' ͻ');
        write  ('  '); TextAttr:=Yellow;
             write('  *** Deleting a partition means loosing all the files within it! ***  ');
             textattr:=ABlink+red; writeln('  ');
        writeln(' ͼ');
        TurnOnMouseCursor;
        TextAttr:=White;
        Window(1,1,80,25);
        if ABlink=0
           then StatusLine(' '#25#24' select partition  '#26#27' disk  ENTER=view  F9=blink on  F10=DELETE IT')
           else StatusLine(' '#25#24' select partition  '#26#27' disk  ENTER=view  F9=no blink  F10=DELETE IT');
        Window(1,1,80,24);
        cursoroff;
        BeginSection;
        TextAttr:=LightGreen;
        CRT.gotoXY(2,18); write('Partition #: '); ClrEOL;
        TextAttr:=$70; write(Answer);
        if Answer<>'' then Part:=Part2Integer(answer);
        if Part=0
           then begin
                write('  ');
                TextAttr:=LightCyan;
                writeln(' <- Select a partition number from the above table to delete');
                window(3,21,79,24);
                TextAttr:=green;
                ClrScr;
                end
           else begin
                if Part<1 then Part:=MaxPartition;
                if Answer='' then write(Part:2);
                TextAttr:=LightCyan;
                writeln(' <- Press F10 to delete it, ESC to quit, or select another  ');
                TextAttr:=Yellow;
                ClrEOL;
                if Part>MaxPartition
                   then writeln('':9,'(Partition numbers only go up to ',MaxPartition,'!)')
                   else with PartitionsOn[Drive and 15]^[Part],RawEntry do
                             begin
                             if System=0 then writeln('':9,'(That partition is already deleted)');
                             if System=5
                                then begin
                                     st:=ListAllSubpartitionsOf(Part);
                                     if st='' then begin
                                                   write('':9,'(That is an empty extended partition');
                                                   if Part>4 then write('; who created that??');
                                                   writeln(')')
                                                   end
                                              else begin
                                                   st[length(st)]:='!';
                                                   writeln('':9,'(This will also delete subpartition(s):',st,')')
                                                   end
                                     end;
                             end;
                window(2,20,79,24);
                ClrScr;
                TextAttr:=green;
                if Part>64 then Part:=MaxPartition+1;
                with PartitionsOn[Drive and 15]^[Part],RawEntry do
                     begin
                     st:=decimal(round(NumberOfSectors/2048))+' Mb';
                     ClrEOL;
                     if description=''
                        then description:=PartitionType[System];
                     if description=''
                        then case System of
                                   5 : description:='Extended';
                               1,4,6 : description:='DOS';
                                  else description:='non-DOS';
                                  end;
                     wr('Partition ['+decimal(Part)+'] of the '+nth(1+Drive and 15)
                                   +' disk is type 0x'+hex(System)+' ('+Description+')');
                     ClrEOL;
                     if System=0
                        then if (StartSector<>0) and (EndSector<>0)
                                then wr('*deleted* partition at offset ['+decimal(FirstSector)
                                      +'] = ['+chs(StartCyl,StartSide,StartSector)+']->['+chs(EndCyl,EndSide,EndSector)+']'^M^J
                                      +'I cannot delete it, but you might be able to undelete it')
                                else wr('*no partition* (use the arrow keys to select a partition to delete)')
                        else begin
                             wr('This '+st+' partition at offset ['+decimal(FirstSector)
                                +']: ['+chs(StartCyl,StartSide,StartSector)+'] -> ['+chs(EndCyl,EndSide,EndSector)+']');
                             if CurrentDosName<'A'
                               then wr('Current DOS name: ['+CurrentDosName+'], Linux name would be: [/dev/'+THISLinuxName+']')
                              else wr('Is known to DOS as: ['+CurrentDosName+'], Linux name: [/dev/'+THISLinuxName+']');
                             (*
                             if not (System in ExtendedTypes)
                                then wr('Seems to contain '+DescribeContents(System,FirstSector));
                             *)
                             end;
                     end;
                end;
        gotoXY(1,24);
        TextAttr:=White;
        cursoron;
        Highlight(Part);
        st:='';
        while st='' do
              if keypressed
                 then st:=upcase(ReadKey)
                 else st:=ProcessMouseButton;
        Window(1,1,80,25);
        case st[1] of
              #0 : begin
                   k:=ord(ReadKey);
                   st:='';
                   Answer[0]:=#0;
                   case k of
                        75 : begin
                             if Drive>0 then dec(Drive);
                             NeedToRead:=true;
                             end;
                        77 : begin
                             inc(Drive);
                             NeedToRead:=true;
                             end;
                        67 : ABlink:=ABlink xor Blink;
                        68 : begin
                             if Part>4 then DeleteLogical(Part)
                                       else if Part>0 then DeletePrimary(Part);
                             exit;
                             end;
                        72 : if Part>1 then dec(Part)
                                                  else Part:=1;
                        80 : if Part<MaxPartition then inc(Part)
                                       else Part:=MaxPartition;
                        {else write(k:3);}
                        end;
                   end;
              ^M : if Part<>0 then PopupPartitionInfo(Part)
                              else st:=#27;
              #9 : TabMode:=not TabMode;
              '+' : begin inc(Part); Answer:=''; end;
              '-' : begin dec(Part); Answer:=''; end;
              '1'..'9' : begin
                         if (Answer='') or (st<'7') then Answer:=Answer+st
                                                    else Answer:=st;
                         val(Answer,Part,j);
                         end;
              #127,#8 : begin
                        if Answer<>'' then dec(Answer[0]);
                        val(Answer,Part,j);
                        end;
             ^C,#27,'0': exit;
              else Answer:=Answer+st;
              end;
        until st=#27;
 TurnOffMouseCursor;
 if st>' ' then write(st);
 ListAllMode:=[ListLogical];
 Message('');
 gotoXY(64,24);
 end;

const ExpertOptions : OptionsType = (
      'Relocate/resize/rename partitions (eg hda2->hda3)',
      'Type change (eg HPFS->ext2fs)',
      'Edit absolute sectors on the disk',
      'CMOS setup (view/change CMOS RAM contents)',
      'Write sectors to a disk file (or vica versa)',
      'IDE information',
      'MBR code modifications (rewrite Master Boot Record)',
      'Park heads');

{$IFDEF EXPERT}
{$I FDISKEXP.PAS}
{$ENDIF}

procedure DoCommand(command : string);
var st : string;
begin
st:=command;
while (Command<>'') and (Command[1]<=' ') do delete(Command,1,1);
st:=Command;
case Split(Command,MainOptions) of
     ^C  : halt;
     '1' : CreateNewPartition(Command);
     '2' : SelectBootOption(Command);
     '3' : DeletePartition(Command);
     '4' : ListSubPartitions(Command);
     '5' : PickPhysicalDisk(Command);
     '6' : FindAndFixFaults(Command);
{$IFDEF EXPERT}
  '7','X': ExpertMenu(Command);
  else case Split(st,ExpertOptions) of
     '1' : RenameMenu(Command);
     '2' : ChangeType(Command);
   'M','7': RewriteMBR(Command);
     '3' : EditSectors(Command);
     '5' : WriteSectors(Command);
     'S' : SaveCylinders(Command);
     'L' : if upcase(st[2])='O' then LoadCylinders(Command);
   '6','I': IdeInfo(Command);
     '4' : EditCMOS(Command);
     #27,'0' : begin writeln; exit; end;
{$ENDIF}
     'N' : CreateNewPartition(Command);
     'B' : SelectBootOption(Command);
     'D' : DeletePartition(Command);
     'L' : ListSubPartitions(Command);
     'P' : PickPhysicalDisk(Command);
     'F' : FindAndFixFaults(Command);
{$IFDEF EXPERT}
     'E' : ExpertMenu(Command);
     'R' : if length(st)<3
              then RenameResizeMenu(Command)
              else case upcase(st[3]) of
                        'S':ResizePartition(Command);
                        'L':RelocatePartition(Command);
                        'N':RenamePartition(Command);
                        'T':ChangeType(Command);
                        'A':if capitals(st)='READ' then ReadSectors(Command);
                        else ExpertMenu('');
                        end;
     'T' : ChangeType(Command);
     'M' : RewriteMBR(Command);
     'E' : EditSectors(Command);
     'W' : WriteSectors(Command);
     'I' : IdeInfo(Command);
     'C' : EditCMOS(Command);
     end;
{$ENDIF}
   end;
end;

procedure InitialisePartitionTypeNames;
var fyle : text;
    state: byte;
begin
for i:=0 to $FF do PartitionType[i]:=KnownName(i);
st:=Paramstr(0);
if st[length(st)-3]='.' then dec(st[0],4);
assign(fyle,st+'.INI');
{$I-}
reset(fyle);
if IORESULT=0
   then begin
        state:=0;
        repeat readln(fyle,st);
               if st[1]='['
                  then state:=pos(capitals(copy(st,2,4)),'MAIN,PART,EXPE,HELP,BOOT,HASH')
                  else if st>' '
                          then begin
                               i:=StringToInteger(copy(st,1,4));
                               repeat delete(st,1,1) until (st='') or (st[i]<=' ');
                               repeat delete(st,1,1) until (st='') or (st[i]>' ');
                               if (i>0) and (st<>'') then case state of
                                  0,6 : PartitionType[i]:=st;
                                  end;
                               end;
               until eof(fyle);
        close(fyle);
        end;
end;

function HowManyNonScsiDrives : integer;
begin
i:=CmosRam($12); if (i shr 4)=0 then HowManyNonScsiDrives:=0
   else if CmosRam($19)=0 then HowManyNonScsiDrives:=0
   else if (i and $F)=0 then HowManyNonScsiDrives:=1
   else if CmosRam($1A)=0 then HowManyNonScsiDrives:=1
   else HowManyNonScsiDrives:=2;  (* must fix to cope with >2 IDE drives!!! *)
end;

procedure InteractiveMode;
label loop;
const Initials : string[9]='CSDLPFRT ';
var Command : string;

begin {interactive mode}
if (LastMode>7) or not (LastMode in [CO80,Mono])
   then TextMode(CO80);
DetermineScreenAddressEtc;
DirectVideo:=true;
SetVideoMode(3);
window(1,1,80,25);
drive:=0;
NeedToRead:=true;
repeat
 PrepareScreen('(C)'+decimal(ThisYear)+' MSA; BETA! *DO NOT DISTRIBUTE*'); (* fix this *)
 DisplayPartitionTable;
 if (MaxPartition>4) and LogicalPartitionsExist
			  then begin
					 i:=TextAttr; TextAttr:=8;
					 writeln('   (logical partitions exist; use option 4 to list them)');
					 TextAttr:=i;
					 end;
 if FaultyPartitions<>'' then MainOptions[6]:='Fix faults in partitions. A VERY GOOD IDEA!'
								 else MainOptions[6]:='Find and fix faults in partitions';
 if Changed=nil then MainOptions[8]:=''
					 else MainOptions[8]:='Undo '+Changed^.Comment;
 Command:=menu('Choose from...',MainOptions);
 if Command<>' ' then case Split(Command,MainOptions) of
	  ^C  : halt;
     #27,'0' : begin TextAttr:=7; gotoXY(1,24); writeln; clrEOL; end;
     #9  : {ignore};
     '1' : CreateNewPartition(Command);
     '2' : SelectBootOption(Command);
     '3' : DeletePartition(Command);
     '4' : ListSubPartitions(Command);
     '5' : PickPhysicalDisk(Command);
     '6' : FindAndFixFaults(Command);
     'M' : RewriteMBR(Command);
{$IFDEF EXPERT}
     'E' : EditSectors(Command);
     'W' : WriteSectors(Command);
     'I' : IdeInfo(Command);
     'C' : EditCMOS(Command);
  '7','X': ExpertMenu(Command);
     'R' : if length(st)<3
              then RenameResizeMenu(Command)
              else case upcase(st[3]) of
                        'S':ResizePartition(Command);
                        'L':RelocatePartition(Command);
                        'N':RenamePartition(Command);
                        'T':ChangeType(Command);
                        'A':if capitals(st)='READ' then ReadSectors(Command);
                        else ExpertMenu('');
                        end;
     'T' : ChangeType(Command);
{$ENDIF}
     end;
 until Command[1] in [#0,#27,^C,'0'];
end;

{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}
{{                                                       {}
{{         main program                                  {}
{{                                                       {}
{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}

begin { main body of program FDISK}
GetCountryInfo(CountryInfo,0);
ProgName:=ProgramName;
DirectVideo:=false;
i:=1;
GetDir(0,CurrentDir);
if CurrentDir[length(CurrentDir)]<>'\' then CurrentDir:=CurrentDir+'\';
InFlag:=false;
GetParameters('');
fillchar(partitionsOn,sizeof(PartitionsOn),0);
new(PartitionsOn[0]);
WizardMode:=(pos('WIZARD',Globals)>0) or (GetEnv('WIZARD')<>'') or (GetEnv('GURU')<>'');

if pos('/?',Globals) or pos('/H',Globals)>0
   then begin
        ExplainWhatItDoes;
        exit;
        end;
OutputLine('FDISK (Fixed Disk Utility) Rev '+Version);
fillchar(DriveDetails,sizeof(DriveDetails),0);
fillchar(PartitionsOn[Drive and 15]^,sizeof(KnownPartitionType),0);
InitialisePartitionTypeNames;
FirstScsiDrive:=HowManyNonScsiDrives;

for drive:=3 to 26 do
    begin
 	x:=DiskSize(drive);
    dir:=char(drive+64)+':';
 	if (copy(Canonical(dir),1,2)<>'\\') and ((x>0)  or ((x=0) and (DiskFree(drive)>=0)))
 	   then StoreDriveSpecs(drive);
    end;
ThisParameter:=1;
Drive:=0;
NeedToRead:=true;
if ParametersInList>0
   then begin
        st:=Parameter[1]^;
        for i:=2 to ParametersInList do st:=st+' '+Parameter[2]^;
        DirectVideo:=false;
        assign(output,GetGlobalSpec('/L')); rewrite(output);
        DoCommand(st); {st won't have /options in it}
        end
   else if pos('/F',Globals)>0 then RepairPartitions('ALL')
   else if pos('/M',Globals)>0 then RewriteMBR(GetGlobalSpec('/M'))
   else if (pos('/@',Globals)>0) or ((DeviceCharacteristics(StandardInputHandle) and $9093)<>$8093)
           then begin
                st:=GetGlobalSpec('/@');
                assign(input,st); {if /@ wasn't used we'll be using std in}
                reset(input);
                while not eof(input)
                      do begin
                         readln(CommandLine^);
                         DoCommand(CommandLine^);
                         end;
                close(input);
                exit;
                end
           else InteractiveMode
end.
