/*
// Program:  Free FDISK
// Module:  MAIN.H
// Module Description:  Header File for MAIN.CPP
// Written By:  Brian E. Reifsnyder
// Version:  0.99
// Copyright:  1998-2000 under the terms of the GNU GPL
*/

/*
/////////////////////////////////////////////////////////////////////////////
//  SPECIAL
/////////////////////////////////////////////////////////////////////////////
*/

#ifdef MAIN
#define MEXTERN /**/
#else
#define MEXTERN extern
#endif

/*
/////////////////////////////////////////////////////////////////////////////
//  PROTOTYPES
/////////////////////////////////////////////////////////////////////////////
*/

MEXTERN int LBA_Partition_Type_To_Create(int standard_partition_type);
MEXTERN int Create_DOS_Partition_Interface(int numeric_type, long size_in_MB);
MEXTERN int Create_Logical_Drive(int numeric_type, long size_in_MB);
MEXTERN int Create_Logical_Drive_Interface();
MEXTERN int Create_Primary_Partition(int numeric_type,long size_in_MB);
MEXTERN int Delete_Logical_Drive_Interface();
MEXTERN int Get_Environment_Settings(char *environment[]);
MEXTERN int Get_Options(char *arguments[],int number_of_arguments);
MEXTERN int More_Than_One_Hard_Disk();
MEXTERN int Partition_Type_To_Create(unsigned long size_in_mb);
MEXTERN int Set_Active_Partition_Interface();
MEXTERN int Standard_Menu(int menu);
MEXTERN int Write_Partition_Tables();

MEXTERN unsigned long Combine_Cylinder_and_Sector(unsigned long cylinder, unsigned long sector);
MEXTERN unsigned long Decimal_Number(unsigned long hex1, unsigned long hex2
 ,unsigned long hex3, unsigned long hex4);
MEXTERN unsigned long Extract_Cylinder(unsigned long hex1, unsigned long hex2);
MEXTERN unsigned long Extract_Cylinder_From_LBA_Value(long double lba_value
 ,long double head,long double sector,long double total_heads
 ,long double total_sectors);
MEXTERN unsigned long Extract_Sector(unsigned long hex1, unsigned long hex2);
MEXTERN unsigned long Input(int size_of_field,int x_position,int y_position
 ,int type, int min_range, long max_range,int return_message
 ,int default_value,long maxiumum_possible_percentage
 ,char optional_char_1[1],char optional_char_2[1]);

MEXTERN void Ask_User_About_FAT32_Support();
MEXTERN void Calculate_Partition_Ending_Cylinder(long start_cylinder,long size);
MEXTERN void Clear_Active_Partition();
MEXTERN void Clear_Boot_Sector(int drive,long cylinder,long head,long sector);
MEXTERN void Clear_Extended_Partition_Table(int drive);
MEXTERN void Clear_Screen(int type);
MEXTERN void Convert_Long_To_Integer(long number);
MEXTERN void Delete_Extended_DOS_Partition_Interface();
MEXTERN void Delete_Logical_Drive(int logical_drive_number);
MEXTERN void Delete_N_DOS_Partition_Interface();
MEXTERN void Delete_Primary_Partition(int partition_number);
MEXTERN void Delete_Primary_DOS_Partition_Interface();
MEXTERN void Determine_Color_Video_Support();
MEXTERN void Determine_Free_Space();
MEXTERN void Display_All_Drives();
MEXTERN void Display_CL_Partition_Table();
MEXTERN void Display_Extended_Partition_Information_SS();
MEXTERN void Display_Help_Screen();
MEXTERN void Display_Information();
MEXTERN void Display_Label();
MEXTERN void Display_Or_Modify_Logical_Drive_Information();
MEXTERN void Display_Partition_Information();
MEXTERN void Display_Primary_Partition_Information_SS();
MEXTERN void Dump_Partition_Information();
MEXTERN void Initialization(char *environment[]);
MEXTERN void Interactive_User_Interface();
MEXTERN void List_Partition_Types();
MEXTERN void Menu_Routine();
MEXTERN void Modify_Extended_Partition_Information(int logical_drive_number);
MEXTERN void Modify_Partition_Type(int partition_number,int type_number);
MEXTERN void Modify_Primary_Partition_Information(int logical_drive);
MEXTERN void Pause();
MEXTERN void Position_Cursor(int row,int column);
MEXTERN void Print_Centered(int y,char *text,int style);
MEXTERN void Reboot_PC();
MEXTERN void Re_Initialization();
MEXTERN void Set_Active_Partition(int partition_number);
