;-----------------------------------------------------------------------------;
;   Copyright (C) 2003  Hsu-Ping Feng                                         ;
;                                                                             ;
;   This program is free software; you can redistribute it and/or modify      ;
;   it under the terms of the GNU General Public License as published by      ;
;   the Free Software Foundation; either version 2 of the License, or         ;
;   (at your option) any later version.                                       ;
;                                                                             ;
;   This program is distributed in the hope that it will be useful,           ;
;   but WITHOUT ANY WARRANTY; without even the implied warranty of            ;
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             ;
;   GNU General Public License for more details.                              ;
;                                                                             ;
;   You should have received a copy of the GNU General Public License         ;
;   along with this program; if not, write to the Free Software               ;
;                                                                             ;
;   Foundation, Inc., 59 Temple Place, Suite 330,                             ;
;   Boston, MA  02111-1307 USA                                                ;
;                                                                             ;
;                                                                             ;
;   Author e-mail: spferng@ksts.seed.net.tw                                   ;
;-----------------------------------------------------------------------------;
;                                                                             ;
;                                  MBR {q                                 ;
;                                                                             ;
;-----------------------------------------------------------------------------;
INCLUDE kernel.h

;         .MODEL  small, c
          .MODEL  COMPILE_MODE, c
          public  MBR_HEAD, MBR_END

          .386
          .CODE

MBR_HEAD  PROC near
          xor  ax, ax
          cli
          mov  ss, ax
          mov  sp, 7C00h
          sti
          push ax
          ;
          mov  ax, 07C0h
          mov  ds, ax
          mov  ax, 07E0h
          mov  es, ax
          xor  si, si
          xor  di, di
          mov  cx, 100h
          cld
          rep  movsw                                            ; Move a sector

          mov  ax, FIND_ACT - MBR_HEAD + 7E00h
          push ax
          retf

FIND_ACT:                                                    ; MiҰʪ
          push es                                                 ; xchg ds, es
          push ds
          pop  es
          pop  ds

          mov  cx, 4
          mov  si, 1BEh                                        ; Ϊҩl}
NEXT_ACT:
          cmp  BYTE PTR [si], 80h
          jz   SHORT CHK_NEXT
          cmp  BYTE PTR [si], 00h
          jnz  SHORT ACTIVE_ERR                           ; O 80h ]O 00h
          add  si, 10h                                    ; U@Ӥ
          loop NEXT_ACT

          int  18h                                             ; Ұ ROM Basic

;---------------------------- ܿ~TåB ----------------------------
ACTIVE_ERR:
          mov  si, MSG1 - MBR_HEAD                                ; aΪI
          jmp  SHORT SHOW_MSG
LOAD_ERR:
          mov  si, MSG2 - MBR_HEAD
          jmp  SHORT SHOW_MSG
BOOT_ERR:
          mov  si, MSG3 - MBR_HEAD
SHOW_MSG:
          lodsb
          mov  ah, 0Eh
          xor  bx, bx
          int  10h
          cmp  al, 0
          jnz  SHORT SHOW_MSG
LOOP_LOCK:
          jmp  SHORT LOOP_LOCK

;------------------------------------------------------------------------------
CHK_NEXT:                                                ; ~䦳Ұv
          push  si

FIND_NEXT:
          dec  cx
          jz   SHORT LOAD_BOOT
          add  si, 10h                                       ; U@Ӥ
          cmp  BYTE PTR [si], 80h
          jz   SHORT ACTIVE_ERR                      ; ӥHW 80h PɦsbI
          cmp  BYTE PTR [si], 00h
          jnz  SHORT ACTIVE_ERR                          ; O 80h ]O 00hI
          ;
          jmp  SHORT FIND_NEXT

LOAD_BOOT:
          ;---------------------------------------
          ;   d O _   INT 13h extension
          ;---------------------------------------
          mov  ah, 41h
          mov  bx, 55AAh
          mov  dl, 80h
          int  13h
          pop  si
          ;
          mov  di, RETRY_TIMES
          jc   SHORT CONV_INT13
          cmp  bx, 0AA55h
          jnz  SHORT CONV_INT13
          test cx, 1
          jz   SHORT CONV_INT13

INT13_EXT:
          ;---------------------------------------------
          ;    INT 13h extension Ū     
          ;---------------------------------------------
          push di
          ;          
          mov  di, DrvPK - MBR_HEAD
          mov  BYTE PTR ds:[di + DRV_PK._Size], 16          ; buffer size
          mov  BYTE PTR ds:[di + DRV_PK.Transfer], 1             ; nSects

          ; target = es:0000h
          push es
          pop  WORD PTR ds:[di + DRV_PK.Buff_SEG]
          mov  WORD PTR ds:[di + DRV_PK.Buff_OFF], 0

          ; boot sector
          push DWORD PTR ds:[si + 8]
          pop  DWORD PTR ds:[di + DRV_PK.StartLow]                   ; StartLow
          mov  DWORD PTR ds:[di + DRV_PK.StartHigh], 0              ; StartHigh
          ;
          mov  ax, 4200h                                   ; clear high 2 bytes
          mov  si, di
          mov  dl, 80h                                               ; ϺСB
          int  13h
          jnc  LOAD_OK
          ;
          xor  ax, ax
          int  13h
          ;
          pop  di
          dec  di
          jnz  INT13_EXT
          jmp  LOAD_ERR                                    ; Ұʵ{JѡI

CONV_INT13:
          ;---------------------------------------
          ;    Old INT 13h Ū     
          ;---------------------------------------
          xor  bx, bx
          mov  dx, ds:[si]                                           ; ϺСB
          mov  cx, ds:[si + 2]                                       ; ϰϡBy
RETRY:
          push di
          mov  ax, 0201h
          int  13h
          jnc  LOAD_OK
          ;
          xor  ah, ah                                              ; Reset Disk
          int  13h
          ;
          pop  di
          dec  di
          jnc  RETRY
          jmp  LOAD_ERR                                    ; Ұʵ{JѡI

LOAD_OK:
          pop  di
          cmp  WORD PTR es:[1FEh], 0AA55h
          jnz  BOOT_ERR                                        ; LĪΪI
          ;
          push cs
          pop  es                                                   ; ds = 7C0h
          push cs
          pop  ds
          mov  ax, 7C00h
          jmp  ax


DrvPK     DRV_PK  <16, 0, 0, 0, 0, 0, 0, 0>        ; INT 13h extension ϥεc
MSG1      db      "Invalid partition table !", 0
MSG2      db      "Error loading operating system !", 0
MSG3      db      "Missing operating system !", 0
          db      "Made in SPFDisk"

MBR_HEAD  ENDP

MBR_END:                                              ; Use in get program size
          END
