/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include "bootmgr.h"
#include "common.h"
#include "global.h"
#include "keymap.h"

static void  Display_Box (sbyte *title, sbyte *msg, sbyte *waitmsg);
 
static sword (*BoxMGR[])(sbyte *str, sbyte *YN) =
{
    Warning_Msg_Box,
    Prompt_Msg_Box,
    Error_Msg_Box,
    Immediate_Box,
    Talk_Msg_Box

#if SPF_DEBUG
    , Bug_Msg_Box
#endif   
};


/*============================ ܬOB_ܮ ===========================*/
sword YN_box (sword type, sbyte *str)
{
    #if ( DISPLAY == CHINESE )
        #define YES_NO_MSG      "[Y]O   [N]_"
    #else
        #define YES_NO_MSG      "(Y)es   (N)o"
    #endif    

    sword  key;
 
    do
    {
        /** ھ type Is Message_Box **/
        key = (*BoxMGR[type])(str, YES_NO_MSG);
        key = toupper(key);
    } while ( (key != 'Y') && (key != 'N') );
 
    return( key == 'Y' );
} /* end YN_box */


/*=========================== ܥxs ================================*/
sword IsUpdatePartn (void)
{
    #if ( DISPLAY == CHINESE )
        #define PROMPT_SAVE_MSG     "zxsΩثeA~iiI"
    #else
        #define PROMPT_SAVE_MSG     "Please retry after save or give up\nmodify !"
    #endif

    if ( g_Info.fd.modified )
        Prompt_Msg_Box(PROMPT_SAVE_MSG, NULL);
 
    return( g_Info.fd.modified != 0 );
} /* end IsUpdatePartn */


/*=========================== ܥxs ================================*/
sword IsAllowSavePartn (void)
{
    #if ( DISPLAY == CHINESE )
        #define REJECT_SAVE_MSG     "ΪA~ڵxsI"
    #else 
        #define REJECT_SAVE_MSG     "Partition error, reject to save !"
    #endif

    if ( !g_Info.fd.canSaveFlag )
        Prompt_Msg_Box(REJECT_SAVE_MSG, NULL);
 
    return( g_Info.fd.canSaveFlag );
} /* end IsAllowSavePartn */


/*============================== ܨT ===========================*/
void Cancel_Box (void)
{
    #if ( DISPLAY == CHINESE )
        #define CANCEL_RUN_MSG      "   DDD"
    #else 
        #define CANCEL_RUN_MSG      " Cancel...!"
    #endif

    Prompt_Msg_Box(CANCEL_RUN_MSG, NULL);
} /* end Cancel_Box */


/*================================ ϥΪ̤_ ===============================*/
void User_Interrupt_Box (void)
{
    #if ( DISPLAY == CHINESE )
        #define USER_INTERRUPT_MSG  "    _ I"
    #else 
        #define USER_INTERRUPT_MSG  "User interrupt !"
    #endif

    Prompt_Msg_Box(USER_INTERRUPT_MSG, NULL);
} /* end Cencel_Box */


/*========================      ~ T  ==========================*/
void Disk_Err_Msg (sword flag)
{
    if ( flag & CUT_ERR_PARTN )
        ShowError( 12 );                                   /** ~ **/
    if ( flag & INV_PARTN_TAB )
        ShowError( 5 );                                      /** LĤΪ **/
    if ( flag & PARTN_NUM_TOO_MUCH )
        ShowError( 13 );                               /** μƶWX̤j **/
    if ( flag & INV_DISK_PARA )
        ShowError( 19 );                                       /** w~ **/
    if ( flag & PARTN_ACCESS_ERR )
        ShowError( 6 );                                  /** Ϊs **/
    if ( flag & PARTN_OVERLAP )
        ShowError( 24 );                                   /** εoͭ| **/
} /* End Disk_Err_Msg */


/*============================ ܨT =============================*/
sword Immediate_Box (sbyte *str, sbyte *waitmsg)
{
    #if ( DISPLAY == CHINESE )
        #define IMMEDIATE_MSG   "` NI   @ |    "
    #else 
        #define IMMEDIATE_MSG   "CAUTION! It will work immediatly"
    #endif

    return( Message_Box(IMMEDIATE_MSG, str, waitmsg, TRUE) );
} /* end immediate_msg */


/*=============================== ĵiT ==================================*/
sword Warning_Msg_Box (sbyte *str, sbyte *waitmsg)
{
    #if ( DISPLAY == CHINESE )
        #define CAUTION_MSG     "ĵ  i"
    #else 
        #define CAUTION_MSG     "CAUTION"
    #endif

    return( Message_Box(CAUTION_MSG, str, waitmsg, TRUE) );
} /* end Warning_Msg_Box */


/*=============================== ~T ==================================*/
sword Error_Msg_Box (sbyte *str, sbyte *waitmsg)
{
    #if ( DISPLAY == CHINESE )
        #define ERROR_MSG       "  ~"
    #else 
        #define ERROR_MSG       "ERROR"
    #endif

    return( Message_Box(ERROR_MSG, str, waitmsg, TRUE) );
} /* end Error_Msg_Box */


/*=============================== ܰT ==================================*/
sword Prompt_Msg_Box (sbyte *str, sbyte *waitmsg)
{ 
    #if ( DISPLAY == CHINESE )
        #define MESSAGE_MSG     "T  "
    #else
        #define MESSAGE_MSG     "Message"
    #endif

    return( Message_Box(MESSAGE_MSG, str, waitmsg, FALSE) );
} /* end Error_Msg_Box */


/*=============================== ͰT ==================================*/
sword Talk_Msg_Box (sbyte *str, sbyte *waitmsg)
{
    #if ( DISPLAY == CHINESE )
        #define DIALOG_MSG      "  "
    #else 
        #define DIALOG_MSG      "Dialog"
    #endif

    return( Message_Box(DIALOG_MSG, str, waitmsg, FALSE) );
} /* end Talk_Msg_Box */


/*=============================== ܰT ==================================*/
#if SPF_DEBUG
sword Bug_Msg_Box (sbyte *str, sbyte *waitmsg)
{ 
    waitmsg = "[ Press any key to terminate ]";
    Message_Box("Found Bug", str, waitmsg, TRUE);
 
    /* ۷ alt-3 */
    PushKey(0x0003);
    WaitKey();
    return(0);
}
#endif


/*========================== TܨõݥN =========================*/
sword Message_Box (sbyte *title, sbyte *msg, sbyte *waitmsg, sword beepFlag)
{
    #if ( DISPLAY == CHINESE )
        #define WAITING_MSG     "[   N  ~  ]"
    #else 
        #define WAITING_MSG     "[ Press any key to continue ]"
    #endif

    /* static word  bakScreen[8][42]; */
    sword  key;

    /* c_gettext(20, 9, 61, 16, bakScreen);  */
    PushScreenBlock(21, 9, 62, 16);

    if ( waitmsg == NULL )
        waitmsg = WAITING_MSG;
 
    Display_Box(title, msg, waitmsg);
 
    ClrKeyBuffer();
    c_textattr(BOX_MSG_COLOR);
 
    if ( beepFlag )
        Beep();
 
    /* SetHotKeySW(F5_KEY, FALSE);  */                     /** Ȱ F5  **/
    key = WaitKey();
    /* SetHotKeySW(F5_KEY, TRUE);*/                        /** _ F5  **/
    /* c_puttext(20, 9, 61, 16, bakScreen); */
    PopScreenBlock(21, 9, 62, 16);
 
    c_textattr(DEFAULT_COLOR);
    return( key );
} /* end Message_Box */


/*================================ T ===============================*/
static void Display_Box (sbyte *title, sbyte *msg, sbyte *waitmsg)
{
    #define TOKEN_LEN    (36)
    sword  line[] = { 11, 0 };
    sword  len, x, y;
    sbyte  *ptr;
 
    c_textattr(BOX_LINE_COLOR);
    Clr_Block(20, 8, 61, 15);
    Square(22, 9, 61, 16, line);
 
    if ( title )
    {
        c_textattr(BOX_TITLE_COLOR);
        Clr_Block(23, 9, 58, 9);
        x = (TOKEN_LEN - strlen(title)) / 2;               /** 襤ܼD **/
        c_printXY(x + 24, 10, title);
        c_textattr(BOX_MSG_COLOR);
    } /* end if */
 
    y = 12;
 
    while ( msg && (y < 14) )
    {
        ptr = strchr(msg, '\n');
        len = ( ptr ) ? ptr - msg : strlen(msg);
  
        if ( len > TOKEN_LEN )
            len = TOKEN_LEN;
  
        /** aܲĤ@CT **/
        if ( len > 0 )
            c_printXY(24, y, "%-*.*s", len, len, msg);
        
        y++;
        msg += len;
        if ( ptr )
            msg = ptr + 1;                                    /** L '\n' **/
    } /* end while */
 
    if ( waitmsg )
    {
       c_textattr(BOX_KEY_COLOR);
       x = (TOKEN_LEN - strlen(waitmsg)) / 2;          /** 襤ܴܰT **/
       c_printXY(x + 24, 15, waitmsg);
    } /* end if */
     
    /* c_textattr(DEFAULT_COLOR);  */
} /* end Display_Box */

