/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/

#ifndef __KEYMAP_H_
#define __KEYMAP_H_

/*=============================================================================
 *      KEY_NAME        Key_Value (HighByte = Scan Code, LowByte = ASCII Code)
 *============================================================================*/
#define BACKSPACE_KEY        0x0008
#define TAB_KEY              0x0009
#define ENTER_KEY            0x000d
#define ESC_KEY              0x001b

#define HOME_KEY             0x4700
#define LEFT_KEY             0x4b00
#define RIGHT_KEY            0x4d00
#define END_KEY              0x4f00
#define UP_KEY               0x4800
#define PAGE_UP_KEY          0x4900
#define DOWN_KEY             0x5000
#define PAGE_DOWN_KEY        0x5100
#define INS_KEY              0x5200
#define DEL_KEY              0x5300
 
#define F1_KEY               0x3b00
#define F2_KEY               0x3c00
#define F3_KEY               0x3d00
#define F4_KEY               0x3e00
#define F5_KEY               0x3f00
#define F6_KEY               0x4000
#define F7_KEY               0x4100
#define F8_KEY               0x4200
#define F9_KEY               0x4300
#define F10_KEY              0x4400

#define S_TAB_KEY            0x0f00

/*============================================================================*/
#define C_ENTER_KEY          0x001a
#define C_PRINT_SCREEN_KEY   0x7200
#define C_LEFT_KEY           0x7300
#define C_RIGHT_KEY          0x7400
#define C_END_KEY            0x7500
#define C_HOME_KEY           0x7700
#define C_BACKSPACE_KEY      0x7f00
                                  
#define C_F1_KEY             0x5e00                   /* CTRL  F1F10 զX */
#define C_F2_KEY             0x5f00
#define C_F3_KEY             0x6000
#define C_F4_KEY             0x6100
#define C_F5_KEY             0x6200
#define C_F6_KEY             0x6300
#define C_F7_KEY             0x6400
#define C_F8_KEY             0x6500
#define C_F9_KEY             0x6600
#define C_F10_KEY            0x6700

#define C_A_KEY              0x0001                   /* CTRL έ^rզX */
#define C_B_KEY              0x0002
#define C_C_KEY              0x0003
#define C_D_KEY              0x0004
#define C_E_KEY              0x0005
#define C_F_KEY              0x0006
#define C_G_KEY              0x0007
#define C_H_KEY              0x0008
#define C_I_KEY              0x0009
#define C_J_KEY              0x000a
#define C_K_KEY              0x000b
#define C_L_KEY              0x000c
#define C_M_KEY              0x000d
#define C_N_KEY              0x000e
#define C_O_KEY              0x000f
#define C_P_KEY              0x0010
#define C_Q_KEY              0x0011
#define C_R_KEY              0x0012
#define C_S_KEY              0x0013
#define C_T_KEY              0x0014
#define C_U_KEY              0x0015
#define C_V_KEY              0x0016
#define C_W_KEY              0x0017
#define C_X_KEY              0x0018
#define C_Y_KEY              0x0019
#define C_Z_KEY              0x001a


/*============================================================================*/
#define A_F1_KEY             0x6800                    /* ALT  F1F10 զX */
#define A_F2_KEY             0x6900
#define A_F3_KEY             0x6a00
#define A_F4_KEY             0x6b00
#define A_F5_KEY             0x6c00
#define A_F6_KEY             0x6d00
#define A_F7_KEY             0x6e00
#define A_F8_KEY             0x6f00
#define A_F9_KEY             0x7000
#define A_F10_KEY            0x7100

#define A_1_KEY              0x7800                   /* ALT μƦr 09 զX */
#define A_2_KEY              0x7900
#define A_3_KEY              0x7a00
#define A_4_KEY              0x7b00
#define A_5_KEY              0x7c00
#define A_6_KEY              0x7d00
#define A_7_KEY              0x7e00
#define A_8_KEY              0x7f00
#define A_9_KEY              0x8000
#define A_0_KEY              0x8100

#define A_MINUS_KEY          0x8200                      /* ALT  -B + զX */
#define A_PLUS_KEY           0x8300

#define A_Q_KEY              0x1000                     /* ALT έ^rզX */
#define A_W_KEY              0x1100
#define A_E_KEY              0x1200
#define A_R_KEY              0x1300
#define A_T_KEY              0x1400
#define A_Y_KEY              0x1500
#define A_U_KEY              0x1600
#define A_I_KEY              0x1700
#define A_O_KEY              0x1800
#define A_P_KEY              0x1900
#define A_A_KEY              0x1e00
#define A_S_KEY              0x1f00
#define A_D_KEY              0x2000
#define A_F_KEY              0x2100
#define A_G_KEY              0x2200
#define A_H_KEY              0x2300
#define A_J_KEY              0x2400
#define A_K_KEY              0x2500
#define A_L_KEY              0x2600
#define A_Z_KEY              0x2c00
#define A_X_KEY              0x2d00
#define A_C_KEY              0x2e00
#define A_V_KEY              0x2f00
#define A_B_KEY              0x3000
#define A_N_KEY              0x3100
#define A_M_KEY              0x3200

#endif  /* __KEYMAP_H_ */
