/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include "fdisk.h"
#include "common.h"
#include "global.h"

/*=============================  M   =================================*/
/*       wtmDΡG  id < 4        tmDΡG  id == 0           */
/*       wtm޿ΡG id > 4       tm޿ΡG id == -1         */
/*       HҩlϬWȱƧǫA~iϥΥ禡A_hұoGNT    */
/*===========================================================================*/
void Find_space (PARTN *partnArr)
{       
    PARTN  *ptr, *pre;
    sword  i;
 
    if ( g_Info.fd.used >= MAX_PARTN_ELEM )
        return;
 
    if ( g_Info.fd.primary == 0 )
        Ins_elem(partnArr, 0, 0, (sword)CUR_DK->lgeo.maxCyl);
    else
    {
        ptr = partnArr;
        if ( ptr->stCyl > 0 && (!Is_Extended(ptr->id) || ptr->stCyl > 1) )
            Ins_elem(partnArr, 0, 0, ptr->stCyl - 1);
  
        pre = ptr++;
        for ( i = 1 ; i < g_Info.fd.pri_use ; i++,  ptr++,  pre++ )
            if ( ptr->stCyl > (pre->endCyl + 1) )
                Ins_elem(partnArr, i, pre->endCyl + 1, ptr->stCyl - 1);
  
        if ( pre->endCyl < CUR_DK->lgeo.maxCyl )
            Ins_elem(partnArr, i, pre->endCyl + 1, (sword)CUR_DK->lgeo.maxCyl);
  
        i = g_Info.fd.pri_use;
        if ( g_Info.fd.ext_head != -1 )
        {
            if ( g_Info.fd.logic_exist == FALSE )
                Ins_elem(partnArr, i, g_Info.fd.ext_head, g_Info.fd.ext_end);
            else
            {
                ptr = partnArr + i;
                if ( !Out_of_ext(ptr) && (ptr->stCyl > (g_Info.fd.ext_head + 1)) )
                    Ins_elem(partnArr, i, g_Info.fd.ext_head, ptr->stCyl - 1);

                pre = ptr++;
                for ( ++i ; i < g_Info.fd.used ; i++,  ptr++,  pre++ )
                    if ( !Out_of_ext(ptr) && (ptr->stCyl > (pre->endCyl + 1)) )
                        Ins_elem(partnArr, i, pre->endCyl + 1, ptr->stCyl - 1);
    
                if ( !Out_of_ext(pre) && pre->endCyl < g_Info.fd.ext_end )
                    Ins_elem(partnArr, i, pre->endCyl + 1, g_Info.fd.ext_end);
            } /* end if */
        } /* end if */
    } /* end if */
} /* end Find_space */


/*============================= ] w   =================================*/
#if 0

void chk_ins_elem (PARTN *partnArr, sword ndx, dword begin, dword end)
{ 
    PARTN *ptr = partnArr + ndx;
    PARTN *pre = ptr - 1;
 
    if ( ptr->id == 0 )
    {
        if ( ptr->stCyl > begin ) 
            ptr->stCyl = begin;
    }
    else if ( ndx > 0 && pre->id == 0 )
    {
        if ( pre->endCyl < end )
            pre->endCyl = end;
    }
    else
        Ins_elem(partnArr, ndx, begin, end);
} /* end chk_ins_elem */

#endif /* 0 */


/*====================  d   O _ W X extended d  ===============*/
sword Out_of_ext (PARTN *ptr)
{
    return ( g_Info.fd.ext_head == -1 ||
             ptr->stCyl < g_Info.fd.ext_head || ptr->endCyl > g_Info.fd.ext_end ||
             ptr->stCyl > g_Info.fd.ext_end || ptr->endCyl < g_Info.fd.ext_head );
} /* end Out_of_ext */


/*============================ ] w     ============================*/
void Ins_elem (PARTN *partnArr, sword ndx, dword begin, dword end)
{ 
    PARTN *ptr = partnArr + ndx;
 
    if ( g_Info.fd.used >= MAX_PARTN_ELEM )
       return;
 
    CopyMem(&partnArr[ndx + 1], &partnArr[ndx],
            sizeof(PARTN) * (MAX_PARTN_ELEM - 1 - ndx) );
 
    Init_Partn_Elem(ptr);                             /** m ptr ҫe **/
    ptr->stCyl  = begin;
    ptr->endCyl = end;
    g_Info.fd.used++;
 
    if ( begin >= g_Info.fd.ext_head && end <= g_Info.fd.ext_end )
       ptr->no = -1;                                       /** XRΰϰ **/
    else
    {
        ptr->no = 0;                                         /** Dΰϰ **/
        g_Info.fd.pri_use++;
    } /* end if */
} /* end Ins_elem */

