/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include <io.h>
#include "bootmgr.h"
#include "common.h"
#include "global.h"

static sbyte gs_MagicString[] = "SPF Boot Manager\x1a\x7\x44\x55\xaa";

/*==============================  J   ================================*/
sword load_file (BMGR *boot)
{                       
    sbyte     str[43];
    sword     errCode;
 /* dword     ver;  */
    FILE      *fptr;
 
    if ( Input_Filename(str, 42) == FALSE )                    /** JɦW **/
    {
        errCode = -1;                                          /**  **/
    }
    else if ( (fptr = new_fopen(str, "rb")) == NULL )
    {
        errCode = -2;                                         /** }ɥѡI**/
    }
    else
    {
        Init_BMGR(boot, &g_BootPara);
  
        /*-------------------------------------------------------------+
        |  ŪXYTG                                              |
        |      0 - 15    ɮ׻r                                  |
        |     16 - 19    r AA554407h                            |
        |     20 - 22    ~N 20,21 X֦ 16 iA 22 睊   |
        +-------------------------------------------------------------*/
        new_fread(str, sizeof(gs_MagicString) + 2, 1, fptr);
        new_fread(&g_BootPara, 1, sizeof(BOOTPARA), fptr); /** Get BootPara **/
  
     /* ver = ((dword)(*(word *)&str[20]) << 8) + (dword)str[22];  */
  
        if ( CompMEM(gs_MagicString, str, sizeof(gs_MagicString) - 1) != 0 ||
             (g_BootPara.nBootREC > REC_NUMBER) ||
             new_fread(str, 1, 30, fptr) < 30 ||         /** ťհϡAXR **/
             new_fread(boot, sizeof(BMGR), g_BootPara.nBootREC, fptr) < g_BootPara.nBootREC ||
             new_fgetc(fptr) != -1 )
        {
            errCode = -3;                                 /** ɮפe~I**/
            Init_BMGR(boot, &g_BootPara);
        }
        else
            errCode = 0;
  
        new_fclose( fptr );
    } /* end if */
 
    return( errCode );    
} /* end load_file */


/*============================== s J   ================================*/
sword save_file (BMGR *boot)
{                          
    sword  errCode;
    sbyte  str[43];
    FILE   *fptr;
 
    if ( !Input_Filename(str, 42) || !Is_Overwrite(str) )      /** JɦW **/
    {
        errCode = -2;                                              /**  **/
    }
    else if ( (fptr = new_fopen(str, "wb")) == NULL )
    {
        errCode = -1;                                          /** ɥ **/
    }
    else
    {
        /*---------------------------------------------------------+
        |  1999-001 }lאּHU榡 \x7\x44\x55\xaa Ѧr  |
        +---------------------------------------------------------*/
        *(dword *)str = 0x00012000L;                       /** ver = 2000-1 **/
        new_fwrite(gs_MagicString, sizeof(gs_MagicString) - 1, 1, fptr);
        new_fwrite(str, 3, 1, fptr);                       /** save 3 bytes **/
        new_fwrite(&g_BootPara, sizeof(BOOTPARA), 1, fptr);  /** save BootPara **/
        new_fprintf(fptr, "%*c", 30, ' ');      /** 30 Bytes ťհϡAXR **/
  
        if ( new_fwrite(boot, sizeof(BMGR), g_BootPara.nBootREC, fptr) < g_BootPara.nBootREC )
            errCode = -1;
        else
            errCode = 0;
        new_fclose( fptr );
    } /* end if */
 
    return( errCode );
} /* end save_file */
