; A tool for APM power management in FreeDOS.
; Copyright Eric Auer 2003. Please do not spread - just send
; me (NASM) CODE to complete the project! When done, you will
; be credited and the project will be released under GPL 2.
; Please read apmnotes.txt for an outline of the workings.

; This file: shutDownHandler (destroys registers, CY on error)
; Call with type selection AX. Writes status to stdout.
; 0 hot reboot 1 warm reboot 2 cold reboot
; 3 stand by 4 suspend 5 power off (APM 1.2+ only)

shutDownHandler:	; various kinds of shutdown (select in AX):
	; 0 hot reboot 1 warm reboot 2 cold reboot
	; 3 stand by 4 suspend 5 power off (APM 1.2+ only)
	; returns carry set on error.
	cmp ax,5
	jbe sdokay
	push ax
	mov dx,sdinvmode
	mov ah,9
	int 21h
	pop ax
	call showax
	stc
	ret
sdokay:	cmp al,3	; standby, suspend, off?
	jb sdok2	; otherwise no APM needed
	push ax
	call connectAPM	; need APM for the required feature, so...
	mov bx,ax	; remember version
	pop ax
	jnc sdok2
	push ax
	mov dx,sdnotsleep
	mov ah,9
	int 21h		; cannot suspend / standby without APM
	pop ax
	cmp al,4	; suspend, off?
	jb sbonly
	; VGA off without auto-back-on would be confusing!
	call spinDownDisks	; at least that
sbonly:	stc
	ret
sdok2: 	cmp al,5	; off?
	jb sdok3
	cmp bx,0102h	; APM 1.2 (or better?)
	jae sdok3
	mov dx,sdnotoff
	mov ah,9
	int 21h		; cannot turn off without APM 1.2 or better
	call spinDownDisks	; at least that...
	stc
	ret

sdok3:	mov si,shutdownlist
	call showlist
	push ax
	call flushCaches	; flush all caches first in any case!
	pop ax
	push ax
	cmp al,4
	jb notSpinningDown	; if suspend or off, spin down disks
	call spinDownDisks	; Laptop BIOSes often spin down anyway
%ifdef EXTRAVGAOFF
	call wxVgaOff		; Almost every BIOS turns VGA off anyway
%endif
notSpinningDown:
	pop ax
	add ax,ax
	mov bx,ax
	jmp near [cs:sdcode+bx]

hotboot:
	int 19h			; reload DOS only
	; if failed, fall through to warmboot

warmboot:
	push ds
	mov ax,40h
	mov ds,ax
	mov word [ds:72h],1234h	; warm boot only
	pop ds
	jmp far [cs:bootpt]

coldboot:
	push ds
	mov ax,40h
	mov ds,ax
	mov word [ds:72h],0000h	; full cold boot
	pop ds
	mov al,0feh		; keyboard reboot
	out 64h,al		; try keyboard...
	jmp far [cs:bootpt]	; ...and normal reboot 

bootpt	dw 0,0ffffh	; boot entry point is FFFF:0000

standby:
	call enableAPM	; needed?
	mov ax,5307h
	mov bx,1	; whole system
	mov cx,1	; standby
	int 15h		; APM call
	mov cx,3
	jmp short recoveryTime

suspend:
	call enableAPM	; needed?
	mov ax,5307h
	mov bx,1	; whole system
	mov cx,2	; suspend
	int 15h		; APM call
%ifdef WARMUPDISKS
	mov cx,6
%else
	mov cx,4
%endif
	; jmp short recoveryTime
	
recoveryTime:
	push cx
%ifdef EXTRAVGAOFF
	call wxVgaOn	; if we turned it OFF, we must turn it back on, too!
%endif
%ifdef WARMUPDISKS
	call spinUpDisks	; let disks spin up
%endif
	mov ah,9
	mov dx,recoveringMsg
	int 21h		; ask the user for patience
	pop cx
	call countBar	; take some time to wake up completely
	mov ah,9
	mov dx,recoveredMsg
	int 21h		; back working
	clc
	ret

poweroff:
	call enableAPM	; needed?
	mov ax,5307h
	mov bx,1	; whole system
	mov cx,3	; power off (APM 1.2 or newer needed)
	int 15h		; APM call
	; should not return, so we chain to suspend...
	mov ah,9
	mov dx,nOffMsg
	int 21h		; tell user that power off did not work
	mov ax,4
	jmp suspend	; flush/spindown/vgaoff already done, only suspend

spinUpDisks:
	mov al,0e1h	; immediate idle (motor on, possibly again)
	mov [cs:spinCommand],al
	mov dx,dskup1	; tell user to wait for disk spin up
	jmp short spinUpDisks2

spinDownDisks:
	mov al,0e0h	; immediate standby (motor off)
	mov [cs:spinCommand],al
	mov ah,9
	mov dx,dskmsg1
	int 21h		; first "wait"
	mov cx,3	; 3 seconds for the last leftovers
	call countBar	; of cache flushing calls...
	mov dx,dskmsg2
	;
spinUpDisks2:
	mov ah,9
	int 21h		; now announce spin down / spin up
	;
	mov dx,1f6h	; primary controller
spinDownLoop:
	mov al,0a0h	; no LBA, master disk
	out dx,al
	inc dx
	call miniWait
	mov al,[cs:spinCommand]	; e0 for standby, e1 for on/idle
	out dx,al
	dec dx
	call miniWait
	mov al,0b0h	; no LBA, slave disk
	out dx,al
	inc dx
	call miniWait
	mov al,[cs:spinCommand]	; e0 for standby, e1 for on/idle
	out dx,al
	dec dx
	sub dx,80h	; 1f6 -> 176 -> done
	cmp dx,176h
	jz spinDownLoop	; repeat with secondary controller
	;
	mov al,[cs:spinCommand]
	cmp al,0e1h	; spinning UP?
	jz spinUpWait
	;
spinDownWait:
	mov cx,5
	call countBar	; give disks time to spin down
	mov ah,9
	mov dx,dskmsg3
	int 21h		; declare spin down finished
	clc
	ret

spinUpWait:
	mov cx,7
	call countBar
	mov ah,9
	mov dx,dskup2
	int 21h
	clc
	ret

		; IDE/ATEA commands: E1 immediate idle (motor on)
		; E6 immediate sleep (motor and logics off)
spinCommand:	; E0 immediate standby (motor off, *easy wakeup*)
	db 0e0h	; e.g. Seagate Barracuda: seek 12W spinup 25W
		; working 9W idle 8W *standby* 1W sleep < 1W
	; commands with arguments / return values:
	; E2 config standby timer E3 config idle timer E5 read state
	; EC read description (receive by doing 200h in 1f0h!)

miniWait:	; wait a moment
	xchg ax,bx
	inc ax
	xchg ax,bx
	dec bx
	ret

countBar:	; wait N seconds (destroys AX CX DX=
	push cx
	mov ah,9
	mov dx,dotmsg
	int 21h
	call getTicks
	add ax,18	; 1 second
	mov dx,ax
countWaiting:		; we do NOT call int 28h / idling while waiting!
	call getTicks
	cmp ax,dx
	jnz countWaiting
	pop cx
	loop countBar
	ret

getTicks:	; get low word of timer tick count into AX
	push ds
	xor ax,ax
	mov ds,ax
	mov ax,[ds:46ch]
	pop ds
	ret

shutdownlist:
	dw hotmsg, warmmsg, coldmsg
	dw stdbmsg, suspmsg, offmsg
sdcode	dw hotboot, warmboot, coldboot
	dw standby, suspend, poweroff
hotmsg	db "Triggering hot int 19h reboot...",13,10,"$"
warmmsg	db "Triggering warm reboot...",13,10,"$"
coldmsg	db "Triggering cold reboot...",13,10,"$"
stdbmsg	db "Putting system into STAND BY mode...",13,10,"$"
suspmsg db "Putting system into SUSPEND mode...",13,10,"$"

offmsg  db "Turning OFF system...",13,10,"$"
nOffMsg	db "System could not be turned off - suspending instead."
	db 13,10,"$"

recoveringMsg	db "Please wait, warming up$"
recoveredMsg	db " System is back up now.",13,10,"$"

	; this should actually measure how far down the disks are!
dskmsg1	db "Giving disk handlers some time$"
dskmsg2	db " Spinning down$"
dskmsg3	db " Disks stopped.",13,10,"$"
dskup1	db "Spinning up disks$"
dskup2	db " Disks on.",13,10,"$"

dotmsg	db ".$"

sdinvmode	db "Invalid shutdown mode: $"
sdnotoff	db "Need APM 1.2 to turn off power!",13,10,"$"
sdnotsleep	db "Need APM for suspend / stand by / power off!"
		db 13,10,"$"

