; A tool for APM power management in FreeDOS.
; Copyright Eric Auer 2003. Please do not spread - just send
; me (NASM) CODE to complete the project! When done, you will
; be credited and the project will be released under GPL 2.
; Please read apmnotes.txt for an outline of the workings.

; This file: statusPOWER (destroys registers)
; Writes POWER TSR status to stdout, or just tells if no TSR found.

foundmsg	db "Found resident POWER driver version $"
nfoundmsg	db "No POWER driver resident yet.",13,10,"$"

status1msg	db "Savings mode: $"
status1list	dw status1off, status1inv, status1std, status1adv
status1off	db "off (no savings)$"
status1inv	db "only hooks, but no savings!?$"
status1std	db "BIOS APM enabled$"
status1adv	db "BIOS APM plus hooked DOS interrupts $"

idledetmsg	db "Idle detection strategy bitmask: $"

advlist		dw advminmsg, advminmsg, advminmsg, advminmsg
		dw advminmsg, advminmsg, advregmsg, advmaxmsg
advminmsg	db "(MIN setting)$"
advregmsg	db "(REG setting)$"
advmaxmsg	db "(MAX setting)$"

pollfreqmsg	db "APM polling frequency: $"

; ---------------

statusPOWER:
	mov ax,5400h
	xor bx,bx
	int 2fh
	cmp bx,504dh
	jz tsrStatus
	mov dx,nfoundmsg
	mov ah,9
	int 21h
	ret
tsrStatus:
	push ax		; store version
	mov dx,foundmsg
	mov ah,9
	int 21h
	pop ax
	;
	xchg al,ah	; AH first
	call showal	; major version (w/o leading 0s)
	mov al,'.'
	call showtty
	xchg al,ah	; AL now
	call showal	; minor version (w/o leading 0s)
			; use showalFull for with leading 0s
	call crlf
	;
	mov dx,status1msg
	mov ah,9
	int 21h
	mov ax,5401h
	mov bh,0	; get status
	int 2fh
	and bl,3	; 0 off 2 std 3 adv
	mov al,bl
	mov si,status1list
	call showlist	; OFF STD or ADV
	cmp al,3
	jnz nAdvStatus
	;
	mov ax,5403h
	xor bx,bx	; get ADV intensity
	int 2fh
	mov al,bl
	cmp bx,7
	jbe advSaneStatus
	mov al,7	; unknown intensity -> assume MAX
advSaneStatus:
	mov si,advlist
	call showlist
	call crlf
	;
	mov dx,pollfreqmsg
	mov ah,9
	int 21h
	mov ax,5482h
	xor bx,bx	; get APM polling frequency
	call hex2dec	; convert AX to BCD (saturates at 9999)
	call showax
	;
	; *** you MAY want to display the idleness and APM counters
	; *** which would mean 8 32bit values, probably far too much
	; *** info for a normal user. However, the cpu on ticks vs
	; *** cpu idle ticks ratio might be interesting, e.g. as
	; *** percent display...
	;
nAdvStatus:
	call crlf
	;
	mov dx,idledetmsg
	mov ah,9
	int 21h
	mov ax,5402h
	xor bx,bx
	int 2fh
	mov al,bl
	call showal	; idle detection strategy bitmask
	call crlf
	;
	ret

