
;--- 16 bit ASM part of Jemm386

		.286
        .SEQ		;avoid DOSSEG segment order (RSEG must be first)

	include jemm386.inc	
	include debug.inc

if ?MASM
	option proc:private
endif

;--- some parts of the EMM binary are written in C.
;--- to prevent the linker from including CRT modules,
;--- some compiler helper functions are (re)implemented in ASM

ifndef ?WCC			; Open Watcom WCC
?WCC equ 0
endif
ifndef ?MSC			; MS Visual C++ 1.52 compiler
?MSC equ 0
endif
ifndef ?DMC			; Digital Mars C++
?DMC equ 0
endif

?NEARC	equ 0		; set to 1 to support TCC 3
if ?WCC
?RSEG	equ 0
else
?RSEG	equ 1		; use separate RSEG segment
endif
?ADDCONT equ 0		; currently not used

EXECMODE_SYS equ 0
EXECMODE_EXE equ 1

;--- @DefineBP: macro to define a v86-"breakpoint"

@DefineBP macro _name
if ?MASM
_name&::
else
_name&:
endif
	@BPOPC
	endm

ife ?MASM
	LOCALS
endif

;-- publics _TEXT

    public _fmemset
    public _memcpy
	public _TestForSystemRAM	;test if a page is RAM in upper memory
	PUBLIC	_ltob			; convert long to string
	public _EmmStatus		; display EMM status
	public _EmmUpdate		; update Jemm386 status
	public _IsProtectedMode	; proc to determine if cpu is in v86 mode
	public _put_console		; write to console
	public _XMSinit			; get XMS status
	public _emmcall			; call EMS function
	public _xmscall			; call XMS function
	public _xmscall32		; call XMS 3.0 function with 32bit registers
	public _VMwareDetect
if ?ADDCONT    
	public _AddIfContiguousWithDosMem
endif

if ?RSEG
RSEG SEGMENT PARA public 'CODE'	;resident code + data
RSEG ENDS
endif

if ?RSEG
_TEXT	segment	word public 'CODE'
else
_TEXT	segment	PARA public 'CODE'
endif
		extrn	_printf:near
		extrn _TheRealMain:near
		extrn _TheV86Main:near
_TEXT	ends

if ?RSEG
_TEXT16 GROUP RSEG, _TEXT
else
_TEXT16 GROUP _TEXT
endif

_TEXT32 SEGMENT PARA public 'CODE'	;include external module Jemm32
		.nolist
ifdef _DEBUG
		include Debug\jemm32.inc
else
		include Release\jemm32.inc
endif
		.list
_TEXT32	ENDS

BEGDATA segment PARA public 'DATA'	;make sure DGROUP is para aligned
BEGDATA ends

_DATA	segment word public 'DATA'
		extrn _jemmini:JEMMINIT
		extrn _startup_verbose:BYTE		; more (debug) output in Init Phase
;		extrn _XMS_Handle_Table:dword
        extrn _XMSdriverAddress:dword
        extrn _UMBsegments:near
        extrn _emmfunction:byte
if ?LOADSUPP
        extrn _bLoad:BYTE
endif
        extrn _NoHigh:BYTE
        extrn _emmreg16:near
        extrn _reg16:near
        extrn _reg32:near
_DATA	ends

if ?MSC
CONST	segment word public 'CONST'
CONST	ends
endif

_BSS	segment word public 'BSS'
_BSS	ends

_STACK	segment para STACK  'STACK'
_STACK	ends

if ?MSC
DGROUP	group	BEGDATA,_DATA,CONST,_BSS,_STACK
else
DGROUP	group	BEGDATA,_DATA,_BSS,_STACK
endif

_DATA	segment

;--- _brptab is the second or two parameters for Jemm32 init
;--- the entries are offsets in RSEG
;--- the most important one is the offset to the v86 breakpoint table

if ?DMA        
_brptab	RSOFS {offset bptab,offset bRFlags}
else
_brptab	RSOFS {offset bptab}
endif

if 0;?A20PORTS
wBiosA20	DW 1+2	;default: trap both kbdc + ps2 ports
endif

dBye		db " JEMM386 initialized",13,10,'$'
dAlreadyInstalled db 'JEMM386: EMM already installed',CR,LF,07,'$'
dFailed		db ' something failed - driver aborted',CR,LF,07,'$'
dError1		db "JEMM386 not installed.",13,10,'$'

sig1        db 'EMMXXXX0',0
sig2        db 'EMMQXXX0',0	; ID if NOEMS specified
szDispVer   db "JEMM386 v%u.%02u installed.",LF,0
szEMSStatus db "EMS is %s",0
szEMSMemory db ", %u of max. %u pages allocated",0
szVCPIOff   db "VCPI is Off.",LF,0
szVCPIOn    db "VCPI is On, %lu of max. %lu pages allocated.",LF,0
if ?VME
szVMEStatus db "VME is %s.",LF,0
endif
szA20Status db "A20 emulation is %s.",LF,0
if ?PGE
szPGEStatus db "PGE is %s.",LF,0
endif
szOn        db "On",0
szOff       db "Off",0
szFrameNone db ", no Page Frame",0
szDotLF		db ".", 10, 0
szFrameYes  db ", Page Frame at %04X",0
szDMABuffer db "DMA buffer at %08lX, size %u kB.",LF,0
szUMB       db "UMB supplied at %04X-%04X.",LF,0
szUMBErr1   db "UMB handler already installed, not installing another one",LF,0

_DATA	ends

		.386P

if ?RSEG
RSEG SEGMENT
else
_TEXT SEGMENT
endif

    ASSUME  CS:_TEXT16
	ASSUME  DS:NOTHING,ES:NOTHING,FS:NOTHING,GS:NOTHING

;******************************************************************************
; device driver header

device_header:
		dd  -1			    ; last driver in list
		dw  0c000h		    ; driver flags :
							; 8000 - character device
							; 4000 - supports IOCTL - like EMM386
pStratOfs dw  offset strategy	    ; offset to strategy routine
pIntOfs dw  offset _driver_entry    ; offset to interrupt handler

device_name label byte
		db  'EMMXXXX0'	    ; device driver name

;--- start of real-mode resident data area

;--- v86 breakpoint table
;--- the order is fixed (it must match the table in Jemm32.asm) !

bptab	label byte
if ?VDS
NEW4B:					; int 4Bh entry real-mode (VDS)
	@DefineBP BPVDS
endif
	@DefineBP BPXMS
if ?DMA    
	@DefineBP BP1340	; copy out of DMA buffer
endif
NEW67:					; int 67h entry real-mode
	@DefineBP BP67
	@DefineBP BPBACK	; BP to return to v86 monitor from a v86 far proc
	@DefineBP BPSTRAT	; EMMXXXX0 device strategy call
	@DefineBP BPDRV		; EMMXXXX0 device interrupt call
	@DefineBP BPREBOOT	; return from Int15 after ctrl-alt-del 
NEW06:            		; entry invalid opcode exception (int 06)
	@DefineBP BP06

if ?DMA
bRFlags 	DB 0
endif

;--- end of the data part

	align 4
    
if ?DMA

NEW13 PROC FAR
	mov cs:[bRFlags],2	; tell the monitor that a new DMA op has started
	pushf
    db 09Ah
OLDINT13 dd 0    
NEW13 ENDP

int1340common:
	jc  iret_with_new_CY
	test cs:[bRFlags],1
	jz  iret_with_new_CY
    jmp BP1340
    
NEW40 PROC FAR
	mov cs:[bRFlags],2	; tell the monitor that a new DMA op has started
	pushf
    db 09Ah
OLDINT40 dd 0    
	jmp int1340common
NEW40 ENDP

endif

;******************************************************************************
; INT15 handler:
;    everything forwarded to old handler, except int15/87 = move_memory
;******************************************************************************

	align 4

NEW15 PROC FAR
	CMP     AH,87H               	; is it a blockmove ?
	JZ      SHORT @@do_int1587
    db 0EAh
OLDINT15 dd 0    

; suggested by eric auer:
;	the int 15h, ah=87h is routed to int 67h, registers unchanged.
;   works because int 67h, ah=87h is not used by EMS.
;
;INT 15 - SYSTEM - COPY EXTENDED MEMORY
;
;        AH = 87h
;        CX = number of words to copy (max 8000h)
;        ES:SI -> GDT (4 descriptors)
;Return: CF set on error
;        CF clear if successful
;        AH = status

@@do_int1587:
	int 067h

;--- fall through
    
NEW15 ENDP

; update CF on IRET frame on stack

iret_with_new_CY:
	push bp
	mov	bp,sp
	rcr	byte ptr [bp+2+4],1
	rol	byte ptr [bp+2+4],1
	pop	bp
	iret
    
;*********************************************************
; XMS hook - required for UMBs and A20 emulation
;*********************************************************

XMShandler proc

	jmp short @@XMSHandler	; standard XMS link chain
	nop					    ; with 3 required NOPs
	nop
	nop
@@XMSHandler:
if ?A20XMS
	cmp	ah,3
    jb  @@xms_prev
    cmp ah,6
	jbe	BPXMS
endif    
if ?MASM
XMSUMB::
else
XMSUMB:
endif
	cmp ah,10h				; 10h=alloc, 11h=free, 12=realloc
	jb  @@xms_prev
	cmp	ah,12h
	jbe BPXMS
@@xms_prev:
	db 0eah					; jmp far XMS prev handler
XMSoldhandler dd 0

;-- for A20 disable and enable emulation it is useful to trap
;-- the XMS functions as well, even if the A20 ports (92, 60, 64)
;-- are trapped. That's because if certain conditions are true
;-- the XMS host will never access the ports and leave A20 unchanged.

XMShandler endp

if 0

;--- print a string in real-mode (for debugging)

RPRINTSTR PROC
	push bp
    mov bp,sp
    XCHG BX,[bp+2]
    PUSHF
	PUSH AX
@@NEXTCHAR:
    MOV AL,CS:[BX]
    INC BX
    CMP AL,0
    JZ  @@DONE
    push bx
    cmp al,10
	jnz @@isnotlf
    mov al,13
    xor bx,bx
    mov ah,0Eh
    int 10h
    mov al,10
@@isnotlf:    
    xor bx,bx
    mov ah,0Eh
    int 10h
    pop bx
    JMP @@NEXTCHAR
@@DONE:
	POP AX
	POPF
	XCHG BX,[bp+2]
    pop bp
    RET
RPRINTSTR ENDP

rwordout proc near
		push	ax
		mov 	al,ah
		call	rbyteout
		pop 	ax
rwordout endp
rbyteout proc near
		pushf
		push	ax
        mov		ah,al
		shr 	al,4
        call    rnibout
        mov		al,ah
        call    rnibout
        pop     ax
        popf
        ret
rnibout:        
		and 	al,0Fh
		cmp 	al,10
		sbb 	al,69H
		das
        push bx
        push ax
        xor bx,bx
        mov ah,0Eh
        int 10h
        pop ax
        pop bx
        ret
rbyteout endp

endif
		align 16

RSEG_END equ $ - device_header

if ?RSEG
RSEG  ends
_TEXT segment
endif

;
; installation part of the virtual Monitor, that later is given back again
; to the system.
;

	assume CS:_TEXT16
    assume FS:nothing
    assume GS:nothing

request_ptr dd 0

;--- the original strategy proc, must be 8086 compatible
;--- will be replaced by a shorter 80386 version

strategy:
	mov word ptr cs:[request_ptr+0],bx
	mov word ptr cs:[request_ptr+2],es
	retf

;**********************************************
; driver init part
; this code is only necessary on init and    
; will not go resident. It must however be
; in the same physical segment as the
; resident part. The proc must be declared far.
;**********************************************

;struc	request_hdr
;  req_size	db	?		; number of bytes stored
;  unit_id	db	?		; unit ID code
;  cmd		db	?		; command code
;  status	dw	?		; status word
;  rsvd		db	8 dup (?)	; reserved
;ends	request_hdr

;struc	init_strc
;  init_hdr	db	size request_hdr dup (?)
;  units		db	?	; number of supported units
;  end_addr	dd	?		; end address of resident part
;  cmd_line	dd	?		; address of command line
;ends	init_strc

_driver_entry proc far

	push ds
    push es
    push di
	lds di, cs:[request_ptr]          ; load address of request header
	mov word ptr ds:[di+3],8103h
    pop di
    call TestCPU
    jc @@no386
	pushad
	lds di, cs:[request_ptr]        ; load address of request header
	cmp byte ptr ds:[di+2],0 		; command == 0 : do we have to initialize?
	jne @@exit
	push ds					; save DS:DI
	push di
    mov		cx,ss
    mov		bx,sp
	les     si, ds:[di+18]	; fetch driver commandline
	mov     ax, DGROUP
	mov     ds, ax
    assume	DS:DGROUP
	mov     ss, ax
	mov     sp, offset DGROUP:exe_stacktop
    push	cx
    push	bx
    call	installcheck
    jnc		@@noemm
	mov 	dx, OFFSET DGROUP:dAlreadyInstalled
    mov		ah, 9
    int		21h
    xor		ax,ax
    jmp 	@@driver_exit
@@noemm:
    sub sp,128
    mov di,sp
    push ds
    push es
    pop ds
    push ss
    pop es
@@nxtchar1:    			;skip program name
    lodsb
    and al,al
    jz done
    cmp al,13
    jz done
	cmp al,20h
    ja @@nxtchar1
@@nxtchar2:    
	lodsb
    and al,al
    jz done
    cmp al,13
    jz done
    stosb
    jmp @@nxtchar2
done:
	mov al,0
    stosb
    pop ds
	push sp				; startup_driver(char far *cmdLine)
    push EXECMODE_SYS
	call _TheRealMain
	add sp,128+2*2
	MOV DX,OFFSET DGROUP:dFailed
	or 	ax,ax			; error occured?
    mov ax,0
	jnz @@driver_exit
	call 	init_jemm
@@driver_exit:
	pop		bx
    pop		ss
    mov		sp,bx
    pop		di
    pop		ds
	mov word ptr ds:[di+3],0100h	; STATUS_OK
	mov ds:[di+0eh+0],ax  			; if ax == 0, driver won't be installed
	mov ds:[di+0eh+2],cs			; set end address
@@exit:
	popad
@@no386:    
    pop es
	pop ds
	ret
    
_driver_entry ENDP

;
; check, if this program runs after all on a 386-Computer (o.ae.)
; (... you never know)
;

IS386 PROC NEAR
	PUSHF
	mov     AX,7000h
	PUSH    AX
	POPF                        ; on a 80386 in real-mode, bits 15..12
	PUSHF                       ; should be 7, on a 8086 they are F,
	POP     AX                  ; on a 80286 they are 0
	POPF
    and		ah,0F0h
	cmp     AH,70H
    stc
	JNZ     @@NO_386
    clc
@@NO_386:
	RET
IS386 ENDP

;--- test if CPU is 386, display error if not
;--- returns C and modifies DS in case of error
;--- other registers preserved

TestCPU proc near
	push ax
	call IS386
    and ax, ax
    pop ax
    jnc @@is386
    push ax
    push dx
    push cs
    pop ds
    mov ah,9
    mov dx,offset _TEXT16:dErrCpu
    int 21h
    pop dx
    pop ax
    stc
@@is386:    
    ret
TestCPU endp

dErrCpu  db "JEMM386: at least a 80386 cpu is required",13,10,'$'

if ?LOADSUPP

;--- check if there is already an EMM installed
;--- DS=DGROUP

installcheck proc
	push	es
    pusha
	MOV     AX,3567H         ; get INT 67h
	INT     21H
	MOV     AX,ES            ; EMM already installed ?
	OR      AX,BX
	JZ      @@ok
	MOV     DI,10
	MOV     SI,OFFSET sig1
	CLD
	MOV     CX,8
	REPZ    CMPSB
	je @@error      	; matched 1st ID string
	mov	di, 10			; didn't match, check 2nd ID (NOEMS version)
	mov	si, OFFSET sig2
	mov	cl, 8
	repz cmpsb
    clc
	jne @@ok	   		; did match 2nd ID string?
@@error:
	stc
@@ok:
	popa
	pop es
	ret
installcheck endp    

;--- hook resident part into the driver chain

postcheck proc
	mov ah,52h
    int 21h
    add bx,22h
    mov eax,es:[bx]
    mov cs:[0], eax
	mov word ptr es:[bx+0],0
	mov es:[bx+2],cs
	ret
postcheck endp

endif

;*********************************************
; startpoint when executing as EXE
;*********************************************

GO_EXE proc

	mov     ax, DGROUP
	mov     ds,ax
    assume	ds:DGROUP
	mov     ss,ax
	mov     sp, offset DGROUP:exe_stacktop
    call	TestCPU
    jc		@@exit
if ?LOADSUPP
    call	installcheck
    pushf
endif
	sub sp,128
    mov di,sp
    push ds
    push es
    pop ds
    mov si,0080h
    lodsb
    movzx cx,al
    push ss
    pop es
    rep movsb
    mov al,0
    stosb
    pop ds
    
	push  sp
    push EXECMODE_EXE
	call  _TheRealMain	;returns 0 if everything ok
    add sp,128+2*2

if ?LOADSUPP
	popf
    adc	 al,al
    jnz	 @@exit
    cmp	 _bLoad,1
    jnz	 @@exit
    call init_jemm
    and  ax,ax
    jz   @@exit			;shall we go resident?
    push ax
    call postcheck
    mov  ah,51h
    int  21h
    mov  es,bx
    mov  es,es:[002Ch]
    mov  ah,49h
    int  21h
    mov  bx,0
@@nextfile:    
    mov	 ah,3Eh
    int  21h
    inc  bx
    cmp  bx,5
    jb   @@nextfile 
    pop  dx
    shr  dx, 4
    add  dx, 10h
    mov	 ax,3100h
    int  21h
endif

@@exit:    
	mov     ah,04ch         ; that was all
	int 	21h
GO_EXE endp

driverret dw 0				; return value of init_jemm

;--- monitor installation
;--- expects on entry:
;--- SS=DS=DGROUP
;--- ES:SI=cmdline if running as driver
;--- out: AX=resident size (or NULL on errors)
;--- may modify all registers except SS:SP and CS

init_jemm PROC

	mov cs:[driverret],0

if 0; ?A20PORTS			;this info is unreliable, don't activate!
    mov		ax,2403h	;get A20 gate support
    int		15h
    cmp		ah,00		;ignore carry flag, it is not reliable
    jnz		@@noi1524
    mov		wBIOSA20,bx	
@@noi1524:    
endif
if 0
	mov		ah,5		;enable A20 local
    call 	dword ptr ds:[_XMSdriverAddress]
    and		ax, ax
    jz		@@ERROR2
endif    

;--- prepare running Jemm32
;--- set a GDTR on the stack

	MOV     AX, _TEXT32
    mov		ES, AX				; ES=_TEXT32
	MOVZX   EAX,AX
	SHL     EAX,4

    lea		edx, [eax+V86_TOS]	; assume GDT is located behind monitor stack
    push	edx
	push	4*8-1

FLAT_CODE_SEL equ 1*8

    push	FLAT_CODE_SEL
    push	eax
    mov		bp,sp
    mov		di, offset _jemmini	; DI=first parameter
    mov		bx, offset _brptab	; BX=second parameter
	CLI
	LGDT    FWORD PTR [bp+6]
    push	cs
    pop		ds					; DS=_TEXT16

	MOV     EAX,CR0			    ; Set the Protected-Mode-Enable-Bit in
	OR      AL,1			    ; CR0
	MOV     CR0,EAX			    ; In Protected-Mode !
    call	fword ptr [bp]		; expects ES=_TEXT32, DS=_TEXT16, SS=DGROUP
	add		sp,6+6

; In case the switch was succesfull, the remaining commands are
; already executed in virtual 8086-mode

;--- the virtual monitor init code has returned with
;--- SS:SP = unchanged
;--- CS, DS, ES, FS, GS = unchanged
;--- EAX = physical address of start of EMS/VCPI memory
;--- interrupts are still disabled

    assume	DS:_TEXT16
	assume	ss:DGROUP
    
    push	eax 				; FIRSTPAGE value

    sti

	mov		si,offset _TEXT16:intvecs
@@nextint:
    mov		al,[si].INTMOD.bInt
    cmp		al,-1
    jz		@@intmoddone
    mov		di,[si].INTMOD.wOld
    cmp		di,-1
    jz		@@nooldsave
    mov		ah,35h
    int		21h
    mov		[di+0],bx
    mov		[di+2],es
@@nooldsave:
	mov		ah,25h
    mov		dx,[si].INTMOD.wNew
    int		21h
    add		si,size INTMOD
    jmp		@@nextint

INTMOD struc
bInt	db ?
wNew	dw ?
wOld	dw ?
INTMOD ends

intvecs label INTMOD
	INTMOD <15h,offset NEW15, offset OLDINT15>
if ?DMA    
	INTMOD <13h,offset NEW13, offset OLDINT13>
	INTMOD <40h,offset NEW40, offset OLDINT40>
endif
	INTMOD <67h,offset NEW67, -1>
	INTMOD <06h,offset NEW06, -1>
    db -1

@@intmoddone:

;-- set new interrupt routine offset in the driver header, so any further
;-- access to device EMMXXXX0 is handled by the monitor

    mov 	[pIntOfs],offset BPDRV
    mov 	[pStratOfs],offset BPSTRAT

	push	ss
    pop		ds
	assume	DS:DGROUP
	call  	_TheV86Main		; do postprocessing work
    pop		cx				; skip DWORD parameter
    pop		cx

	mov cs:[driverret], OFFSET _TEXT16:RSEG_END	;set end offset resident part
    
	push	ax					; ax == 1 if UMBs are to be installed
    
    call	endinit
    
    call	_InstallXMSHandler	; this proc has stdcall convention


; local disable A20 again (since we enabled it in TheRealMain)

	push	6					; disable A20
	call	_xmscall
    pop		cx
    
    cmp _startup_verbose,0
    jz  @@nomsg
    mov dx, offset DGROUP:dBye
@@driver_exit:
    mov ah, 9
    int 21h
@@nomsg:    
	mov ax, cs:[driverret]
	ret

init_jemm ENDP

    assume ss:nothing
	assume es:nothing
	assume ds:DGROUP

_IsProtectedMode proc near
	SMSW    AX
	AND    AX,0001H             ; PE-Bit (Protect Enable) set ?
	ret
_IsProtectedMode ENDP

if ?ADDCONT

;--- this will eventually make segment A000-AFFF (and B000-B7FF)
;--- part of conventional DOS memory if option RAM=A000-AFFF is given

_AddIfContiguousWithDosMem proc 
	push bp
    mov bp,sp
    push si
    push es
if 0    
    mov ah, 52h
    int 21h
	mov es, es:[bx-2]
@@nextblock:
    mov al, es:[0]
    cmp al,'Z'
    jz @@endfound
    cmp al,'M'
    jnz @@error
    mov ax, es:[3]
    mov cx, es
    add ax, cx
    inc ax
    mov es, ax
    jmp @@nextblock
@@endfound:
	mov ax, es:[3]
    inc ax
    mov cx, es	;save last Z block in cx
    add ax, cx
    mov es, ax
    cmp word ptr es:[1],8
    jnz @@error
    cmp word ptr es:[8],"CS"
    jnz @@error
    inc ax
    mov si, [bp+4]
    cmp ax, si
    jnz @@error

	mov si, [bp+6]
    
;--- ok, found and contiguous
    
@@error:    
endif
    xor ax, ax
    pop es
    pop si
    pop bp
    ret
_AddIfContiguousWithDosMem endp    

endif

_memcpy proc
	push bp
    mov bp,sp
    push si
    push di
    mov di,[bp+4]
    mov si,[bp+6]
    mov cx,[bp+8]
    rep movsb
    pop di
    pop si
    pop bp
    ret
_memcpy endp

_fmemset proc
	push bp
    mov bp,sp
	push di
    les di,[bp+4]
    mov ax,[bp+8]
    mov cx,[bp+10]
    rep stosb
    pop di
    pop bp
	ret
_fmemset endp

;--- convert long to string
;--- ltob(long n, char * s, int base);


_ltob	PROC

n	equ <bp+4>
s	equ <bp+8>
base equ <bp+10>

	push	bp
    mov		bp,sp
	push	edi
	push	si
;	n = 4
;	s = 8
;	base = 10
;	u = -4
;	register si = p
	mov ch,0
	movzx edi,WORD PTR [base]
	mov	eax,[n]
	cmp	di,-10
	jne	@@ispositive
	mov	di,10
    and eax,eax
    jns @@ispositive
    neg eax
    mov ch,'-'
@@ispositive:
	mov	bx,[s]
	lea	si,[bx+10]
	mov	BYTE PTR [si],0
	dec	si
@@nextdigit:
	xor edx, edx
    div edi
	add dl,'0'
    cmp dl,'9'
    jbe @@isdigit
    add dl,7+20h
@@isdigit:    
	mov	[si],dl
	dec	si
    and eax, eax
	jne	@@nextdigit
    cmp ch,0
	je	@@nosign
	mov	[si],ch
	dec	si
@@nosign:
	inc si
	mov	ax,si
	pop	si
	pop	edi
	pop bp
	ret	

n	equ <>
s	equ <>
base equ <>

_ltob	ENDP


;--- TestForSystemRAM(void *, int, int *);

_TestForSystemRAM proc
	push bp
    mov bp,sp
    push 0
    push si
    push di
    xor di, di
    mov si, [bp+4]
    mov dx, [bp+6]
    add si, dx
    mov cx, 100h
    sub cx, dx
    jbe @@done
@@nextpage:
	lodsb
    cmp al,'U'
    jz @@testitem
    cmp al,'I'			;'I' is also tested, but not modified
    jnz @@skipitem		;so a warning can be displayed 
@@testitem:    
    mov ax, dx
    shl ax, 8
    mov es, ax
    cli
    mov ax, es:[0]
    mov bx, ax
    xor ax, 055AAh
    mov es:[0], ax
    cmp ax, es:[0]
    jnz @@noram
    xor ax, 0AA55h
    mov es:[0], ax
    cmp ax, es:[0]
    jnz @@noram
    
    cmp byte ptr [si-1], 'U'
    jnz @@nochange
	mov byte ptr [si-1], 'R'    
@@nochange:
	and di,di
    jnz  @@notstart
    mov di, es
@@notstart:    
    add word ptr [bp-2], 100h	;in paragraphs
    jmp @@shared
    
@@noram:
    and di, di
    jz @@shared	;skip test now, found a region
    mov cx,1
@@shared:
	cmp bx, es:[0]
    jz  @@unchanged
	mov es:[0],bx
@@unchanged:    
    sti
@@skipitem:
	inc dx
	loop @@nextpage
@@done:    
    mov bx, [bp+8]
    mov cx, [bp-2]
    mov [bx],cx
    mov ax, di
    pop di
    pop si
    mov sp,bp
    pop bp
	ret 
_TestForSystemRAM endp

IsJemmInstalled proc
	mov bx, -1
	mov dx, offset sig1
    mov ax, 3D00h
    int 21h
    jnc @@found
    mov dx, offset sig2
    mov ax, 3D00h
    int 21h
    jc @@nojemm
@@found:
    mov bx,ax
    xor ax,ax
    push ax
    push ax
    push ax
    mov cx,6
    mov dx, sp
    mov ax,4402h	;read ioctl
    int 21h
    pop ax
    pop cx
    pop cx
    jc  @@nojemm
    cmp ax,0028h	;this is JEMM386!
    jnz @@nojemm
    mov ax,bx
    clc
	ret
@@nojemm:
	cmp bx,-1
    jz  @@noclose
    mov ah,3Eh
    int 21h
@@noclose:    
	stc
    ret
IsJemmInstalled endp


	assume DS:DGROUP

buff equ <bp-34>

_EmmStatus proc
    push di
    push si
	push bp
    mov bp,sp
    push -1
    sub sp,32
	call IsJemmInstalled
    jc  @@nojemm
    mov [bp-2],ax
    mov bx, ax
    lea dx, [buff]	;get version
	mov byte ptr [buff],2
    mov cx,2
    mov ax,4402h	;read ioctl
    int 21h
    jc  @@nojemm
    movzx ax, byte ptr [buff+0]
    movzx cx, byte ptr [buff+1]
    push cx
    push ax
    push offset szDispVer
    call _printf
    add sp,3*2

;--- get EMS, VCPI, UMB, VME, A20 infos

    lea dx, [buff]
	mov byte ptr [buff],6
    mov cx,24
	mov bx, [bp-2]
    mov ax,4402h	;read ioctl
    int 21h
    jc  @@close

    mov di, ax

    mov dx, offset szOff
    lea si, [buff]
    cmp [si].EMX06.e06_NoEMS, 0
	jnz @@emsflag
    mov dx, offset szOn
@@emsflag:    
    push dx
    push offset szEMSStatus
    call _printf 
    pop cx
    pop cx

	cmp [si].EMX06.e06_NoEMS,0
    jnz @@nodispframe			;dont display FRAME status if no EMS

    mov ah,42h
    int 67h
    mov ax, dx
    sub ax, bx
	push dx
    push ax
    push offset szEMSMemory
    call _printf
    add sp,3*2

	mov ax, offset szFrameNone
    mov cx, [si].EMX06.e06_Frame
	jcxz @@noframe
	mov ax, offset szFrameYes
@@noframe:
    push cx
    push ax
    call _printf
    pop cx
    pop cx

@@nodispframe:
	push offset szDotLF
    call _printf
    pop cx

    cmp [si].EMX06.e06_NoVCPI, 0            	;_NoVCPI flag
	jnz @@vcpioff
    push [si].EMX06.e06_VCPITotal
    push [si].EMX06.e06_VCPIUsed
    push offset szVCPIOn
    call _printf
    add sp,2+4+4
    jmp @@vcpidone
    
@@vcpioff:
	push offset szVCPIOff
    call _printf
    pop cx
@@vcpidone:

	mov ax, 64		;default DMA buffer size
    cmp di, 16		;could the DMA buffer size be read?
    jb  @@nodmasize
    mov ax, [si].EMX06.e06_DMASize
@@nodmasize:    
    mov ecx, [si].EMX06.e06_DMABuff
    push ax
    push ecx
    push offset szDMABuffer
    call _printf
    add sp,2+4+2

if ?A20PORTS or ?A20XMS
	mov ax, offset szOff
    cmp [si].EMX06.e06_NoA20, 0
	jnz @@a20flag
	mov ax, offset szOn
@@a20flag:
    push ax
    push offset szA20Status
    call _printf
    pop cx
    pop cx
endif

if ?VME
	mov ax, offset szOff
    cmp [si].EMX06.e06_NoVME, 0
	jnz @@vmeflag
	mov ax, offset szOn
@@vmeflag:
    push ax
    push offset szVMEStatus
    call _printf
    pop cx
    pop cx
endif

if ?PGE
	mov ax, offset szOff
    cmp [si].EMX06.e06_NoPGE, 0
	jnz @@pgeflag
	mov ax, offset szOn
@@pgeflag:
    push ax
    push offset szPGEStatus
    call _printf
    pop cx
    pop cx
endif

    lea dx, [buff]
	mov byte ptr [buff],7
    mov cx,8*4
	mov bx, [bp-2]
    mov ax,4402h	;read ioctl
    int 21h
    jc  @@close

	lea si,[buff]
    mov cx, 8
@@nextumb:
    mov ax, [si+0]
    and ax, ax
	jz @@umbdone    
    push cx
    mov dx, [si+2]
    and dh, 7Fh ;reset highest flag
    add dx, ax
    dec dx
    push dx
    push ax
    push offset szUMB
    call _printf
    add sp, 3*2
    pop cx
    add si, 4
    loop @@nextumb
@@umbdone:
@@noumbs:

@@close:
	mov bx, [bp-2]
	cmp bx, -1
    jz  @@exit
    mov ah, 3Eh
    int 21h
@@exit:
	mov	sp,bp
    pop bp
	pop si
	pop di
    ret
@@nojemm:
	MOV     DX,OFFSET dError1
	MOV     AH,9
	INT     21H
	jmp		@@close
_EmmStatus endp

buff equ <bp-16>

_EmmUpdate proc
    push di
    push bp
	mov bp, sp
    sub sp,16
    xor di,di
    call IsJemmInstalled
    jnc @@jemmok
	MOV     DX,OFFSET dError1
	MOV     AH,9
	INT     21H
    jmp		@@exit
@@jemmok:    
    mov bx, ax
    mov byte ptr [buff+0],15
    mov ax,_TEXT32
    mov es,ax
    assume es:_TEXT32
    
;--- create a EMX15W variable to send to installed Jemm386    
    
?IOCTLBUFFSIZ = 5
if ?VME    
    mov al, [_jemmini.jiNoVME]
else
	mov al,-1
endif    
    mov [buff+1],al
if ?A20PORTS or ?A20XMS
    mov al, [_jemmini.jiNoA20]
else
	mov al,-1
endif    
    mov [buff+2],al
    mov al, [_jemmini.jiNoVCPI]
    mov [buff+3],al
if ?PGE
    mov al, [_jemmini.jiNoPGE]
else
	mov al,-1
endif    
    mov [buff+4],al
    assume es:nothing

    mov cx,?IOCTLBUFFSIZ
    lea dx,[buff]
    mov ax,4403h	;write ioctl
    int 21h
    jc @@noioctlwrite
    inc di
@@noioctlwrite:    
    mov ah,3Eh
    int 21h
@@exit:
	mov ax,di
    mov sp,bp
    pop bp
    pop di
    ret
_EmmUpdate endp

endinit proc

;--- clear UMBs	

	mov si, offset DGROUP:_UMBsegments
if 1    
	mov cx, ?NUMUMBS
    push si
@@nextumb:    
    mov ax, [si].UMBBLK.wSegm
    and ax, ax
    jz @@umbcleared
    mov es, ax
    xor di, di
    push cx
    movzx ecx, word ptr [si].UMBBLK.wSize
    shl ecx, 2			;para -> dword
    xor eax, eax
    rep stosd
    pop cx
    add si, 4
    loop @@nextumb
@@umbcleared:
	pop si
endif
if ?MOVEHIGH
	cli
	mov cl,1
	cmp [_NoHigh],0
    jnz @@nomovehigh
    mov ax, cs
    cmp ax, 0A000h
    jae @@nomovehigh
    mov dx, RSEG_END / 10h
    cmp [si].UMBBLK.wSize, dx
    jb  @@nomovehigh
    push ds
    pusha
	mov	ax, [si].UMBBLK.wSegm
    mov es,ax
    push cs
    pop ds
    mov cx, RSEG_END / 2
    xor di,di
    xor si,si
    rep movsw
    push 0
    pop ds
;	mov		ds:[67h*4+2],ax
	mov		ds:[15h*4+2],ax
	mov		ds:[06h*4+2],ax
if ?DMA
	mov		ds:[13h*4+2],ax
	mov		ds:[40h*4+2],ax
endif
	test	byte ptr ds:[47Bh],20h
    jz		@@novds
    mov		ds:[4Bh*4+2],ax
@@novds:
	popa
	pop ds
    add [si].UMBBLK.wSegm, dx
    sub [si].UMBBLK.wSize, dx
    mov cl,0
	mov cs:[driverret], 0
@@nomovehigh:
endif
	mov ax, 449Fh		;request end of initialization phase
    xor dx, dx			;system handle
    int 67h
if ?MOVEHIGH
	test cl,1
    jnz @@nomove2
	mov ah,52h
    int 21h
    push ds
    push 0
    pop ds
    mov ax,ds:[67h*4+2]
    mov ds,ax
    add bx,22h
    shl eax,16
    xchg eax,es:[bx]
	mov ds:[0],eax
    pop ds
@@nomove2:    
	sti
endif
    ret
endinit endp

;--- _InstallXMSHandler is a stdcall proc

_InstallXMSHandler proc
	push bp
    mov bp,sp
ife ?A20XMS      		;if there is no XMS A20 trapping
    mov ax, [bp+4]		;XMS hook is needed *only* for UMBs.
    and ax, ax			;then dont install if no UMBs are supplied
    jz @@umbdone
endif    
    mov ax,4300h
    int 2Fh
    cmp al,80h
    jnz @@noxms
    mov ax,4310h
    int 2Fh
    push es
    push bx
    mov dx, -1
    mov ah, 10h
    call dword ptr [bp-4]
    and ax, ax
    jnz @@umbalreadythere
    les bx,[bp-4]
@@nexttest:
	mov al,es:[bx]
    cmp al,0EBh
    jz  @@endofchain
    les bx,es:[bx+1]
    cmp al,0EAh
    jz @@nexttest
;--- unexpected pattern found in XMS hook chain
    jmp @@umbdone
@@endofchain:
	cli
    mov byte ptr es:[bx+0],0EAh
    mov word ptr es:[bx+1],offset XMShandler
    push ds
if ?MOVEHIGH    
    push 0
    pop ds
    mov ax,ds:[67h*4+2]
else
	mov ax, cs
endif
    mov es:[bx+3], ax
    add bx,5
    mov ds, ax
    assume DS:_TEXT16
    mov word ptr ds:[XMSoldhandler+0],bx
    mov word ptr ds:[XMSoldhandler+2],es
if ?A20XMS
    mov ax, [bp+4]
    and ax, ax
    jnz @@xmswithumb
    mov byte ptr ds:[XMSUMB], 0EAh
    mov word ptr ds:[XMSUMB+1], bx
    mov word ptr ds:[XMSUMB+3], es
@@xmswithumb:
endif
	pop ds
    assume DS:DGROUP
	sti
    jmp @@umbdone
@@umbalreadythere:
	push offset DGROUP:szUMBErr1
    call _printf
    pop cx
@@noxms:
@@umbdone:
	mov sp,bp
    pop bp
	ret 2
_InstallXMSHandler endp

_put_console proc

	pop cx
    pop dx
    push dx
    push cx
    cmp dl,10
    jnz @@isnotlf
    push dx
    mov dl,13
    mov ah,2
    int 21h
    pop dx
@@isnotlf:    
    mov ah,2
	int 21h
    ret
    
_put_console endp

;--- C compiler helper procs. Avoids to need the C runtime libs

divprocs proc

ife (?WCC + ?MSC + ?DMC)
?TCC equ 1
else
?TCC equ 0
endif

if ?TCC

	public	LDIV@			; the procs which were in LIBM.LIB
    public	LUDIV@			; are now implemented here
	public	LMOD@
    public	LUMOD@
	public	LXLSH@
	public	LXRSH@
	public	LXURSH@
	public	LXMUL@
if ?NEARC    
    public	N_LUDIV@
	public	N_LXLSH@
	public	N_LXRSH@
	public	N_LXURSH@
endif    

;--- [bp+6] mod|div [bp+10]
;--- clears stack!


if ?MASM
LMOD@::
LUMOD@::
else
LMOD@:
LUMOD@:
endif
		mov bl,1
        jmp @@common
if ?MASM
LDIV@::
LUDIV@::
else
LDIV@:
LUDIV@:
endif
		mov bl,0
@@common:        
    	push BP
		mov	BP,SP
        mov eax, [bp+6]
        mov ecx, [bp+10]
        cdq
        div ecx
        test bl,1
        jz @@isdiv
        mov eax, edx
@@isdiv:        
        push eax
        pop ax
        pop dx
        pop bp
        retf 8
if ?NEARC        
if ?MASM
N_LDIV@::
N_LUDIV@::
else
N_LDIV@:
N_LUDIV@:
endif
		mov bl,0
    	push BP
		mov	BP,SP
        mov eax, [bp+6]
        mov ecx, [bp+10]
        cdq
        div ecx
        test bl,1
        jz @@n_isdiv
        mov eax, edx
@@n_isdiv:        
        push eax
        pop ax
        pop dx
        pop bp
        ret 8
endif

;--- shl DX:AX CL bits

if ?MASM
LXLSH@::
else
LXLSH@:
endif
		push dx
        push ax
        pop eax
        shl eax, cl
        push eax
        pop ax
        pop dx
        retf

if ?NEARC
if ?MASM
N_LXLSH@::
else
N_LXLSH@:
endif
		push dx
        push ax
        pop eax
        shl eax, cl
        push eax
        pop ax
        pop dx
        ret
endif

;--- shr DX:AX CL bits

if ?MASM
LXURSH@::
LXRSH@::
else
LXURSH@:
LXRSH@:
endif
		push dx
        push ax
        pop eax
        shr eax, cl
        push eax
        pop ax
        pop dx
		retf
if ?NEARC
if ?MASM
N_LXURSH@::
N_LXRSH@::
else
N_LXURSH@:
N_LXRSH@:
endif
		push dx
        push ax
        pop eax
        shr eax, cl
        push eax
        pop ax
        pop dx
		ret
endif

;--- mul DX:AX with CX:BX, result in DX:AX

if ?MASM
LXMUL@::
else
LXMUL@:
endif
		push dx
		push ax
        pop eax
        push cx
        push bx
        pop ecx
        mul ecx
        push eax
        pop ax
        pop dx
		retf
endif

if ?WCC        
        public __U4D	;used by WCC (dx:ax / cx:bx = dx:ax, remainder in cx:bx)
        public __I4M	;used by WCC (dx:ax * cx:bx = dx:ax)
if ?MASM
__U4D::
else
__U4D:
endif
		push dx
		push ax
        pop eax
        push cx
        push bx
        pop ecx
        cdq
        div ecx
        push edx	;remainder into CX:BX
        pop bx
        pop cx
        push eax
        pop ax
        pop dx
		ret
if ?MASM
__I4M::
else
__I4M:
endif
		push dx
		push ax
        pop eax
        push cx
        push bx
        pop ecx
        cdq
        mul ecx
        push eax
        pop ax
        pop dx
		ret
endif

if ?MSC

;--- some publics for MS C 1.5

		public __aNulrem
		public __aNuldiv
		public __aNulshr
		public __aNlmul
		public __aNlshl

if ?MASM
__aNulrem::
else
__aNulrem:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        cdq
        div ecx
        push edx
        pop ax
        pop dx
		ret
if ?MASM        
__aNuldiv::
else
__aNuldiv:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        cdq
        div ecx
        push eax
        pop ax
        pop dx
		ret
if ?MASM        
__aNlmul::
else
__aNlmul:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        mul ecx
        push eax
        pop ax
        pop dx
		ret
if ?MASM
__aNulshr::
else
__aNulshr:
endif
		push dx
        push ax
        pop eax
        shr eax, cl
        push eax
		pop ax
        pop dx
		ret
if ?MASM        
__aNlshl::
else
__aNlshl:
endif
		push dx
        push ax
        pop eax
        shl eax, cl
        push eax
		pop ax
        pop dx
		ret

endif

if ?DMC

;--- some publics for DMC

		public __ULREM@
		public __ULDIV@
		public __ULSHR@
		public __aNlmul
		public __aNlshl

if ?MASM
__ULREM@::
else
__ULREM@:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        cdq
        div ecx
        push edx
        pop ax
        pop dx
		ret
if ?MASM        
__ULDIV@::
else
__ULDIV@:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        cdq
        div ecx
        push eax
        pop ax
        pop dx
		ret
if ?MASM        
__aNlmul::
else
__aNlmul:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        mul ecx
        push eax
        pop ax
        pop dx
		ret
if ?MASM
__ULSHR@::
else
__ULSHR@:
endif
		push dx
        push ax
        pop eax
        shr eax, cl
        push eax
		pop ax
        pop dx
		ret
if ?MASM        
__aNlshl::
else
__aNlshl:
endif
		push dx
        push ax
        pop eax
        shl eax, cl
        push eax
		pop ax
        pop dx
		ret

endif

divprocs endp

STREG16 struc
st_ax	dw ?
st_bx	dw ?
st_cx	dw ?
st_dx	dw ?
STREG16 ends

        
_emmcall proc
		push bp
        mov bp,sp
        push si
        mov si,offset DGROUP:_emmreg16
        mov ax,[si].STREG16.st_ax
        mov ah, [bp+4]
        mov _emmfunction, ah
        mov bx,[si].STREG16.st_bx
        mov cx,[si].STREG16.st_cx
        mov dx,[si].STREG16.st_dx
        int 67h
        mov [si].STREG16.st_ax,ax
        mov [si].STREG16.st_bx,bx
        mov [si].STREG16.st_cx,cx
        mov [si].STREG16.st_dx,dx
        movzx ax,ah
        pop si
        pop bp
		ret
_emmcall endp

        
_xmscall proc
		push bp
        mov bp,sp
        push si
        mov si,offset DGROUP:_reg16
        mov bx,[si].STREG16.st_bx
        mov dx,[si].STREG16.st_dx
        mov ah, [bp+4]
        call dword ptr ds:[_XMSdriverAddress]
        mov [si].STREG16.st_ax,ax
        mov [si].STREG16.st_bx,bx
        mov [si].STREG16.st_dx,dx
        pop si
        pop bp
		ret
_xmscall endp

STREG32 struc
st_eax	dd ?
st_ebx	dd ?
st_ecx	dd ?
st_edx	dd ?
STREG32 ends

_xmscall32 proc
		push bp
        mov bp,sp
        push si
        mov si,offset DGROUP:_reg32
        mov ebx,[si].STREG32.st_ebx
        mov edx,[si].STREG32.st_edx
        mov ah, [bp+4]
        call dword ptr ds:[_XMSdriverAddress]
        mov [si].STREG32.st_eax,eax
        mov [si].STREG32.st_ebx,ebx
        mov [si].STREG32.st_ecx,ecx
        mov [si].STREG32.st_edx,edx
        pop si
        pop bp
		ret
_xmscall32 endp

_XMSinit proc
	    mov ax, 4300h
		int 2fh
		cmp al, 80h
		jne @@not_detected
		mov ax, 4310h
		int 2fh
		mov word ptr _XMSdriverAddress+0, bx
		mov word ptr _XMSdriverAddress+2, es

		mov ax, 4309h		;  XMS get xms handle table
		int 2fh
		cmp al,43h
		jne @@no_table
		mov word ptr _jemmini.jiXMSHandleTable+0, bx
		mov word ptr _jemmini.jiXMSHandleTable+2, es
@@no_table:
		mov ax,1
		ret
@@not_detected:
		xor ax,ax
        ret
_XMSinit endp

_VMwareDetect proc
		
		mov eax, 564D5868h	;/* mov eax,564d5856h */
		mov ecx, 0000000ah
		mov ebx,ecx
		mov dx, 5658h
		in eax,dx
		cmp ebx, 564D5868h
		jne @@failed
        mov ax,1
        ret
@@failed:
		xor ax, ax
        ret
_VMwareDetect endp

if ?WCC
		public _small_code_	;required by Open Watcom WCC
_small_code_ label byte

endif

_TEXT ENDS

_STACK	segment

		db 1024 dup(?)       ; stack for the C - things

exe_stacktop label byte

_STACK	ends

		end GO_EXE
