#
# To build Jemm386, you will need:
#
# Tool        Default (recommended) Alternatives
#-----------------------------------------------------------------
# Assembler   JWasm                 Masm 6.14/6.15/7.00
# C Compiler  Open Watcom WCC       MS VC++ 1.5, Turbo C 2.01/4.0, DMC
# OMF Linker  Open Watcom Wlink     DM OptLink, MS Link, TLink 7.1.30
# COFF Linker Open Watcom Wlink     MS Link, PoLink
# Make        Open Watcom Wmake     MS NMAKE, Borland MAKE (v3.6+)
#
# not all combinations work, however, i.e. OW WLINK won't link modules
# compiled with MS VC.
#
# Since Jemm386 v5.4, the 32bit code uses the FLAT memory model and
# is linked separately. This complicates the build process slightly:
#
#  1. assemble + link Jemm32 to Jemm32.bin. This is a Win32 PE binary.
#  2. use EXTRSECT to extract the section contents of this binary to file
#     Jemm32.inc.
#  3. assemble Jemm16.asm (which includes Jemm32.inc).
#  4. compile the C modules with 16-bit compiler.
#  5. link Jemm16.obj and C modules to Jemm386.exe.

!ifndef DEBUG
DEBUG=0
!endif

# select assembler, default JWasm

!ifndef MASM
MASM=0
!endif

# select 16-bit C compiler, default WCC

!ifndef WCC
WCC=0
!endif
!ifndef MSC
MSC=0
!endif
!ifndef DMC
DMC=0
!endif
!ifndef TCC
TCC=0
!endif

!if $(WCC)+$(MSC)+$(DMC)+$(TCC)==0
WCC=1
WATCOM=\WATCOM\BINNT
!endif

COFFMODS=$(OUTDIR)\jemm32.obj $(OUTDIR)\ems.obj  $(OUTDIR)\vcpi.obj &
         $(OUTDIR)\dev.obj    $(OUTDIR)\xms.obj  $(OUTDIR)\dma.obj  &
         $(OUTDIR)\vds.obj    $(OUTDIR)\i15.obj  $(OUTDIR)\emu.obj  &
         $(OUTDIR)\pool.obj   $(OUTDIR)\init.obj $(OUTDIR)\debug.obj

# select Win32 COFF linker, default MS LINK

!ifndef WLINK32
WLINK32=1
!endif

!if $(WLINK32)
# wlink
LINK32=wlink format windows nt file {$(COFFMODS)} name $(OUTDIR)\jemm32.bin option offs=0x100000, objalign=0x10000, start=_start, map=$(OUTDIR)\jemm32.map, quiet, norelocs
!else
# MS link (option FILEALIGN may be rejected by newer versions)
COFFOPT=/nologo /fixed /driver /subsystem:native /entry:start /base:0x100000 /align:0x10000 /MAP:$(OUTDIR)\jemm32.map /OUT:$(OUTDIR)\jemm32.bin
LINK32=link.exe /FileAlign:0x200 $(COFFOPT) $(COFFMODS)
# PoLink
#LINK32=polink.exe $(COFFOPT) $(COFFMODS)
!endif

# select OMF linker, default WLINK

!ifndef WLINK
WLINK=0
!endif
!ifndef OPTLINK
OPTLINK=0
!endif
!ifndef MSLINK
MSLINK=0
!endif
!ifndef TLINK
TLINK=0
!endif
!ifndef VALX
VALX=0
!endif

!if $(TLINK)+$(WLINK)+$(VALX)+$(MSLINK)+$(OPTLINK)==0
WLINK=1
!endif

NAME=JEMM386

!if $(DEBUG)
!if $(MASM)
AOPTD=-D_DEBUG
!else
AOPTD=-d_DEBUG
!endif
OUTDIR=DEB386
!else
AOPTD=
OUTDIR=REL386
!endif

!if $(MASM)
ASM=ml.exe
!else
ASM=jwasm.exe
!endif

AS1=$(ASM) -c -Cp -nologo $(AOPTD) -Fl$(OUTDIR)\jemm16.LST -Fo$(OUTDIR)\jemm16.OBJ -D?WCC=$(WCC) -D?MSC=$(MSC) -D?DMC=$(DMC) -I$(OUTDIR)
AS2=$(ASM) -c -Cp -nologo -coff $(AOPTD) -Fl$*.LST -Fo$*.OBJ

!if $(WCC)
CC=$(WATCOM)\wcc.exe -3 -bt=dos -ecc -ms -os -q -s -fp3 -w=3
# the OW C++ compiler produces slightly better code
#CC=wpp.exe -3 -bt=dos -ecc -ms -os -q -s -fp3 -w=3
OUTO=-fo
!endif
!if $(DMC)
CC=\dm\bin\sc.exe -msd -c -3 -J -o
OUTO=-o
!endif
!if $(TCC)
CC=tcc.exe -c -G- -w -r -N- -O -Z -k-
#CC=bcc.exe -c -3 -N- -O -w -Z
OUTO=-o
!endif
!if $(MSC)
CC=cl.exe -c -nologo -O1 -G3 -Gs -Gx -J -Zl -Fl$*.lst
OUTO=-Fo
!endif

!if $(WLINK)
LINK16=$(WATCOM)\wlink.exe format dos file $(OUTDIR)\jemm16.obj,$(OUTDIR)\jemm16c.obj name $(OUTDIR)\$(NAME).EXE option map=$(OUTDIR)\$(NAME).MAP, quiet
!endif
!if $(OPTLINK)
LINK16=\dm\bin\link.exe /MAP:FULL /NOD /NOI /ONE:NOE $(OUTDIR)\jemm16.obj $(OUTDIR)\jemm16c.obj,$(OUTDIR)\$(NAME).EXE,$(OUTDIR)\$(NAME).MAP;
!endif  
!if $(MSLINK)
LINK16=link16.exe /MAP:FULL/NOD /NOI $(OUTDIR)\jemm16.obj $(OUTDIR)\jemm16c.obj,$(OUTDIR)\$(NAME).EXE,$(OUTDIR)\$(NAME).MAP;
!endif  
!if $(TLINK)
LINK16=tlink.exe /3 /m /s /n $(OUTDIR)\jemm16.obj $(OUTDIR)\jemm16c.obj,$(OUTDIR)\$(NAME).EXE,$(OUTDIR)\$(NAME).MAP;
!endif
!if $(VALX)
LINK16=valx.exe /MAP $(OUTDIR)\jemm16.obj $(OUTDIR)\jemm16c.obj,$(OUTDIR)\$(NAME).EXE,$(OUTDIR)\$(NAME).MAP;
!endif

ALL: $(OUTDIR) $(OUTDIR)\$(NAME).EXE

$(OUTDIR):
	@mkdir $(OUTDIR)
  
$(OUTDIR)\$(NAME).EXE: $(OUTDIR)\jemm16.obj $(OUTDIR)\jemm16c.obj 
	$(LINK16)

$(OUTDIR)\jemm16.obj: jemm16.asm jemm.inc debug.inc $(OUTDIR)\_jemm32.inc $(NAME).MAK
	@$(AS1) jemm16.asm

$(OUTDIR)\jemm16c.obj: jemm16c.c jemm16c.h $(NAME).MAK
	@$(CC) $(OUTO)$(OUTDIR)\jemm16c.obj jemm16c.c

COFFDEPS=$(COFFMODS:.\=REL386\)

$(OUTDIR)\_jemm32.inc: $(OUTDIR)\jemm32.bin
	@extrsect -i -q -x 0 $(OUTDIR)\jemm32.bin $(OUTDIR)\_jemm32.inc

$(OUTDIR)\jemm32.bin: $(COFFDEPS)
	@$(LINK32) 

32BITDEPS=jemm32.inc jemm.inc external.inc debug.inc $(NAME).MAK

$(OUTDIR)\jemm32.obj: jemm32.asm $(32BITDEPS)
	@$(AS2) jemm32.asm

$(OUTDIR)\ems.obj: ems.asm ems32.inc $(32BITDEPS)
	@$(AS2) ems.asm

$(OUTDIR)\vcpi.obj: vcpi.asm $(32BITDEPS)
	@$(AS2) vcpi.asm

$(OUTDIR)\dev.obj: dev.asm $(32BITDEPS)
	@$(AS2) dev.asm

$(OUTDIR)\xms.obj: xms.asm $(32BITDEPS)
	@$(AS2) xms.asm

$(OUTDIR)\vds.obj: vds.asm $(32BITDEPS)
	@$(AS2) vds.asm

$(OUTDIR)\pool.obj: pool.asm $(32BITDEPS)
	@$(AS2) pool.asm

$(OUTDIR)\init.obj: init.asm $(32BITDEPS)
	@$(AS2) init.asm

$(OUTDIR)\dma.obj: dma.asm $(32BITDEPS)
	@$(AS2) dma.asm

$(OUTDIR)\emu.obj: emu.asm $(32BITDEPS)
	@$(AS2) emu.asm

$(OUTDIR)\i15.obj: i15.asm $(32BITDEPS)
	@$(AS2) i15.asm

$(OUTDIR)\debug.obj: debug.asm $(32BITDEPS)  
	@$(AS2) debug.asm

clean:
	@if exist $(OUTDIR)\*.obj erase $(OUTDIR)\*.obj
	@if exist $(OUTDIR)\*.lst erase $(OUTDIR)\*.lst
	@if exist $(OUTDIR)\*.map erase $(OUTDIR)\*.map
	@if exist $(OUTDIR)\*.exe erase $(OUTDIR)\*.exe
	@if exist $(OUTDIR)\*.bin erase $(OUTDIR)\*.bin

