
/************************************************************************/
/*                                                                      */
/* FILE: proto.h                                                        */
/* Global function prototypes                                           */
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* This file is part of G-COM.                                          */
/* G-COM is derived from DOS-C source (GPL).                            */
/*                                                                      */
/* (C) Copyright 1999-2000  Roberto Gordo Saez   (GCOM)                 */
/* (C) Copyright 1995-1998  Pasquale J. Villani  (DOSC)                 */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option)  */
/* any later version.                                                   */
/*                                                                      */
/* This program is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     */
/* General Public License for more details.                             */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.                  */
/*                                                                      */
/************************************************************************/


/* -------------------------------------------------------------------- */
/* batch.c                                                              */
/* -------------------------------------------------------------------- */

BYTE batch              (char*, int, char*);
BOOL cmd_call_bat       (char*, int, char*);
BOOL cmd_goto_bat       (char*, int, char*);
BOOL cmd_rem_bat        (char*, int, char*);
BOOL cmd_shift_bat      (char*, int, char*);


/* -------------------------------------------------------------------- */
/* command.c                                                            */
/* -------------------------------------------------------------------- */

BOOL do_command         (char*);
BOOL cmd_exit           (char*, int, char*);


/* -------------------------------------------------------------------- */
/* doslib.c                                                             */
/* -------------------------------------------------------------------- */

UWORD DosAllocMem       (UWORD, DWORD FAR*);
DWORD DosCd             (char FAR*);
DWORD DosClose          (UWORD);
DWORD DosCreate         (char FAR*, UWORD);
DWORD DosDelete         (char FAR*);
DWORD DosDupHandle      (DWORD, DWORD FAR*);
DWORD DosExec           (char FAR*, exec_block FAR*);
void DosExit            (UBYTE);
DWORD DosForceDupHandle (DWORD, DWORD);
DWORD DosFreeMem        (UWORD);
BOOL DosGetBreak        (void);
char DosGetChar         (void);
void DosGetDate         (UBYTE*, UBYTE*, UBYTE*, UWORD*);
UBYTE DosGetDrive       (void);
DWORD DosGetInfo        (info FAR*);
psp FAR *DosGetPSP      (void);
void DosGetTime         (UBYTE*, UBYTE*, UBYTE*, UBYTE*);
BOOL DosGetVerify       (void);
DWORD DosOpen           (char FAR*, UBYTE);
BOOL DosParseFilename   (char FAR*, fcb FAR*, UBYTE);
DWORD DosPwd            (UBYTE, char FAR*);
DWORD DosRead           (UWORD, char FAR*, UWORD);
UWORD DosRtnValue       (void);
DWORD DosSeek           (UWORD, UBYTE, DWORD);
void DosSetBreak        (BOOL);
void DosSetDrive        (UBYTE);
void DosSetInt          (UBYTE, void FAR*);
void DosSetVerify       (BOOL);
DWORD DosWrite          (UWORD, char FAR*, UWORD);


/* -------------------------------------------------------------------- */
/* env.c                                                                */
/* -------------------------------------------------------------------- */

unsigned int EnvGetSize (void);
void EnvAlloc           (unsigned int);
char FAR *EnvLookup     (char*);
BOOL EnvClearVar        (char*);
void EnvSetVar          (char*, char*);
void EnvDump            (void);


/* -------------------------------------------------------------------- */
/* error.c                                                              */
/* -------------------------------------------------------------------- */

void error_message      (enum error_msg_idx);
void InitHandler        (void);


/* -------------------------------------------------------------------- */
/* exec.c                                                               */
/* -------------------------------------------------------------------- */

BOOL ExecCmd            (char*, int, char*);
BOOL Execute            (char*, int, char*);


/* -------------------------------------------------------------------- */
/* intcmds.c                                                            */
/* -------------------------------------------------------------------- */

BOOL cmd_beep           (char*, int, char*);
BOOL cmd_break          (char*, int, char*);
BOOL cmd_cd             (char*, int, char*);
BOOL cmd_echo           (char*, int, char*);
BOOL cmd_echo_dot       (char*, int, char*);
BOOL cmd_path           (char*, int, char*);
BOOL cmd_pause          (char*, int, char*);
BOOL cmd_set            (char*, int, char*);
BOOL cmd_unset          (char*, int, char*);
BOOL cmd_ver            (char*, int, char*);
BOOL cmd_verify         (char*, int, char*);


/* -------------------------------------------------------------------- */
/* library.c                                                            */
/* -------------------------------------------------------------------- */

unsigned int strlen     (REG char*);
unsigned int fstrlen    (REG char FAR*);
void strcpy             (REG char*, REG char*);
BOOL strncpy            (REG char*, REG char*, unsigned int);
BOOL fstrncpy           (REG char FAR*, REG char FAR*, unsigned int);
BOOL strcmp             (REG char*, REG char*);
BOOL stricmp            (REG char*, REG char*);
BOOL strncmp            (REG char*, REG char*, unsigned int);
BOOL fstrnicmp          (REG char FAR*, REG char FAR*, unsigned int);
char toupper            (char);

void printf             (char*, ...);

BOOL isdigit            (int);
BOOL isalpha            (int);
char *itoa              (int, char*, UBYTE);
char *uitoa             (unsigned int, char*, UBYTE);
char *ltoa              (long, char*, UBYTE);
char *ultoa             (unsigned long, char*, UBYTE);
int atoi                (char*);


/* -------------------------------------------------------------------- */
/* prompt.c                                                             */
/* -------------------------------------------------------------------- */

void put_prompt         (REG char*);
BOOL cmd_prompt         (char*, int, char*);


/* -------------------------------------------------------------------- */
/* scan.c                                                               */
/* -------------------------------------------------------------------- */

void parsing            (char*, char FAR*, void*, ...);
BOOL expand             (REG char*, char**);
char *skipwh            (char*);
char FAR *fskipwh       (char FAR*);
BOOL issep              (char);
char *scanfile          (char*);
BOOL checkfile          (char*);
int num_args            (char*);


/* -------------------------------------------------------------------- */
/* time.c                                                               */
/* -------------------------------------------------------------------- */

void put_time           (UBYTE, UBYTE);
void put_full_time      (UBYTE, UBYTE, UBYTE, UBYTE);
void put_date           (UBYTE, UBYTE, UWORD);
BOOL cmd_time           (char*, int, char*);
BOOL cmd_date           (char*, int, char*);
