
/************************************************************************/
/*                                                                      */
/* FILE: prompt.c                                                       */
/* command.com Prompt functions                                         */
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* This file is part of G-COM.                                          */
/* G-COM is derived from DOS-C source (GPL).                            */
/*                                                                      */
/* (C) Copyright 1999-2000  Roberto Gordo Saez   (GCOM)                 */
/* (C) Copyright 1995-1998  Pasquale J. Villani  (DOSC)                 */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option)  */
/* any later version.                                                   */
/*                                                                      */
/* This program is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     */
/* General Public License for more details.                             */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.                  */
/*                                                                      */
/************************************************************************/


#include "globals.h"


void put_prompt (REG char*);
static void print_path (void);
static void print_time (void);
static void print_date (void);
BOOL cmd_prompt (char*, int, char*);


/* -------------------------------------------------------------------- */
/* put_prompt                                                           */
/* -------------------------------------------------------------------- */

void put_prompt(REG char *fmt)
{
    static char c;

    while(*fmt != '\0')
    {
        if(*fmt != '$')
        {
            DosWrite(STDOUT, (char FAR *)fmt++, 1);
            continue;
        }

        switch(toupper(*++fmt))
        {
        case 'P':
            print_path();
            break;

        case 'N':
            c = 'A' + default_drive;
            DosWrite(STDOUT, (char FAR *)&c, 1);
            break;

        case 'T':
            print_time();
            break;

        case 'D':
            print_date();
            break;

        case 'Q':
            DosWrite(STDOUT, (char FAR *)"=", 1);
            break;

        case '$':
            DosWrite(STDOUT, (char FAR *)"$", 1);
            break;

        case 'G':
            DosWrite(STDOUT, (char FAR *)">", 1);
            break;

        case 'L':
            DosWrite(STDOUT, (char FAR *)"<", 1);
            break;

        case 'B':
            DosWrite(STDOUT, (char FAR *)"|", 1);
            break;

        case '_':
            DosWrite(STDOUT, (char FAR *)newline, 2);
            break;

        case 'V':
            printf(version, MAJOR_RELEASE, MINOR_RELEASE);
            break;

        default:
            DosWrite(STDOUT, (char FAR *)fmt, 1);
            break;
        }
        fmt++;
    }
}


static void print_path(void)
{
    char directory[MAX_PATH];
    DosPwd(default_drive + 1, (char FAR *)directory);
    printf("%c:\\%s", 'A' + default_drive, directory);
}


static void print_time(void)
{
    UBYTE hour, min, sec, hdths;
    info inf;

    DosGetTime(&hour, &min, &sec, &hdths);
    DosGetInfo((info FAR *)&inf);

    if(inf.time_format == TIME_12H)
    {
        printf("%2u:%02u%s", hour > 12 ? (unsigned int)(hour - 12) : (hour == 0) ? (unsigned int)12 : (unsigned int)hour, (unsigned int)min, hour >= 12 ? "pm" : "am");
    }
    else
        printf("%2u:%02u", (unsigned int)hour, (unsigned int)min);
}


static void print_date(void)
{
    UBYTE month, day, weekday;
    UWORD year;
    info inf;

    DosGetDate(&weekday, &month, &day, &year);
    DosWrite(STDOUT, (char FAR *)day_of_week[weekday], strlen(day_of_week[weekday]));
    DosWrite(STDOUT, (char FAR *)" ", 1);

    DosGetInfo((info FAR *)&inf);

    switch(inf.date_format)
    {
    case DATE_YMD:
        printf("%4u%s%02u%s%02u", (unsigned int)year, inf.date_sep, (unsigned int)month, inf.date_sep, (unsigned int)day);
        break;

    case DATE_MDY:
        printf("%2u%s%02u%s%4u", (unsigned int)month, inf.date_sep, (unsigned int)day, inf.date_sep, (unsigned int)year);
        break;

    default:
        printf("%2u%s%02u%s%4u", (unsigned int)day, inf.date_sep, (unsigned int)month, inf.date_sep, (unsigned int)year);
    }
}


/* -------------------------------------------------------------------- */
/* cmd_prompt - PROMPT command                                          */
/* -------------------------------------------------------------------- */

BOOL cmd_prompt(char *cmd_name, int argc, char *arguments)
{
    char *PROMPT = "PROMPT";

    if(argc == 0)
    {
        strcpy(prompt_string, default_prompt);
        EnvClearVar(PROMPT);
    }
    else
    {
        strcpy(prompt_string, arguments);
        EnvSetVar(PROMPT, prompt_string);
    }
    return TRUE;
}
