#!/bin/sh

###################################################

# run a set of standard pascal compiler tests

###################################################

  if [ -z $P5CDIR ] ; then
      echo "\$P5CDIR is not set, bailing out"
      exit 1;
  fi

  echo
  echo "iso 7185 standard tests"

  rm -f conformant conformant.exe conformant.out
  $P5CDIR/r conformant | tee conformant.out | awk 'BEGIN { nf=0; np=0; } \
                               /^ PASS/ { np++ }; \
                               /FAIL/ {nf++; print}; \
                        END { print np, "tests passed,", nf==1? "one test": nf " tests", "failed" }'
  if ! tail conformant.out | grep -q "tests completed" ; then
    echo "conformant tests not completed"
    printf 'Press RETURN to continue ... '
    read REPLY
  fi
  if grep -E -e '^c6p[0-9p]+[a-z]+ *unreferenced' conformant.lst ; then
    echo "conformant tests ommitted"
    printf 'Press RETURN to continue ... '
    read REPLY
  fi

  echo

  rm -f ta ta.exe
  $P5CDIR/r ta
  test -x ta || echo "ta tests failed"

  echo
  echo "acceptance tests"
  rm -f iso7185pat iso7185pat.exe
  $P5CDIR/r iso7185pat | awk -f patCheck.awk | tail -4 | tee iso7185pat.result

  printf 'Press RETURN to continue ... '
  read REPLY
