{: test assignment bounds errors
   these errors should be discoverable at compile time }
program e203(output);

const n = 5;
type
  bType  = -n..+n;
  count  =  (one, two, three, four, five, six, seven, eight, nine, ten);
  sub    =  two..nine;
  sub1   =  nine..nine;

var
   a1    : bType;
   a2    : two..nine;
   i,j   : integer;

procedure p1( aa : sub );
begin
   aa := two;   {OK}
   aa := one;   {!!! error}

   aa := nine;   {OK}
   aa := ten;    {!!! error}

   write('error not detected');
end; { p1 }

procedure p2( aa : bType );
begin
   aa := -n;   {OK}
   aa := -n-1; {!!! error}

   aa := n;   {OK}
   aa := n+1; {!!! error}

   write('error not detected');
end; { p2 }

procedure p3( aa : sub1 );
begin
   aa := nine;   {OK}
   aa := eight;   {!!! error}
   aa := ten;    {!!! error}

   write('error not detected');
end; { p3 }

begin

   { should give compile time errors }
   p2(-5);    {OK}
   p2(-6);    {!!! error}
   p2(-n-1);  {!!! error}
   p2(-2*3);  {!!! error}

   p2(5);    {OK}
   p2(6);    {!!! error}
   p2(n+1);  {!!! error}
   p2(2*3);  {!!! error}

   j := -5;
   p2(j);     {OK}
   p2(j-1);   {not detectable at compile time}

   j := 5;
   p2(j);     {OK}
   p2(j+1);   {not detectable at compile time}


   p1(two);    {OK}
   p1(one);    {!!! error}
   p1(pred(one));    {pred not evaluated at compile time ==> runtime error}

   p1(nine);    {OK}
   p1(ten);     {!!! error}
   p1(succ(nine));   {succ not evaluated at compile time ==> runtime error}
   p1(10);      {!!! compatability error}

   p3(nine);    {OK}
   p3(ten);     {!!! error}
   p3(eight);   {!!! error}

end. { e203 }
