{: test that passing an array to a conformant array parameter
   with mismatched index types causes a fatal error }

{$d+}
program e125( output );

type
   smallInt  =  1..10;
   smallInt0 =  11..20;
   smallInt1 =  1..19;
   smallInt2 =  -2..10;
   smallInt3 =  -2..11;

var
   a0: array[smallInt0] of integer;
   a1: array[smallInt1]  of integer;
   a2: array[smallInt2] of integer;
   a3: array[smallInt3] of integer;

procedure test(aa : array[lo..hi : smallInt] of integer);
var
   aa1 : array[smallInt] of integer;
   z   : smallInt;
begin
   z := lo;
   aa[z] := 3;
   aa[hi] := 3;
end;

procedure test0(aa : array[lo..hi : smallInt0] of integer);
begin
   test(aa);   { !!! incompatible index range }
end;

procedure test1(aa : array[lo..hi : smallInt1] of integer);
begin
   test(aa);
end;

procedure test2(aa : array[lo..hi : smallInt2] of integer);
begin
   test(aa);
end;

procedure test3(aa : array[lo..hi : smallInt3] of integer);
begin
   test(aa);
end;

begin {e125}

   test1(a1);  { OK - compatible index bounds }
   test2(a2);  { OK - compatible index bounds }
   test3(a3);  { OK - compatible index bounds }
   test0(a0);  { fails inside test0() }
   writeln( 'fails: conformant array index error is not detected' );

end. { e125 }

