{: test that exp(x) causes a fatal error if x is large enough }

{$d+}
program d087( output );

var
   k : real;
   x : real;

function side : real;
begin
   side := k;
   k := k+1;
end;
begin {d087}

   k := 0;
   x := exp(side);
   if abs(x-1) > 1.0e-37 then begin
      writeln( 'unexpected value of exp(0) is ', x);
   end;
   if k <> 1 then
      writeln( 'exp() for debug has side effects' );

   write( 'checking exp(x) for underflow ... ' );
   k := -1;
   repeat
      k := 2*k;
      x := exp(k);
   until x = 0;

   writeln('underflows for x = ', k:1:2);

   writeln( 'checking for overflow, expecting to generate a fatal error' );
   k := 1;
   repeat
      k := 2*k;
      x := exp(k);  {should get a run time error when k is large enough}
   until abs(ln(x)-k) > 0.1;

   writeln( 'fails: exp(x) overflow not detected for large x' );
end. { d087 }

