{: test that overflow in constant integer expressions causes a
   compilation error }

program e082( output );

var
   i, k : integer;
   x    : real;

begin {e082}

   x := -maxint; x := x - 1;  {OK}
   x := -x;           {OK}

   write( 'checking for -(-maxint-1) overflow, expect error ... ' );
   k := -maxint; {OK}
   k := -maxint - 1; {!!! = -maxint - 1 ==> possible overflow}
   k := -(-maxint - 1); {!!! = -(-maxint - 1) ==> overflow}

   k := 2147483647;     {OK}
   k := -2147483647;    {OK}
   k := 2147483648;     {!!! overflows}
   k := -2147483648;    {!!! overflows}
   k := -(-2147483648); {!!! overflows}

   k := (maxint - 10) + 10; {OK}
   k := (maxint - 10) + 11; {!!! overflow}

   k := (-maxint + 10) - 10; {OK}
   k := (-maxint + 10) - 11; {!!! overflow}

   k := (maxint - 10) - (-10); {OK}
   k := (maxint - 10) - (-11); {!!! overflow}

   k := (-maxint + 10) + (-10); {OK}
   k := (-maxint + 10) + (-11); {!!! overflow}

   k := (maxint div 10) * 10; {OK}
   k := (maxint div 10) * 11; {!!! overflow}

   k := (maxint div 10) * (-10); {OK}
   k := (maxint div 10) * (-11); {!!! overflow}

   k := ((-maxint) div 10) * 10; {OK}
   k := ((-maxint) div 10) * 11; {!!! overflow}

   k := ((-maxint) div 10) * (-10); {OK}
   k := ((-maxint) div 10) * (-11); {!!! overflow}

   writeln;
   write( '-(-maxint-1) overflow not detected, result is ' );
   if i+1 = -maxint then writeln( '-maxint-1' )
   else writeln( i:1 );

end. { e082 }

