{: test that set overflow from an + operation causes a fatal error }

{$d+}
program d213( output );

type
   digits =  set of '0'..'9';

var
   s : array['a'..'d'] of digits;
   k : char;

procedure p(as : digits );
begin
   if as = [] then
      writeln( 'set as is empty' );
end; { p }

function side: char;
begin
   side := k;
   k := succ(k);
end; { side }

begin { d213 }

   k := '3';
   s['a'] := [k];
   k := 'a';
   s['a'] := s[side] + ['1'];
   if s['a'] <> ['1','3'] then
      writeln( '**** set op has side effects **** (1)' );
   if k <> 'b' then
      writeln( '**** set op has side effects **** (2)' );


   k := '4';
   p([side]);
   if k <> '5' then
      writeln( '**** set param has side effects ****' );

   s['b'] := ['1'..'5', 'a'] - ['a'];  {OK}
   p( ['1'..'5', 'a'] - ['a'] );  {OK}

   s['c'] := ['1'..'5', 'a'..'z'] * ['0'..'9'];  {OK}
   p( ['1'..'5', 'a'..'z'] * ['0'..'9'] );  {OK}

   k := succ('9');
   p( (s['c'] + [k]) + (['3','4'] - ['4']) ); {!!! k is outside bounds of param}

   writeln( 'set overflow not detected' );
end. { d213 }

