{: test that assigning to a set outside its bounds causes a fatal error
   here we assign with a procedure parameter, where sets are disjoint,
   vary the size of src set
}

{ this is ageneric test, many versions of this test will be built with
  cpp -D ARG1=ARG -D ARG2=(ARG+ADJ)
  for all combinatiopns of ARG & ADJ

ARG   9 8 7 6 1 0 -1 -7 -8 -9 -15 -16 -17 -23 -24 -25
ADJ    0 1 2 7 8 9 15 16 17

}

{$d+}
program d208( output );

#if !defined ARG1 || ! defined ARG2
#error "ARG2 or ARG1 not defined"
#endif
#if ARG2 < ARG1
#error "ARG2 must be >= than ARG1"
#endif

const
   lo  = 27;
   hi  = 40;
   lo1 = -25;
   hi1 = ARG2; {varies -25 .. +26}
   t   = ARG1; {varies -25 ..  +9}
type
   src = set of lo1..hi1;
   dst = set of lo..hi;
var
   i  : integer;
   s1 : src;

procedure test(s  : dst);
begin
   writeln( 'INFO: s is [', lo:1, '..', hi:1, '], s1 is [', lo1:1, '..', hi1:1, '], test bit ', t:1 );
end;

begin {d208}

   s1 :=[]; i := t;

   test(s1 + [27 + 13 * (i+25) div 34] ); {this should be OK}

   test(s1+[2*i-t]) ; {!!! assignment outside bounds}

   writeln('failed to detect set assign error');

end. { d208 }

