{: test that exp(ln(x)*y) causes a fatal error if x < 0
Note: exp(ln(0)*y) is mathematically valid, (== 1 iff y is 0, ==0 otherwise),
      so allow x to be 0 in this test
}

{$d+}
program d088( output );

var
   e,k : real;

function side : real;
begin
   side := k;
   k := k+1;
end;
begin {d088}

   k := 1;
   writeln( 'exp(ln(1)*2) is ', exp(ln(side)*2):1:2);
   if k <> 2 then
      writeln( 'exp(ln(x)*y) for debug has side effects' );

   k := 1;
   writeln( 'exp(2*ln(1)) is ', exp(2*ln(side)):1:2);
   if k <> 2 then
      writeln( 'exp(y*ln(x)) for debug has side effects' );

   k := 1;
   while k > 0 do begin
      e := k;
      k := k/2;
   end;
   writeln( 'exp(ln(', e, ')*10) is ', exp(ln(e)*10):9:4 );

   k := -1;
   while k < 0 do begin
      e := k;
      k := k/2;
   end;
   writeln( 'exp(ln(', e, ')*10) is ', exp(ln(e)*10):9 ); {!!!error}
   writeln( 'fails: negative arg error in exp(ln(arg)*10) is not detected' );
end. { d088 }

