{

                Chipmunk Basic, ported to p5x

# // force cpp

}


{$d- debug}
program basic(input, output);
{$d+ debug}

#include "string.inc.pas"

label 1000;

const
   varnamelen = 20;
   maxdims    = 4;
   basExt     = '.bas';

type
   varnamestring = STRING(varnamelen);

   string255 = STRING(255);
   string255ptr = ^string255;

   tokenkinds = (tokvar, toknum, tokstr, toksnerr,

                 tokplus, tokminus, toktimes, tokdiv, tokup, toklp, tokrp,
                 tokcomma, toksemi, tokcolon, tokeq, toklt, tokgt,
                 tokle, tokge, tokne,

                 tokand, tokor, tokxor, tokmod, toknot, toksqr, toksqrt, toksin,
                 tokcos, toktan, tokarctan, toklog, tokexp, tokabs, toksgn,
                 tokstr_, tokval, tokchr_, tokasc, toklen, tokmid_, tokpeek,

                 tokrem, toklet, tokprint, tokinput, tokgoto, tokif, tokend,
                 tokstop, tokfor, toknext, tokwhile, tokwend, tokgosub,
                 tokreturn, tokread, tokdata, tokrestore, tokgotoxy, tokon,
                 tokdim, tokpoke,

                 toklist, tokrun, toknew, tokload, tokmerge, toksave, tokbye,
                 tokdel, tokrenum,

                 tokthen, tokelse, tokto, tokstep);

   realptr = ^real;
   basicstring = string255ptr;
   stringptr = ^basicstring;
   // this array could be larger for recent versions of gcc
   // try 0..maxint
   numarray = array[0..maxint div 8 - 1] of real;
   arrayptr = ^numarray;
   // try 0..maxint
   strarray = array[0..maxint div 256] of basicstring;
   strarrayptr = ^strarray;

   tokenptr = ^tokenrec;
   lineptr = ^linerec;
   varptr = ^varrec;

   tokenrec =
      record
         next : tokenptr;
         case kind : tokenkinds of
            tokvar : (vp : varptr);
            toknum : (num : real);
            tokstr, tokrem : (sp : string255ptr);
            toksnerr : (snch : char);
      end;

   linerec =
      record
         num, num2 : integer;
         txt : tokenptr;
         next : lineptr;
      end;

   varrec =
      record
         name : varnamestring;
         next : varptr;
         dims : array [1..maxdims] of integer;
         numdims : 0..maxdims;
         case stringvar : boolean of
            false : (arr : arrayptr;  valaddr : realptr;  rv : real);
            true : (sarr : strarrayptr;  /*sval*/ svaddr : stringptr;  sv : basicstring);
      end;

   valrec =
      record
         case stringval : boolean of
            false : (val : real);
            true : (sval : basicstring);
      end;


{get a pointer to a basicstring}
function svptr( var sv : basicstring) : stringptr;
begin
   svptr := nil;
   {@@
   return sv_2;
   @@}
end; { addr }

{get a pointer to a real}
function rvptr( var rv : real ) : realptr;
begin
   rvptr := nil;
   {@@ return rv_2; @@}
end; { rvptr }


type
   loopptr = ^looprec;
   loopkind = (forloop, whileloop, gosubloop);
   looprec =
      record
         next : loopptr;
         homeline : lineptr;
         hometok : tokenptr;
         case kind : loopkind of
            forloop :
               ( vp : varptr;
                 max, step : real );
      end;



var

   inbuf : string255ptr;

   linebase : lineptr;
   varbase : varptr;      // chain of variables
   loopbase : loopptr;

   curline : integer;
   stmtline, dataline : lineptr;
   stmttok, datatok, buf : tokenptr;

   exitflag : boolean;



procedure errormsg(s : string255);
begin
   write(chr(7), s);
   if stmtline <> nil then
         write(' at line ', stmtline^.num:1);
   writeln;
   goto 1000;
end; { errormsg }


procedure fatalmsg(s : string255);
begin
   write(chr(7), s);
   halt(42);
end; { fatalmsg }


procedure sarr_new(var p : strarrayptr; size : integer);
var i : integer;
begin
{@@
   *p_2 = malloc(sizeof((*p_2)->component[0])*size_2);
@@}
   for i := 0 to size-1 do
      p^[i] := nil;
end;

procedure arr_new(var p : arrayptr; size : integer);
var i : integer;
begin
{@@
   *p_2 = malloc(sizeof((*p_2)->component[0])*size_2);
@@}
   for i := 0 to size-1 do
      p^[i] := 0;
end;


procedure arr_dispose(p : arrayptr);
begin
   {@@   free(p_2); @@}
end;



procedure restoredata;
   begin
      dataline := nil;
      datatok := nil;
   end;


procedure clearloops;
   var
      l : loopptr;
   begin
      while loopbase <> nil do
         begin
            l := loopbase^.next;
            dispose(loopbase);
            loopbase := l;
         end;
   end;


procedure clearvar(v : varptr);
   begin
      with v^ do begin
         if numdims <> 0 then begin
            arr_dispose(arr);
         end
         else if stringvar and (sv <> nil) then
            dispose(sv);
         numdims := 0;
         if stringvar then begin
            sv := nil;
            svaddr := svptr(sv);
         end
         else begin
            rv := 0;
            valaddr := rvptr(rv);
         end; {if}
      end; {with}
   end; { clearvar }


procedure clearvars;
   var
      v : varptr;
   begin
      v := varbase;
      while v <> nil do
         begin
            clearvar(v);
            v := v^.next;
         end;
   end; { clearvars }



procedure numtostr(x : real; var str : string255);
begin
      {@@ (void)sprintf(str_2->component, "%g", x_2); @@}
end; { numtostr }


procedure parse(inbuf : string255ptr; var buf : tokenptr);

#define       idchars ['A'..'Z','a'..'z','0'..'9','_','$']

   const
      toklength = 20;
   type
      tokenType = STRING(toklength);
   var
      i, j, k : integer;
      token : tokenType;
      t, tptr : tokenptr;
      v : varptr;
      ch : char;
      n, d, d1 : real;

   {return true iff token = string s,
    s is lower case, and shorter than max token len}
   function tok_cmp(s: packed array[one..len :integer] of char ) : boolean;
   var i : integer;
       c : char;
       l : integer;
       match : boolean;
   begin
      i := 1;
      l := strlen(token);
      match :=  l = strlen(s);
      while match and (i<=l) do begin
         c := token[i];
         if c in ['A'..'Z'] then {convert to lower case}
            c := chr( ord(c) - ord('A') + ord('a') );
         if c <> s[i] then
            match := false;
         i := i+1;
      end; {while}
      tok_cmp := match;
   end; { tok_cmp }

   {: compare name with token, ignoring case}
   function name_cmp(n : varnamestring; t: tokenType ) : boolean;
   var
      i,l    : integer;
      match  : boolean;
      cn, ct :  char;
   begin
      l := strlen(n);
      match := l = strlen(t);
      i := 1;
      while match and (i <= l) do begin
         cn := n[i]; ct := t[i];
         if cn in ['A'..'Z'] then
            cn := chr( ord(cn) - ord('A') + ord('a') );
         if ct in ['A'..'Z'] then
            ct := chr( ord(ct) - ord('A') + ord('a') );
         if cn <> ct then
            match := false;
         i := i+1;
      end; {while}
      name_cmp := match;
   end; { name_cmp }


   begin {parse}
      tptr := nil;
      buf := nil;
      i := 1;
      repeat
         {skip leading white space}
         ch := ' ';
         while (i <= strlen(inbuf^)) and (ch = ' ') do begin
            ch := inbuf^[i];
            i := i + 1;
         end;

         {get next token, determine its type}
         if ch <> ' ' then begin
            new(t);
            if tptr = nil then
               buf := t
            else
               tptr^.next := t;
            tptr := t;
            t^.next := nil;
            case ch of
              'A'..'Z', 'a'..'z' :  begin
                 i := i - 1;
                 j := 0;
                 setstrlen(token, strmax(token));
                 while (i <= strlen(inbuf^)) and (inbuf^[i] in idchars)
                 do begin
                    if j < toklength then begin
                       j := j + 1;
                       token[j] := inbuf^[i];
                    end;
                    i := i + 1;
                 end;
                 setstrlen(token, j);
                      if tok_cmp('and')   then t^.kind := tokand
                 else if tok_cmp('or')    then t^.kind := tokor
                 else if tok_cmp('xor')   then t^.kind := tokxor
                 else if tok_cmp('not')   then t^.kind := toknot
                 else if tok_cmp('mod')   then t^.kind := tokmod
                 else if tok_cmp('sqr')   then t^.kind := toksqr
                 else if tok_cmp('sqrt')  then t^.kind := toksqrt
                 else if tok_cmp('sin')   then t^.kind := toksin
                 else if tok_cmp('cos')   then t^.kind := tokcos
                 else if tok_cmp('tan')   then t^.kind := toktan
                 else if tok_cmp('arctan')then t^.kind := tokarctan
                 else if tok_cmp('log')   then t^.kind := toklog
                 else if tok_cmp('exp')   then t^.kind := tokexp
                 else if tok_cmp('abs')   then t^.kind := tokabs
                 else if tok_cmp('sgn')   then t^.kind := toksgn
                 else if tok_cmp('str$')  then t^.kind := tokstr_
                 else if tok_cmp('val')   then t^.kind := tokval
                 else if tok_cmp('chr$')  then t^.kind := tokchr_
                 else if tok_cmp('asc')   then t^.kind := tokasc
                 else if tok_cmp('len')   then t^.kind := toklen
                 else if tok_cmp('mid$')  then t^.kind := tokmid_
                 else if tok_cmp('peek')  then t^.kind := tokpeek
                 else if tok_cmp('let')   then t^.kind := toklet
                 else if tok_cmp('print') then t^.kind := tokprint
                 else if tok_cmp('input') then t^.kind := tokinput
                 else if tok_cmp('goto')  then t^.kind := tokgoto
                 else if tok_cmp('go to') then t^.kind := tokgoto
                 else if tok_cmp('if')    then t^.kind := tokif
                 else if tok_cmp('end')   then t^.kind := tokend
                 else if tok_cmp('stop')  then t^.kind := tokstop
                 else if tok_cmp('for')   then t^.kind := tokfor
                 else if tok_cmp('next')  then t^.kind := toknext
                 else if tok_cmp('while') then t^.kind := tokwhile
                 else if tok_cmp('wend')  then t^.kind := tokwend
                 else if tok_cmp('gosub') then t^.kind := tokgosub
                 else if tok_cmp('return') then t^.kind := tokreturn
                 else if tok_cmp('read')  then t^.kind := tokread
                 else if tok_cmp('data')  then t^.kind := tokdata
                 else if tok_cmp('restore') then t^.kind := tokrestore
                 else if tok_cmp('gotoxy') then t^.kind := tokgotoxy
                 else if tok_cmp('on')    then t^.kind := tokon
                 else if tok_cmp('dim')   then t^.kind := tokdim
                 else if tok_cmp('poke')  then t^.kind := tokpoke
                 else if tok_cmp('list')  then t^.kind := toklist
                 else if tok_cmp('run')   then t^.kind := tokrun
                 else if tok_cmp('new')   then t^.kind := toknew
                 else if tok_cmp('load')  then t^.kind := tokload
                 else if tok_cmp('merge') then t^.kind := tokmerge
                 else if tok_cmp('save')  then t^.kind := toksave
                 else if tok_cmp('bye')   then t^.kind := tokbye
                 else if tok_cmp('quit')  then t^.kind := tokbye
                 else if tok_cmp('del')   then t^.kind := tokdel
                 else if tok_cmp('renum') then t^.kind := tokrenum
                 else if tok_cmp('then')  then t^.kind := tokthen
                 else if tok_cmp('else')  then t^.kind := tokelse
                 else if tok_cmp('to')    then t^.kind := tokto
                 else if tok_cmp('step')  then t^.kind := tokstep
                 else if tok_cmp('rem')   then begin
                    t^.kind := tokrem;
                    new(t^.sp);
                    str(inbuf^, i, strlen(inbuf^)-i+1, t^.sp^);
                    i := strlen(inbuf^)+1;
                 end
                 else begin
                    t^.kind := tokvar;
                    v := varbase;
                    while (v <> nil) and not name_cmp(v^.name, token) do begin
                       v := v^.next;
                    end; {while}
                    if v = nil then begin
                       new(v);
                       v^.next := varbase;
                       varbase := v;
                       v^.name := token;
                       v^.numdims := 0;
                       if token[strlen(token)] = '$' then begin
                          v^.stringvar := true;
                          v^.sv := nil;
                          v^.svaddr := svptr(v^.sv);
                       end
                       else begin
                          v^.stringvar := false;
                          v^.rv := 0;
                          v^.valaddr := rvptr(v^.rv);
                       end;
                    end; {if}
                    t^.vp := v;
                 end;
              end;
              '"', '''' : begin
                 t^.kind := tokstr;
                 new(t^.sp);
                 setstrlen(t^.sp^, 254);
                 j := 0;
                 while (i <= strlen(inbuf^)) and (inbuf^[i] <> ch) do
                 begin
                    j := j + 1;
                    t^.sp^[j] := inbuf^[i];
                    i := i + 1;
                 end;
                 setstrlen(t^.sp^, j);
                 i := i + 1;
              end;
              '0'..'9', '.' :  begin
                 t^.kind := toknum;
                 n := 0;
                 d := 1;
                 d1 := 1;
                 i := i - 1;
                 while (i <= strlen(inbuf^)) and ((inbuf^[i] in ['0'..'9'])
                       or ((inbuf^[i] = '.') and (d1 = 1)))
                 do begin
                    if inbuf^[i] = '.' then
                       d1 := 10
                    else begin
                       n := n * 10 + ord(inbuf^[i]) - ord('0');
                       d := d * d1;
                    end;
                    i := i + 1;
                 end;
                 n := n / d;
                 if (i <= strlen(inbuf^)) and (inbuf^[i] in ['e','E']) then
                 begin
                    i := i + 1;
                    d1 := 10;
                    if (i <= strlen(inbuf^)) and (inbuf^[i] in ['+','-']) then
                    begin
                       if inbuf^[i] = '-' then
                          d1 := 0.1;
                       i := i + 1;
                    end;
                    j := 0;
                    while (i <= strlen(inbuf^)) and (inbuf^[i] in ['0'..'9']) do
                    begin
                       j := j * 10 + ord(inbuf^[i]) - ord('0');
                       i := i + 1;
                    end;
                    for k := 1 to j do
                       n := n * d1;
                 end;
                 t^.num := n;
              end;
              '+' : t^.kind := tokplus;
              '-' : t^.kind := tokminus;
              '*' : t^.kind := toktimes;
              '/' : t^.kind := tokdiv;
              '^' : t^.kind := tokup;
              '(', '[' : t^.kind := toklp;
              ')', ']' : t^.kind := tokrp;
              ',' : t^.kind := tokcomma;
              ';' : t^.kind := toksemi;
              ':' : t^.kind := tokcolon;
              '?' : t^.kind := tokprint;
              '=' : t^.kind := tokeq;
              '<' : begin
                 if (i <= strlen(inbuf^)) and (inbuf^[i] = '=') then
                 begin
                    t^.kind := tokle;
                    i := i + 1;
                 end
                 else if (i <= strlen(inbuf^)) and (inbuf^[i] = '>') then
                 begin
                    t^.kind := tokne;
                    i := i + 1;
                 end
                 else
                    t^.kind := toklt;
              end;
              '>' :  begin
                 if (i <= strlen(inbuf^)) and (inbuf^[i] = '=') then
                 begin
                    t^.kind := tokge;
                    i := i + 1;
                 end
                 else
                    t^.kind := tokgt;
              end;
              otherwise
                 t^.kind := toksnerr;
                 t^.snch := ch;
            end; {case}
         end; {if token found }
      until i > strlen(inbuf^);
   end; {parse}


procedure listtokens(var f : text; buf : tokenptr);
   var
      ltr : boolean;
   begin
      ltr := false;
      while buf <> nil do begin
         if buf^.kind in [tokvar, toknum, toknot..tokrenum] then begin
            if ltr then write(f, ' ');
            ltr := (buf^.kind <> toknot);
         end
         else
            ltr := false;
         case buf^.kind of
           tokvar     : write(f, buf^.vp^.name);
           toknum     : //write(f, /* numtostr(buf^.num) */ buf^.num);
                        with buf^ do begin
                           if (abs(num) <= maxint) and (trunc(num) = num) then
                              write(f, trunc(num), ' ')
                           else if (abs(num) < 1e-2) or (abs(num) >= 1e12) then
                              write(f, num)
                           else
                              write(f, num:1:5);
                  end; {with}
           tokstr     : write(f, '"', buf^.sp^, '"');
           toksnerr   : write(f, '{', buf^.snch, '}');
           tokplus    : write(f, '+');
           tokminus   : write(f, '-');
           toktimes   : write(f, '*');
           tokdiv     : write(f, '/');
           tokup      : write(f, '^');
           toklp      : write(f, '(');
           tokrp      : write(f, ')');
           tokcomma   : write(f, ',');
           toksemi    : write(f, ';');
           tokcolon   : write(f, ' : ');
           tokeq      : write(f, ' = ');
           toklt      : write(f, ' < ');
           tokgt      : write(f, ' > ');
           tokle      : write(f, ' <= ');
           tokge      : write(f, ' >= ');
           tokne      : write(f, ' <> ');
           tokand     : write(f, ' AND ');
           tokor      : write(f, ' OR ');
           tokxor     : write(f, ' XOR ');
           tokmod     : write(f, ' MOD ');
           toknot     : write(f, 'NOT ');
           toksqr     : write(f, 'SQR');
           toksqrt    : write(f, 'SQRT');
           toksin     : write(f, 'SIN');
           tokcos     : write(f, 'COS');
           toktan     : write(f, 'TAN');
           tokarctan  : write(f, 'ARCTAN');
           toklog     : write(f, 'LOG');
           tokexp     : write(f, 'EXP');
           tokabs     : write(f, 'ABS');
           toksgn     : write(f, 'SGN');
           tokstr_    : write(f, 'STR$');
           tokval     : write(f, 'VAL');
           tokchr_    : write(f, 'CHR$');
           tokasc     : write(f, 'ASC');
           toklen     : write(f, 'LEN');
           tokmid_    : write(f, 'MID$');
           tokpeek    : write(f, 'PEEK');
           toklet     : write(f, 'LET');
           tokprint   : write(f, 'PRINT');
           tokinput   : write(f, 'INPUT');
           tokgoto    : write(f, 'GOTO');
           tokif      : write(f, 'IF');
           tokend     : write(f, 'END');
           tokstop    : write(f, 'STOP');
           tokfor     : write(f, 'FOR');
           toknext    : write(f, 'NEXT');
           tokwhile   : write(f, 'WHILE');
           tokwend    : write(f, 'WEND');
           tokgosub   : write(f, 'GOSUB');
           tokreturn  : write(f, 'RETURN');
           tokread    : write(f, 'READ');
           tokdata    : write(f, 'DATA');
           tokrestore : write(f, 'RESTORE');
           tokgotoxy  : write(f, 'GOTOXY');
           tokon      : write(f, 'ON');
           tokdim     : write(f, 'DIM');
           tokpoke    : write(f, 'POKE');
           toklist    : write(f, 'LIST');
           tokrun     : write(f, 'RUN');
           toknew     : write(f, 'NEW');
           tokload    : write(f, 'LOAD');
           tokmerge   : write(f, 'MERGE');
           toksave    : write(f, 'SAVE');
           tokdel     : write(f, 'DEL');
           tokbye     : write(f, 'BYE');
           tokrenum   : write(f, 'RENUM');
           tokthen    : write(f, ' THEN ');
           tokelse    : write(f, ' ELSE ');
           tokto      : write(f, ' TO ');
           tokstep    : write(f, ' STEP ');
           tokrem     : write(f, 'REM', buf^.sp^);
         end;
         buf := buf^.next;
      end;
   end; { listtokens }


procedure disposetokens(var tok : tokenptr);
   var
      tok1 : tokenptr;
   begin
      while tok <> nil do
         begin
            tok1 := tok^.next;
            if tok^.kind in [tokstr, tokrem] then
               dispose(tok^.sp);
            dispose(tok);
            tok := tok1;
         end;
   end; { disposetokens }


procedure parseinput(var buf : tokenptr);
   var
      l, l0, l1 : lineptr;
   begin
      strltrim(inbuf^);

      {get line number}
      curline := 0;
      while (strlen(inbuf^) <> 0) and (inbuf^[1] in ['0'..'9']) do begin
         curline := curline * 10 + ord(inbuf^[1]) - ord('0');
         strdelete(inbuf^, 1, 1);
      end;

      parse(inbuf, buf);

      {add line to list}
      if curline <> 0 then begin
         l := linebase;
         l0 := nil;
         while (l <> nil) and (l^.num < curline) do begin
            l0 := l;
            l := l^.next;
         end;
         if (l <> nil) and (l^.num = curline) then begin
            l1 := l;
            l := l^.next;
            if l0 = nil then
               linebase := l
            else
               l0^.next := l;
            disposetokens(l1^.txt);
            dispose(l1);
         end;
         if buf <> nil then begin
            new(l1);
            l1^.next := l;
            if l0 = nil then
               linebase := l1
            else
               l0^.next := l1;
            l1^.num := curline;
            l1^.txt := buf;
         end;
         clearloops;
         restoredata;
      end;
   end; { parseinput }


procedure snerr;
   begin
      errormsg('Syntax error')
   end;

procedure tmerr;
   begin
      errormsg('Type mismatch error');
   end;

procedure badsubscr;
   begin
      errormsg('Bad subscript');
   end;






procedure exec;

   var
      gotoflag, elseflag : boolean;
      t : tokenptr;
      s : string255;


   procedure factor(var n : valrec);
      forward;

   procedure expr(var n : valrec);
      forward;

   function realfactor : real;
      var
         n : valrec;
      begin
         factor(n);
         if n.stringval then tmerr;
         realfactor := n.val;
      end;

   function strfactor : basicstring;
      var
         n : valrec;
      begin
         factor(n);
         if not n.stringval then tmerr;
         strfactor := n.sval;
      end;

   procedure stringfactor(var r : string255);
      var
         n : valrec;
      begin
         factor(n);
         if not n.stringval then tmerr;
         r := n.sval^;
         dispose(n.sval);
      end;

   function intfactor : integer;
      begin
         intfactor := round(realfactor);
      end;

   function realexpr : real;
      var
         n : valrec;
      begin
         expr(n);
         if n.stringval then tmerr;
         realexpr := n.val;
      end;

   function strexpr : basicstring;
      var
         n : valrec;
      begin
         expr(n);
         if not n.stringval then tmerr;
         strexpr := n.sval;
      end;

   procedure stringexpr(var r : string255);
      var
         n : valrec;
      begin
         expr(n);
         if not n.stringval then tmerr;
         r := n.sval^;
         dispose(n.sval);
      end;

   function intexpr : integer;
      begin
         intexpr := round(realexpr);
      end;


   procedure require(k : tokenkinds);
      begin
         if (t = nil) or (t^.kind <> k) then
            snerr;
         t := t^.next;
      end;


   procedure skipparen;
      label 1;
      begin
         repeat
            if t = nil then snerr;
            if (t^.kind = tokrp) or (t^.kind = tokcomma) then
               goto 1;
            if t^.kind = toklp then
               begin
                  t := t^.next;
                  skipparen;
               end;
            t := t^.next;
         until false;
       1 :
      end;


   function findvar : varptr;
      var
         v : varptr;
         i, j, k : integer;
         tok : tokenptr;
      begin
         if (t = nil) or (t^.kind <> tokvar) then snerr;
         v := t^.vp;
         t := t^.next;
         if (t <> nil) and (t^.kind = toklp) then
            with v^ do begin
               if numdims = 0 then begin
                  tok := t;
                  i := 0;
                  j := 1;
                  repeat
                     if i >= maxdims then badsubscr;
                     t := t^.next;
                     skipparen;
                     j := j * 11;
                     i := i + 1;
                     dims[i] := 11;
                  until t^.kind = tokrp;
                  numdims := i;
                  if stringvar then begin
                     sarr_new(sarr, j);
                  end
                  else begin
                     arr_new(arr, j);
                  end;
                  t := tok;
               end;
               k := 0;
               t := t^.next;
               for i := 1 to numdims do begin
                  j := intexpr;
                  if (j < 0) or (j >= dims[i]) then
                     badsubscr;
                  k := k * dims[i] + j;
                  if i < numdims then
                     require(tokcomma);
               end;
               require(tokrp);
               if stringvar then
                  svaddr := svptr(sarr^[k])
               else
                  valaddr := rvptr(arr^[k]);
            end
            else begin
               if v^.numdims <> 0 then
                  badsubscr;
            end;
         findvar := v;
      end; { findvar }


   function inot(i : integer) : integer;
      begin
         inot := -1 - i;
      end;

   procedure factor;
      var
         v : varptr;
         facttok : tokenptr;
         i, j : integer;
         tok, tok1 : tokenptr;
         s : basicstring;
         trick :
            record
               case boolean of
                  true : (i : integer);
                  false : (c : ^char);
            end;
      begin {factor}
         if t = nil then snerr;
         facttok := t;
         t := t^.next;
         n.stringval := false;
         case facttok^.kind of
            toknum :
               n.val := facttok^.num;
            tokstr :
               begin
                  n.stringval := true;
                  new(n.sval);
                  n.sval^ := facttok^.sp^;
               end;
            tokvar :
               begin
                  t := facttok;
                  v := findvar;
                  n.stringval := v^.stringvar;
                  if n.stringval then begin
                     new(n.sval);
                     if v^.svaddr^ <> nil then
                        n.sval^ := v^.svaddr^^;  {v^.sv?}
                  end
                  else begin
                     if (v = nil) or (v^.valaddr=nil) then
                        snerr;
                     n.val := v^.valaddr^;
                  end; {if}
               end;
            toklp :
               begin
                  expr(n);
                  require(tokrp);
               end;
            tokminus :
               n.val := - realfactor;
            tokplus :
               n.val := realfactor;
            toknot :
               n.val := inot(intfactor);
            toksqr :
               n.val := sqr(realfactor);
            toksqrt :
               n.val := sqrt(realfactor);
            toksin :
               n.val := sin(realfactor);
            tokcos :
               n.val := cos(realfactor);
            toktan :
               begin
                  n.val := realfactor;
                  n.val := sin(n.val) / cos(n.val);
               end;
            tokarctan :
               n.val := arctan(realfactor);
            toklog:
               n.val := ln(realfactor);
            tokexp :
               n.val := exp(realfactor);
            tokabs :
               n.val := abs(realfactor);
            toksgn :
               begin
                  n.val := realfactor;
                  n.val := ord(n.val > 0) - ord(n.val < 0);
               end;
            tokstr_ :
               begin
                  n.stringval := true;
                  new(n.sval);
                  numtostr(realfactor, n.sval^);
               end;
            tokval :
               begin
                  s := strfactor;
                  tok1 := t;
                  parse(s, t);
                  tok := t;
                  if tok = nil then
                     n.val := 0
                  else
                     expr(n);
                  disposetokens(tok);
                  t := tok1;
                  dispose(s);
               end;
            tokchr_ :
               begin
                  n.stringval := true;
                  new(n.sval);
                  n.sval^ := ' ';
                  n.sval^[1] := chr(intfactor);
               end;
            tokasc :
               begin
                  s := strfactor;
                  if strlen(s^) = 0 then
                     n.val := 0
                  else
                     n.val := ord(s^[1]);
                  dispose(s);
               end;
            tokmid_ :
               begin
                  n.stringval := true;
                  require(toklp);
                  n.sval := strexpr;
                  require(tokcomma);
                  i := intexpr;
                  if i < 1 then i := 1;
                  j := 255;
                  if (t <> nil) and (t^.kind = tokcomma) then begin
                        t := t^.next;
                        j := intexpr;
                     end;
                  if j > strlen(n.sval^)-i+1 then
                     j := strlen(n.sval^)-i+1;
                  if i > strlen(n.sval^) then
                     n.sval^ := ''
                  else
                     str(n.sval^, i, j, n.sval^);
                  require(tokrp);
               end;
            toklen :
               begin
                  s := strfactor;
                  n.val := strlen(s^);
                  dispose(s);
               end;
            tokpeek :
               begin
                  trick.i := intfactor;
                  n.val := ord(trick.c^);
               end;
            otherwise
               snerr;
         end;
      end;

   procedure upexpr(var n : valrec);
      var
         n2 : valrec;
      begin
         factor(n);
         while (t <> nil) and (t^.kind = tokup) do
            begin
               if n.stringval then tmerr;
               t := t^.next;
               upexpr(n2);
               if n2.stringval then tmerr;
               if n.val < 0 then
                  begin
                     if n2.val <> trunc(n2.val) then n.val := ln(n.val);
                     n.val := exp(n2.val * ln(-n.val));
                     if odd(trunc(n2.val)) then
                        n.val := - n.val;
                  end
               else
                  n.val := exp(n2.val * ln(n.val));
            end;
      end; { upexpr }


   procedure term (var n: valrec);
      var
         n2 : valrec;
         k : tokenkinds;
      begin
         upexpr(n);
         while (t <> nil) and (t^.kind in [toktimes, tokdiv, tokmod]) do
            begin
               k := t^.kind;
               t := t^.next;
               upexpr(n2);
               if n.stringval or n2.stringval then tmerr;
               if k = tokmod then
                  n.val := round(n.val) mod round(n2.val)
               else if k = toktimes then
                  n.val := n.val * n2.val
               else
                  n.val := n.val / n2.val;
            end;
      end; { term }


   procedure sexpr(var n : valrec);
      var
         n2 : valrec;
         k : tokenkinds;
      begin
         term(n);
         while (t <> nil) and (t^.kind in [tokplus, tokminus]) do
            begin
               k := t^.kind;
               t := t^.next;
               term(n2);
               if n.stringval <> n2.stringval then tmerr;
               if k = tokplus then
                  if n.stringval then begin
                     strappend( n.sval^, n2.sval^ );
                     dispose(n2.sval);
                  end
                  else
                     n.val := n.val + n2.val
               else
                  if n.stringval then
                     tmerr
                  else
                     n.val := n.val - n2.val;
            end;
      end; { sexpr }


   procedure relexpr(var n: valrec);
      var
         n2 : valrec;
         f : boolean;
         k : tokenkinds;
      begin
         sexpr(n);
         while (t <> nil) and (t^.kind in [tokeq..tokne]) do
            begin
               k := t^.kind;
               t := t^.next;
               sexpr(n2);
               if n.stringval <> n2.stringval then tmerr;
               if n.stringval then
                  begin
                     f := ((n.sval^ = n2.sval^) and (k in [tokeq, tokge, tokle]) or
                           (n.sval^ < n2.sval^) and (k in [toklt, tokle, tokne]) or
                           (n.sval^ > n2.sval^) and (k in [tokgt, tokge, tokne]));
                     dispose(n.sval);
                     dispose(n2.sval);
                  end
               else
                  f := ((n.val = n2.val) and (k in [tokeq, tokge, tokle]) or
                        (n.val < n2.val) and (k in [toklt, tokle, tokne]) or
                        (n.val > n2.val) and (k in [tokgt, tokge, tokne]));
               n.stringval := false;
               n.val := ord(f);
            end;
      end; { relexpr }


   procedure andexpr(var n : valrec);
      var
         n2 : valrec;
      begin
         relexpr(n);
         while (t <> nil) and (t^.kind = tokand) do
            begin
               t := t^.next;
               relexpr(n2);
               if n.stringval or n2.stringval then tmerr;
               n.val := bitand(trunc(n.val), trunc(n2.val));
            end;
      end; { andexpr }


   procedure expr;
      var
         n2 : valrec;
         k : tokenkinds;
      begin
         andexpr(n);
         while (t <> nil) and (t^.kind in [tokor, tokxor]) do
            begin
               k := t^.kind;
               t := t^.next;
               andexpr(n2);
               if n.stringval or n2.stringval then tmerr;
               if k = tokor then
                  n.val := bitor(trunc(n.val), trunc(n2.val))
               else
                  n.val := bitxor(trunc(n.val), trunc(n2.val));
            end;
      end; { expr }


   procedure checkextra;
      begin
         if t <> nil then
            errormsg('Extra information on line');
      end;


   function iseos : boolean;
      begin
         iseos := (t = nil) or (t^.kind in [tokcolon, tokelse]);
      end;


   procedure skiptoeos;
      begin
         while not iseos do
            t := t^.next;
      end;


   function findline(n : integer) : lineptr;
      var
         l : lineptr;
      begin
         l := linebase;
         while (l <> nil) and (l^.num <> n) do
            l := l^.next;
         findline := l;
      end;


   function mustfindline(n : integer) : lineptr;
      var
         l : lineptr;
      begin
         l := findline(n);
         if l = nil then
            errormsg('Undefined line');
         mustfindline := l;
      end;


   procedure cmdend;
      begin
         stmtline := nil;
         t := nil;
      end;


   procedure cmdnew;
      var
         pl : lineptr;
         pv : varptr;
      begin
         cmdend;
         clearloops;
         restoredata;
         while linebase <> nil do begin
            pl := linebase^.next;
            disposetokens(linebase^.txt);
            dispose(linebase);
            linebase := pl;
         end;
         while varbase <> nil do begin
            pv := varbase^.next;
            if varbase^.stringvar then
               if varbase^.svaddr^ <> nil then
                  dispose(varbase^.svaddr^);
            dispose(varbase);
            varbase := pv;
            end;
      end;


   procedure cmdlist;
      var
         l : lineptr;
         n1, n2 : integer;
      begin
         repeat
            n1 := 0;
            n2 := maxint;
            if (t <> nil) and (t^.kind = toknum) then begin
               n1 := trunc(t^.num);
               t := t^.next;
               if (t = nil) or (t^.kind <> tokminus) then
                  n2 := n1;
            end;
            if (t <> nil) and (t^.kind = tokminus) then begin
               t := t^.next;
               if (t <> nil) and (t^.kind = toknum) then begin
                  n2 := trunc(t^.num);
                  t := t^.next;
               end
               else
                  n2 := maxint;
            end;
            l := linebase;
            while (l <> nil) and (l^.num <= n2) do begin
               if (l^.num >= n1) then begin
                  write(l^.num:1, ' ');
                  listtokens(output, l^.txt);
                  writeln;
               end;
               l := l^.next;
            end;
            if not iseos then
               require(tokcomma);
         until iseos;
      end; { cmdlist }


   procedure cmdload(merging : boolean; name : string255);
      var
         f : text;
         buf : tokenptr;
      begin
         if not merging then
            cmdnew;
         strappend(name, basExt);
         writeln('file is ', name);
         assign(f, name);
         reset(f);
         while not eof(f) do begin
            readString(f, inbuf^);
            parseinput(buf);
            if curline = 0 then begin
               writeln('Bad line in file: ''', inbuf^, '''');
               disposetokens(buf);
            end;
         end;
         //close(f);
      end; { cmdload }


   procedure cmdrun;
      var
         l : lineptr;
         i : integer;
         s : string255;
      begin
         l := linebase;
         if not iseos then begin
            if t^.kind = toknum then
               l := mustfindline(intexpr)
            else begin
               stringexpr(s);
               i := 0;
               if not iseos then begin
                  require(tokcomma);
                  i := intexpr;
               end;
               checkextra;
               cmdload(false, s);
               if i = 0 then
                  l := linebase
               else
                  l := mustfindline(i)
            end
         end;
         stmtline := l;
         gotoflag := true;
         clearvars;
         clearloops;
         restoredata;
      end; { cmdrun }


   procedure cmdsave;
      var
         f : text;
         l : lineptr;
         s : string255;
      begin
         stringexpr(s);
         strappend(s, basExt);
         assign(f, s);
         rewrite(f);
         l := linebase;
         while l <> nil do begin
            write(f, l^.num:1, ' ');
            listtokens(f, l^.txt);
            writeln(f);
            l := l^.next;
         end;
         //close(f, 'save');
      end;


   procedure cmdbye;
      begin
         exitflag := true;
      end;


   procedure cmddel;
      var
         l, l0, l1 : lineptr;
         n1, n2 : integer;
      begin
         repeat
            if iseos then snerr;
            n1 := 0;
            n2 := maxint;
            if (t <> nil) and (t^.kind = toknum) then
               begin
                  n1 := trunc(t^.num);
                  t := t^.next;
                  if (t = nil) or (t^.kind <> tokminus) then
                     n2 := n1;
               end;
            if (t <> nil) and (t^.kind = tokminus) then
               begin
                  t := t^.next;
                  if (t <> nil) and (t^.kind = toknum) then
                     begin
                        n2 := trunc(t^.num);
                        t := t^.next;
                     end
                  else
                     n2 := maxint;
               end;
            l := linebase;
            l0 := nil;
            while (l <> nil) and (l^.num <= n2) do
               begin
                  l1 := l^.next;
                  if (l^.num >= n1) then
                     begin
                        if l = stmtline then
                           begin
                              cmdend;
                              clearloops;
                              restoredata;
                           end;
                        if l0 = nil then
                           linebase := l^.next
                        else
                           l0^.next := l^.next;
                        disposetokens(l^.txt);
                        dispose(l);
                     end
                  else
                     l0 := l;
                  l := l1;
               end;
            if not iseos then
               require(tokcomma);
         until iseos;
      end;


   procedure cmdrenum;
      var
         l, l1 : lineptr;
         tok : tokenptr;
         lnum, step : integer;
      begin
         lnum := 10;
         step := 10;
         if not iseos then begin
               lnum := intexpr;
               if not iseos then begin
                     require(tokcomma);
                     step := intexpr;
                  end;
            end;
         l := linebase;
         if l <> nil then
            begin
               while l <> nil do
                  begin
                     l^.num2 := lnum;
                     lnum := lnum + step;
                     l := l^.next;
                  end;
               l := linebase;
               repeat
                  tok := l^.txt;
                  repeat
                     if tok^.kind in [tokgoto, tokgosub, tokthen, tokelse, 
                                      tokrun, toklist, tokrestore, tokdel] then
                        while (tok^.next <> nil) and (tok^.next^.kind = toknum)
                        do begin
                              tok := tok^.next;
                              lnum := round(tok^.num);
                              l1 := linebase;
                              while (l1 <> nil) and (l1^.num <> lnum) do
                                 l1 := l1^.next;
                              if l1 = nil then
                                 writeln('Undefined line ', lnum:1, ' in line ', l^.num2:1)
                              else
                                 tok^.num := l1^.num2;
                              if (tok^.next <> nil) and (tok^.next^.kind = tokcomma) then
                                 tok := tok^.next;
                           end;
                     tok := tok^.next;
                  until tok = nil;
                  l := l^.next;
               until l = nil;
               l := linebase;
               while l <> nil do
                  begin
                     l^.num := l^.num2;
                     l := l^.next;
                  end;
            end;
      end;


   procedure cmdprint;
      var
         semiflag : boolean;
         n : valrec;
      begin
         semiflag := false;
         while not iseos do begin
            semiflag := false;
            if t^.kind in [toksemi, tokcomma] then begin
               semiflag := true;
               t := t^.next;
            end
            else begin
               expr(n);
               if n.stringval then begin
                  write(n.sval^);
                  dispose(n.sval);
               end
               else begin
                  with n do begin
                     if (abs(val) <= maxint) and (trunc(val) = val) then
                        write(/* numtostr(n.val) */ trunc(val), ' ')
                     else if (abs(val) < 1e-2) or (abs(val) >= 1e12) then
                        write(val)
                     else
                        write(val:1:5);
                  end; {with}
               end;
            end;
         end;
         if not semiflag then
            writeln;
      end; { cmdprint }


   procedure cmdinput;
      var
         v : varptr;
         s : string255;
         sp : string255ptr;
         tok, tok0, tok1 : tokenptr;
         strflag : boolean;
      begin
         if (t <> nil) and (t^.kind = tokstr) then begin
            write(t^.sp^);
            t := t^.next;
            require(toksemi);
         end
         else begin
            write('? ');
         end;
         tok := t;
         if (t = nil) or (t^.kind <> tokvar) then snerr;
         strflag := t^.vp^.stringvar;
         repeat
            if (t <> nil) and (t^.kind = tokvar) then
               if t^.vp^.stringvar <> strflag then snerr;
            t := t^.next;
         until iseos;
         t := tok;
         if strflag then begin
            repeat
               readString(input, s);
               v := findvar;
               if v^.svaddr^ <> nil then
                  dispose(v^.svaddr^);
               new(v^.svaddr^);
               v^.svaddr^^ := s;
               if not iseos then begin
                  require(tokcomma);
                  write('?? ');
               end;
            until iseos;
         end
         else begin
            new(sp);
            readString(input, sp^);
            parse(sp, tok);
            tok0 := tok;
            repeat
               v := findvar;
               while tok = nil do begin
                  write('?? ');
                  readString(input, s);
                  disposetokens(tok0);
                  parse(sp, tok);
                  tok0 := tok;
               end;
               tok1 := t;
               t := tok;
               v^.valaddr^ := realexpr;
               if t <> nil then begin
                  if t^.kind = tokcomma then
                     t := t^.next
                  else
                     snerr;
               end;
               tok := t;
               t := tok1;
               if not iseos then
                  require(tokcomma);
            until iseos;
            disposetokens(tok0);
            dispose(sp);
         end;
      end; { cmdinput }


   procedure cmdlet(implied : boolean);
      var
         v : varptr;
	 old : basicstring;
      begin
         if implied then
            t := stmttok;
         v := findvar;
         require(tokeq);
         if v^.stringvar then begin
               old := v^.svaddr^;
               v^.svaddr^ := strexpr;
               if old <> nil then
                  dispose(old);
         end
         else
            v^.valaddr^ := realexpr;
      end; { cmdlet }


   procedure cmdgoto;
      begin
         stmtline := mustfindline(intexpr);
         t := nil;
         gotoflag := true;
      end;


   procedure cmdif;
      var
         n : real;
         i : integer;
      begin
         n := realexpr;
         require(tokthen);
         if n = 0 then
            begin
               i := 0;
               repeat
                  if t <> nil then
                     begin
                        if t^.kind = tokif then
                           i := i + 1;
                        if t^.kind = tokelse then
                           i := i - 1;
                        t := t^.next;
                     end;
               until (t = nil) or (i < 0);
            end;
         if (t <> nil) and (t^.kind = toknum) then
            cmdgoto
         else
            elseflag := true;
      end;


   procedure cmdelse;
      begin
         t := nil;
      end;


   function skiploop(up, dn : tokenkinds) : boolean;
      label 1;
      var
         i : integer;
         saveline : lineptr;
      begin
         saveline := stmtline;
         i := 0;
         repeat
            while t = nil do begin
               if (stmtline = nil) or (stmtline^.next = nil) then begin
                  skiploop := false;
                  stmtline := saveline;
                  goto 1;
               end;
               stmtline := stmtline^.next;
               t := stmtline^.txt;
            end; {while}
            if t^.kind = up then
               i := i + 1;
            if t^.kind = dn then
               i := i - 1;
            t := t^.next;
         until i < 0;
         skiploop := true;
     1 :
      end;


   procedure cmdfor;
      var
         l : loopptr;
         lr : looprec;
         saveline : lineptr;
         i, j : integer;
      begin
         lr.kind := forloop;
         lr.vp := findvar;
         if lr.vp^.stringvar then snerr;
         require(tokeq);
         lr.vp^.valaddr^ := realexpr;
         require(tokto);
         lr.max := realexpr;
         if (t <> nil) and (t^.kind = tokstep) then begin
            t := t^.next;
            lr.step := realexpr;
         end
         else
            lr.step := 1;

         lr.homeline := stmtline;
         lr.hometok := t;
         lr.kind := forloop;
         lr.next := loopbase;
         with lr do
            if ((step >= 0) and (vp^.valaddr^ > max))
               or ((step <= 0) and (vp^.valaddr^ < max))
            then begin
               {control starts > max, skip to end of loop}
               saveline := stmtline;
               i := 0;
               j := 0;
               repeat
                  while t = nil do begin
                     if (stmtline = nil) or (stmtline^.next = nil) then begin
                        stmtline := saveline;
                        errormsg('FOR without NEXT');
                     end;
                     stmtline := stmtline^.next;
                     t := stmtline^.txt;
                  end; {while}
                  if t^.kind = tokfor then begin
                     if (t^.next <> nil)
                        and (t^.next^.kind = tokvar)
                        and (t^.next^.vp = vp)
                     then
                        j := j + 1
                     else
                        i := i + 1;
                  end;
                  if (t^.kind = toknext) then
                     if (t^.next <> nil)
                        and (t^.next^.kind = tokvar)
                        and (t^.next^.vp = vp)
                     then
                        j := j - 1
                     else
                        i := i - 1;
                  t := t^.next;
               until (i < 0) or (j < 0);
               skiptoeos;
            end
            else begin
               new(l);
               l^ := lr;
               loopbase := l;
            end; {if}
      end;


   procedure cmdnext;
      var
         v : varptr;
         found : boolean;
         l : loopptr;
      begin
         if not iseos then
            v := findvar
         else
            v := nil;
         repeat
            if (loopbase = nil) or (loopbase^.kind = gosubloop) then 
               errormsg('NEXT without FOR');
            found := (loopbase^.kind = forloop) and
                     ((v = nil) or (loopbase^.vp = v));
            if not found then begin
               l := loopbase^.next;
               dispose(loopbase);
               loopbase := l;
            end;
         until found;
         with loopbase^ do begin
            vp^.valaddr^ := vp^.valaddr^ + step;
            if ((step >= 0) and (vp^.valaddr^ > max))
               or ((step <= 0) and (vp^.valaddr^ < max))
            then begin
               l := loopbase^.next;
               dispose(loopbase);
               loopbase := l;
            end
            else begin
               stmtline := homeline;
               t := hometok;
            end; {if}
         end; {with}
      end; { cmdnext }


   procedure cmdwhile;
      var
         l : loopptr;
      begin
         new(l);
         l^.next := loopbase;
         loopbase := l;
         l^.kind := whileloop;
         l^.homeline := stmtline;
         l^.hometok := t;
         if not iseos then
            if realexpr = 0 then
               begin
                  if not skiploop(tokwhile, tokwend) then 
                     errormsg('WHILE without WEND');
                  l := loopbase^.next;
                  dispose(loopbase);
                  loopbase := l;
                  skiptoeos;
               end;
      end;


   procedure cmdwend;
      var
         tok : tokenptr;
         tokline : lineptr;
         l : loopptr;
         found : boolean;
      begin
         repeat
            if (loopbase = nil) or (loopbase^.kind = gosubloop) then
               errormsg('WEND without WHILE');
            found := (loopbase^.kind = whileloop);
            if not found then
               begin
                  l := loopbase^.next;
                  dispose(loopbase);
                  loopbase := l;
               end;
         until found;
         if not iseos then
            if realexpr <> 0 then
               found := false;
         tok := t;
         tokline := stmtline;
         if found then
            begin
               stmtline := loopbase^.homeline;
               t := loopbase^.hometok;
               if not iseos then
                  if realexpr = 0 then
                     found := false;
            end;
         if not found then
            begin
               t := tok;
               stmtline := tokline;
               l := loopbase^.next;
               dispose(loopbase);
               loopbase := l;
            end;
      end;


   procedure cmdgosub;
      var
         l : loopptr;
      begin
         new(l);
         l^.next := loopbase;
         loopbase := l;
         l^.kind := gosubloop;
         l^.homeline := stmtline;
         l^.hometok := t;
         cmdgoto;
      end;


   procedure cmdreturn;
      var
         l : loopptr;
         found : boolean;
      begin
         repeat
            if loopbase = nil then
               errormsg('RETURN without GOSUB');
            found := (loopbase^.kind = gosubloop);
            if not found then
               begin
                  l := loopbase^.next;
                  dispose(loopbase);
                  loopbase := l;
               end;
         until found;
         stmtline := loopbase^.homeline;
         t := loopbase^.hometok;
         l := loopbase^.next;
         dispose(loopbase);
         loopbase := l;
         skiptoeos;
      end;


   procedure cmdread;
      var
         v : varptr;
         tok : tokenptr;
         found : boolean;
      begin
         repeat
            v := findvar;
            tok := t;
            t := datatok;
            if dataline = nil then
               begin
                  dataline := linebase;
                  t := dataline^.txt;
               end;
            if (t = nil) or (t^.kind <> tokcomma) then
               repeat
                  while t = nil do
                     begin
                        if (dataline = nil) or (dataline^.next = nil) then
                           errormsg('Out of Data');
                        dataline := dataline^.next;
                        t := dataline^.txt;
                     end;
                  found := (t^.kind = tokdata);
                  t := t^.next;
               until found and not iseos
            else
               t := t^.next;
            if v^.stringvar then begin
                  if v^.svaddr^ <> nil then
                     dispose(v^.svaddr^);
                  v^.svaddr^ := strexpr;
               end
            else
               v^.valaddr^ := realexpr;
            datatok := t;
            t := tok;
            if not iseos then
               require(tokcomma);
         until iseos;
      end;


   procedure cmddata;
      begin
         skiptoeos;
      end;


   procedure cmdrestore;
      begin
         if iseos then
            restoredata
         else
            begin
               dataline := mustfindline(intexpr);
               datatok := dataline^.txt;
            end;
      end;


   procedure cmdgotoxy;
      var
         i : integer;
      begin
         i := intexpr;
         require(tokcomma);
         //gotoxy(i, intexpr);
         write(chr(27), '[', intexpr, ';', i, 'H');
      end;


   procedure cmdon;
      var
         i : integer;
         l : loopptr;
      begin
         i := intexpr;
         if (t <> nil) and (t^.kind = tokgosub) then
            begin
               new(l);
               l^.next := loopbase;
               loopbase := l;
               l^.kind := gosubloop;
               l^.homeline := stmtline;
               l^.hometok := t;
               t := t^.next;
            end
         else
            require(tokgoto);
         if i < 1 then
            skiptoeos
         else
            begin
               while (i > 1) and not iseos do
                  begin
                     require(toknum);
                     if not iseos then
                        require(tokcomma);
                     i := i - 1;
                  end;
               if not iseos then
                  cmdgoto;
            end;
      end;


   procedure cmddim;
      var
         i, j, k : integer;
         v : varptr;
         done : boolean;
      begin
         repeat
            if (t = nil) or (t^.kind <> tokvar) then snerr;
            v := t^.vp;
            t := t^.next;
            with v^ do
               begin
                  if numdims <> 0 then
                     errormsg('Array already dimensioned');
                  j := 1;
                  i := 0;
                  require(toklp);
                  repeat
                     k := intexpr + 1;
                     if k < 1 then badsubscr;
                     if i >= maxdims then badsubscr;
                     i := i + 1;
                     dims[i] := k;
                     j := j * k;
                     done := (t <> nil) and (t^.kind = tokrp);
                     if not done then
                        require(tokcomma);
                  until done;
                  t := t^.next;
                  numdims := i;
                  if stringvar then begin
                     sarr_new(sarr, j);
                  end
                  else begin
                     arr_new(arr, j);
                  end;
               end;
            if not iseos then
               require(tokcomma);
         until iseos;
      end;


   procedure cmdpoke;
      var
         trick :
            record
               case boolean of
                  true : (i : integer);
                  false : (c : ^char);
            end;
      begin
         trick.i := intexpr;
         require(tokcomma);
         trick.c^ := chr(intexpr);
      end;


   begin {exec}
      repeat
         repeat
            gotoflag := false;
            elseflag := false;

            {skip over ':' separators}
            while (stmttok <> nil) and (stmttok^.kind = tokcolon) do
               stmttok := stmttok^.next;
            t := stmttok;

            {execute command}
            if t <> nil then begin
               t := t^.next;
               case stmttok^.kind of
                 tokrem     : ;
                 toklist    : cmdlist;
                 tokrun     : cmdrun;
                 toknew     : cmdnew;
                 tokload    : begin
                                 stringexpr(s);
                                 cmdload(false, s);
                              end;

                 tokmerge   : begin
                                 stringexpr(s);
                                 cmdload(true, s);
                              end;
                 toksave    : cmdsave;
                 tokbye     : cmdbye;
                 tokdel     : cmddel;
                 tokrenum   : cmdrenum;
                 toklet     : cmdlet(false);
                 tokvar     : cmdlet(true);
                 tokprint   : cmdprint;
                 tokinput   : cmdinput;
                 tokgoto    : cmdgoto;
                 tokif      : cmdif;
                 tokelse    : cmdelse;
                 tokend     : cmdend;
                 tokstop    : halt(-20);
                 tokfor     : cmdfor;
                 toknext    : cmdnext;
                 tokwhile   : cmdwhile;
                 tokwend    : cmdwend;
                 tokgosub   : cmdgosub;
                 tokreturn  : cmdreturn;
                 tokread    : cmdread;
                 tokdata    : cmddata;
                 tokrestore : cmdrestore;
                 tokgotoxy  : cmdgotoxy;
                 tokon      : cmdon;
                 tokdim     : cmddim;
                 tokpoke    : cmdpoke;
                 otherwise
                 errormsg('Illegal command');
               end;
            end;
            if not elseflag and not iseos then
               checkextra;
            stmttok := t;
         until t = nil;

         {determine next statement}
         if stmtline <> nil then begin
            if not gotoflag then
               stmtline := stmtline^.next;
            if stmtline <> nil then
               stmttok := stmtline^.txt;
         end;
      until stmtline = nil;
   end; {exec}


begin {main}
   new(inbuf);
   linebase := nil;
   varbase := nil;
   loopbase := nil;
   writeln('Chipmunk BASIC 1.0');
   writeln;
   exitflag := false;
1000:  {go here if error}
   repeat
      write('>');
      readString(input, inbuf^);
      parseinput(buf);
      if curline = 0 then begin
         stmtline := nil;
         stmttok := buf;
         if stmttok <> nil then
            exec;
         disposetokens(buf);
      end; {if}
   until exitflag or eof(input);
   dispose(inbuf);
end.
