program dr23(input,output);
{dr23.PAS == driver for Nash Marquardt nonlinear least squares

  This program is designed to minimise functions of n parameters.

  Present example uses the problem file ROSEN.PAS, which must be
  replaced with similar code for the user's problem.


          Copyright 1988 J.C.Nash
}
const
     banner = 'dr23.pas -- Marquardt Nash nonlinear least squares';

#include "common.inc.pas"  // constants, types & procedures
#include "calceps.pas"   
#if ! defined LOGISTIC
#include "rosen.pas"
#else
   {*** run 3 parameter logistic function fit ***} {JN910113}
#include "logistic.pas"
#endif

#include "alg07.pas"     
#include "alg08.pas"     
#include "alg23.pas"     

{main program}
var
  n          : integer; {the order of the problem}
  Bvec       : rvector; {current set of parameters}
  X          : rvector; {"best" set of parameters}
  Workdata   : probdata;
  i          : integer;
  Fmin       : real;
  fail       : boolean;
  mytol      : real;

begin
  startup;
  fminset(n,Bvec,Workdata);
            {Sets up problem and defines starting values of Bvec}
  mytol:=-1.0; {Note: set the tolerance negative to indicate that
            procedure must obtain an appropriate value.}
  Workdata.nlls:=true;
  modmrt( n, Bvec, X, Fmin, Workdata);
  writeln;
  writeln(confile);
  writeln(' Minimum function value found =',Fmin);
  writeln(confile,' Minimum function value found =',Fmin);
  writeln(' At parameters');
  writeln(confile,' At parameters');
  for i:=1 to n do
  begin
    writeln(' Bvec[',i,']=',X[i]);
    writeln(confile,' Bvec[',i,']=',X[i]);
  end;
    {local files auto closed when procedure ends}
end. {dr23.pas == Nash Marquardt nonlinear least squares}

