#ifndef CLIB_INC_PAS
#define CLIB_INC_PAS

{ -*- mode: pascal; … -*-


Note: cstring functions are in their own file, cstr.inc.pas

}

{ ------- maths functions ------- }

{: Return arc cosine of x, result is in radians }
function acos(x: real): real; external;

{: Return arc sine of x, result is in radians }
function asin(x: real): real; external;

{: Return arc tangent of y/x, result is in radians, -pi < result <= pi }
function atan2(y: real; x: real): real; external;

{: Return tangent of angle in radians }
function tan(x: real): real; external;

{: Return the hyperbolic cosine of x }
function cosh(x: real): real; external;

{: Return the hyperbolic sine of x }
 function sinh(x: real): real; external;

{: Return the hyperbolic tangent of x }
function tanh(x: real): real; external;

{: Get smallest integer >= x }
function ceil(x: real): real; external;

{: Get largest integral value <= x }
function floor(x: real): real; external;

{: return remainder x - i*y,
for largest i st remainder has same sign as x, and is closer to zero than y is }
function fmod(x: real; y: real): real; external;

{: find mantissa and exponent of x, where x = result * 2**exponent  }
function frexp(x : real; var exponent: integer): real; external;

{: Return real nr made of mantissa and exponent of two }
function ldexp(x : real; exponent: integer): real; external;

{: Return log to the base 10 of x }
function log10 (x: real ): real; external;

{: find fractional and integer parts of x}
function modf(x : real; var intPart: real): real; external;

{: Return x raised to the power y }
function pow (x: real; y: real): real; external;

{: Seed the random number generator}
procedure srand(seed : integer); {@@ inline @@}
begin
   {@@ srand((unsigned) seed_2); @@}
end;

{: return a random number, 0 <= rand <= maxint }
function rand: integer; external;


{: return a random number in the range [0.0 .. 1.0) (a la borland pascal) }
function random : real;
begin
   {@@
   return (double)rand()/RAND_MAX;
   @@}
   random := 0;
end; { random }


{ ------- system functions ------- }


{: terminate applicatin with status code }
procedure exit(status : integer ); external;

{: run myproc when main program terminates.
   return value is zero if successful }
function atexit( procedure myproc ): integer; external;

{: run a command on the system
   command = command string, eg 'ls -l'.   Must be null terminated.
   return result of command.  Usually zero if successful,
                              consult your library & OS documentation for details

   if command string is empty, test whether a shell is available
   return 0 if no shell available, non-zero otherwise
}
function system(command : packed array[one..len :integer] of char): integer;
begin
   if command[1] = chr(0) then begin
      {command is empty}
      {@@ return system(NULL); @@}  {is there a shell to run a comamnd?}
   end
   else begin
      {@@ return system(command_2.component); @@}
   end;
   system := 0;
end; { system }


{ return the processor time in milliseconds }
function clock: real;
begin
   {@@
   return (1000*(double)clock())/CLOCKS_PER_SEC;
   @@}
   clock := 0.0; {dummy assign to prevent compile error}
end;

{--- end of clib.inc.pas ---}

#endif // CLIB_INC_PAS
