#!/bin/sh
#
# compile p5c * compile all tests
# generate coverage data
#

if [ -z $P5CDIR ] ; then
   echo "\$P5CDIR is not set, bailing out"
  exit 1
fi

PASFILE=pcom

if [ -f $PASFILE ] && [ "`basename $PASFILE .PAS`.PAS" = "`basename $PASFILE`" ] ; then
    TPROG=`dirname $PASFILE`/`basename $PASFILE .PAS`
    EXT=PAS
elif [ -f $PASFILE ] && [ "`basename $PASFILE .pas`.pas" = "`basename $PASFILE`" ] ; then
    TPROG=`dirname $PASFILE`/`basename $PASFILE .pas`
    EXT=pas
elif [ -f $PASFILE ] && [ `basename $PASFILE .p`.p = "`basename $PASFILE`" ] ; then
    TPROG=`dirname $PASFILE`/`basename $PASFILE .p`
    EXT=p
elif [ -f $PASFILE ] && [ `basename $PASFILE .pp`.pp = "`basename $PASFILE`" ] ; then
    TPROG=`dirname $PASFILE`/`basename $PASFILE .pp`
    EXT=pp
elif [ -f $PASFILE.pas ] ; then
    TPROG=$PASFILE
    EXT=pas
elif [ -f $PASFILE.p ] ; then
    TPROG=$PASFILE
    EXT=p
elif [ -f $PASFILE.pp ] ; then
    TPROG=$PASFILE
    EXT=pp
else
    echo "can't find $PASFILE or $PASFILE.pas or $PASFILE.p or $PASFILE.pp"  > /dev/stderr
    exit 1
fi

echo "coverage test for $TPROG.$EXT"

####################################################
#
## step 1 - clear existing coverage counters
#

which lcov 1>/dev/null 2>&1
if [ $? -ne 0 ]
then
    rm -f t.$TPROG.*
else
    #lcov --base-directory . --directory . --zerocounters -q
    lcov --base-directory . --directory . --zerocounters
fi


####################################################
#
## step 2 - instrument program under test for coverage analysis
#           (instrumented program is t.something)

echo '{$n+,d-,v-  -- force line numbers, omit debug code }' > t.$TPROG.$EXT
cpp -E -nostdinc -I $P5CDIR $TPROG.$EXT -w | grep -v -e "^# 1 \"<" >> t.$TPROG.$EXT

$P5CDIR/p5c t.$TPROG.pas t.$TPROG.c >  t.$TPROG.lst

# The status of the compile is not returned,
# so convert a non-zero error message to fail status
if ! grep -qF "Errors in program: 0" t.$TPROG.lst ; then
    awk '{ if( $2=="****" ) {print l0 "\n" l1 "\n" $0 ;} \
           else { l0=l1; l1 = $0; }; } \
           /^Errors in program/,0; \
        ' t.$TPROG.lst > /dev/stderr

    echo "cannot compile p5c, quitting" > /dev/stderr
    exit 1
fi

cc -std=gnu99 --coverage -I $P5CDIR t.$TPROG.c -o t.$TPROG 2> t.$TPROG.err
if [ -s t.$TPROG.err ]; then
    if grep -qF ": error: " t.$TPROG.err; then
        echo "gcc compile failed, quitting" > /dev/stderr
        exit 1
    fi
fi


####################################################
#
## step 3 -  run the tests with the instrumented program
#
cpp -E -nostdinc tp5c.pas -w | grep -v -e "^# 1 \"<" > tp5c.1.pas
echo tp5c
./t.$TPROG tp5c.1.pas /dev/null > /dev/null
cpp -E -nostdinc tp5cd.pas -w | grep -v -e "^# 1 \"<" > tp5cd.1.pas
echo tp5cd
./t.$TPROG tp5cd.1.pas /dev/null > /dev/null
./t.$TPROG copytext.p /dev/null > /dev/null
cpp -E -nostdinc tclib.pas -w | grep -v -e "^# 1 \"<" > tclib.1.pas
./t.$TPROG tclib.1.pas /dev/null > /dev/null

for dir in *-tests ; do
    cd $dir
    echo "$dir"
    rm -f *.1.p *.1.pas
    for f in *.pas; do
        ../t.$TPROG $f /dev/null > /dev/null
    done
    cd ..
done

cd rej-tests
rm -f *.1.p *.1.pas
echo isoprt
for f in iso*.pas; do
    ../t.$TPROG $f /dev/null > /dev/null
done
echo dxxx, exxx, lxxx
for f in [del]???.pas; do
    ../t.$TPROG $f /dev/null > /dev/null
done

echo error, deviance
for f in [de]6p*.p; do
    ../t.$TPROG $f /dev/null > /dev/null
done
cd ..


####################################################
#
## step 4 - show the results
#

gcov t.$TPROG.c

which lcov 1>/dev/null 2>&1
if [ $? -ne 0 ]
then
    less $TPROG.$EXT.gcov # alternatively try the 'gcovr' utility
else
    lcov --base-directory . --directory . -c -o t.$TPROG.info
    genhtml --legend \
            --output-directory $TPROG.rpt \
            --title "test coverage for $TPROG.$EXT" \
            --num-spaces 4 t.$TPROG.info
    konqueror $TPROG.rpt/index.html
fi

#clean up
rm t.$TPROG.{$EXT,err,lst}

############################ end of tcov ##############################

