{: test assignment bounds errors
   these tests should be discoverable at compile time }
program e203(output);

const n = 5;
type
  bType  = -n..+n;
  count  =  (one, two, three, four, five, six, seven, eight, nine, ten);
   sub    =  two.. nine;
var
   a1    : bType;
   a2    : two..nine;
   i,j   : integer;

procedure p1( aa : sub );
begin
   aa := two;   {OK}
   aa := one;   {!!! error}

   aa := nine;   {OK}
   aa := ten;    {!!! error}

   write('error not detected');
end; { p1 }

procedure p2( aa : bType );
begin
   aa := -n;   {OK}
   aa := -n-1; {!!! error}

   aa := n;   {OK}
   aa := n+1; {!!! error}

   write('error not detected');
end; { p2 }

begin

   { should give compile time errors }
   p2(-5);    {OK}
   p2(-6);    {!!! error}
   p2(-n-1);  {!!! error}
   p2(-2*3);  {!!! error}

   p2(5);    {OK}
   p2(6);    {!!! error}
   p2(n+1);  {!!! error}
   p2(2*3);  {!!! error}

   j := -5;
   p2(j);     {OK}
   p2(j-1);   {not detectable at compile time}

   j := 5;
   p2(j);     {OK}
   p2(j+1);   {not detectable at compile time}


   p1(two);    {OK}
   p1(one);    {!!! error}

   p1(nine);    {OK}
   p1(ten);     {!!! error}
   p1(10);      {!!! compatability error}
end. { e203 }
