{: test set out of bounds errors
   these tests should be discoverable at compile time }
program e200(output);

type
  tset = set of -5..+5;
var
   s1    : tset;
   pass1 : boolean;
   i,j   : integer;
procedure p641( as : tset );
begin
end; { p641 }

begin
   pass1 := true;

   { should give compile time errors }
   s1 := [ -5..3];  {OK}
   s1 := [ -6..3];  {!!! error}

   s1 := [4..5];  {OK}
   s1 := [4..6];  {!!! error}

   s1 := [ -5..3, 1..2];  {OK}
   s1 := [ -6..3, 1..2];  {!!! error}

   s1 := [4..5, 1..2];  {OK}
   s1 := [4..6, 1..2];  {!!! error}

   s1 := [5,1];  {OK}
   s1 := [6,1];  {!!! error}

   s1 := [-5,1];  {OK}
   s1 := [-6,1];  {!!! error}

   s1 := [5,1];  {OK}
   s1 := [6,1];  {!!! error}

   s1 := [-5,1];  {OK}
   s1 := [-6,1];  {!!! error}

   s1 := [-5..-5];  {OK}
   s1 := [-18..-10];  {!!! error}

   s1 := [];  {OK}
   s1 := [8..10];  {!!! error}

   p641([5]);  {OK}
   p641([6]);  {!!! error}

   s1 := [i..j] + [6];  {!!! error}
   s1 := [i..j] + [6..6];  {!!! error}

   s1 := [i..j] + [6] - [12];  {!!! error}
   s1 := [i..j] + [6] - [10..12];  {!!! error}

   s1 := [i..j] + [6] * [-12..12];  {!!! error}


   s1 := [5] * [5];  {OK}
   s1 := [5] * [12];  {OK}
   s1 := [12] * [12];  {!!! error}

   s1 := [12] * [12] - [12];  {OK}
   s1 := [12] * [12] + [6];  {!!! error}

   s1 := [6] + [12] * [12];  {!!! error}

   s1 := [5] - [];  {OK}
   s1 := [12] - [];  {!!! error}

   s1 := [5] + [];  {OK}
   s1 := [0,6,0] + [];  {!!! error}

   s1 := ([12] - [12]) + [5];  {OK}
   s1 := ([12] - [12]) + [6];  {!!! error}
   s1 := ([12] - []) + [6];  {!!! error}

   s1 := [5] + ([12] - [12]);  {OK}
   s1 := [6] + ([12] - [12]);  {!!! error}
   s1 := [6] + ([12] - []);  {!!! error}

   s1 := [0..6] * [1..5]; {OK}
   s1 := [0..6] * [5..9]; {!!! error}

   s1 := [-6..0] * [-5..1]; {OK}
   s1 := [-6..0] * [-6..1]; {!!! error}

   s1 := [0..6] - [2..6]; {OK}
   s1 := [0..6] - [2..5]; {!!! error}

   s1 := [-6..0] - [-6..-2]; {OK}
   s1 := [-6..0] - [-5..-2]; {!!! error}

   s1 := [0..6] * [5]; {OK}
   s1 := [6] * [5..9]; {!!! error}

   s1 := [-6] * [-5..1]; {OK}
   s1 := [-6..0] * [-6]; {!!! error}

   s1 := [0..6] - [6]; {OK}
   s1 := [6] - [2..5]; {!!! error}

   s1 := [-6] - [-6..-2]; {OK}
   s1 := [-6..0] - [-5]; {!!! error}

   s1 := [14..5]; {OK - empty set}
   s1 := [14..5]*[14..14]; {OK - empty set}

   s1 := [14..15]; {OK - empty set}
   s1 := [14..15]*[14..14]; {OK - empty set}

   j := -7;
   s1 := [-6..j];             {OK, empty set}
   s1 := [-6..j]*[-6..0];     {not detectable at compile time}

   j := 0;
   s1 := [-6..j];             {not detectable at compile time}
   s1 := [-6..j]*[-6..0];     {not detectable at compile time}


end. { e200 }
