{: test that char variables are not interpreted as constant 1 char strings}

{$d+}
program e131( output );

type
   str1 =  packed array[1..1] of char;
   str2 =  packed array[1..2] of char;

var
   s1 : str1;
   s2 : str2;
   ch : char;

procedure test(as : packed array[lo..hi : integer] of char);
begin
end; { test }

procedure testv(var as : packed array[lo..hi : integer] of char);
begin
end; { testv }

procedure p1(s : str1 );
begin
end; { p1 }

procedure pv(var s : str1 );
begin
   pv(ch);   {!!! ch is not a string}
end; { pv }

procedure p2(s : str2 );
begin
end; { p2 }

begin {e131}

   s1 := 'q'; {ok interpret as string}
   s1 := ch;  {!!! ch is not a string}

   if s1 = 'q' then writeln;  {ok interpret as string}
   if s1 = ch  then writeln;  {!!! ch is not a string}
   if 'q' = s1 then writeln;  {ok interpret as string}
   if ch = s1  then writeln;  {!!! ch is not a string}

   s2 := '12';
   s2 := '1';   {!!!string on rhs has incorrect length}

   if s2 = '12' then writeln; {ok}
   if s2 = '1'  then writeln; {!!!string on rhs has incorrect length}
   if '12' = s2 then writeln; {ok}
   if '1' = s2  then writeln; {!!!string on lhs has incorrect length}

   p1(s1);   {ok}
   p1(ch);   {!!! ch is not a string}
   p1('3');  {ok, string arg}
   p1('34'); {!!! string arg has incorrect length}

   pv(s1);   {ok}
   pv('3');  {!!! const not allowed as var param}

   p2(s2);    {ok}
   p2(ch);    {!!! ch is not a string}
   p2('33');  {ok, string arg}
   p2('3');   {!!! string arg has incorrect length}

   test(s1);   {ok}
   test(ch);   {!!! ch is not a string}
   test('3');  {ok, string arg}

   testv('3');  {!!! const cannot be var param}
   testv(s1);   {ok}
   testv(ch);   {!!! ch is not a string}

end. { e131 }

