{: test that set overflow from an + operation causes a fatal error }

{$d+}
program d212( output );

type
   digits =  set of '0'..'9';

var
   s : digits;
   k : char;

procedure p(as : digits );
begin
   if as = [] then
      writeln( 'set as is empty' );
end; { p }

function side: char;
begin
   side := k;
   k := succ(k);
end; { side }

begin { d212 }

   k := '3';
   s := [side] + ['1'];
   if k <> '4' then
      writeln( '**** set op has side effects ****' );

   p([side]);
   if k <> '5' then
      writeln( '**** set param has side effects ****' );

   s := ['1'..'5', 'a'] - ['a'];  {OK}
   p( ['1'..'5', 'a'] - ['a'] );  {OK}

   s := ['1'..'5', 'a'..'z'] * ['0'..'9'];  {OK}
   p( ['1'..'5', 'a'..'z'] * ['0'..'9'] );  {OK}

   k := succ('9');
   s := (s + [k]) + (['3','4'] - ['4']); {!!! k is outside bounds of s}

   writeln( 'set overflow not detected' );
end. { d212 }

