{: test that assigning to a set outside its bounds causes a fatal error
   here we test various values where sets overlap on the lower bound,
   vary the test element of src set
}

{ this is ageneric test, many versions of this test will be built with
  cpp -D ARG1=ARG -D ARG2=(ARG+ADJ)
  for all combinatiopns of ARG & ADJ

ARG   8 7 1 0 -1 -7 -8 -9 -15 -16 -17 -23 -24 -25
ADJ   1 2 7 8 9 15 16 17

}

{$d+}
program d204( output );

#if !defined ARG1 || ! defined ARG2
#error "ARG2 or ARG1 not defined"
#endif
#if ARG2 <= ARG1
#error "ARG2 must be > than ARG1"
#endif

const
   lo  = ARG2; {varies -25 .. +8}
   lo1 = -30;
   t   = ARG1;  {varies -25 .. +8}
var
   i  : integer;
   s  : set of lo..30;   {dst}
   s1 : set of lo1..20;  {src}

begin {d204}

   s1 := [lo..10];
   s := s1; {this should be OK}

   writeln( 'INFO: s is [', lo:1, '..20], s1 is [', lo1:1, '..10], test bit ', t );

   s1 := [t];
   s := s1; {!!! assign beyond lower bound}

   writeln('failed to detect set assign error');

end. { d204 }

