{: test that exp(ln(x)*y) causes a fatal error if x & y are large enough
   this tests for small x and y just large enough to overflow }

program d08b( output );

var
   e : real;
   k : real;
   x : real;
   y : real;
   z : real;

function side : real;
begin
   side := k;
   k := k+1;
end; { side }

begin {d08b}

   k := 1;
   x := exp(ln(side)*1);
   if abs(x-1) > 1.0e-37 then begin
      writeln( 'unexpected value of exp(ln(1)) is ', x);
   end;
   if k <> 2 then
      writeln( 'ln(x) in exp(ln(x)*y) has side effects' );

   k := 1;
   x := exp(ln(1)*side);
   if abs(x-1) > 1.0e-37 then begin
      writeln( 'unexpected value of exp(ln(1)) is ', x);
   end;
   if k <> 2 then
      writeln( 'y in exp(ln(x)*y) for debug has side effects' );

   {find e, machine precision, & x, smallest nr > 1}
   e := 1;
   repeat
      e := 0.5*e;
      x := 1+0.5*e;
   until x = 1;
   x := x+e;
   {writeln( 'e is ', e, ', x+e = x is ', x=x+e, ', ln(x) is ', ln(x) );}
   writeln('real precision is ', e);

   {write( 'checking for underflow or denormalise ... ' );}
   k := 1;
   repeat
      y := k;
      k := 0.5*k;
      z := k*x;
   until (k = 0) or (z = k);
   writeln('smallest real is ', y);

   {find z, largest nr < 1}
   k := e;
   repeat
      k := k/2;
      z := 1 - k/2;
   until z <= 1;
   z := 1-k;
   writeln( 'k is ', k, ', 1-k = 1 is ', z = z-k );

   z := 4*z/y; {assuming ieee floating point}
   writeln('max real is ', z);

   {find largest y, st y*ln(x) < ln(z)}
   y := ln(z)/ln(x);
   k := y/2;
   if y*ln(x) < ln(z) then begin
      {writeln('y*ln(x) < ln(z)');}
      while (y+k)*ln(x) >= ln(z) do begin
         k := k/2;
      end;
      y := y+k;
   end
   else begin
      {writeln('y*ln(x) >= ln(z)');}
      while (y-k/2)*ln(x) < ln(z) do begin
         k := k/2;
      end;
      y := y-k;
   end;
   {writeln('y*ln(x) > ln(z) is ', y*ln(x) > ln(z),
           ', y*ln(x) - ln(z) is ', y*ln(x) - ln(z));}

   { this shouldn't overflow ... }
   writeln('exp(ln(1+', x-1, ')*', y, ') is ', exp(ln(x)*y));

   {find smallest y, st y*ln(x) > ln(z)}
   y := ln(z)/ln(x);
   if y*ln(x) <= ln(z) then begin
      k := y/2;
      while (y+k/2)*ln(x) > ln(z) do begin
         k := k/2;
      end;
      y := y+k;
   end
   else begin
      k := y/2;
      while (y-k)*ln(x) <= ln(z) do begin
         k := k/2;
      end;
      y := y-k;
   end;
   {writeln('y*ln(x) > ln(z) is ', y*ln(x) > ln(z));}

   writeln( 'checking for overflow, expecting to generate a fatal error' );
   writeln('exp(ln(1+', x-1, ')*', y, ') is ',
           exp(ln(x)*y)); {!!! exp overflows}

   writeln( 'fails: exp(ln(x)*y) overflow not detected for large y' );
end. { d08b }
