{: test that getting a variable from a text file causes a fatal error if
   there is a file error}

{$d+}
program d04i( output );

const
   testInt = 783;
var
   f : array[0..1] of text;
   k : integer;
   c : char;

function side : integer;
begin
   side := k;
   k := k+1;
end;
begin {d04i}
   rewrite( f[0] );
   k := 0;
   f[side]^ := 'A';
   if k <> 1 then
      writeln( 'assign text file buffer for debug has side effects' );
   k := 0;
   put(f[side]);
   if k <> 1 then
      writeln( 'put text for debug has side effects' );

   f[0]^ := 'B'; put(f[0]);

   reset( f[0] );  {this should force a writeln}

   k := 0;
   c := f[side]^;
   if k <> 1 then
      writeln( 'read text buffer for debug has side effects' )
   else if c <> 'A' then
      writeln( 'file buffer is ''', c, ''', expected ''A''' );

   k := 0;
   get( f[side] );
   if k <> 1 then
      writeln( 'read text buffer for debug has side effects' );
   c := f[0]^;
   if c <> 'B' then
      writeln( 'text buffer is ''', c, ''', expected ''B''' );

   get(f[0]);         {eoln}
   c := f[0]^;
   if c <> ' ' then
      writeln( 'text buffer is ''', c, ''', expected '' ''' );

   get(f[0]);         {lazy i/o ==> f[0]^ is empty}
   get(f[0]);         { end of file! no data ==> file error }

   writeln( 'fails: get text file error not detected' );
end. { d04i }

