{: test array index out of bounds errors
   these tests should be discoverable at compile time }
program e201(output);

const n = 5;
type
  tarray = array[-n..+n] of integer;
  count  =  (one, two, three, four, five, six, seven, eight, nine, ten);
var
   a1    : tarray;
   a2    : array[two..nine] of boolean;
   pass1 : boolean;
   i,j   : integer;

procedure p( aa : tarray );
begin
   aa[n] := 0;
   if aa[n+1] <= maxint then write('error not detected');
   aa[-n] := 0;
   if aa[-n-1] <= maxint then write('error not detected');
end; { p }

begin
   pass1 := true;

   { should give compile time errors }
   a1[-5] := 100;    {OK}
   a1[-6] := 100;    {!!! error}
   a1[-n-1] := 101;  {!!! error}
   a1[-2*3] := 101;  {!!! error}

   a1[5] := 200;    {OK}
   a1[6] := 200;    {!!! error}
   a1[n+1] := 201;  {!!! error}
   a1[2*3] := 201;  {!!! error}

   j := -5;
   a1[j] := -6;     {OK}
   a1[j-1] := -6;   {not detectable at compile time}

   j := 5;
   a1[j] := -6;     {OK}
   a1[j+1] := -6;   {not detectable at compile time}


   a2[two] := true;    {OK}
   a2[one] := true;    {!!! error}

   a2[nine] := false;    {OK}
   a2[ten] := false;     {!!! error}
   a2[10] := false;      {!!! error}
end. { e201 }
