{: test that constant expression overflow causes a compilation error }

program e1060( output );

type
   colour = ( black, brown, red, orange, yellow, green, blue, violet, grey, white);

const
   cm = pred(maxchar);

   cp31 = pred(brown);     {OK}
   cs31 = succ(grey);      {OK}
   cp32 = pred(chr(1));    {OK}
   cs32 = succ(cm);        {OK}
   cp33 = pred(true);      {OK}
   cs33 = succ(false);     {OK}
   cp34 = pred(-maxint+1); {OK}
   cs34 = succ(maxint-1);  {OK}

   cp41 = pred(red,2);        {OK}
   cs41 = succ(violet,2);     {OK}
   cp42 = pred(chr(2),2);     {OK}
   cs42 = succ(pred(cm), 2);  {OK}
   cp43 = pred(true,1);       {OK}
   cs43 = succ(false,1);      {OK}
   cp44 = pred(-maxint+2, 2); {OK}
   cs44 = succ(maxint-2, 2);  {OK}

   cp51 = pred(0, maxint);     {OK}
   cs51 = succ(0, maxint);     {OK}
   cp52 = pred(-1, maxint-1); {OK}
   cs52 = succ(1, maxint-1);   {OK}
   cp53 = pred(0, -maxint);     {OK}
   cs53 = succ(0, -maxint);    {OK}
   cp54 = pred(1, -maxint+1); {OK}
   cs54 = succ(-1, -maxint+1);   {OK}

   cp01 = pred(black);     {!!! underflow}
   cs01 = succ(white);     {!!! overflow }
   cp02 = pred(chr(0));    {!!! underflow}
   cs02 = succ(maxchar);   {!!! overflow }
   cp03 = pred(false);     {!!! underflow}
   cs03 = succ(true);      {!!! overflow }
   cp04 = pred(-maxint);   {!!! underflow}
   cs04 = succ(maxint);    {!!! overflow }

   cp11 = pred(brown,2);            {!!! underflow}
   cs11 = succ(grey,2);             {!!! overflow }
   cp12 = pred(chr(1),2);           {!!! underflow}
   cs12 = succ(cm, 2);              {!!! overflow }
   cp13 = pred(true,2);             {!!! underflow}
   cs13 = succ(false,2);            {!!! overflow }
   cp14 = pred(succ(-maxint), 2);   {!!! underflow}
   cs14 = succ(pred(maxint), 2);    {!!! overflow }

   cs21 = succ(brown,maxint);       {!!! overflow }
   cs22 = succ(chr(1), maxint);     {!!! overflow }
   cs23 = succ(true,maxint);        {!!! overflow }
   cp24 = pred(-1, maxint);         {!!! underflow}
   cs24 = succ(1, maxint);          {!!! overflow }
   cp25 = pred(1, -maxint);         {!!! overflow}
   cs25 = succ(-1, -maxint);        {!!! underflow }


var
   e : colour;
   n : integer;
   s : packed array[1..20] of char;

begin { e1060 }

   e := black;
   n := 2;

   writeln( 'constant expression type error not detected' );
end. { e1060 }

