{: test that assigning to a set outside its bounds causes a fatal error
   test bounds error at upper set boundary for vlist * vlist
   (with & without range)
}

{ this is ageneric test, many versions of this test will be built with
  cpp -D ARG1=ARG -D ARG2=(ARG+ADJ)
  for all combinatiopns of ARG & ADJ

ARG   -17 -16 -15 -1 0 2 15 16 17
ADJ   1 7 8

}

{$d+}
program d233( output );

#if !defined ARG1 || ! defined ARG2
#error "ARG2 or ARG1 not defined"
#endif

const
   top = 40;
   lo  = -top;
   hi  = ARG1;
   lo1 = lo;
   offset = ARG2;
var
   i, j  : integer;
   s0  : set of lo..hi;    {dst}
   s2  : set of -top..top; {src}

begin {d233}

   i := hi;                  {min element of s0}
   s2 := [lo, lo+4, i-4, i]; {this should be OK}

   writeln( 'INFO: s0 is [', lo:1, '..', hi:1, ']' );

   j := offset;
   s0 := [j-4 .. j] * [lo, lo+4, i-4, i];  {OK}
   s0 := [j-4 .. j] * [lo, lo+4, i-4, j];  {!!! assignment outside bounds}

   writeln('failed to detect set assign error');

end. { d233 }

